/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.variant;

import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyVariantComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.util.VariantLight;
import ch.icit.pegasus.server.core.dtos.util.VariantMasterLight;
import ch.icit.pegasus.server.core.util.TimeUtil;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public abstract class AddVariantUtil<T extends VariantLight, M extends VariantMasterLight<T>> {
    public T addVariant(Node<List<T>> variantList, Node<M> base) {
        VariantLight latestVariant = null;
        Node node = null;
        if (variantList.getChildCount() > 0) {
            variantList.sortChilds((o1, o2) -> {
                VariantLight v1 = (VariantLight)o1.getValue();
                VariantLight v2 = (VariantLight)o2.getValue();
                return v1.getValidityPeriod().compareTo(v2.getValidityPeriod());
            });
            node = variantList.getChildAt(variantList.getChildCount() - 1);
            latestVariant = (VariantLight)node.getValue();
        }
        T nv = this.createNewVariant(latestVariant, base != null ? (VariantMasterLight)base.getValue() : null);
        nv.setClientOId(Long.valueOf(ADTO.getNextId()));
        if (nv.getValidityPeriod() == null) {
            nv.setValidityPeriod(new PeriodComplete(new java.sql.Date(System.currentTimeMillis()), new java.sql.Date(System.currentTimeMillis())));
        }
        if (latestVariant == null) {
            nv.getValidityPeriod().setStartDate(new java.sql.Date(System.currentTimeMillis()));
            nv.getValidityPeriod().setEndDate(new java.sql.Date(System.currentTimeMillis()));
        } else {
            java.sql.Date oldEndDate;
            java.sql.Date newEndDate = new java.sql.Date(this.getInfinityDate().getTime());
            java.sql.Date newStartDate = new java.sql.Date(System.currentTimeMillis());
            PeriodComplete startPeriod = new PeriodComplete(newStartDate, newStartDate);
            if (latestVariant.getValidityPeriod().getStartDate().getTime() < startPeriod.getStartDate().getTime()) {
                oldEndDate = new java.sql.Date(startPeriod.getStartDate().getTime() - 1L);
                newStartDate = new java.sql.Date(startPeriod.getEndDate().getTime());
            } else {
                oldEndDate = new java.sql.Date(latestVariant.getValidityPeriod().getStartDate().getTime());
                newStartDate = new java.sql.Date(oldEndDate.getTime() + 86400000L);
            }
            PeriodComplete newPeriod = new PeriodComplete(newStartDate, newEndDate);
            PeriodComplete oldPeriod = new PeriodComplete(latestVariant.getValidityPeriod().getStartDate(), oldEndDate);
            nv.getValidityPeriod().setStartDate(newPeriod.getStartDate());
            nv.getValidityPeriod().setEndDate(newPeriod.getEndDate());
            latestVariant.getValidityPeriod().setEndDate(oldPeriod.getEndDate());
            Node oldPeriodEndChild = node.getChildNamed(new DtoField[]{this.getPeriodField(), PeriodComplete_.endDate});
            oldPeriodEndChild.setValue((Object)oldPeriod.getEndDate(), 0L);
            Node validity = node.getChildNamed(CurrencyVariantComplete_.validityPeriod);
            validity.commitThis();
            validity.updateNode();
        }
        Node n = INodeCreator.getDefaultImpl().getNode4DTO(nv, true, false);
        variantList.addChild(n, 0L);
        return nv;
    }

    public abstract DtoField<PeriodComplete> getPeriodField();

    public abstract T createNewVariant(T var1, M var2);

    private Date getInfinityDate() {
        Calendar c = TimeUtil.createCalendar();
        c.set(1, 6666);
        c.set(2, 6);
        c.set(5, 6);
        return new Date(c.getTimeInMillis());
    }
}

