/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.util;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import javax.swing.JFrame;
import sun.java2d.SunGraphicsEnvironment;

public class DisplayUtils {
    public static void maximizeFrame(JFrame frame) {
        int x = frame.getX();
        int y = frame.getY();
        boolean found = false;
        found = DisplayUtils.tryToExpandWindow(frame, x, y);
        if (!found) {
            found = DisplayUtils.tryToExpandWindow(frame, x + frame.getWidth(), y);
        }
        if (!found) {
            found = DisplayUtils.tryToExpandWindow(frame, x, y + frame.getHeight());
        }
        if (!found) {
            found = DisplayUtils.tryToExpandWindow(frame, x + frame.getWidth(), y + frame.getHeight());
        }
        if (!found) {
            found = DisplayUtils.tryToExpandWindow(frame, x + frame.getWidth() / 2, y + frame.getHeight() / 2);
        }
    }

    private static boolean tryToExpandWindow(JFrame frame, int x, int y) {
        GraphicsDevice[] devices;
        for (GraphicsDevice d : devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            GraphicsConfiguration gc = d.getDefaultConfiguration();
            Rectangle bounds = gc.getBounds();
            if (!((double)x >= bounds.getX()) || !((double)x <= bounds.getX() + bounds.getWidth()) || !((double)y >= bounds.getY()) || !((double)y <= bounds.getY() + bounds.getHeight())) continue;
            frame.setLocation((int)bounds.getX(), (int)bounds.getY());
            Rectangle size = DisplayUtils.getMaximumBounds(gc.getDevice());
            frame.setSize((int)size.getWidth(), (int)size.getHeight());
            return true;
        }
        return false;
    }

    private static Rectangle getMaximumBounds(GraphicsDevice device) {
        return SunGraphicsEnvironment.getUsableBounds(device);
    }
}

