/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.util.async;

import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ExceptionHandler;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import javax.swing.SwingUtilities;

public class ThreadSafeRun
implements Runnable {
    private ThreadSafeExecutable job;
    private Node<?> node;

    public ThreadSafeRun(ThreadSafeExecutable job) {
        this.job = job;
    }

    @Override
    public void run() {
        try {
            this.node = this.job.loadData();
            if (this.job.getInvoker() != null) {
                SwingUtilities.invokeLater(() -> this.job.getInvoker().remoteObjectLoaded(this.node));
            }
            ThreadSafeLoader.currentBackgrounds.remove(this);
        }
        catch (Exception e) {
            ExceptionHandler.getHandler().uncaughtException(Thread.currentThread(), (Throwable)e);
        }
    }

    public ThreadSafeExecutable getJob() {
        return this.job;
    }

    public Node<?> getNode() {
        return this.node;
    }
}

