/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.util.toolkits;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.QuantityConverter1Decimal;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.OrderReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.OrderServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.MailToolkit;
import ch.icit.pegasus.client.util.exception.ClientCreateReportException;
import ch.icit.pegasus.client.util.toolkits.copy.CopyTemplateToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.ordering.OrderStateE;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderOutputTypeE;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPositionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPositionPreviewComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPreviewComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderReference;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderSendHistoryComplete;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderComplete;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderPositionComplete;
import ch.icit.pegasus.server.core.dtos.report.PurchaseOrderReportConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionBaseComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionCategoryComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierReference;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.util.StringUtil;
import java.io.File;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PurchaseOrderToolkit {
    static Logger log = LoggerFactory.getLogger(PurchaseOrderToolkit.class);

    public static String createOrderText4Popup(PurchaseOrderComplete order) {
        String t = "";
        Converter quantityRenderer = ConverterRegistry.getConverter(QuantityConverter1Decimal.class);
        t = Words.ORDER_SUCCESSFULLY_PLACED_BR_BR;
        t = t + Words.SUPPLIER_POINT + " " + order.getSupplier().getName() + " " + Words.BR_POSITIONS_BR;
        for (PurchaseOrderPositionComplete pos : order.getOrderPositions()) {
            t = t + quantityRenderer.convert((Object)pos.getQuantity(), null, new Object[0]) + " " + Words.OF + " " + pos.getArticle().getName() + "<br>";
        }
        return t;
    }

    public static String createOrderText4Popup(RequisitionOrderComplete order) {
        String t = "";
        Converter quantityRenderer = ConverterRegistry.getConverter(QuantityConverter1Decimal.class);
        t = Words.ORDER_SUCCESSFULLY_PLACED_BR_BR;
        t = t + Words.DEPARTMENT_POINT + " " + order.getRequiredBy().getDescription() + " " + Words.BR_POSITIONS_BR;
        for (RequisitionOrderPositionComplete pos : order.getOrderPositions()) {
            t = t + quantityRenderer.convert((Object)pos.getQuantity(), null, new Object[0]) + " " + Words.OF + " " + pos.getArticle().getName() + "<br>";
        }
        return t;
    }

    public static PurchaseOrderComplete convertPurchaseOrderPreview(PurchaseOrderPreviewComplete previewOrder) {
        PurchaseOrderComplete order = new PurchaseOrderComplete();
        order.setClientOId(Long.valueOf(ADTO.getNextId()));
        order.setCostCenter(previewOrder.getCostCenter());
        order.setDeliveryAddress(previewOrder.getDeliveryAddress());
        order.setFooter(previewOrder.getFooter());
        order.setDeliveryTerm(previewOrder.getDeliveryTerm());
        order.setOrderPositions(PurchaseOrderToolkit.convertPurchaseOrderPositionPreview(order, previewOrder.getPositionPreviews()));
        order.setOrderDeliveryWindow(previewOrder.getOrderDeliveryWindow());
        order.setCustomer(previewOrder.getCustomer());
        order.setOrderDate(previewOrder.getOrderDate());
        order.setDeliveryDate(previewOrder.getDeliveryDate());
        order.setRemark(previewOrder.getRemark());
        order.setSupplier(previewOrder.getSupplier());
        order.setReorder(previewOrder.getReorder());
        order.setState(OrderStateE.PLACED);
        order.setUseTaxZone(previewOrder.getUseTaxZone());
        order.setTaxZone(previewOrder.getTaxZone());
        return order;
    }

    private static List<PurchaseOrderPositionComplete> convertPurchaseOrderPositionPreview(PurchaseOrderComplete order, List<PurchaseOrderPositionPreviewComplete> positionPreviews) {
        ArrayList<PurchaseOrderPositionComplete> positions = new ArrayList<PurchaseOrderPositionComplete>();
        int sequence = 0;
        for (PurchaseOrderPositionPreviewComplete pos : positionPreviews) {
            PurchaseOrderPositionComplete newPos = new PurchaseOrderPositionComplete();
            newPos.setClientOId(Long.valueOf(ADTO.getNextId()));
            newPos.setArticleLabelCount(pos.getArticleLabelCount());
            newPos.setArticle(pos.getArticle());
            newPos.setComment(pos.getComment());
            newPos.setContractEntry(pos.getContractEntry());
            newPos.setDeliveryDate(pos.getDeliveryDate());
            newPos.setOrder(order);
            newPos.setPriceUnit(pos.getPriceUnit());
            newPos.setSupplierCondition(CopyTemplateToolkit.copySupplierCondition(pos.getSupplierCondition()));
            newPos.setQuantity(pos.getQuantity());
            newPos.setSupplierPrice(pos.getSupplierPrice());
            newPos.setSequenceNumber(Integer.valueOf(sequence++));
            positions.add(newPos);
        }
        return positions;
    }

    public static void sendPurchaseOrder(PurchaseOrderReportConfiguration config, SupplierComplete supplier, PurchaseOrderComplete order) throws Exception {
        List<String> targetList;
        PegasusFileComplete t = (PegasusFileComplete)((OrderReportServiceManager)ServiceManagerRegistry.getService(OrderReportServiceManager.class)).createPurchaseOrderSheet(config).getValue();
        SystemSettingsComplete s = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        String subject = "";
        String msg = s.getDefaultOrderMailText();
        if (msg == null) {
            msg = "";
        }
        msg = msg.replaceAll("&Order", "" + order.getNumber());
        String target = supplier.getOrderContactNumber();
        if (target == null) {
            targetList = new ArrayList<String>();
            targetList.add(supplier.getOrderContact().getEmail());
        } else {
            targetList = Arrays.asList(target.replace(" ", "").split(";"));
        }
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy");
        String orderContent = "Order No: " + order.getNumber() + "\n";
        orderContent = orderContent + "Order Date: " + df.format(order.getOrderDate()) + "\n";
        orderContent = orderContent + "Delivery Date: " + df.format(order.getDeliveryDate()) + "\n";
        orderContent = orderContent + "Delivery Time: " + order.getOrderDeliveryWindow().getValue() + "\n";
        orderContent = orderContent + "Payment Target: " + order.getSupplier().getPaymentDays() + " days";
        orderContent = orderContent + "Delivery Costs: " + (Boolean.TRUE.equals(order.getInclusiveDeliveryCosts()) ? "incl" : "excl");
        orderContent = StringUtil.isBlank((String)order.getRemark()) ? orderContent + "\n" : orderContent + "Remark: " + order.getRemark() + "\n\n";
        orderContent = orderContent + "Positions:\n";
        for (PurchaseOrderPositionComplete orderPosition : order.getOrderPositions()) {
            Node node = INodeCreator.getDefaultImpl().getNode4DTO((Object)orderPosition.getArticle(), false, false);
            BasicArticleComplete artC = (BasicArticleComplete)node.getValue(BasicArticleComplete.class);
            boolean found = false;
            if (artC != null) {
                SupplierConditionBaseComplete condition = artC.getSupplier((SupplierReference)order.getSupplier());
                for (SupplierConditionCategoryComplete cat : condition.getSupplierConditionCategory()) {
                    for (SupplierConditionComplete variant : cat.getVariants()) {
                        if (!variant.getValidityPeriod().within(order.getOrderDate()).booleanValue()) continue;
                        found = true;
                        orderContent = orderContent + variant.getArticleNumber();
                    }
                }
            }
            if (!found) {
                orderContent = orderContent + "\t";
            }
            orderContent = orderContent + "\t" + orderPosition.getArticle().getNumber();
            orderContent = orderContent + "\t" + orderPosition.getArticle().getName();
            orderContent = orderContent + "\t" + orderPosition.getQuantity().getAmount() + " " + orderPosition.getQuantity().getUnit().getShortName() + "\n";
        }
        msg = orderContent = orderContent + "\n You can request an additional order pdf on demand.";
        subject = "Purchase Order " + order.getNumber();
        if (((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser().getContact().getEmail() == null || ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser().getContact().getEmail().isEmpty()) {
            throw new ClientCreateReportException("No Email Address entered in your contact data. Please press the User Settings Icon on Titlebar to edit your personal Email Address", null);
        }
        File f = FileTransferUtil.download((PegasusFileComplete)t, (FileTransferListener[])new FileTransferListener[0]);
        MailToolkit.sendPurchaseOrderMail((String)subject, (String)msg, (File)f, (UserComplete)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser(), targetList);
        PurchaseOrderSendHistoryComplete h = new PurchaseOrderSendHistoryComplete();
        h.setClientOId(Long.valueOf(ADTO.getNextId()));
        h.setPrint(Boolean.valueOf(false));
        h.setSendDate(new Timestamp(System.currentTimeMillis()));
        h.setSentUser((UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser());
        h.setTarget(target);
        h.setPurchaseOrderOutputType(PurchaseOrderOutputTypeE.MAIL);
        PurchaseOrderComplete o = (PurchaseOrderComplete)((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).getPurchaseOrderByReference(new PurchaseOrderReference(order.getId())).getValue();
        o.getSendHistory().add(h);
        ((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).updatePurchaseOrder(o);
    }
}

