/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.util.variantaccessor;

import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.utils.accessor.ProductVariantAccessor;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProductVariantAccessorImpl
implements ProductVariantAccessor {
    private Map<ProductComplete, List<ProductVariantLight>> variants = new HashMap<ProductComplete, List<ProductVariantLight>>();
    private Map<ProductVariantReference, ProductVariantComplete> completes = new HashMap<ProductVariantReference, ProductVariantComplete>();

    public ProductVariantComplete loadData(ProductComplete reference, Timestamp ts) throws ClientServerCallException {
        List v = this.variants.get(reference);
        if (v == null) {
            v = ((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getProductVariantsByReferences(new ListWrapper(reference.getVariants())).getList();
            this.variants.put(reference, v);
        }
        ProductVariantLight selected = null;
        for (ProductVariantLight cv : v) {
            if (cv.getTenderVariant().booleanValue() || ts.getTime() + 1L < cv.getValidityPeriod().getStartDate().getTime() || ts.getTime() + 1L > cv.getValidityPeriod().getEndDate().getTime()) continue;
            selected = cv;
        }
        if (selected == null) {
            throw new IllegalArgumentException("No valid Product Variant found for Product " + reference.getNumber() + " " + reference.getCurrentVariant().getName() + " at " + ((DateConverter)ConverterRegistry.getConverter(DateConverter.class)).convert((Object)ts, null, new Object[0]));
        }
        ProductVariantComplete ccv = this.completes.get(selected);
        if (ccv != null) {
            return ccv;
        }
        ccv = this.getComplete(new ProductVariantReference(selected.getId()));
        this.completes.put((ProductVariantReference)selected, ccv);
        return ccv;
    }

    public ProductVariantComplete getComplete(ProductVariantReference ref) throws ClientServerCallException {
        ProductVariantComplete c = this.completes.get(ref);
        if (c != null) {
            return c;
        }
        c = (ProductVariantComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getProductVariantByReference(ref).getValue();
        this.completes.put(ref, c);
        return c;
    }
}

