/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.validator;

import ch.icit.pegasus.client.gui.utils.Validatable;
import ch.icit.pegasus.client.validator.ValidatingObject;
import ch.icit.pegasus.client.validator.Validator;
import ch.icit.pegasus.server.core.i18n.Words;

public class AmountExistenceValidator
extends Validator<String> {
    @Override
    public ValidatingObject isValid(String o, Validatable v) {
        if (o == null || o.equals("")) {
            return new ValidatingObject(false, "", v);
        }
        Double d = null;
        try {
            d = Double.valueOf(o);
        }
        catch (NumberFormatException e) {
            return new ValidatingObject(false, Words.NOT_A_NUMBER, v);
        }
        if (d > 0.0) {
            return new ValidatingObject(true, "", v);
        }
        return new ValidatingObject(false, Words.NUMBER_MUST_BE_GREATER_THAN_0, v);
    }

    @Override
    public boolean isRemoteValidation() {
        return false;
    }
}

