/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.actions.impl;

import ch.icit.pegasus.client.actions.impl.ActionWithStyleSheet;
import ch.icit.pegasus.client.gui.utils.print.PrintPopupToolkit;
import ch.icit.pegasus.client.print.PrinterLocalToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.DefaultServiceManager;
import ch.icit.pegasus.client.services.interfaces.report.OrderReportServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderReference;
import ch.icit.pegasus.server.core.dtos.report.PurchaseOrderReceivingReportConfiguration;
import ch.icit.pegasus.server.core.dtos.util.SearchResult;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.IDTO;
import ch.icit.util.PrinterToolkit;
import java.awt.Component;
import java.util.List;
import javax.print.PrintService;

public class PrintPurchaseOrderForReceiving
extends ActionWithStyleSheet {
    @Override
    public void performAction(Component source, ProgressListener l, Object ... objects) throws Exception {
        if (l != null) {
            l.stateChanged(Words.PRINT_PURCHASE_ORDER_RECEIVING_SHEET);
        }
        PurchaseOrderComplete order = (PurchaseOrderComplete)objects[0];
        if (PrinterToolkit.getDefaultPrinter() == null) {
            return;
        }
        PrintService service = PrinterToolkit.getDefaultPrinter();
        if (service == null) {
            service = PrinterLocalToolkit.getStandardPrinter(null);
        }
        PurchaseOrderReceivingReportConfiguration config = new PurchaseOrderReceivingReportConfiguration();
        config.setDto((IDTO)new PurchaseOrderReference(order.getId()));
        SearchResult results = ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getReportStyleSheet(ReportTypeE.PURCHASE_ORDER_RECEIVED);
        List<ReportFileComplete> styleSheets = this.filterStyleSheetWithReportConfiguration((SearchResult<ReportFileComplete>)results, ReportTypeE.PURCHASE_ORDER_RECEIVED);
        if (styleSheets.isEmpty()) {
            throw new Exception("No Style Sheet for Purchase Order Receiving Sheet found");
        }
        config.setStylesheet(styleSheets.get(0));
        OptionalWrapper r = ((OrderReportServiceManager)ServiceManagerRegistry.getService(OrderReportServiceManager.class)).createPurchaseOrderReceivingWorksheet(config);
        if (r != null && r.getValue() != null) {
            try {
                PrintPopupToolkit.printFile((PegasusFileComplete)r.getValue(), Words.PRINT_PURCHASE_ORDER_RECEIVING_SHEET, service, null, false, 1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

