/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.batch;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.batch.PrintProcessor;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.dtos.IDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PrintBatchJob<T extends IDTO>
extends BatchJob<T> {
    private static final Logger log = LoggerFactory.getLogger(PrintBatchJob.class);
    private static final long serialVersionUID = 1L;
    private PrintProcessor printProcessor;
    private boolean isPreview;

    public PrintBatchJob(ThreadSafeExecutable job, Node<T> node, PrintProcessor printProcessor, boolean preview) {
        super(DefaultSkins.SubModulePrintIcon, job, node);
        this.printProcessor = printProcessor;
        this.isPreview = preview;
    }

    @Override
    public void jobDone(Node<?> node) {
        if (node.getValue() instanceof PegasusFileComplete) {
            PegasusFileComplete s = (PegasusFileComplete)node.getValue();
            this.processFile(s);
        }
        super.jobDone(node);
    }

    @Override
    public String getErrorText() {
        return "Job failed";
    }

    private boolean processFile(PegasusFileComplete file) {
        try {
            if (this.isPreview) {
                this.printProcessor.previewFile(file);
            } else {
                this.printProcessor.printFile(file);
            }
        }
        catch (Exception e) {
            log.error("Unable to process file", (Throwable)e);
            return false;
        }
        return true;
    }
}

