/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.hud.view;

import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;

public class HudCenterLayout
extends DefaultLayout {
    private int columnCount;
    private int topBorder = 0;
    private int verticalGap = 13;
    private int horizontalGap = 13;
    private int hudButton_default_width = 200;
    private int hudButton_default_height = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("hud_button_default_height"));

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Component[] components = parent.getComponents();
        int x = 0;
        int y = 0;
        int colCount = parent.getWidth() / this.hudButton_default_width;
        int prefColCount = (int)Math.sqrt(components.length);
        if (prefColCount > 3) {
            prefColCount = 3;
        }
        this.columnCount = prefColCount;
        int size = this.verticalGap + this.hudButton_default_height;
        for (Component component : components) {
            if (x >= colCount || x >= prefColCount) {
                x = 0;
                ++y;
                size += this.verticalGap + this.hudButton_default_height;
            }
            ++x;
        }
        return new Dimension(parent.getWidth(), size);
    }

    @Override
    public void layoutContainer(Container parent) {
        Component[] components = parent.getComponents();
        int colCount = parent.getWidth() / this.hudButton_default_width;
        int rightSpace = parent.getWidth() - colCount * this.hudButton_default_width - (colCount + 1) * this.horizontalGap;
        int additionalGap = 0;
        int prefColCount = (int)Math.sqrt(components.length);
        if (prefColCount > 3) {
            prefColCount = 3;
        }
        this.columnCount = prefColCount;
        int x = 0;
        int y = 0;
        for (Component component : components) {
            if (x >= colCount || x >= prefColCount) {
                x = 0;
                ++y;
            }
            component.setLocation(this.horizontalGap + additionalGap + x * (this.horizontalGap + additionalGap) + x * this.hudButton_default_width, y * this.verticalGap + y * this.hudButton_default_height);
            component.setSize(this.hudButton_default_width, this.hudButton_default_height);
            ++x;
        }
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public void setColumnCount(int columnCount) {
        this.columnCount = columnCount;
    }
}

