/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.admin.inserts;

import ch.icit.pegasus.client.gui.modules.masterdata.AbstractDataInsertModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.List;

public class PasswordResetInsert
extends DefaultDataInsert
implements ButtonListener,
SearchTextField2Listener {
    private TitledItem<SearchTextField2<UserLight>> userSearchField = new TitledItem<SearchTextField2<UserLight>>(SearchTextField2Factory.getUserSearchField(false, new DTOProxyNode()), Words.USER, TitledItem.TitledItemOrientation.NORTH);
    private TitledItem<TextLabel> emailLabel;
    private TextLabel hint;
    private Button resetButton;
    private HorizontalSeparator sep1;
    private TitledItem<TextField> oldAdminPassword;
    private TitledItem<TextField> newAdminPassword;
    private TitledItem<TextField> newAdminPassword2;
    private TextButton changeAdminPassword;

    public PasswordResetInsert(AbstractDataInsertModule parent) {
        super(parent);
        this.userSearchField.getElement().addSearchTextFieldListener(this);
        this.emailLabel = new TitledItem<TextLabel>(new TextLabel(), Words.MAIL, TitledItem.TitledItemOrientation.NORTH);
        this.resetButton = new TextButton("Reset and Send Mail");
        this.resetButton.addButtonListener(this);
        this.hint = new TextLabel("Hint: The user will get an email with a new generated password. Also the validitydate is set to 1970. So he is forced to choose a new password on login");
        this.hint.setLineWrap(true, 200);
        this.sep1 = new HorizontalSeparator();
        this.oldAdminPassword = new TitledItem<TextField>(new TextField(), "Old Password", TitledItem.TitledItemOrientation.NORTH);
        this.newAdminPassword = new TitledItem<TextField>(new TextField(), "Password", TitledItem.TitledItemOrientation.NORTH);
        this.newAdminPassword2 = new TitledItem<TextField>(new TextField(), "Repeat Password", TitledItem.TitledItemOrientation.NORTH);
        this.changeAdminPassword = new TextButton("Change Admin Password");
        this.add(this.userSearchField);
        this.add(this.emailLabel);
        this.add(this.hint);
        this.add(this.resetButton);
        this.add(this.sep1);
        this.add(this.oldAdminPassword);
        this.add(this.newAdminPassword);
        this.add(this.newAdminPassword2);
        this.add(this.changeAdminPassword);
        this.setLayout(new Layout());
    }

    @Override
    public void newValueSelected(SearchTextField2 source, Node<?> n) throws ClientServerCallException {
        if (this.userSearchField.getElement().getNode().getValue() != null && ((UserLight)this.userSearchField.getElement().getNode().getValue()).getContact() != null) {
            this.emailLabel.getElement().setText(((UserLight)this.userSearchField.getElement().getNode().getValue()).getContact().getEmail());
        }
    }

    @Override
    public Node getNode() {
        return null;
    }

    @Override
    public void loadData() {
    }

    @Override
    public void saveIt() {
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        return null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.userSearchField != null) {
            this.resetButton.setEnabled(isEnabled);
            this.userSearchField.setEnabled(isEnabled);
        }
    }

    @Override
    public void insertElements() {
    }

    @Override
    public String getInsertName() {
        return Words.PASSWORD_RESET;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.resetButton) {
            try {
                if (this.userSearchField.getElement().getNode().getData() != null) {
                    ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).resetPassword((UserLight)this.userSearchField.getElement().getNode().getData().get(0));
                }
            }
            catch (ClientServerCallException e) {
                InnerPopupFactory.showErrorDialog((Exception)((Object)e), (Component)this);
            }
        } else if (source == this.changeAdminPassword) {
            try {
                if (this.newAdminPassword2.getElement().getText().equals(this.newAdminPassword2.getElement().getText())) {
                    ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).updateAdminPassword(this.oldAdminPassword.getElement().getText(), this.newAdminPassword.getElement().getText());
                } else {
                    InnerPopupFactory.showErrorDialog("Passwords in both field must be equals", (Component)this);
                }
            }
            catch (Exception e) {
                InnerPopupFactory.showErrorDialog(e, (Component)this);
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            if (PasswordResetInsert.this.userSearchField != null) {
                PasswordResetInsert.this.userSearchField.setLocation(border, border);
                PasswordResetInsert.this.userSearchField.setSize(400, ((PasswordResetInsert)PasswordResetInsert.this).userSearchField.getPreferredSize().height);
                PasswordResetInsert.this.emailLabel.setLocation(border, (int)(PasswordResetInsert.this.userSearchField.getLocation().getY() + (double)PasswordResetInsert.this.userSearchField.getHeight() + (double)border));
                PasswordResetInsert.this.emailLabel.setSize(400, ((PasswordResetInsert)PasswordResetInsert.this).emailLabel.getPreferredSize().height);
                PasswordResetInsert.this.resetButton.setLocation(border, (int)(PasswordResetInsert.this.emailLabel.getLocation().getY() + (double)PasswordResetInsert.this.emailLabel.getHeight() + (double)border));
                PasswordResetInsert.this.resetButton.setSize(PasswordResetInsert.this.resetButton.getPreferredSize());
                PasswordResetInsert.this.hint.setLocation(border, (int)(PasswordResetInsert.this.resetButton.getLocation().getY() + (double)PasswordResetInsert.this.resetButton.getHeight() + (double)border));
                PasswordResetInsert.this.hint.setSize(200, 120);
                PasswordResetInsert.this.sep1.setLocation(border, PasswordResetInsert.this.hint.getY() + PasswordResetInsert.this.hint.getHeight() + border);
                PasswordResetInsert.this.sep1.setSize(parent.getWidth() - 2 * border, (int)PasswordResetInsert.this.sep1.getPreferredSize().getHeight());
                PasswordResetInsert.this.oldAdminPassword.setLocation(border, PasswordResetInsert.this.sep1.getY() + PasswordResetInsert.this.sep1.getHeight() + border);
                PasswordResetInsert.this.oldAdminPassword.setSize(400, (int)PasswordResetInsert.this.oldAdminPassword.getPreferredSize().getHeight());
                PasswordResetInsert.this.newAdminPassword.setLocation(border, PasswordResetInsert.this.oldAdminPassword.getY() + PasswordResetInsert.this.oldAdminPassword.getHeight() + border);
                PasswordResetInsert.this.newAdminPassword.setSize(400, (int)PasswordResetInsert.this.newAdminPassword.getPreferredSize().getHeight());
                PasswordResetInsert.this.newAdminPassword2.setLocation(border, PasswordResetInsert.this.newAdminPassword.getY() + PasswordResetInsert.this.newAdminPassword.getHeight() + border);
                PasswordResetInsert.this.newAdminPassword2.setSize(400, (int)PasswordResetInsert.this.newAdminPassword2.getPreferredSize().getHeight());
                PasswordResetInsert.this.changeAdminPassword.setLocation(border, PasswordResetInsert.this.newAdminPassword2.getY() + PasswordResetInsert.this.newAdminPassword2.getHeight() + border);
                PasswordResetInsert.this.changeAdminPassword.setSize(PasswordResetInsert.this.changeAdminPassword.getPreferredSize());
            }
        }
    }
}

