/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.aircraft.details;

import ch.icit.pegasus.client.converter.AircraftTypeConverter;
import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.GalleyEquipmentSystemConverter;
import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDSearchTextField2;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.flightschedule.aircraft.AircraftLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.aircraft.AircraftLight_;
import ch.icit.pegasus.server.core.dtos.masterdata.AircraftTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.GalleyEquipmentSystemComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class SpecificationDetailsPanel
extends DefaultDetailsPanel<AircraftLight> {
    private static final long serialVersionUID = 1L;
    private TitledItem<TextLabel> number;
    private TitledItem<RDSearchTextField2> customer;
    private TitledItem<RDComboBox> type;
    private TitledItem<RDTextField> matriculationField;
    private TitledItem<RDTextField> description;
    private TitledItem<RDComboBox> equipmentSystem;

    public SpecificationDetailsPanel(RowEditor<AircraftLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.BASIC_DATA);
        this.setCustomLayouter(new Layout());
        this.number = new TitledItem<TextLabel>(new TextLabel(null, ConverterRegistry.getConverter(IntegerConverter.class)), WordsToolkit.toCapitalLetter((String)Words.NUMBER), TitledItem.TitledItemOrientation.NORTH);
        this.number.getElement().setReadOnlyTextField(true);
        this.customer = new TitledItem<RDSearchTextField2<RDSearchTextField2>>(new RDSearchTextField2(provider, RDSearchTextField2.SearchTypes.CUSTOMER), WordsToolkit.toCapitalLetter((String)Words.CUSTOMER), TitledItem.TitledItemOrientation.NORTH);
        Converter viewConverter2 = ConverterRegistry.getConverter(AircraftTypeConverter.class);
        this.type = new TitledItem<RDComboBox>(new RDComboBox(provider, viewConverter2), WordsToolkit.toCapitalLetter((String)Words.TYPE), TitledItem.TitledItemOrientation.NORTH);
        this.matriculationField = new TitledItem<RDTextField>(new RDTextField(provider, TextFieldType.NORMAL), Words.getFirstCapitalLetter((String)Words.MATRICULATION_NUMBER), TitledItem.TitledItemOrientation.NORTH);
        this.description = new TitledItem<RDTextField>(new RDTextField(provider, TextFieldType.NORMAL), WordsToolkit.toCapitalLetter((String)Words.DESCRIPTION), TitledItem.TitledItemOrientation.NORTH);
        Converter pViewConverter = ConverterRegistry.getConverter(GalleyEquipmentSystemConverter.class);
        this.equipmentSystem = new TitledItem<RDComboBox>(new RDComboBox(provider, pViewConverter), Words.EQUIPMENT_SYSTEM, TitledItem.TitledItemOrientation.NORTH);
        this.addToView(this.number);
        this.addToView(this.customer);
        this.addToView(this.type);
        this.addToView(this.matriculationField);
        this.addToView(this.description);
        this.addToView(this.equipmentSystem);
    }

    @Override
    public void setNode(Node<?> node) {
        this.number.getElement().setNode(node.getChildNamed(AircraftLight_.number));
        Node customerValue = node.getChildNamed(AircraftLight_.customer);
        this.customer.getElement().setNode(customerValue);
        Node possibleTypes = NodeToolkit.getAffixList(AircraftTypeComplete.class);
        Node typeValue = node.getChildNamed(AircraftLight_.type);
        this.type.getElement().setNode(typeValue);
        this.type.getElement().refreshPossibleValues(possibleTypes);
        this.matriculationField.getElement().setNode(node.getChildNamed(AircraftLight_.matriculation));
        this.description.getElement().setNode(node.getChildNamed(AircraftLight_.description));
        Node pSystems = NodeToolkit.getAffixList(GalleyEquipmentSystemComplete.class);
        Node pValue = this.editor.getModel().getNode().getChildNamed(AircraftLight_.equipmentSystem);
        this.equipmentSystem.getElement().refreshPossibleValues(pSystems);
        this.equipmentSystem.getElement().setNode(pValue);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.number.setEnabled(isEnabled);
        this.customer.setEnabled(isEnabled);
        this.type.setEnabled(isEnabled);
        this.matriculationField.setEnabled(isEnabled);
        this.description.setEnabled(isEnabled);
        if (this.equipmentSystem != null) {
            this.equipmentSystem.setEnabled(isEnabled);
        }
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (this.customer.getElement().isWritable() && this.customer.getElement().getNode().getValue() == null) {
            this.customer.getElement().setInvalid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_CUSTOMER));
        }
        if (this.matriculationField.getElement().isWritable() && (this.matriculationField.getElement().getNode().getValue() == null || this.matriculationField.getElement().getNode().getValue().equals(""))) {
            this.matriculationField.getElement().setInvalid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.MATRICULATION_MUST_BE_SET));
        }
        return validationObjects;
    }

    @Override
    public boolean grabsFocus() {
        return !this.editor.getModel().isAddRow();
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.customer);
        CheckedListAdder.addToList(focusList, this.type);
        CheckedListAdder.addToList(focusList, this.matriculationField);
        CheckedListAdder.addToList(focusList, this.description);
        CheckedListAdder.addToList(focusList, this.equipmentSystem);
        return focusList;
    }

    @Override
    public void resetParagraph() {
        this.initNodeBindings(this.editor.getModel().getNode());
    }

    private void initNodeBindings(Node<?> node) {
        Node typeValue = node.getChildNamed(AircraftLight_.type);
        Node customerValue = node.getChildNamed(AircraftLight_.customer);
        this.type.getElement().setNode(typeValue);
        this.customer.getElement().setNode(customerValue);
        this.matriculationField.getElement().setNode(node.getChildNamed(AircraftLight_.matriculation));
        this.description.getElement().setNode(node.getChildNamed(AircraftLight_.description));
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.number.kill();
        this.number = null;
        this.customer.kill();
        this.customer = null;
        this.type.kill();
        this.type = null;
        this.matriculationField.kill();
        this.matriculationField = null;
        this.description.kill();
        this.description = null;
        if (this.equipmentSystem != null) {
            this.equipmentSystem.kill();
            this.equipmentSystem = null;
        }
    }

    @Override
    public void requestFocusInWindowNow() {
        this.customer.requestFocusInWindowNow();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int currentY = SpecificationDetailsPanel.this.verticalBorder;
            int w = parent.getWidth() - 2 * SpecificationDetailsPanel.this.horizontalBorder;
            SpecificationDetailsPanel.this.customer.setLocation(SpecificationDetailsPanel.this.horizontalBorder, currentY);
            SpecificationDetailsPanel.this.customer.setSize(w - (SpecificationDetailsPanel.this.inner_horizontalBorder + 80), (int)SpecificationDetailsPanel.this.customer.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.number.setLocation(SpecificationDetailsPanel.this.customer.getX() + SpecificationDetailsPanel.this.customer.getWidth() + SpecificationDetailsPanel.this.inner_horizontalBorder, currentY);
            SpecificationDetailsPanel.this.number.setSize(80, (int)SpecificationDetailsPanel.this.number.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.type.setLocation(SpecificationDetailsPanel.this.horizontalBorder, currentY += SpecificationDetailsPanel.this.customer.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.type.setSize(w, (int)SpecificationDetailsPanel.this.type.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.matriculationField.setLocation(SpecificationDetailsPanel.this.horizontalBorder, currentY += SpecificationDetailsPanel.this.type.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.matriculationField.setSize(w, (int)SpecificationDetailsPanel.this.matriculationField.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.description.setLocation(SpecificationDetailsPanel.this.horizontalBorder, currentY += SpecificationDetailsPanel.this.matriculationField.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.description.setSize(w, (int)SpecificationDetailsPanel.this.description.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.equipmentSystem.setLocation(SpecificationDetailsPanel.this.horizontalBorder, currentY += SpecificationDetailsPanel.this.description.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.equipmentSystem.setSize(w, (int)SpecificationDetailsPanel.this.equipmentSystem.getPreferredSize().getHeight());
            currentY += SpecificationDetailsPanel.this.equipmentSystem.getHeight() + SpecificationDetailsPanel.this.verticalBorder;
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int currentY = SpecificationDetailsPanel.this.verticalBorder;
            currentY = (int)((double)currentY + (SpecificationDetailsPanel.this.customer.getPreferredSize().getHeight() + (double)SpecificationDetailsPanel.this.verticalBorder));
            currentY = (int)((double)currentY + (SpecificationDetailsPanel.this.type.getPreferredSize().getHeight() + (double)SpecificationDetailsPanel.this.verticalBorder));
            currentY = (int)((double)currentY + (SpecificationDetailsPanel.this.matriculationField.getPreferredSize().getHeight() + (double)SpecificationDetailsPanel.this.verticalBorder));
            currentY = (int)((double)currentY + (SpecificationDetailsPanel.this.description.getPreferredSize().getHeight() + (double)SpecificationDetailsPanel.this.verticalBorder));
            currentY = (int)((double)currentY + (SpecificationDetailsPanel.this.equipmentSystem.getPreferredSize().getHeight() + (double)SpecificationDetailsPanel.this.verticalBorder));
            return new Dimension(260, currentY);
        }
    }
}

