/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.aircraft.details.utils;

import ch.icit.pegasus.client.converter.CabinClassConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.aircraft.details.PaxClassDetailsPanel;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDSearchComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.flightschedule.SeatConfigurationComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class Air2TableRowImpl
extends Table2RowPanel
implements NodeListener,
ButtonListener {
    private static final long serialVersionUID = 1L;
    private RDSearchComboBox className;
    private RDTextField capField;
    private DeleteButton deleteButton;
    private PaxClassDetailsPanel p2;
    private static Layout INSTANCE;
    private RDProvider provider;

    public Air2TableRowImpl(Table2RowModel m, PaxClassDetailsPanel p2, RDProvider provider) {
        super(m);
        this.p2 = p2;
        this.setLayout(Air2TableRowImpl.getNewLayouter());
        this.provider = provider;
        if (this.model.getParentModel().isDeletable()) {
            this.deleteButton = new DeleteButton();
            this.deleteButton.addButtonListener(this);
            this.add(this.deleteButton);
        }
        m.getNode().addNodeListener((NodeListener)this);
        m.getNode().getAllChildAddEventsFor((NodeListener)this, new String[]{SeatConfigurationComplete_.cabinClass.getFieldName(), SeatConfigurationComplete_.number.getFieldName()});
        this.childAdded(m.getNode(), m.getNode().getChildNamed(SeatConfigurationComplete_.cabinClass));
        this.childAdded(m.getNode(), m.getNode().getChildNamed(SeatConfigurationComplete_.number));
    }

    private static Layout getNewLayouter() {
        if (INSTANCE == null) {
            INSTANCE = new Layout();
        }
        return INSTANCE;
    }

    @Override
    public Object getObject4Column(int column) {
        switch (column) {
            case 0: {
                return this.className.getStringValue();
            }
        }
        return null;
    }

    public void setUsableNodes(ArrayList n) {
    }

    @Override
    public void requestFocusInWindowNow() {
        this.className.requestFocusInWindowNow();
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.className);
        CheckedListAdder.addToList(a, this.capField);
        CheckedListAdder.addToList(a, this.deleteButton);
        return a;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.model.getNode().removeNodeListener((NodeListener)this);
        this.className.kill();
        this.capField.kill();
        if (this.deleteButton != null) {
            this.deleteButton.kill();
        }
        this.className = null;
        this.capField = null;
        this.deleteButton = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.className.setEnabled(isEnabled);
        this.capField.setEnabled(isEnabled);
        if (this.deleteButton != null) {
            this.deleteButton.setEnabled(isEnabled);
        }
    }

    public void childAdded(Node<?> source, Node<?> child) {
        if (child.getName().equals(SeatConfigurationComplete_.cabinClass.getFieldName())) {
            Node<?> classValue = child;
            Node possibleValues = NodeToolkit.getAffixList(CabinClassComplete.class);
            CabinClassConverter viewConverter = (CabinClassConverter)ConverterRegistry.getConverter(CabinClassConverter.class);
            this.className = new RDSearchComboBox(this.provider, RDSearchComboBox.BoxSearchTypes.CABIN_CLASS);
            this.className.setNode(classValue);
            this.className.setProgress(1.0f);
            this.add(this.className);
        } else if (child.getName().equals(SeatConfigurationComplete_.number.getFieldName())) {
            this.capField = new RDTextField(this.provider, TextFieldType.INT);
            this.capField.setNode(child);
            this.capField.setProgress(1.0f);
            this.add(this.capField);
        }
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void valueChanged(Node<?> node) {
        this.p2.recalculateUsableValue4Combo();
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        this.model.getNode().getParent().removeChild(this.model.getNode(), 0L);
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    public boolean isSwingOnly() {
        return true;
    }

    public List<ScreenValidationObject> validateRow() {
        ArrayList<ScreenValidationObject> rets = new ArrayList<ScreenValidationObject>();
        if (this.capField.getEditor() != null && (Integer)this.capField.getNode().getValue() < 0) {
            rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.PAX_COUNT_SHOULD_BE_GREATER_THAN_0));
        }
        return rets;
    }

    public Integer getPax() {
        return (Integer)this.model.getNode().getChildNamed(SeatConfigurationComplete_.number).getValue();
    }

    private static class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            Air2TableRowImpl p = (Air2TableRowImpl)parent;
            int h = parent.getHeight();
            int currentX = 0;
            int w = p.model.getParentModel().getColumnWidth(0);
            p.className.setLocation(p.getCellPadding(), (int)(((double)h - p.className.getPreferredSize().getHeight()) / 2.0));
            p.className.setSize(w - (p.getCellPadding() + p.getCellPadding()), (int)p.className.getPreferredSize().getHeight());
            currentX += w;
            w = p.model.getParentModel().getColumnWidth(1);
            p.capField.setLocation(currentX + p.getCellPadding(), (int)(((double)h - p.className.getPreferredSize().getHeight()) / 2.0));
            p.capField.setSize(w - (p.getCellPadding() + p.getCellPadding()), (int)p.capField.getPreferredSize().getHeight());
            p.setControlsX(currentX += w);
            w = p.model.getParentModel().getColumnWidth(2);
            if (p.deleteButton != null) {
                p.deleteButton.setLocation(currentX + p.getCellPadding(), (int)(((double)h - p.deleteButton.getPreferredSize().getHeight()) / 2.0));
                p.deleteButton.setSize(p.deleteButton.getPreferredSize());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Air2TableRowImpl p = (Air2TableRowImpl)parent;
            return new Dimension(0, p.getDefaultRowHeight());
        }
    }
}

