/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.article.details;

import ch.icit.pegasus.client.comparators.controller.ComparatorRegistry;
import ch.icit.pegasus.client.converter.PerUnitViewConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.article.details.rows.StoresDetailsTableRowImpl;
import ch.icit.pegasus.client.gui.modules.article.details.utils.PreferenceComparator;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight_;
import ch.icit.pegasus.server.core.dtos.supply.StoreConditionComplete;
import ch.icit.pegasus.server.core.dtos.supply.StoreConditionComplete_;
import ch.icit.pegasus.server.core.dtos.supply.StoreConditionTypeE;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class StoresDetailsPanel
extends TableDetailsPanel<BasicArticleLight> {
    private static final long serialVersionUID = 1L;
    private TitledItem<RDTextField> minStock;
    private TitledItem<RDTextField> maxStock;
    private TextLabel perUnit1;
    private TextLabel perUnit2;

    public StoresDetailsPanel(RowEditor<BasicArticleLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(WordsToolkit.toCapitalLetter((String)Words.STORES_CONFIGURATION));
        this.minStock = new TitledItem<RDTextField>(new RDTextField(provider, TextFieldType.INT), Words.MINIMUM_STOCK, TitledItem.TitledItemOrientation.NORTH);
        this.maxStock = new TitledItem<RDTextField>(new RDTextField(provider, TextFieldType.INT), Words.OPTIMAL_STOCK, TitledItem.TitledItemOrientation.NORTH);
        this.perUnit1 = new TextLabel(null, ConverterRegistry.getConverter(PerUnitViewConverter.class));
        this.perUnit2 = new TextLabel(null, ConverterRegistry.getConverter(PerUnitViewConverter.class));
        this.addToView(this.minStock);
        this.addToView(this.maxStock);
        this.addToView(this.perUnit1);
        this.addToView(this.perUnit2);
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        int deleteW = TableColumnInfo.getSortableColumnWidth(this.table);
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo("", null, null, null, "", 30, 30, 30));
        columns.add(new TableColumnInfo(Words.STORE, null, null, null, "", 70, 70, 70));
        columns.add(new TableColumnInfo(Words.STORE_TYPE, null, null, null, "", 70, 70, 70));
        columns.add(new TableColumnInfo(Words.DEPARTMENT, null, null, null, "", 160, 160, 160));
        columns.add(new TableColumnInfo("", null, null, null, "", deleteW, deleteW, deleteW));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.8);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.2);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setProvider(this.provider);
        table.setRequestFocusOnAdd(true);
        table.setComparator(ComparatorRegistry.getComparator(PreferenceComparator.class));
        table.setDontUseScrollBar(15);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
        StoreConditionComplete dto = new StoreConditionComplete();
        dto.setPreference(Integer.valueOf(this.table.getRowCount()));
        dto.setCapacity(Integer.valueOf(0));
        Node nDto = INodeCreator.getDefaultImpl().getNode4DTO((Object)dto, true, false);
        this.editor.getModel().getNode().getChildNamed(BasicArticleComplete_.storeConditions).addChild(nDto, System.currentTimeMillis());
        this.editor.revalidate();
        this.relayoutTable();
    }

    @Override
    public void childRemoved() {
        this.table.writeNumber(StoreConditionComplete_.preference, 0);
        this.editor.revalidate();
        this.relayoutTable();
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        StoresDetailsTableRowImpl p = new StoresDetailsTableRowImpl(model, this, this.provider, this.table.getModel().isOrderChangable(), this.table.getModel().isDeletable());
        p.setUseControlSkin(Table2RowPanel.TableControlsType.THREE);
        return p;
    }

    @Override
    public void setNode(Node<?> node) {
        Node uNode = node.getChildNamed(BasicArticleLight_.mainStoreUnit);
        this.minStock.getElement().setNode(node.getChildNamed(BasicArticleComplete_.minStock));
        this.maxStock.getElement().setNode(node.getChildNamed(BasicArticleComplete_.maxStock));
        this.perUnit1.setNode(uNode);
        this.perUnit2.setNode(uNode);
        this.table.getModel().setNode(node.getChildNamed(BasicArticleComplete_.storeConditions));
        this.table.getModel().allInitiated();
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.minStock.kill();
        this.maxStock.kill();
        this.perUnit1.kill();
        this.perUnit2.kill();
        this.perUnit1 = null;
        this.perUnit2 = null;
        this.minStock = null;
        this.maxStock = null;
        this.table = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.minStock.setEnabled(isEnabled);
        this.maxStock.setEnabled(isEnabled);
        this.table.setEnabled(isEnabled);
        this.perUnit1.setEnabled(isEnabled);
        this.perUnit2.setEnabled(isEnabled);
    }

    protected void relayoutTable() {
        this.table.updateOrder();
        this.editor.createFocusCycle();
        this.table.relayoutRequested();
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        Boolean checkout = (Boolean)this.editor.getModel().getNode().getChildNamed(BasicArticleLight_.autoCheckout).getValue();
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        boolean hasDeliverStore = false;
        if (this.table.isWritable()) {
            boolean storeSelected = true;
            boolean checkoutStore = false;
            for (Table2RowPanel rowPanel : this.table.getRows()) {
                StoresDetailsTableRowImpl rowPanelImpl = (StoresDetailsTableRowImpl)rowPanel;
                if (!rowPanelImpl.isStoreSelected()) {
                    storeSelected = false;
                }
                if (rowPanelImpl.getModel().getNode().getChildNamed(StoreConditionComplete_.type).getValue() == StoreConditionTypeE.FLIGHT_AUTOSTOCK) {
                    checkoutStore = true;
                }
                if (rowPanelImpl.getModel().getNode().getChildNamed(StoreConditionComplete_.type).getValue() != StoreConditionTypeE.REQUISITION_DELIVER) continue;
                hasDeliverStore = true;
            }
            if (!storeSelected) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_STORE_IS_SET_FOR_EACH_ENTRY));
            }
            if (Boolean.TRUE.equals(settings.getAutoCheckout()) && Boolean.TRUE.equals(checkout) && !checkoutStore && !Boolean.TRUE.equals(settings.getFlightCheckoutStoreOptionalWhenAutoCheckoutActive())) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_ATLEAST_ONE_FLIGHT_CHECKOUT_STORE_IS_DEFINED));
            }
            if (Boolean.TRUE.equals(settings.getDeliverRequisitionProcessActive()) && !hasDeliverStore) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_ARTICLE_HAS_A_DELIVER_STORE));
            }
        }
        return validationObjects;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusComponents = new ArrayList<Component>();
        CheckedListAdder.addToList(focusComponents, this.minStock);
        CheckedListAdder.addToList(focusComponents, this.maxStock);
        CheckedListAdder.addToList(focusComponents, this.table);
        return focusComponents;
    }

    @Override
    public void layoutContainer(Container parent) {
        this.minStock.setLocation(this.horizontalBorder, this.verticalBorder);
        this.minStock.setSize((int)this.minStock.getPreferredSize().getWidth(), (int)this.minStock.getPreferredSize().getHeight());
        this.perUnit1.setLocation(this.minStock.getX() + this.minStock.getWidth(), (int)((double)(this.minStock.getY() + this.minStock.getHeight()) - this.minStock.getElement().getPreferredSize().getHeight()));
        this.perUnit1.setSize(this.perUnit1.getPreferredSize());
        this.maxStock.setLocation(this.perUnit1.getX() + this.perUnit1.getWidth() + 2 * this.horizontalBorder, this.verticalBorder);
        this.maxStock.setSize((int)this.maxStock.getPreferredSize().getWidth(), (int)this.maxStock.getPreferredSize().getHeight());
        this.perUnit2.setLocation(this.maxStock.getX() + this.maxStock.getWidth(), (int)((double)(this.maxStock.getY() + this.maxStock.getHeight()) - this.maxStock.getElement().getPreferredSize().getHeight()));
        this.perUnit2.setSize(this.perUnit2.getPreferredSize());
        this.table.setLocation(0, this.verticalBorder * 2 + this.maxStock.getHeight());
        this.table.setSize(parent.getWidth(), parent.getHeight() - this.table.getY());
    }

    @Override
    public Dimension calculateContainerPreferredSize() {
        int h = this.verticalBorder;
        h = (int)((double)h + this.maxStock.getPreferredSize().getHeight());
        h += this.verticalBorder;
        h = (int)((double)h + this.table.getPreferredSize().getHeight());
        return new Dimension(0, h);
    }
}

