/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.article.details;

import ch.icit.pegasus.client.gui.screentemplates.details.AbstractTemplateDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.toolkits.copy.CopyTemplateToolkit;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityBaseComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionBaseComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionCategoryComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionComplete;
import ch.icit.pegasus.server.core.dtos.utils.DateUtil;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;

public class TemplateDetailsPanel
extends AbstractTemplateDetailsPanel<BasicArticleLight> {
    private static final long serialVersionUID = 1L;

    public TemplateDetailsPanel(RowEditor editor, RDProvider provider) {
        super(editor, provider);
    }

    @Override
    public SearchTextField2 getSearchField() {
        return SearchTextField2Factory.getBasicArticleSearchField(true, new DTOProxyNode((Object)null));
    }

    @Override
    public String getSearchFieldTitle() {
        return Words.getFirstCapitalLetter((String)Words.ARTICLE);
    }

    @Override
    public String getLoadingText() {
        return Words.getFirstCapitalLetter((String)Words.COPY) + " " + Words.getFirstCapitalLetter((String)Words.ARTICLE);
    }

    @Override
    public ThreadSafeExecutable getJob() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node n = TemplateDetailsPanel.this.getSelectedNode();
                BasicArticleComplete l = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle((BasicArticleReference)n.getValue()).getValue();
                BasicArticleComplete artC = CopyTemplateToolkit.copyArticle((BasicArticleLight)l);
                Date now = new Date(System.currentTimeMillis());
                int year = DateUtil.getYear((java.util.Date)now);
                Date firstDayInYear = DateUtil.getSQLDate((int)year, (int)1, (int)1, (int)0, (int)0, (int)0);
                for (SupplierConditionBaseComplete supplier : artC.getSuppliers()) {
                    for (SupplierConditionCategoryComplete categoryComplete : supplier.getSupplierConditionCategory()) {
                        ArrayList<SupplierConditionComplete> usedConditions = new ArrayList<SupplierConditionComplete>();
                        for (SupplierConditionComplete condition : categoryComplete.getConditions()) {
                            if (condition.getValidity().getEndDate().getTime() <= firstDayInYear.getTime()) continue;
                            usedConditions.add(condition);
                        }
                        categoryComplete.getConditions().clear();
                        if (usedConditions.size() > 3) {
                            Collections.sort(usedConditions);
                            while (usedConditions.size() > 3) {
                                usedConditions.remove(0);
                            }
                        }
                        categoryComplete.getConditions().addAll(usedConditions);
                    }
                }
                Collections.sort(artC.getPackingQuantitiesVariants());
                for (PackagingQuantityBaseComplete packingQuantitiesVariant : artC.getPackingQuantitiesVariants()) {
                    Collections.sort(packingQuantitiesVariant.getPackingQuantities());
                }
                ViewNode ret = new ViewNode("Return");
                ret.setValue((Object)artC, 0L);
                return ret;
            }

            @Override
            public RemoteLoader getInvoker() {
                return null;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        return run;
    }

    @Override
    public Class<?> getCommittingClass() {
        return BasicArticleComplete.class;
    }

    @Override
    public boolean getUpdateNodeBased() {
        return true;
    }
}

