/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.customer;

import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.search.SearchServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientValidationException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.BankConnectionComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ContactComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.HaulTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.SalutationComplete;
import ch.icit.pegasus.server.core.dtos.product.TaxRateComplete;
import ch.icit.pegasus.server.core.dtos.search.ADtoSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.CustomerSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.CustomerComplete;
import ch.icit.pegasus.server.core.dtos.supply.CustomerComplete_;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.supply.CustomerReference;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.SearchResult;
import ch.icit.pegasus.server.core.i18n.Words;

public class CustomerModuleDataHandler
extends DefaultDataHandler<CustomerReference, CustomerComplete> {
    public CustomerModuleDataHandler(long id, ScreenTableView tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return Words.CHECK_CUSTOMER_CODE;
    }

    @Override
    public void updateData(final Node<CustomerReference> node, final RemoteLoader model, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                node.commit(CustomerComplete.class);
                CustomerComplete dto = (CustomerComplete)node.getValue(CustomerComplete.class);
                if (dto.getGlobalLocationNumber() != null) {
                    dto.setGlobalLocationNumber(dto.getGlobalLocationNumber().trim());
                }
                CustomerReference nDto = (CustomerReference)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).updateCustomer((CustomerReference)dto).getValue();
                node.removeExistingValues();
                node.setValue((Object)nDto, System.currentTimeMillis());
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void createNewData(final Node<CustomerComplete> node, final RemoteLoader model, boolean sameNode, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                node.commit(CustomerComplete.class);
                CustomerComplete dto = (CustomerComplete)node.getValue();
                if (dto.getGlobalLocationNumber() != null) {
                    dto.setGlobalLocationNumber(dto.getGlobalLocationNumber().trim());
                }
                if (dto.getEligibleLocations().isEmpty()) {
                    dto.getEligibleLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
                }
                CustomerComplete nDto = (CustomerComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).createCustomer(dto).getValue();
                node.removeExistingValues();
                node.setValue((Object)nDto, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, final ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                CustomerModuleDataHandler.this.setCurrentLoadMaximum(10);
                CustomerModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CurrencyComplete.class);
                CustomerModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(SalutationComplete.class);
                CustomerModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached();
                CustomerModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(BankConnectionComplete.class);
                CustomerModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getAllLocationsCached();
                CustomerModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(InternalCostCenterComplete.class);
                CustomerModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CabinClassComplete.class);
                CustomerModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(HaulTypeComplete.class);
                CustomerModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCustomersCached();
                CustomerModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(TaxRateComplete.class);
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return CustomerModuleDataHandler.this.model;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<CustomerComplete> resetData(Node<CustomerComplete> node) {
        return this.createEmptyNode();
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener pListener) {
        this.showMessage(pListener, Words.REFRESH_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                CustomerLight cust = (CustomerLight)node.getValue(CustomerLight.class);
                CustomerComplete ncust = (CustomerComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getCustomer(new CustomerReference(cust.getId())).getValue();
                node.removeExistingValues();
                node.setValue((Object)ncust, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    @Override
    public Node<CustomerComplete> createEmptyNode() {
        CustomerComplete nC = new CustomerComplete();
        nC.setCustomerProductNumberForLabelBarCode(Boolean.valueOf(true));
        nC.setUseAdditionalOrderAmountForLabelCount(Boolean.valueOf(false));
        nC.setClientOId(Long.valueOf(ADTO.getNextId()));
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        ContactComplete hq = new ContactComplete();
        hq.setClientOId(Long.valueOf(ADTO.getNextId()));
        hq.setCity("");
        hq.setCountry("");
        hq.setEmail("");
        hq.setFax("");
        if (Boolean.TRUE.equals(settings.getCompany().getSolarCompanyType())) {
            hq.setFirstName("Hauptsitz");
            hq.setFunction("");
        } else {
            hq.setFirstName("Headquarters");
            hq.setFunction("Main");
        }
        hq.setLastName("");
        hq.setMobile("");
        hq.setProvince("");
        hq.setSitaCode("");
        hq.setStation("");
        hq.setStreet("");
        hq.setStreetNumber("");
        hq.setTel("");
        hq.setTitle("");
        hq.setZipCode("");
        nC.setHeadQuarters(hq);
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)nC, false, false);
        INodeCreator.getDefaultImpl().initUpdate(n);
        return n;
    }

    @Override
    public Class<CustomerComplete> getCommittingClass() {
        return CustomerComplete.class;
    }

    @Override
    public void doRemoteValidation(final Node<CustomerReference> node, final RemoteLoader listener, ProgressListener l, boolean validateAll) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                String t = (String)node.getChildNamed(CustomerComplete_.code).getValue(String.class);
                CustomerSearchConfiguration csc = new CustomerSearchConfiguration();
                csc.setCode(t);
                SearchResult ret = ((SearchServiceManager)ServiceManagerRegistry.getService(SearchServiceManager.class)).search((ADtoSearchConfiguration)csc);
                if (!ret.getResults().isEmpty()) {
                    for (CustomerLight c : ret.getResults()) {
                        if (c.equals(node.getValue()) || !t.equals(c.getCode())) continue;
                        throw new ClientValidationException(new ScreenValidationObject[]{new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.CUSTOMER_CODE_IS_ALREADY_IN_USE)});
                    }
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }
}

