/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.customer.details;

import ch.icit.pegasus.client.converter.BankConnectionConverter;
import ch.icit.pegasus.client.converter.CurrencyConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.customer.details.utils.CustomerEditorPopup;
import ch.icit.pegasus.client.gui.modules.supplier.details.utils.ContactNameConverter;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.EditButton;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDCheckBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDInvoiceNoFormatField;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDNumericStepper;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.textfield.InvoiceNoFormatEditor;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.masterdata.BankConnectionComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.supply.CustomerComplete_;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PaymentDetailsPanel
extends DefaultDetailsPanel<CustomerLight>
implements NodeListener,
InnerPopUpListener2 {
    private static final long serialVersionUID = 1L;
    private final boolean isSolarCompany;
    private TitledItem<RDNumericStepper> terms;
    private TextLabel termsPostfix;
    private TitledItem<RDComboBox> currency;
    private TitledItem<RDComboBox> billingContact;
    private Node<?> contactsList;
    private TitledItem<RDComboBox> accountConnection;
    private TitledItem<RDTextField> accountInformation;
    private RDCheckBox discountAllowed;
    private TitledItem<RDNumericStepper> discountDays;
    private TitledItem<RDTextField> discountValue;
    private TextLabel percentage;
    private TitledItem<RDCheckBox> excludeVAT;
    private TitledItem<RDCheckBox> useOtherCustomersProducts;
    private TitledItem<RDCheckBox> useOtherCustomersHandlings;
    private TitledItem<RDCheckBox> showEmailOnInvoiceHeader;
    private TitledItem<RDInvoiceNoFormatField> invoiceFormatEditor;
    private EditButton allowedCustomersButton;
    private TitledItem<RDTextField> vatNumber;

    public PaymentDetailsPanel(RowEditor<CustomerLight> editor, RDProvider provider) {
        super(editor, provider);
        this.isSolarCompany = Boolean.TRUE.equals(this.settings.getCompany().getSolarCompanyType());
        this.setOpaque(false);
        this.setTitleText(Words.PAYMENT_SETTINGS);
        this.setCustomLayouter(new Layout());
        this.terms = new TitledItem<RDNumericStepper>(new RDNumericStepper(provider, 3), Words.TERMS, TitledItem.TitledItemOrientation.NORTH);
        this.termsPostfix = new TextLabel(Words.DAYS);
        this.currency = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(CurrencyConverter.class)), Words.CURRENCY, TitledItem.TitledItemOrientation.NORTH);
        this.billingContact = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(ContactNameConverter.class)), Words.CONTACT, TitledItem.TitledItemOrientation.NORTH);
        this.accountConnection = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(BankConnectionConverter.class)), Words.BANK_CONNECTION, TitledItem.TitledItemOrientation.NORTH);
        this.accountInformation = new TitledItem<RDTextField>(new RDTextField(provider), Words.ACCOUNT_INFORMATION, TitledItem.TitledItemOrientation.NORTH);
        this.discountAllowed = new RDCheckBox(provider);
        this.discountAllowed.addButtonListener(this);
        this.discountDays = new TitledItem<RDNumericStepper>(new RDNumericStepper(provider, 3), Words.DISCOUNT_DAYS, TitledItem.TitledItemOrientation.NORTH);
        this.discountValue = new TitledItem<RDTextField>(new RDTextField(provider, TextFieldType.DOUBLE), Words.DISCOUNT_VALUE, TitledItem.TitledItemOrientation.NORTH);
        this.percentage = new TextLabel("%");
        this.excludeVAT = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.EXCLUDE_VAT, TitledItem.TitledItemOrientation.EAST);
        if (!this.isSolarCompany) {
            this.useOtherCustomersProducts = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.USE_OTHER_CUSTOMERS_PRODUCTS, TitledItem.TitledItemOrientation.EAST);
            this.useOtherCustomersProducts.getElement().addButtonListener(this);
            this.useOtherCustomersHandlings = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.USE_OTHER_CUSTOMERS_HANDLING, TitledItem.TitledItemOrientation.EAST);
            this.allowedCustomersButton = new EditButton();
            this.allowedCustomersButton.addButtonListener(this);
            this.invoiceFormatEditor = new TitledItem<RDInvoiceNoFormatField>(new RDInvoiceNoFormatField(provider), Words.INVOICE_NUMBER_FORMAT, TitledItem.TitledItemOrientation.NORTH);
        }
        this.vatNumber = new TitledItem<RDTextField>(new RDTextField(provider), Words.VAT_NUMBER, TitledItem.TitledItemOrientation.NORTH);
        this.showEmailOnInvoiceHeader = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.SHOW_EMAIL_ON_INVOICE_HEADER, TitledItem.TitledItemOrientation.EAST);
        this.addToView(this.terms);
        this.addToView(this.termsPostfix);
        this.addToView(this.currency);
        this.addToView(this.billingContact);
        this.addToView(this.accountConnection);
        this.addToView(this.accountInformation);
        this.addToView(this.discountAllowed);
        this.addToView(this.discountDays);
        this.addToView(this.discountValue);
        this.addToView(this.percentage);
        this.addToView(this.excludeVAT);
        if (!this.isSolarCompany) {
            this.addToView(this.useOtherCustomersProducts);
            this.addToView(this.allowedCustomersButton);
            this.addToView(this.useOtherCustomersHandlings);
            this.addToView(this.invoiceFormatEditor);
        }
        this.addToView(this.vatNumber);
        this.addToView(this.showEmailOnInvoiceHeader);
    }

    @Override
    public void setNode(Node<?> node) {
        this.terms.getElement().setNode(node.getChildNamed(CustomerComplete_.paymentDays));
        this.currency.getElement().refreshPossibleValues(NodeToolkit.getAffixList(CurrencyComplete.class));
        this.currency.getElement().setNode(node.getChildNamed(CustomerComplete_.paymentCurrency));
        this.billingContact.getElement().refreshPossibleValues(this.createContactView());
        this.billingContact.getElement().setNode(node.getChildNamed(CustomerComplete_.billingContact));
        this.accountConnection.getElement().refreshPossibleValues(NodeToolkit.getAffixList(BankConnectionComplete.class));
        this.accountConnection.getElement().setNode(node.getChildNamed(CustomerComplete_.accountConnection));
        this.accountInformation.getElement().setNode(node.getChildNamed(CustomerComplete_.information));
        this.discountAllowed.setNode(node.getChildNamed(CustomerComplete_.discountAllowed));
        this.discountDays.getElement().setNode(node.getChildNamed(CustomerComplete_.discountDays));
        this.discountValue.getElement().setNode(node.getChildNamed(CustomerComplete_.discountRate));
        this.excludeVAT.getElement().setNode(node.getChildNamed(CustomerComplete_.excludeVAT));
        if (!this.isSolarCompany) {
            this.useOtherCustomersHandlings.getElement().setNode(node.getChildNamed(CustomerLight_.showOtherCustomersHandlingCosts));
            this.useOtherCustomersProducts.getElement().setNode(node.getChildNamed(CustomerComplete_.showOtherCustomersProducts));
            this.invoiceFormatEditor.getElement().setNode(node.getChildNamed(CustomerComplete_.invoiceFormat));
        }
        if (this.editor.getModel().isAddRow()) {
            SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            Node in = node.getChildNamed(CustomerComplete_.invoiceFormat);
            in.setValue((Object)settings.getDefaultInvoiceNoFormat(), 0L);
        }
        this.vatNumber.getElement().setNode(node.getChildNamed(CustomerComplete_.vatNumber));
        this.showEmailOnInvoiceHeader.getElement().setNode(node.getChildNamed(CustomerComplete_.showEmailOnInvoiceHeader));
    }

    private boolean ensureDiscountState() {
        return this.editor.getModel().getNode().getChildNamed(CustomerComplete_.discountAllowed) != null && this.editor.getModel().getNode().getChildNamed(CustomerComplete_.discountAllowed).getValue() != null && (Boolean)this.editor.getModel().getNode().getChildNamed(CustomerComplete_.discountAllowed).getValue() != false;
    }

    private Node<?> createContactView() {
        this.contactsList = new ViewNode("");
        Iterator it = this.editor.getModel().getNode().getChildNamed(CustomerComplete_.contacts).getChilds();
        while (it.hasNext()) {
            Node nn = (Node)it.next();
            this.contactsList.addChild(nn, 0L);
        }
        this.contactsList.addChild(this.editor.getModel().getNode().getChildNamed(CustomerComplete_.headQuarters), 0L);
        this.editor.getModel().getNode().getChildNamed(CustomerComplete_.contacts).addNodeListener((NodeListener)this);
        return this.contactsList;
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.terms);
        CheckedListAdder.addToList(focusList, this.currency);
        CheckedListAdder.addToList(focusList, this.billingContact);
        CheckedListAdder.addToList(focusList, this.accountConnection);
        CheckedListAdder.addToList(focusList, this.accountInformation);
        CheckedListAdder.addToList(focusList, this.discountAllowed);
        CheckedListAdder.addToList(focusList, this.discountDays);
        CheckedListAdder.addToList(focusList, this.discountValue);
        CheckedListAdder.addToList(focusList, this.excludeVAT);
        CheckedListAdder.addToList(focusList, this.vatNumber);
        CheckedListAdder.addToList(focusList, this.useOtherCustomersProducts);
        CheckedListAdder.addToList(focusList, this.useOtherCustomersHandlings);
        CheckedListAdder.addToList(focusList, this.showEmailOnInvoiceHeader);
        CheckedListAdder.addToList(focusList, this.invoiceFormatEditor);
        CheckedListAdder.addToList(focusList, this.allowedCustomersButton);
        return focusList;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.terms.kill();
        this.termsPostfix.kill();
        this.currency.kill();
        this.billingContact.kill();
        this.accountConnection.kill();
        this.accountInformation.kill();
        this.vatNumber.kill();
        this.discountAllowed.kill();
        this.discountDays.kill();
        this.discountValue.kill();
        this.excludeVAT.kill();
        if (!this.isSolarCompany) {
            this.useOtherCustomersProducts.kill();
            this.useOtherCustomersHandlings.kill();
            this.allowedCustomersButton.kill();
            this.invoiceFormatEditor.kill();
        }
        this.showEmailOnInvoiceHeader.kill();
        if (this.editor != null && this.editor.getModel() != null && this.editor.getModel().getNode() != null && this.editor.getModel().getNode().getChildNamed(CustomerComplete_.contacts) != null) {
            this.editor.getModel().getNode().getChildNamed(CustomerComplete_.contacts).removeNodeListener((NodeListener)this);
        }
        this.terms = null;
        this.termsPostfix = null;
        this.currency = null;
        this.billingContact = null;
        this.accountConnection = null;
        this.accountInformation = null;
        this.vatNumber = null;
        this.discountAllowed = null;
        this.discountDays = null;
        this.discountValue = null;
        this.excludeVAT = null;
        this.useOtherCustomersProducts = null;
        this.invoiceFormatEditor = null;
        this.allowedCustomersButton = null;
        this.showEmailOnInvoiceHeader = null;
        this.useOtherCustomersHandlings = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.terms.setEnabled(isEnabled);
        this.termsPostfix.setEnabled(isEnabled);
        this.currency.setEnabled(isEnabled);
        this.billingContact.setEnabled(isEnabled);
        this.accountConnection.setEnabled(isEnabled);
        this.accountInformation.setEnabled(isEnabled);
        this.discountAllowed.setEnabled(isEnabled);
        this.showEmailOnInvoiceHeader.setEnabled(isEnabled);
        boolean discountAllowed = this.ensureDiscountState() && isEnabled;
        this.discountDays.setEnabled(discountAllowed);
        this.discountValue.setEnabled(discountAllowed);
        this.excludeVAT.setEnabled(isEnabled);
        this.vatNumber.setEnabled(isEnabled);
        if (!this.isSolarCompany) {
            this.useOtherCustomersProducts.setEnabled(isEnabled);
            this.allowedCustomersButton.setEnabled((this.useOtherCustomersProducts.getElement().isChecked() || this.useOtherCustomersHandlings.getElement().isChecked()) && isEnabled);
            this.useOtherCustomersHandlings.setEnabled(isEnabled);
            this.invoiceFormatEditor.setEnabled(isEnabled);
        }
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        super.buttonPressed(source, x, y);
        if (source == this.discountAllowed.getEditor()) {
            this.setEnabled(this.isEnabled());
            this.fireFocusCycleChanged(this);
        } else if (source == this.allowedCustomersButton) {
            InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
            popUp.setAttributes(source, true, true, Words.CUSTOMERS);
            popUp.setView(new CustomerEditorPopup(this.editor.getModel().getNode().getChildNamed(CustomerComplete_.showOtherCustomersList), (CustomerLight)this.editor.getModel().getDTO(CustomerLight.class)));
            popUp.showPopUp(x, y, 300, 300, this, source, PopupType.FRAMELESS);
        } else if (source == this.useOtherCustomersProducts.getElement().getEditor()) {
            this.setEnabled(this.isEnabled());
        }
    }

    public void childAdded(Node<?> source, Node<?> child) {
        this.contactsList.addChild(child, 0L);
    }

    public void childRemoved(Node<?> source, Node<?> child) {
        this.contactsList.removeChild(child, 0L);
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    public void valueChanged(Node<?> node) {
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    public boolean isSwingOnly() {
        return true;
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        if (this.invoiceFormatEditor != null && this.invoiceFormatEditor.getElement().isWritable()) {
            return ((InvoiceNoFormatEditor)this.invoiceFormatEditor.getElement().getEditor()).validateFormat();
        }
        return super.validateParagraph();
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int aMinWidth = parent.getWidth() - 4 * PaymentDetailsPanel.this.horizontalBorder;
            aMinWidth -= PaymentDetailsPanel.this.horizontalBorder;
            int w = parent.getWidth() - 3 * PaymentDetailsPanel.this.horizontalBorder;
            PaymentDetailsPanel.this.terms.setLocation(PaymentDetailsPanel.this.horizontalBorder, PaymentDetailsPanel.this.verticalBorder);
            PaymentDetailsPanel.this.terms.setSize((int)((double)(aMinWidth /= 2) - (PaymentDetailsPanel.this.termsPostfix.getPreferredSize().getWidth() + 5.0)), (int)PaymentDetailsPanel.this.terms.getPreferredSize().getHeight());
            PaymentDetailsPanel.this.termsPostfix.setLocation(PaymentDetailsPanel.this.terms.getX() + PaymentDetailsPanel.this.terms.getWidth() + 5, (int)((double)(PaymentDetailsPanel.this.terms.getY() + PaymentDetailsPanel.this.terms.getHeight()) - PaymentDetailsPanel.this.termsPostfix.getPreferredSize().getHeight()));
            PaymentDetailsPanel.this.termsPostfix.setSize(PaymentDetailsPanel.this.termsPostfix.getPreferredSize());
            PaymentDetailsPanel.this.currency.setLocation(PaymentDetailsPanel.this.termsPostfix.getX() + PaymentDetailsPanel.this.termsPostfix.getWidth() + PaymentDetailsPanel.this.horizontalBorder, PaymentDetailsPanel.this.verticalBorder);
            PaymentDetailsPanel.this.currency.setSize(aMinWidth, (int)PaymentDetailsPanel.this.currency.getPreferredSize().getHeight());
            PaymentDetailsPanel.this.billingContact.setLocation(PaymentDetailsPanel.this.horizontalBorder, PaymentDetailsPanel.this.currency.getY() + PaymentDetailsPanel.this.currency.getHeight() + PaymentDetailsPanel.this.inner_verticalBorder);
            PaymentDetailsPanel.this.billingContact.setSize(aMinWidth, (int)PaymentDetailsPanel.this.billingContact.getPreferredSize().getHeight());
            PaymentDetailsPanel.this.accountConnection.setLocation(PaymentDetailsPanel.this.horizontalBorder, PaymentDetailsPanel.this.billingContact.getHeight() + PaymentDetailsPanel.this.billingContact.getY() + PaymentDetailsPanel.this.inner_verticalBorder);
            PaymentDetailsPanel.this.accountConnection.setSize(250, (int)PaymentDetailsPanel.this.accountConnection.getPreferredSize().getHeight());
            PaymentDetailsPanel.this.accountInformation.setLocation(PaymentDetailsPanel.this.horizontalBorder, PaymentDetailsPanel.this.accountConnection.getHeight() + PaymentDetailsPanel.this.accountConnection.getY() + PaymentDetailsPanel.this.inner_verticalBorder);
            PaymentDetailsPanel.this.accountInformation.setSize(250, (int)PaymentDetailsPanel.this.accountInformation.getPreferredSize().getHeight());
            PaymentDetailsPanel.this.discountDays.setLocation((int)((double)PaymentDetailsPanel.this.horizontalBorder + PaymentDetailsPanel.this.discountAllowed.getPreferredSize().getWidth() + 5.0), PaymentDetailsPanel.this.accountInformation.getY() + PaymentDetailsPanel.this.accountInformation.getHeight() + PaymentDetailsPanel.this.inner_verticalBorder);
            PaymentDetailsPanel.this.discountDays.setSize(PaymentDetailsPanel.this.discountDays.getPreferredSize());
            PaymentDetailsPanel.this.discountAllowed.setLocation(PaymentDetailsPanel.this.horizontalBorder, PaymentDetailsPanel.this.discountDays.getY() + PaymentDetailsPanel.this.discountDays.getHeight() - 17);
            PaymentDetailsPanel.this.discountAllowed.setSize(parent.getWidth() - 2 * PaymentDetailsPanel.this.horizontalBorder, (int)PaymentDetailsPanel.this.discountAllowed.getPreferredSize().getHeight());
            PaymentDetailsPanel.this.discountValue.setLocation(PaymentDetailsPanel.this.discountDays.getX() + PaymentDetailsPanel.this.discountDays.getWidth() + PaymentDetailsPanel.this.inner_horizontalBorder, PaymentDetailsPanel.this.discountDays.getY());
            PaymentDetailsPanel.this.discountValue.setSize(PaymentDetailsPanel.this.discountValue.getPreferredSize());
            PaymentDetailsPanel.this.percentage.setLocation(PaymentDetailsPanel.this.discountValue.getX() + PaymentDetailsPanel.this.discountValue.getWidth() + 3, PaymentDetailsPanel.this.discountValue.getY() + PaymentDetailsPanel.this.discountValue.getHeight() - 21);
            PaymentDetailsPanel.this.percentage.setSize(PaymentDetailsPanel.this.percentage.getPreferredSize());
            PaymentDetailsPanel.this.vatNumber.setLocation(PaymentDetailsPanel.this.horizontalBorder, PaymentDetailsPanel.this.discountDays.getY() + PaymentDetailsPanel.this.discountDays.getHeight() + PaymentDetailsPanel.this.verticalBorder);
            PaymentDetailsPanel.this.vatNumber.setSize((int)((double)w - PaymentDetailsPanel.this.excludeVAT.getPreferredSize().getWidth()), (int)PaymentDetailsPanel.this.vatNumber.getPreferredSize().getHeight());
            PaymentDetailsPanel.this.excludeVAT.setLocation(PaymentDetailsPanel.this.vatNumber.getX() + PaymentDetailsPanel.this.vatNumber.getWidth() + PaymentDetailsPanel.this.horizontalBorder, PaymentDetailsPanel.this.vatNumber.getY() + 25);
            PaymentDetailsPanel.this.excludeVAT.setSize(PaymentDetailsPanel.this.excludeVAT.getPreferredSize());
            int cy = PaymentDetailsPanel.this.vatNumber.getY() + PaymentDetailsPanel.this.vatNumber.getHeight();
            if (!PaymentDetailsPanel.this.isSolarCompany) {
                PaymentDetailsPanel.this.useOtherCustomersProducts.setLocation(PaymentDetailsPanel.this.horizontalBorder, cy + PaymentDetailsPanel.this.verticalBorder);
                PaymentDetailsPanel.this.useOtherCustomersProducts.setSize(PaymentDetailsPanel.this.useOtherCustomersProducts.getPreferredSize());
                PaymentDetailsPanel.this.useOtherCustomersHandlings.setLocation(PaymentDetailsPanel.this.horizontalBorder, PaymentDetailsPanel.this.useOtherCustomersProducts.getY() + PaymentDetailsPanel.this.useOtherCustomersProducts.getHeight() + PaymentDetailsPanel.this.inner_verticalBorder);
                PaymentDetailsPanel.this.useOtherCustomersHandlings.setSize(PaymentDetailsPanel.this.useOtherCustomersHandlings.getPreferredSize());
                PaymentDetailsPanel.this.allowedCustomersButton.setLocation((int)((double)parent.getWidth() - PaymentDetailsPanel.this.allowedCustomersButton.getPreferredSize().getWidth() - (double)PaymentDetailsPanel.this.inner_horizontalBorder), PaymentDetailsPanel.this.useOtherCustomersProducts.getY());
                PaymentDetailsPanel.this.allowedCustomersButton.setSize(PaymentDetailsPanel.this.allowedCustomersButton.getPreferredSize());
                cy = PaymentDetailsPanel.this.useOtherCustomersHandlings.getY() + PaymentDetailsPanel.this.useOtherCustomersHandlings.getHeight();
            }
            PaymentDetailsPanel.this.showEmailOnInvoiceHeader.setLocation(PaymentDetailsPanel.this.horizontalBorder, cy + PaymentDetailsPanel.this.inner_verticalBorder);
            PaymentDetailsPanel.this.showEmailOnInvoiceHeader.setSize(PaymentDetailsPanel.this.showEmailOnInvoiceHeader.getPreferredSize());
            if (!PaymentDetailsPanel.this.isSolarCompany) {
                PaymentDetailsPanel.this.invoiceFormatEditor.setLocation(PaymentDetailsPanel.this.horizontalBorder, PaymentDetailsPanel.this.showEmailOnInvoiceHeader.getY() + PaymentDetailsPanel.this.showEmailOnInvoiceHeader.getHeight() + PaymentDetailsPanel.this.inner_verticalBorder);
                PaymentDetailsPanel.this.invoiceFormatEditor.setSize(parent.getWidth() - 2 * PaymentDetailsPanel.this.horizontalBorder, (int)PaymentDetailsPanel.this.invoiceFormatEditor.getPreferredSize().getHeight());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PaymentDetailsPanel.this.verticalBorder;
            h = (int)((double)h + PaymentDetailsPanel.this.terms.getPreferredSize().getHeight());
            h += PaymentDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + PaymentDetailsPanel.this.accountConnection.getPreferredSize().getHeight());
            h += PaymentDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + PaymentDetailsPanel.this.accountInformation.getPreferredSize().getHeight());
            h += PaymentDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + PaymentDetailsPanel.this.billingContact.getPreferredSize().getHeight());
            h += PaymentDetailsPanel.this.verticalBorder;
            h = (int)((double)h + PaymentDetailsPanel.this.discountDays.getPreferredSize().getHeight());
            h += PaymentDetailsPanel.this.verticalBorder;
            h = (int)((double)h + PaymentDetailsPanel.this.vatNumber.getPreferredSize().getHeight());
            h += PaymentDetailsPanel.this.verticalBorder / 2;
            if (!PaymentDetailsPanel.this.isSolarCompany) {
                h = (int)((double)h + PaymentDetailsPanel.this.useOtherCustomersProducts.getPreferredSize().getHeight());
                h += PaymentDetailsPanel.this.inner_verticalBorder;
                h = (int)((double)h + PaymentDetailsPanel.this.useOtherCustomersHandlings.getPreferredSize().getHeight());
                h += PaymentDetailsPanel.this.verticalBorder;
            }
            h = (int)((double)h + PaymentDetailsPanel.this.showEmailOnInvoiceHeader.getPreferredSize().getHeight());
            if (!PaymentDetailsPanel.this.isSolarCompany) {
                h += PaymentDetailsPanel.this.inner_verticalBorder;
                h = (int)((double)h + PaymentDetailsPanel.this.invoiceFormatEditor.getPreferredSize().getHeight());
            }
            return new Dimension(0, h += PaymentDetailsPanel.this.verticalBorder);
        }
    }
}

