/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.customer.details;

import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.commiter.RemoteCommitter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.LocationUtil;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainerListener;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDImageChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDMultiLocationComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ILocalizedDTO;
import ch.icit.pegasus.server.core.dtos.supply.CustomerComplete;
import ch.icit.pegasus.server.core.dtos.supply.CustomerComplete_;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class SpecDetailsPanel
extends DefaultDetailsPanel<CustomerLight> {
    private static final long serialVersionUID = 1L;
    private final boolean isSolarCompany;
    private TitledItem<TextLabel> number;
    private TitledItem<RDTextField> name;
    private TitledItem<RDTextField> code;
    private TitledItem<RDMultiLocationComboBox> locations;
    private TitledItem<RDImageChooser> imageChooser;
    private TitledItem<RDImageChooser> imageIconChooser;

    public SpecDetailsPanel(RowEditor<CustomerLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setOpaque(false);
        this.isSolarCompany = Boolean.TRUE.equals(this.settings.getCompany().getSolarCompanyType());
        this.setTitleText(Words.SPECIFICATION);
        this.setCustomLayouter(new Layout());
        this.number = new TitledItem<TextLabel>(new TextLabel(null, ConverterRegistry.getConverter(IntegerConverter.class)), Words.NUMBER, TitledItem.TitledItemOrientation.NORTH);
        this.name = new TitledItem<RDTextField>(new RDTextField(provider, TextFieldType.NORMAL), Words.NAME, TitledItem.TitledItemOrientation.NORTH);
        this.name.getElement().setValidateAfterTypeing();
        this.code = new TitledItem<RDTextField>(new RDTextField(provider), Words.CODE, TitledItem.TitledItemOrientation.NORTH);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation()) && !this.isSolarCompany) {
            this.locations = new TitledItem<RDMultiLocationComboBox>(new RDMultiLocationComboBox(provider), Words.LOCATIONS, TitledItem.TitledItemOrientation.NORTH);
        }
        this.imageChooser = new TitledItem<RDImageChooser>(new RDImageChooser(provider), Words.CUSTOMER_LOGO, TitledItem.TitledItemOrientation.NORTH);
        this.imageIconChooser = new TitledItem<RDImageChooser>(new RDImageChooser(provider), Words.CUSTOMER_ICON, TitledItem.TitledItemOrientation.NORTH);
        this.number.getElement().setReadOnlyTextField(true);
        this.addToView(this.number);
        this.addToView(this.name);
        this.addToView(this.code);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation()) && !this.isSolarCompany) {
            this.addToView(this.locations);
        }
        this.addToView(this.imageChooser);
        this.addToView(this.imageIconChooser);
    }

    @Override
    public void setNode(Node<?> node) {
        if (this.editor.getModel().isAddRow()) {
            CustomerComplete dto = (CustomerComplete)node.getValue();
            LocationUtil.ensureCurrentLocation((ILocalizedDTO)dto);
        }
        this.number.getElement().setNode(node.getChildNamed(CustomerComplete_.number));
        this.name.getElement().setNode(node.getChildNamed(CustomerComplete_.name));
        this.code.getElement().setNode(node.getChildNamed(CustomerComplete_.code));
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation()) && !this.isSolarCompany) {
            this.locations.getElement().setNode(node.getChildNamed(CustomerComplete_.eligibleLocations));
        }
        this.imageChooser.getElement().setNode(node.getChildNamed(CustomerComplete_.image));
        this.imageIconChooser.getElement().setNode(node.getChildNamed(CustomerComplete_.imageIcon));
    }

    @Override
    public boolean grabsFocus() {
        return true;
    }

    @Override
    public void addFocusCycleChangeListener(MutableFocusContainerListener listener) {
        super.addFocusCycleChangeListener(listener);
        this.imageChooser.getElement().addFocusCycleChangeListener(listener);
        this.imageIconChooser.getElement().addFocusCycleChangeListener(listener);
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        String t;
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (this.name.getElement().isWritable() && ((t = (String)this.editor.getModel().getNode().getChildNamed(CustomerComplete_.name).getValue()) == null || t.isEmpty())) {
            this.name.getElement().setInvalid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_NAME_IS_SET));
        }
        if (this.code.getElement().isWritable() && ((t = (String)this.editor.getModel().getNode().getChildNamed(CustomerComplete_.code).getValue()) == null || t.trim().isEmpty())) {
            this.code.getElement().setInvalid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_CODE_IS_SET));
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation()) && !this.isSolarCompany && this.locations.getElement().isWritable() && this.locations.getElement().getNode().getChildCount() < 1) {
            this.locations.getElement().setInvalid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_LOCATION_IS_SET));
        }
        return validationObjects;
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.number.kill();
        this.name.kill();
        this.code.kill();
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation()) && !this.isSolarCompany) {
            this.locations.kill();
        }
        this.imageChooser.kill();
        this.imageIconChooser.kill();
        this.imageChooser = null;
        this.imageIconChooser = null;
        this.number = null;
        this.name = null;
        this.code = null;
        this.locations = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.number.setEnabled(isEnabled);
        this.name.setEnabled(isEnabled);
        this.code.setEnabled(isEnabled);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation()) && !this.isSolarCompany) {
            this.locations.setEnabled(isEnabled);
        }
        this.imageChooser.setEnabled(isEnabled);
        this.imageIconChooser.setEnabled(isEnabled);
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.name);
        CheckedListAdder.addToList(focusList, this.code);
        CheckedListAdder.addToList(focusList, this.locations);
        CheckedListAdder.addToList(focusList, this.imageChooser);
        CheckedListAdder.addToList(focusList, this.imageIconChooser);
        return focusList;
    }

    @Override
    public List<RemoteCommitter> commitParagraph() {
        List<RemoteCommitter> imageCommitter = this.imageChooser.getElement().commitImage();
        List<RemoteCommitter> logoCommitter = this.imageIconChooser.getElement().commitImage();
        ArrayList<RemoteCommitter> committerList = new ArrayList<RemoteCommitter>();
        if (imageCommitter != null) {
            committerList.addAll(imageCommitter);
        }
        if (logoCommitter != null) {
            committerList.addAll(logoCommitter);
        }
        return committerList;
    }

    @Override
    public void requestFocusInWindowNow() {
        this.name.requestFocusInWindowNow();
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        super.buttonPressed(source, x, y);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            SpecDetailsPanel.this.number.setLocation(SpecDetailsPanel.this.horizontalBorder, SpecDetailsPanel.this.verticalBorder);
            SpecDetailsPanel.this.number.setSize(50, (int)SpecDetailsPanel.this.number.getPreferredSize().getHeight());
            SpecDetailsPanel.this.name.setLocation(SpecDetailsPanel.this.number.getX() + SpecDetailsPanel.this.number.getWidth() + SpecDetailsPanel.this.horizontalBorder, SpecDetailsPanel.this.verticalBorder);
            SpecDetailsPanel.this.name.setSize(parent.getWidth() - (SpecDetailsPanel.this.name.getX() + SpecDetailsPanel.this.horizontalBorder), (int)SpecDetailsPanel.this.name.getPreferredSize().getHeight());
            SpecDetailsPanel.this.code.setLocation(SpecDetailsPanel.this.number.getX(), SpecDetailsPanel.this.name.getY() + SpecDetailsPanel.this.name.getHeight() + SpecDetailsPanel.this.verticalBorder / 2);
            SpecDetailsPanel.this.code.setSize(parent.getWidth() - (3 * SpecDetailsPanel.this.horizontalBorder + 75), (int)SpecDetailsPanel.this.code.getPreferredSize().getHeight());
            int y = SpecDetailsPanel.this.code.getY() + SpecDetailsPanel.this.code.getHeight() + 3 * SpecDetailsPanel.this.inner_verticalBorder;
            if (Boolean.TRUE.equals(SpecDetailsPanel.this.viewSettings.getShowLocation()) && !SpecDetailsPanel.this.isSolarCompany) {
                SpecDetailsPanel.this.locations.setLocation(SpecDetailsPanel.this.code.getX() + SpecDetailsPanel.this.code.getWidth() + SpecDetailsPanel.this.horizontalBorder, SpecDetailsPanel.this.code.getY());
                SpecDetailsPanel.this.locations.setSize(75, (int)SpecDetailsPanel.this.locations.getPreferredSize().getHeight());
                y = SpecDetailsPanel.this.locations.getY() + SpecDetailsPanel.this.locations.getHeight() + 3 * SpecDetailsPanel.this.inner_verticalBorder;
            }
            int x = SpecDetailsPanel.this.code.getX();
            SpecDetailsPanel.this.imageChooser.setLocation(x, y);
            SpecDetailsPanel.this.imageChooser.setSize(SpecDetailsPanel.this.imageChooser.getPreferredSize());
            SpecDetailsPanel.this.imageIconChooser.setLocation(SpecDetailsPanel.this.number.getX(), SpecDetailsPanel.this.imageChooser.getY() + SpecDetailsPanel.this.imageChooser.getHeight() + SpecDetailsPanel.this.inner_verticalBorder);
            SpecDetailsPanel.this.imageIconChooser.setSize(SpecDetailsPanel.this.imageIconChooser.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = SpecDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecDetailsPanel.this.name.getPreferredSize().getHeight());
            h += SpecDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecDetailsPanel.this.code.getPreferredSize().getHeight());
            h += SpecDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecDetailsPanel.this.imageChooser.getPreferredSize().getHeight());
            h += SpecDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecDetailsPanel.this.imageIconChooser.getPreferredSize().getHeight());
            return new Dimension((int)((double)SpecDetailsPanel.this.horizontalBorder + SpecDetailsPanel.this.imageIconChooser.getPreferredSize().getWidth() + (double)SpecDetailsPanel.this.horizontalBorder), h += SpecDetailsPanel.this.verticalBorder);
        }
    }
}

