/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.dataexchange.inserts;

import ch.icit.pegasus.client.converter.AutoReportingInterfaceLastUpdateConverter;
import ch.icit.pegasus.client.converter.DayTimeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.dataexchange.DataExchangeModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.TablePanelAddSaveButton;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.panels.BorderedInletPanel;
import ch.icit.pegasus.client.gui.utils.panels.FTPDataExchangeSettingsPanel;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.tables.AutoReportingInterfaceExportListTable;
import ch.icit.pegasus.client.gui.utils.tables.ClassCbaseMappingEditTable;
import ch.icit.pegasus.client.gui.utils.textfield.DateTimeTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.TimerServiceServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.AutoReportingServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.dataexchange.AutoReportingSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.AutoReportingSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.dataexchange.DataTransferProtocolE;
import ch.icit.pegasus.server.core.dtos.dataexchange.SFTPDataExchangeSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.SFTPDataExchangeSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.dataexchange.TimerServiceSettingsComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.report.autoreporting.AutoReportingExportLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.DayOfWeekE;
import ch.icit.pegasus.server.core.dtos.util.DayOfWeekTimeComplete;
import ch.icit.pegasus.server.core.dtos.util.EncryptedStringComplete;
import ch.icit.pegasus.server.core.dtos.util.TimerServiceConfigComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.timerService.ServiceTypesForTimerService;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class AutoReportingInsert
extends DefaultDataInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private BorderedInletPanel sendPanel;
    private BorderedInletPanel configPanel;
    private TitledItem<CheckBox> useAutoReportingSync;
    private TitledItem<CheckBox> autoSendActive;
    private FTPDataExchangeSettingsPanel ftpPanel;
    private Node<List<AutoReportingExportLight>> autoReportingData;
    private TextLabel lastUpdates;
    private AutoReportingInterfaceExportListTable history;
    private TablePanelAddSaveButton sendButton;
    private TablePanelAddSaveButton saveButton;
    private TextButton resetLastSendDate;
    private TextLabel reportWeekdayText;
    private TitledItem<DateTimeTextField> reportTime;
    private ComboBox reportWeekday;
    private TextLabel weekdayStartText;
    private TextLabel weekdayEndText;
    private ComboBox weekdayStart;
    private ComboBox weekdayEnd;
    private TitledItem<CheckBox> scalePaxBase;
    private ClassCbaseMappingEditTable classCbaseMapping;
    private TitledItem<TextField> fakturaNummer;
    private TitledItem<TextField> noClassMatch;
    private final DataExchangeModule module;
    protected Node<AutoReportingSettingsComplete> settings;
    protected AutoReportingSettingsComplete arisc;

    public AutoReportingInsert(DataExchangeModule module) {
        super(module);
        this.module = module;
    }

    @Override
    public void insertElements() {
        this.configPanel = new BorderedInletPanel(true);
        this.configPanel.setTitleText(Words.CONFIG);
        this.configPanel.setHasBackground(true);
        this.useAutoReportingSync = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(AutoReportingSettingsComplete_.useAutoReportingInterface)), Words.ENABLE_AUTO_REPORTING, TitledItem.TitledItemOrientation.EAST);
        this.useAutoReportingSync.getElement().addButtonListener(this);
        this.autoSendActive = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(AutoReportingSettingsComplete_.autoSendData)), Words.AUTO_SEND, TitledItem.TitledItemOrientation.EAST);
        this.ftpPanel = new FTPDataExchangeSettingsPanel();
        this.ftpPanel.setNode(this.settings.getChildNamed(AutoReportingSettingsComplete_.sendDataExchangeSettings));
        this.reportWeekdayText = new TextLabel(Words.REPORT_WEEKDAY_TIME);
        this.reportWeekday = ComboBoxFactory.getWeeklyDayPopup(false);
        this.reportWeekday.selectItem(this.settings.getChildNamed(AutoReportingSettingsComplete_.reportWeekday).getValue());
        this.reportTime = new TitledItem<DateTimeTextField>(new DateTimeTextField(this.settings.getChildNamed(AutoReportingSettingsComplete_.reportTime), TextFieldType.DAYTIME), Words.WEEKLY_TIME, TitledItem.TitledItemOrientation.NORTH);
        this.weekdayStartText = new TextLabel(Words.START_WEEKDAY);
        this.weekdayEndText = new TextLabel(Words.END_WEEKDAY);
        this.weekdayStart = ComboBoxFactory.getWeeklyDayPopup(false);
        this.weekdayStart.selectItem(this.settings.getChildNamed(AutoReportingSettingsComplete_.weekdayStart).getValue());
        this.weekdayEnd = ComboBoxFactory.getWeeklyDayPopup(false);
        this.weekdayEnd.selectItem(this.settings.getChildNamed(AutoReportingSettingsComplete_.weekdayEnd).getValue());
        this.fakturaNummer = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(AutoReportingSettingsComplete_.fakturaCode)), "Faktura Nummer", TitledItem.TitledItemOrientation.NORTH);
        this.noClassMatch = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(AutoReportingSettingsComplete_.noClassFound)), "No cBase Class Match", TitledItem.TitledItemOrientation.NORTH);
        this.lastUpdates = new TextLabel(this.settings, ConverterRegistry.getConverter(AutoReportingInterfaceLastUpdateConverter.class));
        this.history = new AutoReportingInterfaceExportListTable();
        this.history.setNode(this.autoReportingData);
        this.resetLastSendDate = new TextButton(Words.RESET_LAST_SEND_DATE);
        this.resetLastSendDate.setProgress(1.0f);
        this.resetLastSendDate.addButtonListener(this);
        this.classCbaseMapping = new ClassCbaseMappingEditTable();
        this.classCbaseMapping.getModel().setNode(this.settings.getChildNamed(AutoReportingSettingsComplete_.classCbaseMapping));
        this.sendPanel = new BorderedInletPanel(true);
        this.sendPanel.setTitleText(Words.EXCHANGE_HISTORY);
        this.sendPanel.setHasBackground(true);
        this.sendButton = new TablePanelAddSaveButton();
        this.sendButton.setText(Words.SEND);
        this.sendButton.addButtonListener(this);
        this.saveButton = new TablePanelAddSaveButton();
        this.saveButton.setText(Words.SAVE);
        this.saveButton.addButtonListener(this);
        this.scalePaxBase = new TitledItem<CheckBox>(new CheckBox(), "Scale Pax with Meal Ratio", TitledItem.TitledItemOrientation.EAST);
        this.setLayout(new Layout());
        this.sendPanel.setLayout(new SendLayout());
        this.configPanel.setLayout(new ConfigLayout());
        this.configPanel.add(this.useAutoReportingSync);
        this.configPanel.add(this.autoSendActive);
        this.configPanel.add(this.ftpPanel);
        this.configPanel.add(this.reportWeekdayText);
        this.configPanel.add(this.reportWeekday);
        this.configPanel.add(this.reportTime);
        this.configPanel.add(this.lastUpdates);
        this.configPanel.add(this.saveButton);
        this.configPanel.add(this.resetLastSendDate);
        this.configPanel.add(this.weekdayStartText);
        this.configPanel.add(this.weekdayEndText);
        this.configPanel.add(this.weekdayStart);
        this.configPanel.add(this.weekdayEnd);
        this.configPanel.add(this.classCbaseMapping);
        this.configPanel.add(this.fakturaNummer);
        this.configPanel.add(this.noClassMatch);
        this.configPanel.add(this.scalePaxBase);
        this.sendPanel.add(this.history);
        this.sendPanel.add(this.sendButton);
        this.add(this.configPanel);
        this.add(this.sendPanel);
    }

    private void ensureAnimation(String text) {
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.animation.stateChanged(text);
            this.add((Component)this.animation, 0);
        }
        this.animation.start();
        this.animation.fadeIn();
        this.revalidate();
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                StaticEnumServiceManager.getAllTimeDurations();
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CabinClassComplete.class);
                try {
                    AutoReportingInsert.this.arisc = (AutoReportingSettingsComplete)((AutoReportingServiceManager)ServiceManagerRegistry.getService(AutoReportingServiceManager.class)).getAutoReportingSettings().getValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (AutoReportingInsert.this.arisc == null) {
                    AutoReportingSettingsComplete s = new AutoReportingSettingsComplete();
                    s.setClientOId(Long.valueOf(ADTO.getNextId()));
                    AutoReportingInsert.this.arisc = s;
                }
                AutoReportingInsert.this.arisc.setTimerServiceSettings(AutoReportingInsert.this.createWeeklyTimerService());
                AutoReportingInsert.this.arisc.setReportTime(DayTimeConverter.mapTime((String)"21:00"));
                if (AutoReportingInsert.this.arisc.getSendDataExchangeSettings() == null) {
                    AutoReportingInsert.this.arisc.setSendDataExchangeSettings(new SFTPDataExchangeSettingsComplete());
                }
                if (AutoReportingInsert.this.arisc.getSendDataExchangeSettings().getLoginPwd() == null) {
                    AutoReportingInsert.this.arisc.getSendDataExchangeSettings().setLoginPwd(new EncryptedStringComplete());
                }
                AutoReportingInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)AutoReportingInsert.this.arisc, false, false);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettings();
                AutoReportingInsert.this.autoReportingData = (Node)new ViewNode("data");
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return AutoReportingInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private TimerServiceSettingsComplete createWeeklyTimerService() {
        TimerServiceSettingsComplete ts = new TimerServiceSettingsComplete();
        ts.setClientOId(Long.valueOf(ADTO.getNextId()));
        DayOfWeekTimeComplete dayOfWeekTime = new DayOfWeekTimeComplete(DayOfWeekE.MONDAY, Integer.valueOf(21), Integer.valueOf(0));
        ts.setTimerServiceConfig((TimerServiceConfigComplete)dayOfWeekTime);
        ts.getTimerServiceConfig().setClientOId(Long.valueOf(ADTO.getNextId()));
        return ts;
    }

    private void hideAnimation() {
        if (this.animation != null) {
            this.animation.fadeOut(true);
            this.animation = null;
        }
        this.revalidate();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isInserted) {
            this.useAutoReportingSync.setEnabled(isEnabled);
            boolean b = isEnabled && this.useAutoReportingSync.getElement().isChecked();
            this.sendButton.setEnabled(b);
            this.autoSendActive.setEnabled(b);
            this.ftpPanel.setEnabled(b);
            this.reportWeekdayText.setEnabled(b);
            this.reportWeekday.setEnabled(b);
            this.reportTime.setEnabled(b);
            this.lastUpdates.setEnabled(b);
            this.weekdayStartText.setEnabled(b);
            this.weekdayEndText.setEnabled(b);
            this.weekdayStart.setEnabled(b);
            this.weekdayEnd.setEnabled(b);
            this.scalePaxBase.setEnabled(b);
            this.fakturaNummer.setEnabled(b);
            this.noClassMatch.setEnabled(b);
            this.history.setEnabled(isEnabled);
            this.saveButton.setEnabled(isEnabled);
            this.resetLastSendDate.setEnabled(b);
            this.classCbaseMapping.setEnabled(b);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.sendPanel.kill();
            this.configPanel.kill();
            this.autoSendActive.kill();
            this.history.kill();
            this.scalePaxBase.kill();
            this.ftpPanel.kill();
            this.reportWeekdayText.kill();
            this.reportWeekday.kill();
            this.reportTime.kill();
            this.lastUpdates.kill();
            this.fakturaNummer.kill();
            this.noClassMatch.kill();
            this.saveButton.kill();
            this.useAutoReportingSync.kill();
            this.weekdayStartText.kill();
            this.weekdayEndText.kill();
            this.weekdayStart.kill();
            this.weekdayEnd.kill();
            this.resetLastSendDate.kill();
            this.classCbaseMapping.kill();
        }
        this.sendPanel = null;
        this.configPanel = null;
        this.scalePaxBase = null;
        this.sendButton = null;
        this.ftpPanel = null;
        this.history = null;
        this.autoSendActive = null;
        this.reportWeekdayText = null;
        this.reportWeekday = null;
        this.reportTime = null;
        this.lastUpdates = null;
        this.weekdayStartText = null;
        this.weekdayEndText = null;
        this.weekdayStart = null;
        this.weekdayEnd = null;
        this.saveButton = null;
        this.useAutoReportingSync = null;
        this.resetLastSendDate = null;
        this.classCbaseMapping = null;
    }

    @Override
    public Node getNode() {
        return null;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        return null;
    }

    @Override
    public String getInsertName() {
        return Words.RETAIL_INMOTION;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.sendButton || source == this.saveButton) {
            this.setEnabled(false);
            if (source == this.sendButton) {
                this.ensureAnimation(Words.SEND_AUTO_REPORT_DATA);
                this.processFiles();
            } else if (source == this.saveButton) {
                List<ScreenValidationObject> a = this.validateAutoReportingConfig();
                if (a.isEmpty()) {
                    this.ensureAnimation(Words.SAVE_DATA);
                    this.saveConfig();
                } else {
                    InnerPopupFactory.showErrorDialog(a, Words.UNABLE_TO_SAVE, (Component)this);
                    this.setEnabled(true);
                    return;
                }
            }
            this.module.started();
        } else if (source == this.resetLastSendDate) {
            this.settings.getChildNamed(new DtoField[]{AutoReportingSettingsComplete_.sendDataExchangeSettings, SFTPDataExchangeSettingsComplete_.lastDataTransaction}).setValue((Object)new Timestamp(0L), 0L);
            this.settings.commit();
            this.lastUpdates.setNode((Node)this.settings);
        } else {
            this.setEnabled(this.isEnabled());
        }
    }

    private List<ScreenValidationObject> validateAutoReportingConfig() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Node settings = NodeToolkit.getAffixClass(SystemSettingsComplete.class);
        settings.commitThis(SystemSettingsComplete.class);
        return a;
    }

    private void saveConfig() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                AutoReportingInsert.this.settings.commit(AutoReportingSettingsComplete.class);
                AutoReportingSettingsComplete arisc = (AutoReportingSettingsComplete)AutoReportingInsert.this.settings.getValue();
                arisc.getSendDataExchangeSettings().setDataExchangeProtocol(DataTransferProtocolE.SFTP);
                DayOfWeekE rWd = (DayOfWeekE)AutoReportingInsert.this.reportWeekday.getSelectedItem();
                arisc.setReportWeekday(rWd);
                if (AutoReportingInsert.this.reportTime != null && AutoReportingInsert.this.reportTime.getElement() != null && ((DateTimeTextField)AutoReportingInsert.this.reportTime.getElement()).getText() != null) {
                    arisc.setReportTime(DayTimeConverter.mapTime((String)((DateTimeTextField)AutoReportingInsert.this.reportTime.getElement()).getText()));
                }
                DayOfWeekE ws = (DayOfWeekE)AutoReportingInsert.this.weekdayStart.getSelectedItem();
                arisc.setWeekdayStart(ws);
                DayOfWeekE we = (DayOfWeekE)AutoReportingInsert.this.weekdayEnd.getSelectedItem();
                arisc.setWeekdayEnd(we);
                if (Boolean.TRUE.equals(arisc.getUseAutoReportingInterface())) {
                    arisc.setTimerServiceSettings(AutoReportingInsert.this.createWeeklyTimerService());
                    arisc = (AutoReportingSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)arisc).getValue();
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).manageAllTimerServiceWithInterval(ServiceTypesForTimerService.AUTO_REPORTING_INTERFACE, arisc.getAutoSendData().booleanValue(), arisc.getTimerServiceSettings(), -1L);
                    Node s = ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsUnCached();
                    AutoReportingInsert.this.autoReportingData = (Node)new ViewNode("data");
                    Node settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)arisc, false, false);
                    AutoReportingInsert.this.lastUpdates.setNode(settings);
                    AutoReportingInsert.this.history.setNode(AutoReportingInsert.this.autoReportingData);
                } else {
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).stopTimerService(ServiceTypesForTimerService.AUTO_REPORTING_INTERFACE);
                    arisc = (AutoReportingSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)arisc).getValue();
                    Node s = ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsUnCached();
                    AutoReportingInsert.this.autoReportingData = (Node)new ViewNode("data");
                    Node settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)arisc, false, false);
                    AutoReportingInsert.this.lastUpdates.setNode(settings);
                    AutoReportingInsert.this.history.setNode(AutoReportingInsert.this.autoReportingData);
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        AutoReportingInsert.this.hideAnimation();
                        AutoReportingInsert.this.module.ended();
                        AutoReportingInsert.this.setEnabled(true);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)AutoReportingInsert.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void processFiles() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node n = new Node();
                ((AutoReportingServiceManager)ServiceManagerRegistry.getService(AutoReportingServiceManager.class)).sendAutoReportingData();
                n.setValue((Object)true, 0L);
                AutoReportingInsert.this.arisc = (AutoReportingSettingsComplete)((AutoReportingServiceManager)ServiceManagerRegistry.getService(AutoReportingServiceManager.class)).getAutoReportingSettings().getValue();
                AutoReportingInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)AutoReportingInsert.this.arisc, false, false);
                AutoReportingInsert.this.lastUpdates.setNode((Node)AutoReportingInsert.this.settings);
                AutoReportingInsert.this.history.setNode(AutoReportingInsert.this.autoReportingData);
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        boolean read = (Boolean)node.getValue();
                        AutoReportingInsert.this.hideAnimation();
                        AutoReportingInsert.this.module.ended();
                        AutoReportingInsert.this.setEnabled(true);
                        if (read) {
                            InnerPopupFactory.showMessageDialog(Words.SUCCESSFULLY_IMPORTED, AutoReportingInsert.this.sendButton);
                        }
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, Words.UNABLE_TO_CREATE_RETAIL_INMOTION_EXPORT, (Component)AutoReportingInsert.this.sendButton);
                        AutoReportingInsert.this.hideAnimation();
                        AutoReportingInsert.this.setEnabled(true);
                        AutoReportingInsert.this.module.ended();
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private class ConfigLayout
    extends DefaultLayout {
        private ConfigLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            AutoReportingInsert.this.configPanel.layoutTitle(parent);
            int border = 10;
            AutoReportingInsert.this.useAutoReportingSync.setLocation(border, border + AutoReportingInsert.this.configPanel.getTitleHeight());
            AutoReportingInsert.this.useAutoReportingSync.setSize(AutoReportingInsert.this.useAutoReportingSync.getPreferredSize());
            AutoReportingInsert.this.autoSendActive.setLocation(border, AutoReportingInsert.this.useAutoReportingSync.getY() + AutoReportingInsert.this.useAutoReportingSync.getHeight());
            AutoReportingInsert.this.autoSendActive.setSize(AutoReportingInsert.this.autoSendActive.getPreferredSize());
            AutoReportingInsert.this.ftpPanel.setLocation(border, AutoReportingInsert.this.autoSendActive.getY() + AutoReportingInsert.this.autoSendActive.getHeight() + border);
            AutoReportingInsert.this.ftpPanel.setSize(450, (int)AutoReportingInsert.this.ftpPanel.getPreferredSize().getHeight());
            AutoReportingInsert.this.scalePaxBase.setLocation(AutoReportingInsert.this.ftpPanel.getX(), AutoReportingInsert.this.ftpPanel.getY() + AutoReportingInsert.this.ftpPanel.getHeight() + border);
            AutoReportingInsert.this.scalePaxBase.setSize(AutoReportingInsert.this.scalePaxBase.getPreferredSize());
            AutoReportingInsert.this.reportWeekdayText.setLocation(AutoReportingInsert.this.ftpPanel.getX(), AutoReportingInsert.this.scalePaxBase.getY() + AutoReportingInsert.this.scalePaxBase.getHeight() + border);
            AutoReportingInsert.this.reportWeekdayText.setSize(AutoReportingInsert.this.reportWeekdayText.getPreferredSize());
            AutoReportingInsert.this.reportWeekday.setLocation(AutoReportingInsert.this.reportWeekdayText.getX(), AutoReportingInsert.this.reportWeekdayText.getY() + AutoReportingInsert.this.reportWeekdayText.getHeight() + 3);
            AutoReportingInsert.this.reportWeekday.setSize(100, (int)AutoReportingInsert.this.reportWeekday.getPreferredSize().getHeight());
            AutoReportingInsert.this.reportTime.setLocation(AutoReportingInsert.this.reportWeekdayText.getX() + AutoReportingInsert.this.reportWeekdayText.getWidth() + border, AutoReportingInsert.this.reportWeekdayText.getY());
            AutoReportingInsert.this.reportTime.setSize(100, (int)AutoReportingInsert.this.reportTime.getPreferredSize().getHeight());
            AutoReportingInsert.this.weekdayStartText.setLocation(AutoReportingInsert.this.reportWeekday.getX(), AutoReportingInsert.this.reportTime.getY() + AutoReportingInsert.this.reportTime.getHeight() + border);
            AutoReportingInsert.this.weekdayStartText.setSize(AutoReportingInsert.this.weekdayStartText.getPreferredSize());
            AutoReportingInsert.this.weekdayEndText.setLocation(AutoReportingInsert.this.weekdayStartText.getX() + AutoReportingInsert.this.weekdayStartText.getWidth() + border, AutoReportingInsert.this.weekdayStartText.getY());
            AutoReportingInsert.this.weekdayEndText.setSize(AutoReportingInsert.this.weekdayEndText.getPreferredSize());
            AutoReportingInsert.this.weekdayStart.setLocation(AutoReportingInsert.this.weekdayStartText.getX(), AutoReportingInsert.this.weekdayStartText.getY() + AutoReportingInsert.this.weekdayStartText.getHeight() + border);
            AutoReportingInsert.this.weekdayStart.setSize(80, (int)AutoReportingInsert.this.weekdayStart.getPreferredSize().getHeight());
            AutoReportingInsert.this.weekdayEnd.setLocation(AutoReportingInsert.this.weekdayStart.getX() + AutoReportingInsert.this.weekdayStart.getWidth() + border + 5, AutoReportingInsert.this.weekdayStart.getY());
            AutoReportingInsert.this.weekdayEnd.setSize(80, (int)AutoReportingInsert.this.weekdayStart.getPreferredSize().getHeight());
            AutoReportingInsert.this.lastUpdates.setLocation(AutoReportingInsert.this.weekdayStart.getX(), AutoReportingInsert.this.weekdayEnd.getY() + AutoReportingInsert.this.weekdayEnd.getHeight() + border);
            AutoReportingInsert.this.lastUpdates.setSize(AutoReportingInsert.this.lastUpdates.getPreferredSize());
            AutoReportingInsert.this.resetLastSendDate.setLocation(AutoReportingInsert.this.lastUpdates.getX() + AutoReportingInsert.this.lastUpdates.getWidth() + border, AutoReportingInsert.this.lastUpdates.getY());
            AutoReportingInsert.this.resetLastSendDate.setSize(AutoReportingInsert.this.resetLastSendDate.getPreferredSize());
            AutoReportingInsert.this.fakturaNummer.setLocation(border, AutoReportingInsert.this.resetLastSendDate.getY() + AutoReportingInsert.this.resetLastSendDate.getHeight() + border);
            AutoReportingInsert.this.fakturaNummer.setSize(100, (int)AutoReportingInsert.this.fakturaNummer.getPreferredSize().getHeight());
            AutoReportingInsert.this.noClassMatch.setLocation(AutoReportingInsert.this.fakturaNummer.getX() + AutoReportingInsert.this.fakturaNummer.getWidth() + border, AutoReportingInsert.this.resetLastSendDate.getY() + AutoReportingInsert.this.resetLastSendDate.getHeight() + border);
            AutoReportingInsert.this.noClassMatch.setSize(100, (int)AutoReportingInsert.this.noClassMatch.getPreferredSize().getHeight());
            AutoReportingInsert.this.classCbaseMapping.setLocation(border, AutoReportingInsert.this.fakturaNummer.getY() + AutoReportingInsert.this.fakturaNummer.getHeight() + border);
            AutoReportingInsert.this.classCbaseMapping.setSize(parent.getWidth() - 2 * border, (int)((double)parent.getHeight() - ((double)AutoReportingInsert.this.classCbaseMapping.getY() + (AutoReportingInsert.this.saveButton.getPreferredSize().getHeight() + (double)(2 * border)))));
            AutoReportingInsert.this.saveButton.setLocation((int)((double)parent.getWidth() - AutoReportingInsert.this.saveButton.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - ((double)border + AutoReportingInsert.this.saveButton.getPreferredSize().getHeight())));
            AutoReportingInsert.this.saveButton.setSize(AutoReportingInsert.this.saveButton.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }
    }

    private class SendLayout
    extends DefaultLayout {
        private SendLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            AutoReportingInsert.this.sendPanel.layoutTitle(parent);
            int border = 10;
            AutoReportingInsert.this.history.setLocation(0, AutoReportingInsert.this.sendPanel.getTitleHeight());
            AutoReportingInsert.this.history.setSize(parent.getWidth(), AutoReportingInsert.this.sendPanel.getHeight() - (border + AutoReportingInsert.this.sendPanel.getTitleHeight() + 100));
            AutoReportingInsert.this.sendButton.setLocation((int)((double)parent.getWidth() - AutoReportingInsert.this.sendButton.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - (AutoReportingInsert.this.sendButton.getPreferredSize().getHeight() + (double)border)));
            AutoReportingInsert.this.sendButton.setSize(AutoReportingInsert.this.sendButton.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container arg0) {
            return new Dimension();
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            if (AutoReportingInsert.this.animation != null) {
                AutoReportingInsert.this.animation.setLocation((int)((double)parent.getWidth() - AutoReportingInsert.this.animation.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - AutoReportingInsert.this.animation.getPreferredSize().getHeight()) / 2);
                AutoReportingInsert.this.animation.setSize(AutoReportingInsert.this.animation.getPreferredSize());
            }
            if (AutoReportingInsert.this.isInserted) {
                AutoReportingInsert.this.configPanel.setLocation(border, border);
                AutoReportingInsert.this.configPanel.setSize((parent.getWidth() - 3 * border) / 2, parent.getHeight() - 2 * border);
                AutoReportingInsert.this.sendPanel.setLocation(AutoReportingInsert.this.configPanel.getX() + AutoReportingInsert.this.configPanel.getWidth() + border, border);
                AutoReportingInsert.this.sendPanel.setSize(AutoReportingInsert.this.configPanel.getWidth(), parent.getHeight() - 2 * border);
            }
        }
    }
}

