/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.dataexchange.inserts;

import ch.icit.pegasus.client.converter.RetailInMotionDailyReportingInterfaceLastUpdateConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.dataexchange.DataExchangeModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.TablePanelAddSaveButton;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.panels.BorderedInletPanel;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.tables.MailTable;
import ch.icit.pegasus.client.gui.utils.tables.RetailInMotionDailyReportingInterfaceExportListTable;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.TimerServiceServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.RetailInMotionServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.dataexchange.DataTransferProtocolE;
import ch.icit.pegasus.server.core.dtos.dataexchange.EMailDataExchangeSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.EMailDataExchangeSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.dataexchange.EMailReceiptComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.RetailInMotionDailyReportingSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.RetailInMotionDailyReportingSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.dataexchange.RetailInMotionTransactionExchangeSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.dataexchange.TimerServiceSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.TimerServiceSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.retailinmotion.RetailInMotionDailyReportingExportComplete;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.DailyTimeComplete;
import ch.icit.pegasus.server.core.dtos.util.FixTimeComplete_;
import ch.icit.pegasus.server.core.dtos.util.TimerServiceConfigComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.timerService.ServiceTypesForTimerService;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class DutyFreeDailyReportingInsert
extends DefaultDataInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private TitledItem<CheckBox> useRetailInMotionDailyReporting;
    private TitledItem<CheckBox> autoSendActive;
    private TitledItem<TextField> headerTemplate;
    private TitledItem<TextField> defaultMailSender;
    private BorderedInletPanel sendPanel;
    private BorderedInletPanel configPanel;
    private TextLabel lastUpdates;
    private RetailInMotionDailyReportingInterfaceExportListTable history;
    private TitledItem<TextField> sendRateHour;
    private TitledItem<TextField> sendRateMinute;
    private TablePanelAddSaveButton sendButton;
    private TablePanelAddSaveButton saveButton;
    private TitledItem<SearchTextField2<StoreLight>> defaultStore;
    private TextButton resetLastSendDate;
    private MailTable usersToInform;
    private final DataExchangeModule module;
    protected Node<List<RetailInMotionDailyReportingExportComplete>> retailInMotionData;
    protected Node<RetailInMotionDailyReportingSettingsComplete> settings;
    protected RetailInMotionDailyReportingSettingsComplete rimtesc;

    public DutyFreeDailyReportingInsert(DataExchangeModule module) {
        super(module);
        this.module = module;
    }

    @Override
    public void insertElements() {
        this.configPanel = new BorderedInletPanel(true);
        this.configPanel.setTitleText(Words.CONFIG);
        this.configPanel.setHasBackground(true);
        this.useRetailInMotionDailyReporting = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(RetailInMotionDailyReportingSettingsComplete_.useDailyReporting)), Words.ENABLE_DUTY_FREE_DAILY_REPORTING, TitledItem.TitledItemOrientation.EAST);
        this.useRetailInMotionDailyReporting.getElement().addButtonListener(this);
        this.autoSendActive = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(RetailInMotionDailyReportingSettingsComplete_.autoSendData)), Words.AUTO_SEND_MAIL, TitledItem.TitledItemOrientation.EAST);
        this.headerTemplate = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(new DtoField[]{RetailInMotionDailyReportingSettingsComplete_.mailDataExchangeSettings, EMailDataExchangeSettingsComplete_.mailHeaderTemplate})), Words.HEADER_TEMPLATE, TitledItem.TitledItemOrientation.NORTH);
        this.defaultMailSender = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(new DtoField[]{RetailInMotionDailyReportingSettingsComplete_.mailDataExchangeSettings, EMailDataExchangeSettingsComplete_.defaultMailSender})), Words.MAIL_SENDER, TitledItem.TitledItemOrientation.NORTH);
        this.lastUpdates = new TextLabel(this.settings, ConverterRegistry.getConverter(RetailInMotionDailyReportingInterfaceLastUpdateConverter.class));
        this.sendRateHour = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(new DtoField[]{RetailInMotionDailyReportingSettingsComplete_.timerServiceSettings, TimerServiceSettingsComplete_.timerServiceConfig, FixTimeComplete_.hours}), TextFieldType.INT), Words.DAILY_SEND_AT_HOUR, TitledItem.TitledItemOrientation.NORTH);
        this.sendRateMinute = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(new DtoField[]{RetailInMotionDailyReportingSettingsComplete_.timerServiceSettings, TimerServiceSettingsComplete_.timerServiceConfig, FixTimeComplete_.minutes}), TextFieldType.INT), Words.MINUTE, TitledItem.TitledItemOrientation.NORTH);
        this.defaultStore = new TitledItem<SearchTextField2<StoreLight>>(SearchTextField2Factory.getStoreSearchField(true, this.settings.getChildNamed(RetailInMotionDailyReportingSettingsComplete_.defaultStore)), "Default Store", TitledItem.TitledItemOrientation.NORTH);
        this.usersToInform = new MailTable(){

            @Override
            public Node createNewNode() {
                EMailReceiptComplete receipt = new EMailReceiptComplete();
                receipt.setClientOId(Long.valueOf(ADTO.getNextId()));
                receipt.setMailAddress("");
                return INodeCreator.getDefaultImpl().getNode4DTO((Object)receipt, true, false);
            }
        };
        this.usersToInform.getModel().setNode(this.settings.getChildNamed(new DtoField[]{RetailInMotionDailyReportingSettingsComplete_.mailDataExchangeSettings, EMailDataExchangeSettingsComplete_.mailReceipts}));
        this.history = new RetailInMotionDailyReportingInterfaceExportListTable();
        this.history.setNode(this.retailInMotionData);
        this.resetLastSendDate = new TextButton("Reset last send Date");
        this.resetLastSendDate.setProgress(1.0f);
        this.resetLastSendDate.addButtonListener(this);
        this.sendPanel = new BorderedInletPanel(true);
        this.sendPanel.setTitleText(Words.EXCHANGE_HISTORY);
        this.sendPanel.setHasBackground(true);
        this.sendButton = new TablePanelAddSaveButton();
        this.sendButton.setText(Words.SEND);
        this.sendButton.addButtonListener(this);
        this.saveButton = new TablePanelAddSaveButton();
        this.saveButton.setText(Words.SAVE);
        this.saveButton.addButtonListener(this);
        this.setLayout(new Layout());
        this.sendPanel.setLayout(new SendLayout());
        this.configPanel.setLayout(new ConfigLayout());
        this.configPanel.add(this.useRetailInMotionDailyReporting);
        this.configPanel.add(this.autoSendActive);
        this.configPanel.add(this.headerTemplate);
        this.configPanel.add(this.defaultMailSender);
        this.configPanel.add(this.lastUpdates);
        this.configPanel.add(this.saveButton);
        this.configPanel.add(this.resetLastSendDate);
        this.configPanel.add(this.usersToInform);
        this.configPanel.add(this.sendRateHour);
        this.configPanel.add(this.sendRateMinute);
        this.configPanel.add(this.defaultStore);
        this.sendPanel.add(this.history);
        this.sendPanel.add(this.sendButton);
        this.add(this.configPanel);
        this.add(this.sendPanel);
    }

    private void ensureAnimation(String text) {
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.animation.stateChanged(text);
            this.add((Component)this.animation, 0);
        }
        this.animation.start();
        this.animation.fadeIn();
        this.revalidate();
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                try {
                    DutyFreeDailyReportingInsert.this.rimtesc = (RetailInMotionDailyReportingSettingsComplete)((RetailInMotionServiceManager)ServiceManagerRegistry.getService(RetailInMotionServiceManager.class)).getDailyReportingSettings().getValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (DutyFreeDailyReportingInsert.this.rimtesc == null) {
                    RetailInMotionDailyReportingSettingsComplete s = new RetailInMotionDailyReportingSettingsComplete();
                    s.setClientOId(Long.valueOf(ADTO.getNextId()));
                    DutyFreeDailyReportingInsert.this.rimtesc = s;
                }
                DutyFreeDailyReportingInsert.this.rimtesc.setTimerServiceSettings(DutyFreeDailyReportingInsert.this.createDailyTimerService());
                if (DutyFreeDailyReportingInsert.this.rimtesc.getMailDataExchangeSettings() == null) {
                    EMailDataExchangeSettingsComplete mailSetting = new EMailDataExchangeSettingsComplete();
                    mailSetting.setClientOId(Long.valueOf(ADTO.getNextId()));
                    DutyFreeDailyReportingInsert.this.rimtesc.setMailDataExchangeSettings(mailSetting);
                }
                DutyFreeDailyReportingInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)DutyFreeDailyReportingInsert.this.rimtesc, false, false);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettings();
                DutyFreeDailyReportingInsert.this.retailInMotionData = new ViewNode("data");
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return DutyFreeDailyReportingInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private TimerServiceSettingsComplete createDailyTimerService() {
        TimerServiceSettingsComplete s = new TimerServiceSettingsComplete();
        s.setTimerServiceConfig((TimerServiceConfigComplete)new DailyTimeComplete(Integer.valueOf(19), Integer.valueOf(50)));
        s.getTimerServiceConfig().setClientOId(Long.valueOf(ADTO.getNextId()));
        return s;
    }

    private void hideAnimation() {
        if (this.animation != null) {
            this.animation.fadeOut(true);
            this.animation = null;
        }
        this.revalidate();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isInserted) {
            this.useRetailInMotionDailyReporting.setEnabled(isEnabled);
            boolean b = isEnabled && this.useRetailInMotionDailyReporting.getElement().isChecked();
            this.sendButton.setEnabled(b);
            this.autoSendActive.setEnabled(b);
            this.headerTemplate.setEnabled(b);
            this.defaultMailSender.setEnabled(isEnabled);
            this.lastUpdates.setEnabled(b);
            this.sendRateHour.setEnabled(b);
            this.sendRateMinute.setEnabled(b);
            this.history.setEnabled(isEnabled);
            this.saveButton.setEnabled(isEnabled);
            this.resetLastSendDate.setEnabled(b);
            this.usersToInform.setEnabled(b);
            this.defaultStore.setEnabled(b);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.sendPanel.kill();
            this.configPanel.kill();
            this.autoSendActive.kill();
            this.history.kill();
            this.sendRateHour.kill();
            this.sendRateMinute.kill();
            this.headerTemplate.kill();
            this.defaultMailSender.kill();
            this.lastUpdates.kill();
            this.saveButton.kill();
            this.useRetailInMotionDailyReporting.kill();
            this.resetLastSendDate.kill();
            this.resetLastSendDate = null;
            this.usersToInform.kill();
            this.usersToInform = null;
            this.defaultStore.kill();
            this.defaultStore = null;
        }
        this.sendPanel = null;
        this.configPanel = null;
        this.sendButton = null;
        this.history = null;
        this.autoSendActive = null;
        this.lastUpdates = null;
        this.defaultMailSender = null;
        this.headerTemplate = null;
        this.saveButton = null;
        this.sendRateHour = null;
        this.sendRateMinute = null;
        this.useRetailInMotionDailyReporting = null;
    }

    @Override
    public Node getNode() {
        return null;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        return null;
    }

    @Override
    public String getInsertName() {
        return Words.RETAIL_INMOTION;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.sendButton || source == this.saveButton) {
            this.setEnabled(false);
            if (source == this.sendButton) {
                this.ensureAnimation(Words.EXCHANGE_DATA_WITH_RETAIL_IN_MOTION);
                this.processFiles();
            } else if (source == this.saveButton) {
                List<ScreenValidationObject> a = this.validateDutyFreeConfig();
                if (a.isEmpty()) {
                    this.ensureAnimation(Words.SAVE_DATA);
                    this.saveConfig();
                } else {
                    InnerPopupFactory.showErrorDialog(a, Words.UNABLE_TO_SAVE, (Component)this);
                    this.setEnabled(true);
                    return;
                }
            }
            this.module.started();
        } else if (source == this.resetLastSendDate) {
            this.settings.getChildNamed(new DtoField[]{RetailInMotionTransactionExchangeSettingsComplete_.eMailDataExchangeSettings, EMailDataExchangeSettingsComplete_.lastDataTransaction}).setValue((Object)new Timestamp(0L), 0L);
            this.settings.commit();
            this.lastUpdates.setNode((Node)this.settings);
        } else {
            this.setEnabled(this.isEnabled());
        }
    }

    private List<ScreenValidationObject> validateDutyFreeConfig() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Node settings = NodeToolkit.getAffixClass(SystemSettingsComplete.class);
        settings.commitThis(SystemSettingsComplete.class);
        return a;
    }

    private void saveConfig() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                DutyFreeDailyReportingInsert.this.settings.commit(RetailInMotionDailyReportingSettingsComplete.class);
                RetailInMotionDailyReportingSettingsComplete rimtesc = (RetailInMotionDailyReportingSettingsComplete)DutyFreeDailyReportingInsert.this.settings.getValue();
                rimtesc.getMailDataExchangeSettings().setDataExchangeProtocol(DataTransferProtocolE.EMAIL);
                List<Table2RowPanel> uTIFList = DutyFreeDailyReportingInsert.this.usersToInform.getRows();
                rimtesc.getMailDataExchangeSettings().setMailReceipts(new ArrayList());
                for (Table2RowPanel utif : uTIFList) {
                    EMailReceiptComplete l = (EMailReceiptComplete)utif.getModel().getNode().getValue();
                    if (rimtesc.getMailDataExchangeSettings().getMailReceipts().contains(l)) continue;
                    rimtesc.getMailDataExchangeSettings().getMailReceipts().add(l);
                }
                if (Boolean.TRUE.equals(rimtesc.getUseDailyReporting())) {
                    rimtesc.setTimerServiceSettings(DutyFreeDailyReportingInsert.this.createDailyTimerService());
                    TimerServiceSettingsComplete ts = (TimerServiceSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).setTimerServiceData(rimtesc.getTimerServiceSettings()).getValue();
                    rimtesc.setTimerServiceSettings(ts);
                    rimtesc = (RetailInMotionDailyReportingSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)rimtesc).getValue();
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).manageAllTimerServiceWithInterval(ServiceTypesForTimerService.DUTY_FREE_DAILY_REPORTING, rimtesc.getAutoSendData().booleanValue(), ts, -1L);
                    Node settingsA = INodeCreator.getDefaultImpl().getNode4DTO((Object)rimtesc, false, false);
                    DutyFreeDailyReportingInsert.this.lastUpdates.setNode(settingsA);
                    DutyFreeDailyReportingInsert.this.history.setNode(DutyFreeDailyReportingInsert.this.retailInMotionData);
                } else {
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).stopTimerService(ServiceTypesForTimerService.DUTY_FREE_DAILY_REPORTING);
                    rimtesc = (RetailInMotionDailyReportingSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)rimtesc).getValue();
                    DutyFreeDailyReportingInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)rimtesc, false, false);
                    ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsUnCached();
                    DutyFreeDailyReportingInsert.this.lastUpdates.setNode((Node)DutyFreeDailyReportingInsert.this.settings);
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        DutyFreeDailyReportingInsert.this.hideAnimation();
                        DutyFreeDailyReportingInsert.this.module.ended();
                        DutyFreeDailyReportingInsert.this.setEnabled(true);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)DutyFreeDailyReportingInsert.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void processFiles() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node n = new Node();
                ((RetailInMotionServiceManager)ServiceManagerRegistry.getService(RetailInMotionServiceManager.class)).sendDailyReporting();
                n.setValue((Object)true, 0L);
                DutyFreeDailyReportingInsert.this.rimtesc = (RetailInMotionDailyReportingSettingsComplete)((RetailInMotionServiceManager)ServiceManagerRegistry.getService(RetailInMotionServiceManager.class)).getDailyReportingSettings().getValue();
                DutyFreeDailyReportingInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)DutyFreeDailyReportingInsert.this.rimtesc, false, false);
                DutyFreeDailyReportingInsert.this.lastUpdates.setNode((Node)DutyFreeDailyReportingInsert.this.settings);
                DutyFreeDailyReportingInsert.this.history.setNode(DutyFreeDailyReportingInsert.this.retailInMotionData);
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        boolean read = (Boolean)node.getValue();
                        DutyFreeDailyReportingInsert.this.hideAnimation();
                        DutyFreeDailyReportingInsert.this.module.ended();
                        DutyFreeDailyReportingInsert.this.setEnabled(true);
                        if (read) {
                            InnerPopupFactory.showMessageDialog(Words.SUCCESSFULLY_IMPORTED, DutyFreeDailyReportingInsert.this.sendButton);
                        }
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, Words.UNABLE_TO_CREATE_RETAIL_IN_MOTION_IMPORT, (Component)DutyFreeDailyReportingInsert.this.sendButton);
                        DutyFreeDailyReportingInsert.this.hideAnimation();
                        DutyFreeDailyReportingInsert.this.setEnabled(true);
                        DutyFreeDailyReportingInsert.this.module.ended();
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private class ConfigLayout
    extends DefaultLayout {
        private ConfigLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            DutyFreeDailyReportingInsert.this.configPanel.layoutTitle(parent);
            int border = 10;
            DutyFreeDailyReportingInsert.this.useRetailInMotionDailyReporting.setLocation(border, border + DutyFreeDailyReportingInsert.this.configPanel.getTitleHeight());
            DutyFreeDailyReportingInsert.this.useRetailInMotionDailyReporting.setSize(DutyFreeDailyReportingInsert.this.useRetailInMotionDailyReporting.getPreferredSize());
            DutyFreeDailyReportingInsert.this.autoSendActive.setLocation(border, DutyFreeDailyReportingInsert.this.useRetailInMotionDailyReporting.getY() + DutyFreeDailyReportingInsert.this.useRetailInMotionDailyReporting.getHeight());
            DutyFreeDailyReportingInsert.this.autoSendActive.setSize(DutyFreeDailyReportingInsert.this.autoSendActive.getPreferredSize());
            DutyFreeDailyReportingInsert.this.headerTemplate.setLocation(border, DutyFreeDailyReportingInsert.this.autoSendActive.getY() + DutyFreeDailyReportingInsert.this.autoSendActive.getHeight() + border);
            DutyFreeDailyReportingInsert.this.headerTemplate.setSize(220, (int)DutyFreeDailyReportingInsert.this.headerTemplate.getPreferredSize().getHeight());
            DutyFreeDailyReportingInsert.this.defaultMailSender.setLocation(DutyFreeDailyReportingInsert.this.headerTemplate.getX() + DutyFreeDailyReportingInsert.this.headerTemplate.getWidth() + border, DutyFreeDailyReportingInsert.this.headerTemplate.getY());
            DutyFreeDailyReportingInsert.this.defaultMailSender.setSize(220, (int)DutyFreeDailyReportingInsert.this.defaultMailSender.getPreferredSize().getHeight());
            DutyFreeDailyReportingInsert.this.defaultStore.setLocation(border, DutyFreeDailyReportingInsert.this.headerTemplate.getY() + DutyFreeDailyReportingInsert.this.headerTemplate.getHeight() + border);
            DutyFreeDailyReportingInsert.this.defaultStore.setSize(220, (int)DutyFreeDailyReportingInsert.this.defaultStore.getPreferredSize().getHeight());
            DutyFreeDailyReportingInsert.this.sendRateHour.setLocation(DutyFreeDailyReportingInsert.this.headerTemplate.getX(), DutyFreeDailyReportingInsert.this.defaultStore.getY() + DutyFreeDailyReportingInsert.this.defaultStore.getHeight() + border);
            DutyFreeDailyReportingInsert.this.sendRateHour.setSize(100, (int)DutyFreeDailyReportingInsert.this.sendRateHour.getPreferredSize().getHeight());
            DutyFreeDailyReportingInsert.this.sendRateMinute.setLocation(DutyFreeDailyReportingInsert.this.sendRateHour.getX() + DutyFreeDailyReportingInsert.this.sendRateHour.getWidth() + border, DutyFreeDailyReportingInsert.this.sendRateHour.getY());
            DutyFreeDailyReportingInsert.this.sendRateMinute.setSize(100, (int)DutyFreeDailyReportingInsert.this.sendRateMinute.getPreferredSize().getHeight());
            DutyFreeDailyReportingInsert.this.lastUpdates.setLocation(border, DutyFreeDailyReportingInsert.this.sendRateMinute.getY() + DutyFreeDailyReportingInsert.this.sendRateMinute.getHeight() + border);
            DutyFreeDailyReportingInsert.this.lastUpdates.setSize(DutyFreeDailyReportingInsert.this.lastUpdates.getPreferredSize());
            DutyFreeDailyReportingInsert.this.resetLastSendDate.setLocation(DutyFreeDailyReportingInsert.this.lastUpdates.getX() + DutyFreeDailyReportingInsert.this.lastUpdates.getWidth() + border, DutyFreeDailyReportingInsert.this.lastUpdates.getY());
            DutyFreeDailyReportingInsert.this.resetLastSendDate.setSize(DutyFreeDailyReportingInsert.this.resetLastSendDate.getPreferredSize());
            DutyFreeDailyReportingInsert.this.saveButton.setLocation((int)((double)parent.getWidth() - DutyFreeDailyReportingInsert.this.saveButton.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - ((double)border + DutyFreeDailyReportingInsert.this.saveButton.getPreferredSize().getHeight())));
            DutyFreeDailyReportingInsert.this.saveButton.setSize(DutyFreeDailyReportingInsert.this.saveButton.getPreferredSize());
            DutyFreeDailyReportingInsert.this.usersToInform.setLocation(border, DutyFreeDailyReportingInsert.this.resetLastSendDate.getY() + DutyFreeDailyReportingInsert.this.resetLastSendDate.getHeight() + border);
            DutyFreeDailyReportingInsert.this.usersToInform.setSize(parent.getWidth() - 2 * DutyFreeDailyReportingInsert.this.usersToInform.getX(), 150);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }
    }

    private class SendLayout
    extends DefaultLayout {
        private SendLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            DutyFreeDailyReportingInsert.this.sendPanel.layoutTitle(parent);
            int border = 10;
            DutyFreeDailyReportingInsert.this.history.setLocation(0, DutyFreeDailyReportingInsert.this.sendPanel.getTitleHeight());
            DutyFreeDailyReportingInsert.this.history.setSize(parent.getWidth(), DutyFreeDailyReportingInsert.this.sendPanel.getHeight() - (border + DutyFreeDailyReportingInsert.this.sendPanel.getTitleHeight() + 100));
            DutyFreeDailyReportingInsert.this.sendButton.setLocation((int)((double)parent.getWidth() - DutyFreeDailyReportingInsert.this.sendButton.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - (DutyFreeDailyReportingInsert.this.sendButton.getPreferredSize().getHeight() + (double)border)));
            DutyFreeDailyReportingInsert.this.sendButton.setSize(DutyFreeDailyReportingInsert.this.sendButton.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container arg0) {
            return new Dimension();
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            if (DutyFreeDailyReportingInsert.this.animation != null) {
                DutyFreeDailyReportingInsert.this.animation.setLocation((int)((double)parent.getWidth() - DutyFreeDailyReportingInsert.this.animation.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - DutyFreeDailyReportingInsert.this.animation.getPreferredSize().getHeight()) / 2);
                DutyFreeDailyReportingInsert.this.animation.setSize(DutyFreeDailyReportingInsert.this.animation.getPreferredSize());
            }
            if (DutyFreeDailyReportingInsert.this.isInserted) {
                DutyFreeDailyReportingInsert.this.configPanel.setLocation(border, border);
                DutyFreeDailyReportingInsert.this.configPanel.setSize((parent.getWidth() - 3 * border) / 2, parent.getHeight() - 2 * border);
                DutyFreeDailyReportingInsert.this.sendPanel.setLocation(DutyFreeDailyReportingInsert.this.configPanel.getX() + DutyFreeDailyReportingInsert.this.configPanel.getWidth() + border, border);
                DutyFreeDailyReportingInsert.this.sendPanel.setSize(DutyFreeDailyReportingInsert.this.configPanel.getWidth(), parent.getHeight() - 2 * border);
            }
        }
    }
}

