/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.dataexchange.inserts;

import ch.icit.pegasus.client.gui.modules.dataexchange.DataExchangeModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.TablePanelAddSaveButton;
import ch.icit.pegasus.client.gui.utils.panels.BorderedInletPanel;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.tables.ProductivityDailyFixHoursSettingsTable;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.TimerServiceServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.report.FlightReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.TimerServiceSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.productivity.ProductivityMeasureSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.productivity.ProductivityMeasureSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.DailyTimeComplete;
import ch.icit.pegasus.server.core.dtos.util.TimerServiceConfigComplete;
import ch.icit.pegasus.server.core.dtos.utils.DateUtil;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.timerService.ServiceTypesForTimerService;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ProductivityMeasureSettingsInsert
extends DefaultDataInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private BorderedInletPanel sendPanel;
    private BorderedInletPanel configPanel;
    private TitledItem<CheckBox> useProductivityMeasure;
    private TitledItem<CheckBox> autoGenerateMeasure;
    private TitledItem<CheckBox> includeProductHours;
    private TitledItem<CheckBox> includeProductGroupHours;
    private TitledItem<CheckBox> includeProductComponentHours;
    private TitledItem<CheckBox> includeRecipeHours;
    private TitledItem<CheckBox> includeRecipeReserve;
    private TitledItem<CheckBox> includeHandlingCostHours;
    private TitledItem<CheckBox> includeDailyFixHours;
    private TitledItem<TextField> errorNotificationsAddress;
    private TitledItem<TextField> notificationAddress;
    private ProductivityDailyFixHoursSettingsTable dailyFixHours;
    private TablePanelAddSaveButton generateButton;
    private TablePanelAddSaveButton saveButton;
    private final DataExchangeModule module;
    protected Node<ProductivityMeasureSettingsComplete> settings;
    protected ProductivityMeasureSettingsComplete productivitySettings;

    public ProductivityMeasureSettingsInsert(DataExchangeModule module) {
        super(module);
        this.module = module;
    }

    @Override
    public void insertElements() {
        this.configPanel = new BorderedInletPanel(true);
        this.configPanel.setTitleText(Words.CONFIG);
        this.configPanel.setHasBackground(true);
        this.dailyFixHours = new ProductivityDailyFixHoursSettingsTable();
        this.dailyFixHours.getModel().setNode(this.settings.getChildNamed(ProductivityMeasureSettingsComplete_.dailyFixHours));
        this.useProductivityMeasure = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(ProductivityMeasureSettingsComplete_.useProductivityMeasure)), "Enable Productivity Measure", TitledItem.TitledItemOrientation.EAST);
        this.useProductivityMeasure.getElement().addButtonListener(this);
        this.autoGenerateMeasure = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(ProductivityMeasureSettingsComplete_.autoGenerateMeasure)), "Auto Generate", TitledItem.TitledItemOrientation.EAST);
        this.errorNotificationsAddress = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(ProductivityMeasureSettingsComplete_.errorNotificationAddress)), "Error Notification Address", TitledItem.TitledItemOrientation.NORTH);
        this.notificationAddress = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(ProductivityMeasureSettingsComplete_.notificationAddress)), "Notification Address", TitledItem.TitledItemOrientation.NORTH);
        this.includeProductHours = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(ProductivityMeasureSettingsComplete_.includeProductHours)), "Include Product Hours", TitledItem.TitledItemOrientation.EAST);
        this.includeProductGroupHours = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(ProductivityMeasureSettingsComplete_.includeProductGroupHours)), "Include Product Group Hours", TitledItem.TitledItemOrientation.EAST);
        this.includeProductComponentHours = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(ProductivityMeasureSettingsComplete_.includeProductComponentHours)), "Include Product Component Hours", TitledItem.TitledItemOrientation.EAST);
        this.includeRecipeHours = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(ProductivityMeasureSettingsComplete_.includeRecipeHours)), "Include Recipe Hours", TitledItem.TitledItemOrientation.EAST);
        this.includeRecipeReserve = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(ProductivityMeasureSettingsComplete_.includeRecipeReserve)), "Include Recipe Reserve", TitledItem.TitledItemOrientation.EAST);
        this.includeHandlingCostHours = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(ProductivityMeasureSettingsComplete_.includeHandlingCostHours)), "Include Handling Cost Hours", TitledItem.TitledItemOrientation.EAST);
        this.includeDailyFixHours = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(ProductivityMeasureSettingsComplete_.includeDailyFixHours)), "Include Daily Fix Hours", TitledItem.TitledItemOrientation.EAST);
        this.sendPanel = new BorderedInletPanel(true);
        this.sendPanel.setTitleText(Words.EXCHANGE_HISTORY);
        this.sendPanel.setHasBackground(true);
        this.generateButton = new TablePanelAddSaveButton();
        this.generateButton.setText(Words.RECEIVE);
        this.generateButton.addButtonListener(this);
        this.saveButton = new TablePanelAddSaveButton();
        this.saveButton.setText(Words.SAVE);
        this.saveButton.addButtonListener(this);
        this.setLayout(new Layout());
        this.sendPanel.setLayout(new SendLayout());
        this.configPanel.setLayout(new ConfigLayout());
        this.configPanel.add(this.useProductivityMeasure);
        this.configPanel.add(this.autoGenerateMeasure);
        this.configPanel.add(this.errorNotificationsAddress);
        this.configPanel.add(this.saveButton);
        this.configPanel.add(this.notificationAddress);
        this.configPanel.add(this.includeProductHours);
        this.configPanel.add(this.includeProductGroupHours);
        this.configPanel.add(this.includeProductComponentHours);
        this.configPanel.add(this.includeRecipeHours);
        this.configPanel.add(this.includeRecipeReserve);
        this.configPanel.add(this.includeHandlingCostHours);
        this.configPanel.add(this.includeDailyFixHours);
        this.configPanel.add(this.dailyFixHours);
        this.sendPanel.add(this.generateButton);
        this.add(this.configPanel);
        this.add(this.sendPanel);
    }

    private void ensureAnimation(String text) {
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.animation.stateChanged(text);
            this.add((Component)this.animation, 0);
        }
        this.animation.start();
        this.animation.fadeIn();
        this.revalidate();
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                StaticEnumServiceManager.getAllTimeDurations();
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(InternalCostCenterComplete.class);
                try {
                    ProductivityMeasureSettingsInsert.this.productivitySettings = (ProductivityMeasureSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getProductivityMeasureSettings().getValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (ProductivityMeasureSettingsInsert.this.productivitySettings == null) {
                    ProductivityMeasureSettingsComplete s = new ProductivityMeasureSettingsComplete();
                    s.setClientOId(Long.valueOf(ADTO.getNextId()));
                    ProductivityMeasureSettingsInsert.this.productivitySettings = s;
                }
                ProductivityMeasureSettingsInsert.this.productivitySettings.setTimerServiceSettings(ProductivityMeasureSettingsInsert.this.createTimerService());
                ProductivityMeasureSettingsInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)ProductivityMeasureSettingsInsert.this.productivitySettings, false, false);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettings();
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ProductivityMeasureSettingsInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private TimerServiceSettingsComplete createTimerService() {
        TimerServiceSettingsComplete s = new TimerServiceSettingsComplete();
        s.setClientOId(Long.valueOf(ADTO.getNextId()));
        s.setTimerServiceConfig((TimerServiceConfigComplete)new DailyTimeComplete(Integer.valueOf(22), Integer.valueOf(0), Integer.valueOf(0)));
        return s;
    }

    private void hideAnimation() {
        if (this.animation != null) {
            this.animation.fadeOut(true);
            this.animation = null;
        }
        this.revalidate();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isInserted) {
            this.useProductivityMeasure.setEnabled(isEnabled);
            boolean b = isEnabled && this.useProductivityMeasure.getElement().isChecked();
            this.autoGenerateMeasure.setEnabled(b);
            this.errorNotificationsAddress.setEnabled(b);
            this.notificationAddress.setEnabled(b);
            this.includeProductHours.setEnabled(b);
            this.includeProductGroupHours.setEnabled(b);
            this.includeProductComponentHours.setEnabled(b);
            this.includeRecipeHours.setEnabled(b);
            this.includeRecipeReserve.setEnabled(b);
            this.includeHandlingCostHours.setEnabled(b);
            this.includeDailyFixHours.setEnabled(b);
            this.saveButton.setEnabled(isEnabled);
            this.generateButton.setEnabled(b);
            this.dailyFixHours.setEnabled(b);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.sendPanel.kill();
            this.configPanel.kill();
            this.autoGenerateMeasure.kill();
            this.notificationAddress.kill();
            this.generateButton.kill();
            this.errorNotificationsAddress.kill();
            this.saveButton.kill();
            this.useProductivityMeasure.kill();
            this.includeProductHours.kill();
            this.includeProductGroupHours.kill();
            this.includeProductComponentHours.kill();
            this.includeRecipeHours.kill();
            this.includeRecipeReserve.kill();
            this.includeHandlingCostHours.kill();
            this.includeDailyFixHours.kill();
            this.dailyFixHours.kill();
        }
        this.notificationAddress = null;
        this.sendPanel = null;
        this.configPanel = null;
        this.generateButton = null;
        this.autoGenerateMeasure = null;
        this.errorNotificationsAddress = null;
        this.saveButton = null;
        this.useProductivityMeasure = null;
        this.includeProductHours = null;
        this.includeProductGroupHours = null;
        this.includeProductComponentHours = null;
        this.includeRecipeHours = null;
        this.includeRecipeReserve = null;
        this.includeHandlingCostHours = null;
        this.includeDailyFixHours = null;
        this.dailyFixHours = null;
    }

    @Override
    public Node getNode() {
        return null;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        return null;
    }

    @Override
    public String getInsertName() {
        return "Productivity Measure";
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.generateButton || source == this.saveButton) {
            this.setEnabled(false);
            if (source == this.generateButton) {
                this.ensureAnimation("Generate Report");
                this.processFiles();
            } else if (source == this.saveButton) {
                List<ScreenValidationObject> a = this.validateRetailinMotionConfig();
                if (a.isEmpty()) {
                    this.ensureAnimation(Words.SAVE_DATA);
                    this.saveConfig();
                } else {
                    InnerPopupFactory.showErrorDialog(a, Words.UNABLE_TO_SAVE, (Component)this);
                    this.setEnabled(true);
                    return;
                }
            }
            this.module.started();
        } else {
            this.setEnabled(this.isEnabled());
        }
    }

    private List<ScreenValidationObject> validateRetailinMotionConfig() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Node settings = NodeToolkit.getAffixClass(SystemSettingsComplete.class);
        settings.commitThis(SystemSettingsComplete.class);
        return a;
    }

    private void saveConfig() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                ProductivityMeasureSettingsInsert.this.settings.commit(ProductivityMeasureSettingsComplete.class);
                ProductivityMeasureSettingsComplete pdt = (ProductivityMeasureSettingsComplete)ProductivityMeasureSettingsInsert.this.settings.getValue();
                if (pdt != null && Boolean.TRUE.equals(pdt.getUseProductivityMeasure())) {
                    pdt.setTimerServiceSettings(ProductivityMeasureSettingsInsert.this.createTimerService());
                    ProductivityMeasureSettingsComplete productivityMeasure = pdt = (ProductivityMeasureSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)pdt).getValue();
                    TimerServiceSettingsComplete ts = (TimerServiceSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).setTimerServiceData(productivityMeasure.getTimerServiceSettings()).getValue();
                    productivityMeasure.setTimerServiceSettings(ts);
                    productivityMeasure = (ProductivityMeasureSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)productivityMeasure).getValue();
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).manageAllTimerServiceWithInterval(ServiceTypesForTimerService.PRODUCTIVITY_MEASURE, productivityMeasure.getAutoGenerateMeasure().booleanValue(), ts, -1L);
                } else {
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).stopTimerService(ServiceTypesForTimerService.PRODUCTIVITY_MEASURE);
                    pdt = (ProductivityMeasureSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)pdt).getValue();
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        ProductivityMeasureSettingsInsert.this.hideAnimation();
                        ProductivityMeasureSettingsInsert.this.module.ended();
                        ProductivityMeasureSettingsInsert.this.setEnabled(true);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)ProductivityMeasureSettingsInsert.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void processFiles() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node n = new Node();
                PeriodComplete reportPeriod = new PeriodComplete();
                reportPeriod.setStartDate(DateUtil.getSQLDate((int)2025, (int)12, (int)1));
                reportPeriod.setEndDate(DateUtil.getSQLDate((int)2025, (int)12, (int)7));
                PegasusFileComplete value = (PegasusFileComplete)((FlightReportServiceManager)ServiceManagerRegistry.getService(FlightReportServiceManager.class)).generateProductivityMeasureReport(reportPeriod).getValue();
                File download = FileTransferUtil.download((PegasusFileComplete)value, (FileTransferListener[])new FileTransferListener[0]);
                Desktop.getDesktop().open(download);
                n.setValue((Object)true, 0L);
                ProductivityMeasureSettingsInsert.this.productivitySettings = (ProductivityMeasureSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getProductivityMeasureSettings().getValue();
                ProductivityMeasureSettingsInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)ProductivityMeasureSettingsInsert.this.productivitySettings, false, false);
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        boolean read = (Boolean)node.getValue();
                        ProductivityMeasureSettingsInsert.this.hideAnimation();
                        ProductivityMeasureSettingsInsert.this.module.ended();
                        ProductivityMeasureSettingsInsert.this.setEnabled(true);
                        if (read) {
                            InnerPopupFactory.showMessageDialog(Words.SUCCESSFULLY_EXPORTED, ProductivityMeasureSettingsInsert.this.generateButton);
                        }
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, "Unable to create report", (Component)ProductivityMeasureSettingsInsert.this.generateButton);
                        ProductivityMeasureSettingsInsert.this.hideAnimation();
                        ProductivityMeasureSettingsInsert.this.setEnabled(true);
                        ProductivityMeasureSettingsInsert.this.module.ended();
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private class ConfigLayout
    extends DefaultLayout {
        private ConfigLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            ProductivityMeasureSettingsInsert.this.configPanel.layoutTitle(parent);
            int border = 10;
            ProductivityMeasureSettingsInsert.this.useProductivityMeasure.setLocation(border, border + ProductivityMeasureSettingsInsert.this.configPanel.getTitleHeight());
            ProductivityMeasureSettingsInsert.this.useProductivityMeasure.setSize(ProductivityMeasureSettingsInsert.this.useProductivityMeasure.getPreferredSize());
            ProductivityMeasureSettingsInsert.this.includeProductHours.setLocation(border, ProductivityMeasureSettingsInsert.this.useProductivityMeasure.getY() + ProductivityMeasureSettingsInsert.this.useProductivityMeasure.getHeight() + border);
            ProductivityMeasureSettingsInsert.this.includeProductHours.setSize(ProductivityMeasureSettingsInsert.this.includeProductHours.getPreferredSize());
            ProductivityMeasureSettingsInsert.this.includeProductGroupHours.setLocation(border, ProductivityMeasureSettingsInsert.this.includeProductHours.getY() + ProductivityMeasureSettingsInsert.this.includeProductHours.getHeight());
            ProductivityMeasureSettingsInsert.this.includeProductGroupHours.setSize(ProductivityMeasureSettingsInsert.this.includeProductGroupHours.getPreferredSize());
            ProductivityMeasureSettingsInsert.this.includeProductComponentHours.setLocation(border, ProductivityMeasureSettingsInsert.this.includeProductGroupHours.getY() + ProductivityMeasureSettingsInsert.this.includeProductGroupHours.getHeight());
            ProductivityMeasureSettingsInsert.this.includeProductComponentHours.setSize(ProductivityMeasureSettingsInsert.this.includeProductComponentHours.getPreferredSize());
            ProductivityMeasureSettingsInsert.this.includeRecipeHours.setLocation(border, ProductivityMeasureSettingsInsert.this.includeProductComponentHours.getY() + ProductivityMeasureSettingsInsert.this.includeProductComponentHours.getHeight());
            ProductivityMeasureSettingsInsert.this.includeRecipeHours.setSize(ProductivityMeasureSettingsInsert.this.includeRecipeHours.getPreferredSize());
            ProductivityMeasureSettingsInsert.this.includeRecipeReserve.setLocation(border, ProductivityMeasureSettingsInsert.this.includeRecipeHours.getY() + ProductivityMeasureSettingsInsert.this.includeRecipeHours.getHeight());
            ProductivityMeasureSettingsInsert.this.includeRecipeReserve.setSize(ProductivityMeasureSettingsInsert.this.includeRecipeReserve.getPreferredSize());
            ProductivityMeasureSettingsInsert.this.includeHandlingCostHours.setLocation(border, ProductivityMeasureSettingsInsert.this.includeRecipeReserve.getY() + ProductivityMeasureSettingsInsert.this.includeRecipeReserve.getHeight());
            ProductivityMeasureSettingsInsert.this.includeHandlingCostHours.setSize(ProductivityMeasureSettingsInsert.this.includeHandlingCostHours.getPreferredSize());
            ProductivityMeasureSettingsInsert.this.includeDailyFixHours.setLocation(border, ProductivityMeasureSettingsInsert.this.includeHandlingCostHours.getY() + ProductivityMeasureSettingsInsert.this.includeHandlingCostHours.getHeight());
            ProductivityMeasureSettingsInsert.this.includeDailyFixHours.setSize(ProductivityMeasureSettingsInsert.this.includeDailyFixHours.getPreferredSize());
            ProductivityMeasureSettingsInsert.this.errorNotificationsAddress.setLocation(border, ProductivityMeasureSettingsInsert.this.includeDailyFixHours.getY() + ProductivityMeasureSettingsInsert.this.includeDailyFixHours.getHeight() + border);
            ProductivityMeasureSettingsInsert.this.errorNotificationsAddress.setSize(400, (int)ProductivityMeasureSettingsInsert.this.errorNotificationsAddress.getPreferredSize().getHeight());
            ProductivityMeasureSettingsInsert.this.notificationAddress.setLocation(ProductivityMeasureSettingsInsert.this.errorNotificationsAddress.getX(), ProductivityMeasureSettingsInsert.this.errorNotificationsAddress.getY() + ProductivityMeasureSettingsInsert.this.errorNotificationsAddress.getHeight() + border);
            ProductivityMeasureSettingsInsert.this.notificationAddress.setSize(400, (int)ProductivityMeasureSettingsInsert.this.notificationAddress.getPreferredSize().getHeight());
            ProductivityMeasureSettingsInsert.this.dailyFixHours.setLocation(border, ProductivityMeasureSettingsInsert.this.notificationAddress.getY() + ProductivityMeasureSettingsInsert.this.notificationAddress.getHeight() + border);
            ProductivityMeasureSettingsInsert.this.dailyFixHours.setSize(parent.getWidth() - 2 * border, 400);
            ProductivityMeasureSettingsInsert.this.saveButton.setLocation((int)((double)parent.getWidth() - ProductivityMeasureSettingsInsert.this.saveButton.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - ((double)border + ProductivityMeasureSettingsInsert.this.saveButton.getPreferredSize().getHeight())));
            ProductivityMeasureSettingsInsert.this.saveButton.setSize(ProductivityMeasureSettingsInsert.this.saveButton.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }
    }

    private class SendLayout
    extends DefaultLayout {
        private SendLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            ProductivityMeasureSettingsInsert.this.sendPanel.layoutTitle(parent);
            int border = 10;
            ProductivityMeasureSettingsInsert.this.generateButton.setLocation((int)((double)parent.getWidth() - ProductivityMeasureSettingsInsert.this.generateButton.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - (ProductivityMeasureSettingsInsert.this.generateButton.getPreferredSize().getHeight() + (double)border)));
            ProductivityMeasureSettingsInsert.this.generateButton.setSize(ProductivityMeasureSettingsInsert.this.generateButton.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container arg0) {
            return new Dimension();
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            if (ProductivityMeasureSettingsInsert.this.animation != null) {
                ProductivityMeasureSettingsInsert.this.animation.setLocation((int)((double)parent.getWidth() - ProductivityMeasureSettingsInsert.this.animation.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - ProductivityMeasureSettingsInsert.this.animation.getPreferredSize().getHeight()) / 2);
                ProductivityMeasureSettingsInsert.this.animation.setSize(ProductivityMeasureSettingsInsert.this.animation.getPreferredSize());
            }
            if (ProductivityMeasureSettingsInsert.this.isInserted) {
                int oneThird = (parent.getWidth() - 3 * border) / 8;
                ProductivityMeasureSettingsInsert.this.configPanel.setLocation(border, border);
                ProductivityMeasureSettingsInsert.this.configPanel.setSize(oneThird * 7, parent.getHeight() - 2 * border);
                ProductivityMeasureSettingsInsert.this.sendPanel.setLocation(ProductivityMeasureSettingsInsert.this.configPanel.getX() + ProductivityMeasureSettingsInsert.this.configPanel.getWidth() + border, border);
                ProductivityMeasureSettingsInsert.this.sendPanel.setSize(oneThird, parent.getHeight() - 2 * border);
            }
        }
    }
}

