/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.edelweiss.details;

import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.datechooser.DateTimeChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.CalendarUtil;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.edelweiss.EdelweissDataImportComplete_;
import ch.icit.pegasus.server.core.dtos.edelweiss.EdelweissDataImportLight;
import ch.icit.pegasus.server.core.dtos.edelweiss.EdelweissFlightImportFileDataComplete;
import ch.icit.pegasus.server.core.dtos.edelweiss.EdelweissFlightImportFileDataComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.utils.DateUtil;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class EDWFlightsDetailsPanel
extends TableDetailsPanel<EdelweissDataImportLight> {
    private static final long serialVersionUID = 1L;

    public EDWFlightsDetailsPanel(RowEditor<EdelweissDataImportLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.FLIGHT_UPDATES);
    }

    @Override
    public void setNode(Node<?> node) {
        this.table.getModel().setNode(node.getChildNamed(EdelweissDataImportComplete_.transactions));
    }

    @Override
    public void resetParagraph() {
        this.table.getModel().setNode(this.editor.getModel().getNode().getChildNamed(EdelweissDataImportComplete_.transactions));
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> rets = new ArrayList<ScreenValidationObject>();
        return rets;
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> headers = new ArrayList<TableColumnInfo>();
        headers.add(new TableColumnInfo(0.0, 0.0, Words.FLIGHT, null, null, null, "", 100, 100, 100));
        headers.add(new TableColumnInfo(0.0, 0.0, Words.FLIGHT_INTERFACE, null, null, null, "", 180, 180, 180));
        int dw = DateTimeChooser.getPreferredWidth(this) - 15;
        headers.add(new TableColumnInfo(0.0, 0.0, "Std Local Time", null, null, null, "", dw, dw, dw));
        headers.add(new TableColumnInfo(0.0, 0.0, "Std UTC", null, null, null, "", dw, dw, dw));
        headers.add(new TableColumnInfo(0.0, 0.0, "LEG", null, null, null, "", 100, 100, 100));
        headers.add(new TableColumnInfo(0.0, 0.0, Words.MATRICULATION_INTERFACE, null, null, null, "", 100, 100, 100));
        headers.add(new TableColumnInfo(0.0, 0.0, Words.AIRCRAFT_INTERFACE, null, null, null, "", 100, 100, 100));
        ((TableColumnInfo)headers.get(0)).setxExpand(0.5);
        ((TableColumnInfo)headers.get(1)).setxExpand(0.0);
        ((TableColumnInfo)headers.get(2)).setxExpand(0.0);
        ((TableColumnInfo)headers.get(3)).setxExpand(0.0);
        ((TableColumnInfo)headers.get(4)).setxExpand(0.0);
        ((TableColumnInfo)headers.get(5)).setxExpand(0.0);
        ((TableColumnInfo)headers.get(6)).setxExpand(0.0);
        return headers;
    }

    @Override
    public void configTable(Table2 table) {
        table.setDontUseScrollBar(15);
        table.setSortedColumn(2);
        table.setSortDirection(false);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
    }

    @Override
    public void childRemoved() {
        this.editor.revalidate();
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        TableRowImpl p = new TableRowImpl(model);
        p.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
        return p;
    }

    private class TableRowImpl
    extends Table2RowPanel {
        private static final long serialVersionUID = 1L;
        private SearchTextField2<FlightLight> flightSearch;
        private TextLabel flight;
        private TextLabel stdLocalTime;
        private TextLabel stdUTC;
        private TextLabel leg;
        private TextLabel aircraftType;
        private TextLabel matriculation;
        private Timestamp timestamp;
        private Timestamp timestampUTC;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.flightSearch = SearchTextField2Factory.getFlightSearchField(true, m.getNode().getChildNamed(EdelweissFlightImportFileDataComplete_.flight));
            this.flight = new TextLabel(m.getNode().getChildNamed(EdelweissFlightImportFileDataComplete_.ftlCarrier) + " " + m.getNode().getChildNamed(EdelweissFlightImportFileDataComplete_.ftlNo));
            this.stdLocalTime = new TextLabel(m.getNode().getChildNamed(EdelweissFlightImportFileDataComplete_.depDayScd).getValue() + " " + m.getNode().getChildNamed(EdelweissFlightImportFileDataComplete_.depDayTime).getValue());
            this.stdUTC = new TextLabel(m.getNode().getChildNamed(EdelweissFlightImportFileDataComplete_.depDayScdUTC).getValue() + " " + m.getNode().getChildNamed(EdelweissFlightImportFileDataComplete_.depDayTimeUTC).getValue());
            this.leg = new TextLabel(m.getNode().getChildNamed(EdelweissFlightImportFileDataComplete_.depAPTScd).getValue() + " " + m.getNode().getChildNamed(EdelweissFlightImportFileDataComplete_.arrAPTScd).getValue());
            this.matriculation = new TextLabel(m.getNode().getChildNamed(EdelweissFlightImportFileDataComplete_.matriculation), ConverterRegistry.getConverter(StringConverter.class));
            this.aircraftType = new TextLabel(m.getNode().getChildNamed(EdelweissFlightImportFileDataComplete_.aircraftCode), ConverterRegistry.getConverter(StringConverter.class));
            EdelweissFlightImportFileDataComplete set = (EdelweissFlightImportFileDataComplete)this.model.getNode().getValue(EdelweissFlightImportFileDataComplete.class);
            this.timestamp = this.createTimestamp(set.getDepDayScd(), set.getDepDayTime());
            this.timestampUTC = this.createTimestamp(set.getDepDayScdUTC(), set.getDepDayTimeUTC());
            this.setLayout(new Layout());
            this.add(this.flightSearch);
            this.add(this.flight);
            this.add(this.stdLocalTime);
            this.add(this.leg);
            this.add(this.matriculation);
            this.add(this.aircraftType);
            this.add(this.stdUTC);
        }

        private Timestamp createTimestamp(String dateString, String timeString) {
            String[] dateParts = dateString.split("\\.");
            int day = 0;
            int month = 0;
            int year = 0;
            int hour = 0;
            int minute = 0;
            String[] timeParts = timeString.split(":");
            try {
                day = Integer.valueOf(dateParts[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                month = Integer.valueOf(dateParts[1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                year = Integer.valueOf(dateParts[2]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                hour = Integer.valueOf(timeParts[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                minute = Integer.valueOf(timeParts[1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Date date = DateUtil.getDate((int)year, (int)month, (int)day);
            Time time = DateUtil.getSQLTime((int)hour, (int)minute, (int)0);
            return CalendarUtil.mergeTimestamps((Date)date, (Time)time);
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            if (!EDWFlightsDetailsPanel.this.provider.isWritable(EdelweissFlightImportFileDataComplete_.flight)) {
                this.flightSearch.setEnabled(false);
            }
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.flightSearch);
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            EdelweissFlightImportFileDataComplete set = (EdelweissFlightImportFileDataComplete)this.model.getNode().getValue(EdelweissFlightImportFileDataComplete.class);
            switch (column) {
                case 0: {
                    if (set.getFlight() != null) {
                        return set.getFlight();
                    }
                    return null;
                }
                case 1: {
                    return set.getFtlCarrier() + " " + set.getFtlNo();
                }
                case 2: {
                    return this.timestamp;
                }
                case 3: {
                    return this.timestampUTC;
                }
                case 4: {
                    return set.getLevelCode();
                }
                case 5: {
                    return set.getMatriculation();
                }
                case 6: {
                    return set.getAircraftCode();
                }
            }
            return null;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(0);
                int currentX = 0;
                TableRowImpl.this.flightSearch.setLocation(TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.flightSearch.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.flightSearch.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.flightSearch.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(1);
                TableRowImpl.this.flight.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.flight.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.flight.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.flight.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(2);
                TableRowImpl.this.stdLocalTime.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.stdLocalTime.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.stdLocalTime.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.stdLocalTime.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(3);
                TableRowImpl.this.stdUTC.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.stdUTC.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.stdUTC.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.stdUTC.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(4);
                TableRowImpl.this.leg.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.leg.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.leg.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.leg.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(5);
                TableRowImpl.this.matriculation.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.matriculation.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.matriculation.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.matriculation.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(6);
                TableRowImpl.this.aircraftType.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.aircraftType.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.aircraftType.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.aircraftType.getPreferredSize().getHeight());
            }
        }
    }
}

