/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.flightschedule.details.utils;

import ch.icit.pegasus.client.converter.LegTypeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.mealplan.details.FixPriceDetailsPanel;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelKillable;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDCheckBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDRadioButton;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDSearchTextField2;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.CalendarUtil;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.toolkits.LegToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.flightschedule.ALegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.ALegComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLegComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleLegComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.LegTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.PaxFigureComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.SeatConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.IStowingListLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLight;
import ch.icit.pegasus.server.core.dtos.masterdata.AirportComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PaxFigureTypeComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.MealplanTemplateLegComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class LegTable
extends JPanelKillable
implements NodeListener,
Focusable {
    private static final long serialVersionUID = 1L;
    private Table2 table;
    private FixPriceDetailsPanel fixpanel;
    private TitledItem<RDSearchTextField2> deliveryAirport;
    private LegTableType flightType;
    private boolean useGalleyBellySwitch;
    private boolean inculdeFlightData;
    private boolean writeStdData;
    private StowingListTemplateVariantLight currentStowingList;
    private Node<FlightComplete> adHocFlight;
    private transient boolean nodeSettingActive = false;

    public LegTable(FixPriceDetailsPanel panel, RDProvider provider, LegTableType flightSchedule) {
        this(panel, provider, flightSchedule, false, false);
    }

    public LegTable(FixPriceDetailsPanel panel, RDProvider provider, LegTableType flightSchedule, boolean useGalleyBellySwitch) {
        this(panel, provider, flightSchedule, useGalleyBellySwitch, false);
    }

    public LegTable(RDProvider provider, LegTableType flightSchedule, boolean useGalleyBellySwitch, boolean includeFlightData) {
        this(null, provider, flightSchedule, useGalleyBellySwitch, includeFlightData);
    }

    public LegTable(FixPriceDetailsPanel panel, RDProvider provider, LegTableType flightSchedule, boolean useGalleyBellySwitch, boolean includeFlightData) {
        int deleteWidth;
        this.fixpanel = panel;
        this.flightType = flightSchedule;
        this.useGalleyBellySwitch = useGalleyBellySwitch;
        this.inculdeFlightData = includeFlightData;
        this.table = new Table2(true, Words.ADD);
        this.table.setProgress(1.0f);
        if (this.flightType == LegTableType.ADHOC) {
            this.table.setUseWriteAccessRight(true);
        }
        this.table.setRequestFocusOnAdd(true);
        this.table.setProvider(provider);
        this.table.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                FlightScheduleLegComplete dto = null;
                switch (LegTable.this.flightType) {
                    case FLIGHTSCHEDULE: {
                        dto = new FlightScheduleLegComplete();
                        dto.setCateringLeg(Boolean.valueOf(true));
                        dto.setShowLegOnDailyOps(Boolean.valueOf(true));
                        dto.setFlightTime(new Time(System.currentTimeMillis()));
                        dto.setClientOId(Long.valueOf(ADTO.getNextId()));
                        break;
                    }
                    case MEALPLAN: {
                        dto = new MealplanTemplateLegComplete();
                        break;
                    }
                    case STOWINGLIST: {
                        dto = new StowingListTemplateLegComplete();
                        break;
                    }
                    case ADHOC: {
                        FlightLegComplete flc = new FlightLegComplete();
                        flc.setCateringLeg(Boolean.valueOf(true));
                        flc.setShowLegOnDailyOps(Boolean.valueOf(true));
                        Object fc = null;
                        fc = LegTable.this.adHocFlight.getChildNamed(DtoFieldConstants.NEW_STW) == null || LegTable.this.adHocFlight.getChildNamed(DtoFieldConstants.NEW_STW).getValue() == null ? (IStowingListLight)LegTable.this.adHocFlight.getChildNamed(FlightLight_.activeStowingList).getValue() : LegTable.this.currentStowingList;
                        if (fc != null) {
                            List types = (List)NodeToolkit.getAffixList(PaxFigureTypeComplete.class).getValue();
                            for (PaxFigureTypeComplete t : types) {
                                for (SeatConfigurationComplete sc : fc.getSeatConfigurations()) {
                                    PaxFigureComplete p = new PaxFigureComplete();
                                    p.setClientOId(Long.valueOf(ADTO.getNextId()));
                                    p.setCabinClass(sc.getCabinClass());
                                    p.setLeg(flc);
                                    p.setNumber(Integer.valueOf(0));
                                    p.setPaxFigureType(t);
                                    flc.getPaxFigures().add(p);
                                }
                            }
                            for (SeatConfigurationComplete sc : fc.getSeatConfigurations()) {
                                PaxFigureComplete p = new PaxFigureComplete();
                                p.setClientOId(Long.valueOf(ADTO.getNextId()));
                                p.setCabinClass(sc.getCabinClass());
                                p.setLeg(flc);
                                p.setNumber(Integer.valueOf(0));
                                flc.getPaxFigures().add(p);
                            }
                        }
                        dto = flc;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown state");
                    }
                }
                dto.setClientOId(Long.valueOf(ADTO.getNextId()));
                dto.setNumber(Integer.valueOf(LegTable.this.table.getRowCount()));
                if (LegTable.this.table.getRowCount() > 0) {
                    Table2RowModel lastPanel = LegTable.this.table.getModel().getModelAt(LegTable.this.table.getRowCount() - 1);
                    Node n = lastPanel.getNode();
                    dto.setDepartureAirport((AirportComplete)n.getChildNamed(ALegComplete_.arrivalAirport).getValue());
                    SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                    dto.setArrivalAirport(settings.getHomeBase());
                    switch (LegTable.this.flightType) {
                        case FLIGHTSCHEDULE: {
                            FlightTypeE type = (FlightTypeE)LegTable.this.table.getModel().getNode().getParent().getChildNamed(FlightScheduleComplete_.flightType).getValue();
                            if (type == FlightTypeE.RETURN) {
                                dto.setLegType(LegTypeE.INBOUND);
                                break;
                            }
                            dto.setLegType(LegTypeE.OUTBOUND);
                            break;
                        }
                        case MEALPLAN: 
                        case STOWINGLIST: 
                        case ADHOC: {
                            dto.setLegType(LegTypeE.INBOUND);
                        }
                    }
                } else {
                    SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                    dto.setDepartureAirport(settings.getHomeBase());
                    dto.setArrivalAirport((AirportComplete)NodeToolkit.getAffixList(AirportComplete.class).getChildAt(0).getValue());
                    switch (LegTable.this.flightType) {
                        case FLIGHTSCHEDULE: {
                            FlightTypeE type = (FlightTypeE)LegTable.this.table.getModel().getNode().getParent().getChildNamed(FlightScheduleComplete_.flightType).getValue();
                            if (type == FlightTypeE.RETURN) {
                                dto.setLegType(LegTypeE.OUTBOUND);
                                break;
                            }
                            dto.setLegType(LegTypeE.INBOUND);
                            break;
                        }
                        case MEALPLAN: 
                        case STOWINGLIST: 
                        case ADHOC: {
                            dto.setLegType(LegTypeE.OUTBOUND);
                        }
                    }
                }
                LegTable.this.table.getModel().getNode().addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)dto, true, false), System.currentTimeMillis());
                if (LegTable.this.useGalleyBellySwitch && LegTable.this.table.getRowCount() == 1) {
                    Node gbs = LegTable.this.table.getModel().getNode().getParent().getChildNamed(StowingListTemplateComplete_.galleyBellySwitch);
                    LegTable.this.valueChanged(gbs);
                }
                if (LegTable.this.flightType == LegTableType.STOWINGLIST && !LegTable.this.nodeSettingActive) {
                    Iterator it = LegTable.this.table.getModel().getNode().getParent().getChildNamed(StowingListTemplateComplete_.variants).getFailSafeChildIterator();
                    while (it.hasNext()) {
                        Node n;
                        Node next = (Node)it.next();
                        if (next.getValue(StowingListTemplateVariantLight.class) == null) continue;
                        Node next2 = n = next;
                        LegToolkit.syncLegsNodebased((Node)LegTable.this.table.getModel().getNode().getParent(), (Node)next2);
                    }
                }
                LegTable.this.getParent().validate();
                LegTable.this.updateAdditionalFlightNo();
            }

            @Override
            public void childRemoved() {
                LegTable.this.table.writeNumber("number", 0);
                if (LegTable.this.flightType == LegTableType.STOWINGLIST && !LegTable.this.nodeSettingActive) {
                    Iterator it = LegTable.this.table.getModel().getNode().getParent().getChildNamed(StowingListTemplateComplete_.variants).getFailSafeChildIterator();
                    while (it.hasNext()) {
                        Node n;
                        Node next = (Node)it.next();
                        if (next.getValue(StowingListTemplateVariantLight.class) == null) continue;
                        Node next2 = n = next;
                        LegToolkit.syncLegsNodebased((Node)LegTable.this.table.getModel().getNode().getParent(), (Node)next2);
                    }
                }
                LegTable.this.updateAdditionalFlightNo();
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        int a = RadioButton.getPreferredWidth() + 2 * this.table.getCellPadding();
        int b = 45;
        if (flightSchedule != LegTableType.FLIGHTSCHEDULE) {
            columns.add(new TableColumnInfo(Words.NO_NUMBER, "", null, null, "", 40, 40, 40));
            if (this.useGalleyBellySwitch) {
                columns.add(new TableColumnInfo("", "", null, null, "", a, a, a));
            }
        }
        if (flightSchedule == LegTableType.FLIGHTSCHEDULE || flightSchedule == LegTableType.ADHOC) {
            columns.add(new TableColumnInfo(Words.SHOW_ON_DAILY_OPS, "", null, null, "", b, b, b));
            columns.add(new TableColumnInfo(Words.CATERING_LEG, "", null, null, "", b, b, b));
            columns.add(new TableColumnInfo(Words.STD_LEG, "", null, null, "", b, b, b));
            columns.add(new TableColumnInfo(Words.STA_LEG, "", null, null, "", b, b, b));
        }
        int minAirportWidth = 75;
        columns.add(new TableColumnInfo(Words.FROM, "", null, null, "", minAirportWidth, Integer.MAX_VALUE, minAirportWidth));
        columns.add(new TableColumnInfo(Words.TO, "", null, null, "", minAirportWidth, Integer.MAX_VALUE, minAirportWidth));
        if (flightSchedule == LegTableType.FLIGHTSCHEDULE || flightSchedule == LegTableType.ADHOC) {
            if (this.inculdeFlightData) {
                columns.add(new TableColumnInfo(Words.TYPE, "", null, null, "", 80, Integer.MAX_VALUE, 80));
                columns.add(new TableColumnInfo(Words.NUMBER, "", null, null, "", 120, Integer.MAX_VALUE, 120));
                columns.add(new TableColumnInfo(Words.TIME, "", null, null, "", 80, Integer.MAX_VALUE, 80));
            } else {
                columns.add(new TableColumnInfo(Words.TYPE, "", null, null, "", 80, Integer.MAX_VALUE, 80));
            }
            if (flightSchedule == LegTableType.ADHOC) {
                deleteWidth = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
                columns.add(new TableColumnInfo("", "", null, null, "", deleteWidth += 2 * this.table.getCellPadding(), deleteWidth, deleteWidth));
            }
        }
        deleteWidth = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", "", null, null, "", deleteWidth += 2 * this.table.getCellPadding(), deleteWidth, deleteWidth));
        if (flightSchedule != LegTableType.FLIGHTSCHEDULE) {
            if (flightSchedule == LegTableType.ADHOC) {
                ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
                ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
                ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
                ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
                ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
                ((TableColumnInfo)columns.get(5)).setxExpand(0.2);
                ((TableColumnInfo)columns.get(6)).setxExpand(0.2);
                ((TableColumnInfo)columns.get(7)).setxExpand(0.6);
                ((TableColumnInfo)columns.get(8)).setxExpand(0.0);
                ((TableColumnInfo)columns.get(9)).setxExpand(0.0);
                ((TableColumnInfo)columns.get(10)).setxExpand(0.0);
                ((TableColumnInfo)columns.get(11)).setxExpand(0.0);
            } else if (this.useGalleyBellySwitch) {
                ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
                ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
                ((TableColumnInfo)columns.get(2)).setxExpand(0.5);
                ((TableColumnInfo)columns.get(3)).setxExpand(0.5);
                ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
            } else {
                ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
                ((TableColumnInfo)columns.get(1)).setxExpand(0.5);
                ((TableColumnInfo)columns.get(2)).setxExpand(0.5);
                ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
            }
        } else {
            ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(4)).setxExpand(0.2);
            ((TableColumnInfo)columns.get(5)).setxExpand(0.2);
            ((TableColumnInfo)columns.get(6)).setxExpand(0.6);
            ((TableColumnInfo)columns.get(7)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(8)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(9)).setxExpand(0.0);
        }
        this.setOpaque(false);
        this.table.setModel(new Table2Model(columns, model1 -> new LegTableRowPanel(model1)));
        this.table.setSortedColumn(0, true);
        if (flightSchedule == LegTableType.FLIGHTSCHEDULE) {
            this.deliveryAirport = new TitledItem<RDSearchTextField2<RDSearchTextField2>>(new RDSearchTextField2(provider, RDSearchTextField2.SearchTypes.AIRPORT), Words.DELIVERY_AIRPORT, TitledItem.TitledItemOrientation.NORTH);
        }
        this.setLayout(new LegTableLayout());
        this.add(this.table);
        if (flightSchedule == LegTableType.FLIGHTSCHEDULE) {
            this.add(this.deliveryAirport);
        }
    }

    public void setCurrentStowingList(StowingListTemplateVariantLight currentStowingList) {
        this.currentStowingList = currentStowingList;
    }

    public void setAdHocNode(Node<FlightComplete> adHocNode) {
        if (this.flightType == LegTableType.ADHOC) {
            if (this.adHocFlight != null) {
                this.adHocFlight.getChildNamed(FlightScheduleComplete_.std).removeNodeListener((NodeListener)this);
                this.adHocFlight.getChildNamed(FlightScheduleComplete_.sta).removeNodeListener((NodeListener)this);
                this.adHocFlight.getChildNamed(FlightScheduleComplete_.outboundCode).removeNodeListener((NodeListener)this);
                this.adHocFlight.getChildNamed(FlightScheduleComplete_.inboundCode).removeNodeListener((NodeListener)this);
            }
            if (adHocNode != null) {
                adHocNode.getChildNamed(FlightScheduleComplete_.std).addNodeListener((NodeListener)this);
                adHocNode.getChildNamed(FlightScheduleComplete_.sta).addNodeListener((NodeListener)this);
                adHocNode.getChildNamed(FlightScheduleComplete_.outboundCode).addNodeListener((NodeListener)this);
                adHocNode.getChildNamed(FlightScheduleComplete_.inboundCode).addNodeListener((NodeListener)this);
            }
        }
        this.adHocFlight = adHocNode;
    }

    public void setNode(Node node) {
        this.nodeSettingActive = true;
        this.table.getModel().setNode(node);
        this.nodeSettingActive = false;
        if (node != null) {
            Node scheduleNode;
            if (this.deliveryAirport != null) {
                Node n = node.getParent().getChildNamed(FlightScheduleComplete_.deliveryAirport);
                if (n.getValue() == null) {
                    SystemSettingsComplete s = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                    n.setValue((Object)s.getHomeBase(), 0L);
                }
                this.deliveryAirport.getElement().setNode(n);
            }
            if (this.flightType == LegTableType.FLIGHTSCHEDULE && (scheduleNode = node.getParent()) != null) {
                scheduleNode.getChildNamed(FlightScheduleComplete_.std).removeNodeListener((NodeListener)this);
                scheduleNode.getChildNamed(FlightScheduleComplete_.sta).removeNodeListener((NodeListener)this);
                scheduleNode.getChildNamed(FlightScheduleComplete_.outboundCode).removeNodeListener((NodeListener)this);
                scheduleNode.getChildNamed(FlightScheduleComplete_.inboundCode).removeNodeListener((NodeListener)this);
                scheduleNode.getChildNamed(FlightScheduleComplete_.std).addNodeListener((NodeListener)this);
                scheduleNode.getChildNamed(FlightScheduleComplete_.sta).addNodeListener((NodeListener)this);
                scheduleNode.getChildNamed(FlightScheduleComplete_.outboundCode).addNodeListener((NodeListener)this);
                scheduleNode.getChildNamed(FlightScheduleComplete_.inboundCode).addNodeListener((NodeListener)this);
            }
            if (this.useGalleyBellySwitch) {
                Node gbs = node.getParent().getChildNamed(StowingListTemplateComplete_.galleyBellySwitch);
                gbs.addNodeListener((NodeListener)this);
                this.valueChanged(gbs);
            }
        }
        this.table.updateOrder();
        this.updateAdditionalFlightNo();
    }

    public Node getNode() {
        return this.table.getModel().getNode();
    }

    private void updateGalleyBellySwitch(Node node) {
        if (this.table == null) {
            return;
        }
        for (Table2RowPanel p : this.table.getRows()) {
            LegTableRowPanel ltrp = (LegTableRowPanel)p;
            ltrp.updateGalleyBellySwitch(node);
        }
    }

    private void updateAdditionalFlightNo() {
        if (!this.inculdeFlightData) {
            return;
        }
        for (Table2RowPanel p : this.table.getRows()) {
            LegTableRowPanel ltrp = (LegTableRowPanel)p;
            ltrp.ensureAdditionalFlightNo();
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.table.setEnabled(isEnabled);
        if (this.deliveryAirport != null) {
            this.deliveryAirport.setEnabled(isEnabled);
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> a = this.table.getFocusComponents();
        if (this.deliveryAirport != null) {
            a.addAll(this.deliveryAirport.getFocusComponents());
        }
        return a;
    }

    public Table2 getTable() {
        return this.table;
    }

    public void setTableBackground(Color c) {
        this.setBackground(c);
        this.table.setTableBackground(c);
    }

    public void resetList() {
        this.table.resetTable();
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        this.setAdHocNode(null);
        this.setNode(null);
        super.kill();
        this.table.kill();
        this.table = null;
        if (this.deliveryAirport != null) {
            this.deliveryAirport.kill();
        }
        this.deliveryAirport = null;
    }

    public void ensureAllStdStaLegs() {
        for (Table2RowPanel p : this.table.getRows()) {
            LegTableRowPanel lp = (LegTableRowPanel)p;
            lp.ensureStaLeg();
            lp.ensureStdLeg();
        }
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void valueChanged(Node<?> node) {
        if (this.flightType == LegTableType.FLIGHTSCHEDULE) {
            Node scheduleNode = node.getParent();
            if (node.getName().equals(FlightScheduleComplete_.sta.getFieldName())) {
                Time selectedTime = (Time)node.getValue();
                Node staLeg = scheduleNode.getChildNamed(FlightScheduleComplete_.staLeg);
                if (staLeg != null && staLeg.getValue() != null) {
                    staLeg.getChildNamed(FlightScheduleLegComplete_.flightTime).setValue((Object)selectedTime, 0L);
                }
            } else if (node.getName().equals(FlightScheduleComplete_.std.getFieldName())) {
                Time selectedTime = (Time)node.getValue();
                Node stdLeg = scheduleNode.getChildNamed(FlightScheduleComplete_.stdLeg);
                if (stdLeg != null && stdLeg.getValue() != null) {
                    stdLeg.getChildNamed(FlightScheduleLegComplete_.flightTime).setValue((Object)selectedTime, 0L);
                }
            } else if (node.getName().equals(FlightScheduleComplete_.outboundCode.getFieldName())) {
                String selectedNo = (String)node.getValue();
                Node stdLeg = scheduleNode.getChildNamed(FlightScheduleComplete_.stdLeg);
                if (stdLeg != null && stdLeg.getValue() != null) {
                    stdLeg.getChildNamed(FlightScheduleLegComplete_.flightNo).setValue((Object)selectedNo, 0L);
                }
            } else if (node.getName().equals(FlightScheduleComplete_.inboundCode.getFieldName())) {
                String selectedNo = (String)node.getValue();
                Node staLeg = scheduleNode.getChildNamed(FlightScheduleComplete_.staLeg);
                if (staLeg != null && staLeg.getValue() != null) {
                    staLeg.getChildNamed(FlightScheduleLegComplete_.flightNo).setValue((Object)selectedNo, 0L);
                }
            }
        } else if (this.flightType == LegTableType.ADHOC) {
            Node<FlightComplete> scheduleNode = this.adHocFlight;
            if (node.getName().equals(FlightLight_.sta.getFieldName())) {
                Timestamp selectedTime = (Timestamp)node.getValue();
                Node staLeg = scheduleNode.getChildNamed(FlightComplete_.staLeg);
                if (staLeg != null && staLeg.getValue() != null) {
                    LegTableRowPanel legRow = (LegTableRowPanel)this.table.getRowPanel4Node(staLeg);
                    staLeg.getChildNamed(FlightLegComplete_.flightTime).setValueSilent((Object)new Time(selectedTime.getTime()), false, 0L, new NodeListener[]{legRow});
                }
            } else if (node.getName().equals(FlightLight_.std.getFieldName())) {
                Timestamp selectedTime = (Timestamp)node.getValue();
                Node stdLeg = scheduleNode.getChildNamed(FlightComplete_.stdLeg);
                LegTableRowPanel legRow = (LegTableRowPanel)this.table.getRowPanel4Node(stdLeg);
                if (stdLeg != null && stdLeg.getValue() != null) {
                    stdLeg.getChildNamed(FlightLegComplete_.flightTime).setValueSilent((Object)new Time(selectedTime.getTime()), false, 0L, new NodeListener[]{legRow});
                }
            } else if (node.getName().equals(FlightLight_.outboundCode.getFieldName())) {
                String selectedNo = (String)node.getValue();
                Node stdLeg = scheduleNode.getChildNamed(FlightComplete_.stdLeg);
                LegTableRowPanel legRow = (LegTableRowPanel)this.table.getRowPanel4Node(stdLeg);
                if (stdLeg != null && stdLeg.getValue() != null) {
                    stdLeg.getChildNamed(FlightLegComplete_.flightNo).setValueSilent((Object)selectedNo, false, 0L, new NodeListener[]{legRow});
                }
            } else if (node.getName().equals(FlightLight_.inboundCode.getFieldName())) {
                String selectedNo = (String)node.getValue();
                Node staLeg = scheduleNode.getChildNamed(FlightScheduleComplete_.staLeg);
                LegTableRowPanel legRow = (LegTableRowPanel)this.table.getRowPanel4Node(staLeg);
                if (staLeg != null && staLeg.getValue() != null) {
                    staLeg.getChildNamed(FlightScheduleLegComplete_.flightNo).setValueSilent((Object)selectedNo, false, 0L, new NodeListener[]{legRow});
                }
            }
        }
        this.updateGalleyBellySwitch(node);
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        this.table.setVisibleContainer(pane);
    }

    public void updateRowViews() {
        for (Table2RowPanel p : this.table.getRows()) {
            LegTableRowPanel i = (LegTableRowPanel)p;
            i.updateCurrentView();
        }
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        return null;
    }

    @Override
    public void requestFocusInWindowNow() {
        this.table.requestFocusInWindowNow();
    }

    public boolean isSwingOnly() {
        return true;
    }

    public List<ScreenValidationObject> validateTable() {
        ArrayList<ScreenValidationObject> o = new ArrayList<ScreenValidationObject>();
        if (this.flightType == LegTableType.FLIGHTSCHEDULE) {
            SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            AirportComplete airport = (AirportComplete)this.table.getModel().getNode().getParent().getChildNamed(FlightScheduleComplete_.deliveryAirport).getValue();
            boolean foundDeliveryAirport = false;
            int homeBaseCount = 0;
            int nsCount = 0;
            int dsCount = 0;
            for (Table2RowPanel p : this.table.getRows()) {
                LegTableRowPanel pp = (LegTableRowPanel)p;
                AirportComplete l1 = (AirportComplete)pp.getModel().getNode().getChildNamed(ALegComplete_.arrivalAirport).getValue();
                AirportComplete l2 = (AirportComplete)pp.getModel().getNode().getChildNamed(ALegComplete_.departureAirport).getValue();
                if (l1.equals((Object)airport) || l2.equals((Object)airport)) {
                    foundDeliveryAirport = true;
                }
                if (l2.equals((Object)settings.getNightStop()) || l1.equals((Object)settings.getNightStop())) {
                    ++nsCount;
                    if (l2.equals((Object)settings.getDayStop()) || l1.equals((Object)settings.getDayStop())) {
                        o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, Words.LEG_NS_TO_DS_NOT_SUPPORTED));
                    }
                    if (!l2.equals((Object)settings.getHomeBase()) && !l1.equals((Object)settings.getHomeBase())) {
                        o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, Words.LEG_NS_ALWAYS_TO_HOME_BASE));
                    }
                } else if (l2.equals((Object)settings.getDayStop()) || l1.equals((Object)settings.getDayStop())) {
                    ++dsCount;
                    if (l2.equals((Object)settings.getNightStop()) || l1.equals((Object)settings.getNightStop())) {
                        o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, Words.LEG_DS_TO_NS_NOT_SUPPORTED));
                    }
                    if (!l2.equals((Object)settings.getHomeBase()) && !l1.equals((Object)settings.getHomeBase())) {
                        o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, Words.LEG_FROM_DS_ALWAYS_TO_HOME_BASE));
                    }
                } else if (l1.equals((Object)settings.getHomeBase()) || l2.equals((Object)settings.getHomeBase())) {
                    ++homeBaseCount;
                }
                if (!l1.equals((Object)l2)) continue;
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, Words.ENSURE_LEGS_AIRPORTS_NOT_EQUALS));
            }
            if (nsCount > 1) {
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, Words.NS_IS_ONLY_ALLOWED_ONCE_PER_ROUTING));
            }
            if (dsCount > 1) {
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, Words.DS_IS_ONLY_ALLOWED_ONCE_PER_ROUTING));
            }
            if (homeBaseCount > 2 && settings.getMutlipleHomebaseWarning().booleanValue()) {
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, Words.HOME_BASE_IS_ONLY_ALLOWED_TWICE_PER_ROUTING));
            }
            if (!foundDeliveryAirport) {
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, Words.DELIVERY_AIRPORT_IS_NOT_IN_ROUTING));
            }
        } else if (this.table != null && this.table.getModel().getNode().getChildCount() == 0) {
            o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.PLEASE_DEFINE_LEGS));
        }
        return o;
    }

    public boolean getWriteStdData() {
        return this.writeStdData;
    }

    public void setWriteStdData(boolean writeStdData) {
        this.writeStdData = writeStdData;
    }

    public void setLocked(boolean isDraft) {
        this.table.setLocked(isDraft);
    }

    private class LegTableRowPanel
    extends Table2RowPanel
    implements NodeListener,
    ButtonListener,
    LafListener,
    SearchTextField2Listener {
        private static final long serialVersionUID = 1L;
        private TextLabel legNumber;
        private RDCheckBox showOnDailyOps;
        private RDCheckBox cateringLeg;
        private RDRadioButton stdLeg;
        private RDRadioButton staLeg;
        private RDSearchTextField2<AirportComplete> depPort;
        private RDSearchTextField2<AirportComplete> arrPort;
        private DeleteButton delete;
        private RDRadioButton galleyChange;
        private boolean isReferenced;
        private RDComboBox type;
        private RDTextField flightNo;
        private RDTextField flightTime;
        private RDComboBox timeType;
        private InfoButton legMapping;

        public LegTableRowPanel(Table2RowModel m) {
            super(m);
            this.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
            this.isReferenced = m.getNode().getChildNamed(ADTO.ID_).getValue() == null ? false : this.isLegReferenced((Node<ALegComplete>)m.getNode());
            this.setLayout(new Layout());
            this.depPort = new RDSearchTextField2(m.getParentModel().getTable().getProvider(), RDSearchTextField2.SearchTypes.AIRPORT);
            this.depPort.setNode(m.getNode().getChildNamed(ALegComplete_.departureAirport));
            this.add(this.depPort);
            this.depPort.fadeIn();
            if (LegTable.this.flightType == LegTableType.FLIGHTSCHEDULE || LegTable.this.flightType == LegTableType.ADHOC) {
                this.type = new RDComboBox(LegTable.this.table.getProvider(), ConverterRegistry.getConverter(LegTypeConverter.class));
                this.type.refreshPossibleValues(NodeToolkit.getAffixList(LegTypeE.class));
                this.type.setNode(m.getNode().getChildNamed(ALegComplete_.legType));
                this.add(this.type);
                this.stdLeg = new RDRadioButton(m.getParentModel().getTable().getProvider());
                this.staLeg = new RDRadioButton(m.getParentModel().getTable().getProvider());
                if (LegTable.this.flightType == LegTableType.FLIGHTSCHEDULE) {
                    this.stdLeg.setOverrideName(FlightScheduleComplete_.stdLeg);
                    this.staLeg.setOverrideName(FlightScheduleComplete_.staLeg);
                } else if (LegTable.this.flightType == LegTableType.ADHOC) {
                    this.stdLeg.setOverrideName(FlightComplete_.stdLeg);
                    this.staLeg.setOverrideName(FlightComplete_.staLeg);
                }
                this.stdLeg.addButtonListener(this);
                this.staLeg.addButtonListener(this);
                this.stdLeg.setNode(null);
                this.staLeg.setNode(null);
                this.add(this.stdLeg);
                this.add(this.staLeg);
            }
            if (LegTable.this.flightType == LegTableType.FLIGHTSCHEDULE) {
                m.getNode().getChildNamed(FlightScheduleLegComplete_.flightNo).removeNodeListener((NodeListener)this);
                m.getNode().getChildNamed(FlightScheduleLegComplete_.flightTime).removeNodeListener((NodeListener)this);
                if (m.getNode().getChildNamed(FlightScheduleLegComplete_.flightNo).getValue() == null || m.getNode().getChildNamed(FlightScheduleLegComplete_.flightTime).getValue() == null) {
                    Node fsNode = LegTable.this.table.getModel().getNode().getParent();
                    if (m.getNode().getValue().equals(fsNode.getChildNamed(FlightScheduleComplete_.stdLeg).getValue())) {
                        m.getNode().getChildNamed(FlightScheduleLegComplete_.flightNo).setValue(fsNode.getChildNamed(FlightScheduleComplete_.outboundCode).getValue(), 0L);
                        Time std = (Time)fsNode.getChildNamed(FlightScheduleComplete_.std).getValue();
                        Time stdTime = (Time)m.getNode().getChildNamed(FlightScheduleLegComplete_.flightTime).getValue();
                        if (stdTime == null) {
                            stdTime = new Time(0L);
                        }
                        stdTime.setTime(std.getTime());
                        m.getNode().getChildNamed(FlightScheduleLegComplete_.flightTime).setValue((Object)stdTime, 0L);
                    }
                    if (m.getNode().getValue().equals(fsNode.getChildNamed(FlightScheduleComplete_.staLeg).getValue())) {
                        m.getNode().getChildNamed(FlightScheduleLegComplete_.flightNo).setValue(fsNode.getChildNamed(FlightScheduleComplete_.inboundCode).getValue(), 0L);
                        Time sta = (Time)fsNode.getChildNamed(FlightScheduleComplete_.sta).getValue();
                        Time staTime = (Time)m.getNode().getChildNamed(FlightScheduleLegComplete_.flightTime).getValue();
                        if (staTime == null) {
                            staTime = new Time(0L);
                        }
                        staTime.setTime(sta.getTime());
                        m.getNode().getChildNamed(FlightScheduleLegComplete_.flightTime).setValue((Object)staTime, 0L);
                    }
                }
                m.getNode().getChildNamed(FlightScheduleLegComplete_.flightNo).addNodeListener((NodeListener)this);
                m.getNode().getChildNamed(FlightScheduleLegComplete_.flightTime).addNodeListener((NodeListener)this);
            } else if (LegTable.this.flightType == LegTableType.ADHOC) {
                m.getNode().getChildNamed(FlightLegComplete_.flightNo).removeNodeListener((NodeListener)this);
                m.getNode().getChildNamed(FlightLegComplete_.flightTime).removeNodeListener((NodeListener)this);
                this.legMapping = new InfoButton();
                this.legMapping.installStringViewer(LegToolkit.createLegMappingText((Node)m.getNode()));
                this.add(this.legMapping);
                if (m.getNode().getChildNamed(FlightLegComplete_.flightNo).getValue() == null || m.getNode().getChildNamed(FlightLegComplete_.flightTime).getValue() == null) {
                    Node fsNode = LegTable.this.table.getModel().getNode().getParent();
                    if (m.getNode().getValue().equals(fsNode.getChildNamed(FlightComplete_.stdLeg).getValue())) {
                        m.getNode().getChildNamed(FlightLegComplete_.flightNo).setValue(fsNode.getChildNamed(FlightLight_.outboundCode).getValue(), 0L);
                        Timestamp std = (Timestamp)fsNode.getChildNamed(FlightLight_.std).getValue();
                        Time stdTime = (Time)m.getNode().getChildNamed(FlightLegComplete_.flightTime).getValue();
                        if (stdTime == null) {
                            stdTime = new Time(0L);
                        }
                        stdTime.setTime(std.getTime());
                        m.getNode().getChildNamed(FlightLegComplete_.flightTime).setValue((Object)stdTime, 0L);
                    }
                    if (m.getNode().getValue().equals(fsNode.getChildNamed(FlightComplete_.stdLeg).getValue())) {
                        m.getNode().getChildNamed(FlightLegComplete_.flightNo).setValue(fsNode.getChildNamed(FlightLight_.inboundCode).getValue(), 0L);
                        Timestamp sta = (Timestamp)fsNode.getChildNamed(FlightLight_.sta).getValue();
                        Time staTime = (Time)m.getNode().getChildNamed(FlightLegComplete_.flightTime).getValue();
                        if (staTime == null) {
                            staTime = new Time(0L);
                        }
                        staTime.setTime(sta.getTime());
                        m.getNode().getChildNamed(FlightLegComplete_.flightTime).setValue((Object)staTime, 0L);
                    }
                }
                m.getNode().getChildNamed(FlightLegComplete_.flightNo).addNodeListener((NodeListener)this);
                m.getNode().getChildNamed(FlightLegComplete_.flightTime).addNodeListener((NodeListener)this);
            }
            this.arrPort = new RDSearchTextField2(m.getParentModel().getTable().getProvider(), RDSearchTextField2.SearchTypes.AIRPORT);
            this.arrPort.setNode(m.getNode().getChildNamed(ALegComplete_.arrivalAirport));
            this.add(this.arrPort);
            this.arrPort.fadeIn();
            if (LegTable.this.useGalleyBellySwitch && (Integer)m.getNode().getChildNamed(ALegComplete_.number).getValue() > 0) {
                this.galleyChange = new RDRadioButton(m.getParentModel().getTable().getProvider());
                this.galleyChange.setOverrideName("galleyBellySwitch");
                this.galleyChange.setNode(null);
                this.galleyChange.setToolTipText(Words.CHOOSE_LEG_FOR_GALLEY_BELLY_SWITCH);
                this.galleyChange.addButtonListener(this);
            }
            m.getNode().addNodeListener((NodeListener)this);
            this.childAdded(m.getNode(), m.getNode().getChildNamed(ALegComplete_.number));
            this.lafAttributeChanged("All attribues changed");
            if (m.getParentModel().getTable().getProvider().isDeletable("legs") || m.getParentModel().getTable().getProvider().isWritable("removeLegs")) {
                this.delete = new DeleteButton(SizedSkin1Field.SkinSize.MEDIUM);
                this.delete.addButtonListener(this);
                this.delete.setUserObject(m.getNode());
                this.add(this.delete);
                this.delete.fadeIn();
            }
            if (this.galleyChange != null) {
                this.add(this.galleyChange);
            }
            this.ensureAdditionalFlightNo();
            this.ensureStaLeg();
            this.ensureStdLeg();
            this.setEnabled(true);
        }

        private void ensureStaLeg() {
            if (LegTable.this.flightType == LegTableType.FLIGHTSCHEDULE) {
                if (this.model.getNode().getValue() != null && this.model.getNode().getValue().equals(this.model.getNode().getParent().getParent().getChildNamed(FlightScheduleComplete_.staLeg).getValue())) {
                    this.staLeg.setChecked(true);
                } else {
                    this.staLeg.setChecked(false);
                }
            } else if (LegTable.this.flightType == LegTableType.ADHOC) {
                if (this.model.getNode().getValue() != null && LegTable.this.adHocFlight != null && LegTable.this.adHocFlight.getChildNamed(FlightComplete_.staLeg) != null && this.model.getNode().getValue().equals(LegTable.this.adHocFlight.getChildNamed(FlightComplete_.staLeg).getValue())) {
                    this.staLeg.setChecked(true);
                } else {
                    this.staLeg.setChecked(false);
                }
            }
        }

        private void ensureStdLeg() {
            if (LegTable.this.flightType == LegTableType.FLIGHTSCHEDULE) {
                if (this.model.getNode().getValue() != null && this.model.getNode().getValue().equals(this.model.getNode().getParent().getParent().getChildNamed(FlightScheduleComplete_.stdLeg).getValue())) {
                    this.stdLeg.setChecked(true);
                } else {
                    this.stdLeg.setChecked(false);
                }
            } else if (LegTable.this.flightType == LegTableType.ADHOC) {
                if (this.model.getNode().getValue() != null && LegTable.this.adHocFlight != null && LegTable.this.adHocFlight.getChildNamed(FlightComplete_.stdLeg) != null && this.model.getNode().getValue().equals(LegTable.this.adHocFlight.getChildNamed(FlightComplete_.stdLeg).getValue())) {
                    this.stdLeg.setChecked(true);
                } else {
                    this.stdLeg.setChecked(false);
                }
            }
        }

        private void ensureAdditionalFlightNo() {
            if (LegTable.this.flightType == LegTableType.FLIGHTSCHEDULE || LegTable.this.flightType == LegTableType.ADHOC) {
                this.showAdditionalFlightNo();
            }
        }

        private void showAdditionalFlightNo() {
            if (this.flightNo == null) {
                this.flightNo = new RDTextField(LegTable.this.table.getProvider());
                this.flightNo.setNode(this.model.getNode().getChildNamed(FlightScheduleLegComplete_.flightNo));
                this.add(this.flightNo);
            }
            if (this.flightTime == null) {
                this.flightTime = new RDTextField(LegTable.this.table.getProvider(), TextFieldType.DAYTIME);
                if (this.model.getNode().getChildNamed(FlightScheduleLegComplete_.flightTime) != null && this.model.getNode().getChildNamed(FlightScheduleLegComplete_.flightTime).getValue() == null) {
                    this.model.getNode().getChildNamed(FlightScheduleLegComplete_.flightTime).setValue((Object)new Time(System.currentTimeMillis()), 0L);
                }
                this.flightTime.setNode(this.model.getNode().getChildNamed(FlightScheduleLegComplete_.flightTime));
                this.add(this.flightTime);
            }
            if (this.showOnDailyOps == null) {
                this.showOnDailyOps = new RDCheckBox(LegTable.this.table.getProvider());
                this.showOnDailyOps.setNode(this.model.getNode().getChildNamed(FlightScheduleLegComplete_.showLegOnDailyOps));
                this.add(this.showOnDailyOps);
            }
            if (this.cateringLeg == null) {
                this.cateringLeg = new RDCheckBox(LegTable.this.table.getProvider());
                this.cateringLeg.setNode(this.model.getNode().getChildNamed(FlightScheduleLegComplete_.cateringLeg));
                this.add(this.cateringLeg);
            }
        }

        private boolean isLegReferenced(Node<ALegComplete> leg) {
            Node dlNode = NodeToolkit.getAffixNamed((String)"referencedLegs");
            if (dlNode != null) {
                List l = (List)dlNode.getValue();
                return l.contains(leg.getValue());
            }
            return false;
        }

        public void updateCurrentView() {
            if (this.depPort.getEditor() != null) {
                this.newValueSelected((SearchTextField2)this.depPort.getEditor(), null);
            }
            if (this.arrPort.getEditor() != null) {
                this.newValueSelected((SearchTextField2)this.arrPort.getEditor(), null);
            }
        }

        @Override
        public Object getObject4Column(int column) {
            if (LegTable.this.flightType == LegTableType.FLIGHTSCHEDULE) {
                return null;
            }
            return this.model.getNode().getChildNamed(ALegComplete_.number).getValue();
        }

        protected void updateGalleyBellySwitch(Node n) {
            if (this.galleyChange == null) {
                return;
            }
            if (this.model.getNode().getValue().equals(n.getValue())) {
                this.galleyChange.setChecked(true);
            } else {
                this.galleyChange.setChecked(false);
            }
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.showOnDailyOps);
            CheckedListAdder.addToList(a, this.cateringLeg);
            CheckedListAdder.addToList(a, this.stdLeg);
            CheckedListAdder.addToList(a, this.staLeg);
            CheckedListAdder.addToList(a, this.depPort);
            CheckedListAdder.addToList(a, this.arrPort);
            CheckedListAdder.addToList(a, this.type);
            if (this.flightNo != null) {
                CheckedListAdder.addToList(a, this.flightNo);
            }
            if (this.flightTime != null) {
                CheckedListAdder.addToList(a, this.flightTime);
            }
            CheckedListAdder.addToList(a, this.timeType);
            CheckedListAdder.addToList(a, this.delete);
            return a;
        }

        @Override
        public void requestFocusInWindowNow() {
            if (this.flightNo != null) {
                this.flightNo.requestFocusInWindowNow();
            }
        }

        public void childAdded(Node<?> source, Node<?> child) {
            if (LegTable.this.flightType != LegTableType.FLIGHTSCHEDULE && child.getName().equals("number")) {
                this.legNumber = new TextLabel("" + ((Integer)child.getFormattedValue() + 1));
                child.addNodeListener((NodeListener)this);
                this.add(this.legNumber);
                this.legNumber.fadeIn();
            }
        }

        public void childRemoved(Node<?> source, Node<?> child) {
        }

        public void valueChanged(Node<?> node) {
            if (LegTable.this.flightType != LegTableType.FLIGHTSCHEDULE && LegTable.this.flightType != LegTableType.ADHOC) {
                if (node.getName().equals(ALegComplete_.number.getFieldName()) && this.legNumber != null) {
                    Integer i = (Integer)node.getFormattedValue();
                    if (i == null) {
                        i = 0;
                    }
                    this.legNumber.setText("" + (i + 1));
                }
            } else if (LegTable.this.flightType == LegTableType.ADHOC) {
                Node tNode;
                DtoField attName;
                Timestamp nstd;
                Time rstd;
                Date fstd;
                String t;
                Node fsNode = LegTable.this.adHocFlight;
                if (this.model.getNode().getValue().equals(fsNode.getChildNamed(FlightComplete_.stdLeg).getValue())) {
                    if (node.getName().equals(FlightLegComplete_.flightNo.getFieldName())) {
                        String outcode;
                        t = (String)node.getValue();
                        if (!t.equals(outcode = (String)fsNode.getChildNamed(FlightComplete_.outboundCode).getValue())) {
                            fsNode.getChildNamed(FlightComplete_.outboundCode).setValueSilent((Object)t, false, 0L, new NodeListener[]{LegTable.this});
                        }
                    } else if (node.getName().equals(FlightLegComplete_.flightTime.getFieldName())) {
                        fstd = (Date)fsNode.getChildNamed(FlightLight_.std).getValue();
                        rstd = (Time)node.getValue();
                        nstd = CalendarUtil.mergeTimestamps((Date)fstd, (Time)rstd);
                        attName = FlightComplete_.realstd;
                        if (LegTable.this.writeStdData) {
                            attName = FlightComplete_.std;
                        }
                        if (!nstd.equals((tNode = fsNode.getChildNamed(attName)).getValue())) {
                            tNode.setValueSilent((Object)nstd, false, 0L, new NodeListener[]{LegTable.this});
                        }
                    }
                }
                if (this.model.getNode().getValue().equals(fsNode.getChildNamed(FlightComplete_.staLeg).getValue())) {
                    if (node.getName().equals(FlightLegComplete_.flightNo.getFieldName())) {
                        String incode;
                        t = (String)node.getValue();
                        if (!t.equals(incode = (String)fsNode.getChildNamed(FlightComplete_.inboundCode).getValue())) {
                            fsNode.getChildNamed(FlightComplete_.inboundCode).setValueSilent((Object)t, false, 0L, new NodeListener[]{LegTable.this});
                        }
                    } else if (node.getName().equals(FlightLegComplete_.flightTime.getFieldName())) {
                        fstd = (Date)fsNode.getChildNamed(FlightLight_.sta).getValue();
                        rstd = (Time)node.getValue();
                        nstd = CalendarUtil.mergeTimestamps((Date)fstd, (Time)rstd);
                        attName = FlightComplete_.realsta;
                        if (LegTable.this.writeStdData) {
                            attName = FlightComplete_.sta;
                        }
                        if (!nstd.equals((tNode = fsNode.getChildNamed(attName)).getValue())) {
                            tNode.setValueSilent((Object)nstd, false, 0L, new NodeListener[]{LegTable.this});
                        }
                    }
                }
            } else if (LegTable.this.flightType == LegTableType.FLIGHTSCHEDULE) {
                Node tNode;
                String outcode;
                String t;
                Node fsNode = this.model.getNode().getParent().getParent();
                if (this.model.getNode().getValue().equals(fsNode.getChildNamed(FlightScheduleComplete_.stdLeg).getValue())) {
                    if (node.getName().equals(FlightScheduleLegComplete_.flightNo.getFieldName())) {
                        t = (String)node.getValue();
                        if (!t.equals(outcode = (String)fsNode.getChildNamed(FlightScheduleComplete_.outboundCode).getValue())) {
                            fsNode.getChildNamed(FlightScheduleComplete_.outboundCode).setValueSilent((Object)t, false, 0L, new NodeListener[]{LegTable.this});
                        }
                    } else if (node.getName().equals(FlightScheduleLegComplete_.flightTime.getFieldName())) {
                        tNode = fsNode.getChildNamed(FlightScheduleComplete_.std);
                        if (!node.getValue().equals(tNode.getValue())) {
                            tNode.setValueSilent((Object)((Time)node.getValue()), false, 0L, new NodeListener[]{LegTable.this});
                        }
                    }
                }
                if (this.model.getNode().getValue().equals(fsNode.getChildNamed(FlightScheduleComplete_.staLeg).getValue())) {
                    if (node.getName().equals(FlightScheduleLegComplete_.flightNo.getFieldName())) {
                        t = (String)node.getValue();
                        if (!t.equals(outcode = (String)fsNode.getChildNamed(FlightScheduleComplete_.inboundCode).getValue())) {
                            fsNode.getChildNamed(FlightScheduleComplete_.inboundCode).setValueSilent((Object)t, false, 0L, new NodeListener[]{LegTable.this});
                        }
                    } else if (node.getName().equals(FlightScheduleLegComplete_.flightTime.getFieldName())) {
                        tNode = fsNode.getChildNamed(FlightScheduleComplete_.sta);
                        if (!node.getValue().equals(tNode.getValue())) {
                            tNode.setValueSilent((Object)((Time)node.getValue()), false, 0L, new NodeListener[]{LegTable.this});
                        }
                    }
                }
            }
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getParentModel().getNode().removeChild(this.model.getNode(), System.currentTimeMillis());
            } else if (this.galleyChange != null && source == this.galleyChange.getEditor()) {
                Node galleyBellySwitch = this.model.getNode().getParent().getParent().getChildNamed(StowingListTemplateComplete_.galleyBellySwitch);
                if (galleyBellySwitch instanceof Node) {
                    if (galleyBellySwitch.getValue() != null && galleyBellySwitch.getValue().equals(this.model.getNode().getValue())) {
                        galleyBellySwitch.setValue(null, System.currentTimeMillis());
                    } else {
                        galleyBellySwitch.setValue(this.model.getNode().getValue(), System.currentTimeMillis());
                    }
                }
            } else if (source == this.stdLeg.getEditor()) {
                if (((RadioButton)this.stdLeg.getEditor()).isChecked()) {
                    if (LegTable.this.flightType == LegTableType.ADHOC) {
                        LegTable.this.adHocFlight.getChildNamed(FlightScheduleComplete_.stdLeg).setValue(this.model.getNode().getValue(), 0L);
                    } else {
                        this.model.getNode().getParent().getParent().getChildNamed(FlightScheduleComplete_.stdLeg).setValue(this.model.getNode().getValue(), 0L);
                    }
                }
                LegTable.this.ensureAllStdStaLegs();
            } else if (source == this.staLeg.getEditor()) {
                if (((RadioButton)this.staLeg.getEditor()).isChecked()) {
                    if (LegTable.this.flightType == LegTableType.ADHOC) {
                        LegTable.this.adHocFlight.getChildNamed(FlightScheduleComplete_.staLeg).setValue(this.model.getNode().getValue(), 0L);
                    } else {
                        this.model.getNode().getParent().getParent().getChildNamed(FlightScheduleComplete_.staLeg).setValue(this.model.getNode().getValue(), 0L);
                    }
                }
                LegTable.this.ensureAllStdStaLegs();
            }
        }

        @Override
        public void lafAttributeChanged(String att) {
            Font f = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
            if (this.legNumber != null) {
                this.legNumber.setFont(f);
            }
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            if (this.legNumber != null) {
                this.legNumber.setEnabled(isEnabled);
            }
            this.depPort.setEnabled(isEnabled);
            this.arrPort.setEnabled(isEnabled);
            if (this.type != null) {
                this.type.setEnabled(isEnabled);
            }
            if (this.flightNo != null) {
                this.flightNo.setEnabled(isEnabled);
            }
            if (this.flightTime != null) {
                this.flightTime.setEnabled(isEnabled);
            }
            if (this.delete != null) {
                this.delete.setEnabled(isEnabled && !this.isReferenced);
            }
            if (this.galleyChange != null) {
                this.galleyChange.setEnabled(isEnabled);
            }
            if (this.showOnDailyOps != null) {
                this.showOnDailyOps.setEnabled(isEnabled);
            }
            if (this.cateringLeg != null) {
                this.cateringLeg.setEnabled(isEnabled);
            }
            if (this.stdLeg != null) {
                this.stdLeg.setEnabled(isEnabled);
            }
            if (this.staLeg != null) {
                this.staLeg.setEnabled(isEnabled);
            }
            if (this.timeType != null) {
                this.timeType.setEnabled(isEnabled);
            }
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            if (this.legNumber != null) {
                this.legNumber.kill();
            }
            this.depPort.kill();
            this.arrPort.kill();
            if (this.delete != null) {
                this.delete.kill();
            }
            if (this.galleyChange != null) {
                this.galleyChange.kill();
            }
            if (this.type != null) {
                this.type.kill();
            }
            if (this.flightNo != null) {
                this.flightNo.kill();
            }
            if (this.flightTime != null) {
                this.flightTime.kill();
            }
            if (this.showOnDailyOps != null) {
                this.showOnDailyOps.kill();
            }
            if (this.cateringLeg != null) {
                this.cateringLeg.kill();
            }
            if (this.staLeg != null) {
                this.staLeg.kill();
            }
            if (this.stdLeg != null) {
                this.stdLeg.kill();
            }
            if (this.timeType != null) {
                this.timeType.kill();
            }
            this.model.getNode().removeNodeListenerRecursively((NodeListener)this);
            this.legNumber = null;
            this.depPort = null;
            this.arrPort = null;
            this.delete = null;
            this.galleyChange = null;
            this.type = null;
            this.flightNo = null;
            this.flightTime = null;
            this.showOnDailyOps = null;
            this.cateringLeg = null;
            this.staLeg = null;
            this.stdLeg = null;
            this.timeType = null;
        }

        public void childrenAdded(Node<?> source, Node<?> ... nodes) {
        }

        public boolean isSwingOnly() {
            return true;
        }

        @Override
        public void newValueSelected(SearchTextField2 source, Node<?> n) {
            this.model.getNode().commit(ALegComplete.class);
            this.model.getNode().updateNode();
            if (LegTable.this.fixpanel != null) {
                LegTable.this.fixpanel.updateAirports();
            }
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int h = parent.getHeight();
                int xInset = LegTableRowPanel.this.getCellPadding();
                int i = 2;
                int w = LegTableRowPanel.this.model.getParentModel().getColumnWidth(0);
                if (LegTable.this.flightType == LegTableType.ADHOC) {
                    LegTableRowPanel.this.legNumber.setLocation(currentX + xInset, (int)(((double)h - LegTableRowPanel.this.legNumber.getPreferredSize().getHeight()) / 2.0));
                    LegTableRowPanel.this.legNumber.setSize((int)LegTableRowPanel.this.legNumber.getPreferredSize().getWidth(), (int)LegTableRowPanel.this.legNumber.getPreferredSize().getHeight());
                    currentX += w;
                    w = LegTableRowPanel.this.model.getParentModel().getColumnWidth(1);
                    LegTableRowPanel.this.showOnDailyOps.setLocation(currentX + 4 + xInset, (int)(((double)h - LegTableRowPanel.this.showOnDailyOps.getPreferredSize().getHeight()) / 2.0));
                    LegTableRowPanel.this.showOnDailyOps.setSize(w - 2 * LegTableRowPanel.this.getCellPadding(), (int)LegTableRowPanel.this.showOnDailyOps.getPreferredSize().getHeight());
                    currentX += w;
                    w = LegTableRowPanel.this.model.getParentModel().getColumnWidth(2);
                    LegTableRowPanel.this.cateringLeg.setLocation(currentX + 4 + xInset, (int)(((double)h - LegTableRowPanel.this.cateringLeg.getPreferredSize().getHeight()) / 2.0));
                    LegTableRowPanel.this.cateringLeg.setSize(w - 2 * LegTableRowPanel.this.getCellPadding(), (int)LegTableRowPanel.this.cateringLeg.getPreferredSize().getHeight());
                    currentX += w;
                    w = LegTableRowPanel.this.model.getParentModel().getColumnWidth(3);
                    LegTableRowPanel.this.stdLeg.setLocation(currentX + 4 + xInset, (int)(((double)h - LegTableRowPanel.this.stdLeg.getPreferredSize().getHeight()) / 2.0));
                    LegTableRowPanel.this.stdLeg.setSize(w - 2 * LegTableRowPanel.this.getCellPadding(), (int)LegTableRowPanel.this.stdLeg.getPreferredSize().getHeight());
                    currentX += w;
                    w = LegTableRowPanel.this.model.getParentModel().getColumnWidth(4);
                    LegTableRowPanel.this.staLeg.setLocation(currentX + 4 + xInset, (int)(((double)h - LegTableRowPanel.this.staLeg.getPreferredSize().getHeight()) / 2.0));
                    LegTableRowPanel.this.staLeg.setSize(w - 2 * LegTableRowPanel.this.getCellPadding(), (int)LegTableRowPanel.this.staLeg.getPreferredSize().getHeight());
                    currentX += w;
                    w = LegTableRowPanel.this.model.getParentModel().getColumnWidth(5);
                    LegTableRowPanel.this.depPort.setLocation(currentX + xInset, (int)(((double)h - LegTableRowPanel.this.depPort.getPreferredSize().getHeight()) / 2.0));
                    LegTableRowPanel.this.depPort.setSize(w - 2 * xInset, (int)LegTableRowPanel.this.depPort.getPreferredSize().getHeight());
                    currentX += w;
                    w = LegTableRowPanel.this.model.getParentModel().getColumnWidth(6);
                    LegTableRowPanel.this.arrPort.setLocation(currentX + xInset, (int)(((double)h - LegTableRowPanel.this.arrPort.getPreferredSize().getHeight()) / 2.0));
                    LegTableRowPanel.this.arrPort.setSize(w - 2 * xInset, (int)LegTableRowPanel.this.arrPort.getPreferredSize().getHeight());
                    currentX += w;
                    w = LegTableRowPanel.this.model.getParentModel().getColumnWidth(7);
                    if (LegTableRowPanel.this.type != null) {
                        LegTableRowPanel.this.type.setLocation(currentX + LegTableRowPanel.this.getCellPadding(), (int)(((double)parent.getHeight() - LegTableRowPanel.this.type.getPreferredSize().getHeight()) / 2.0));
                        LegTableRowPanel.this.type.setSize(w - 2 * LegTableRowPanel.this.getCellPadding(), (int)LegTableRowPanel.this.type.getPreferredSize().getHeight());
                        currentX += w;
                        w = LegTableRowPanel.this.model.getParentModel().getColumnWidth(8);
                    }
                    if (LegTableRowPanel.this.flightNo != null) {
                        LegTableRowPanel.this.flightNo.setLocation(currentX + LegTableRowPanel.this.getCellPadding(), (int)(((double)parent.getHeight() - LegTableRowPanel.this.flightNo.getPreferredSize().getHeight()) / 2.0));
                        LegTableRowPanel.this.flightNo.setSize(w - 2 * LegTableRowPanel.this.getCellPadding(), (int)LegTableRowPanel.this.flightNo.getPreferredSize().getHeight());
                        currentX += w;
                        w = LegTableRowPanel.this.model.getParentModel().getColumnWidth(9);
                    }
                    if (LegTableRowPanel.this.flightTime != null) {
                        LegTableRowPanel.this.flightTime.setLocation(currentX + LegTableRowPanel.this.getCellPadding(), (int)(((double)parent.getHeight() - LegTableRowPanel.this.flightTime.getPreferredSize().getHeight()) / 2.0));
                        LegTableRowPanel.this.flightTime.setSize(w - 2 * LegTableRowPanel.this.getCellPadding(), (int)LegTableRowPanel.this.flightTime.getPreferredSize().getHeight());
                        currentX += w;
                        w = LegTableRowPanel.this.model.getParentModel().getColumnWidth(10);
                    }
                    if (LegTableRowPanel.this.legMapping != null) {
                        LegTableRowPanel.this.legMapping.setLocation(currentX + xInset, (int)(((double)h - LegTableRowPanel.this.legMapping.getPreferredSize().getHeight()) / 2.0));
                        LegTableRowPanel.this.legMapping.setSize(LegTableRowPanel.this.legMapping.getPreferredSize());
                        currentX += w;
                        w = LegTableRowPanel.this.model.getParentModel().getColumnWidth(11);
                    }
                    LegTableRowPanel.this.setControlsX(currentX);
                    if (LegTableRowPanel.this.delete != null) {
                        LegTableRowPanel.this.delete.setLocation(currentX + xInset, (int)(((double)h - LegTableRowPanel.this.delete.getPreferredSize().getHeight()) / 2.0));
                        LegTableRowPanel.this.delete.setSize((int)LegTableRowPanel.this.delete.getPreferredSize().getWidth(), (int)LegTableRowPanel.this.delete.getPreferredSize().getHeight());
                    }
                } else if (LegTable.this.flightType != LegTableType.FLIGHTSCHEDULE) {
                    LegTableRowPanel.this.legNumber.setLocation(currentX + xInset, (int)(((double)h - LegTableRowPanel.this.legNumber.getPreferredSize().getHeight()) / 2.0));
                    LegTableRowPanel.this.legNumber.setSize((int)LegTableRowPanel.this.legNumber.getPreferredSize().getWidth(), (int)LegTableRowPanel.this.legNumber.getPreferredSize().getHeight());
                    currentX += w;
                    w = LegTableRowPanel.this.model.getParentModel().getColumnWidth(1);
                    if (LegTableRowPanel.this.galleyChange != null) {
                        LegTableRowPanel.this.galleyChange.setLocation(currentX + xInset, (int)(((double)parent.getHeight() - LegTableRowPanel.this.galleyChange.getPreferredSize().getHeight()) / 2.0));
                        LegTableRowPanel.this.galleyChange.setSize(LegTableRowPanel.this.galleyChange.getPreferredSize());
                        currentX += w;
                        w = LegTableRowPanel.this.model.getParentModel().getColumnWidth(i);
                        ++i;
                    } else if (LegTable.this.useGalleyBellySwitch) {
                        currentX += w;
                        w = LegTableRowPanel.this.model.getParentModel().getColumnWidth(i);
                        ++i;
                    }
                    LegTableRowPanel.this.depPort.setLocation(currentX + xInset, (int)(((double)h - LegTableRowPanel.this.depPort.getPreferredSize().getHeight()) / 2.0));
                    LegTableRowPanel.this.depPort.setSize(w - 2 * xInset, (int)LegTableRowPanel.this.depPort.getPreferredSize().getHeight());
                    currentX += w;
                    w = LegTableRowPanel.this.model.getParentModel().getColumnWidth(i);
                    LegTableRowPanel.this.arrPort.setLocation(currentX + xInset, (int)(((double)h - LegTableRowPanel.this.arrPort.getPreferredSize().getHeight()) / 2.0));
                    LegTableRowPanel.this.arrPort.setSize(w - 2 * xInset, (int)LegTableRowPanel.this.arrPort.getPreferredSize().getHeight());
                    currentX += w;
                    w = LegTableRowPanel.this.model.getParentModel().getColumnWidth(++i);
                    ++i;
                    if (LegTableRowPanel.this.type != null) {
                        LegTableRowPanel.this.type.setLocation(currentX + LegTableRowPanel.this.getCellPadding(), (int)(((double)parent.getHeight() - LegTableRowPanel.this.type.getPreferredSize().getHeight()) / 2.0));
                        LegTableRowPanel.this.type.setSize(w - 2 * LegTableRowPanel.this.getCellPadding(), (int)LegTableRowPanel.this.type.getPreferredSize().getHeight());
                        currentX += w;
                        w = LegTableRowPanel.this.model.getParentModel().getColumnWidth(i);
                        ++i;
                    }
                    if (LegTableRowPanel.this.timeType != null) {
                        LegTableRowPanel.this.timeType.setLocation(currentX + LegTableRowPanel.this.getCellPadding(), (int)(((double)parent.getHeight() - LegTableRowPanel.this.timeType.getPreferredSize().getHeight()) / 2.0));
                        LegTableRowPanel.this.timeType.setSize(w - 2 * LegTableRowPanel.this.getCellPadding(), (int)LegTableRowPanel.this.timeType.getPreferredSize().getHeight());
                        currentX += w;
                        w = LegTableRowPanel.this.model.getParentModel().getColumnWidth(i);
                        ++i;
                    }
                    LegTableRowPanel.this.setControlsX(currentX);
                    if (LegTableRowPanel.this.delete != null) {
                        LegTableRowPanel.this.delete.setLocation(currentX + xInset, (int)(((double)h - LegTableRowPanel.this.delete.getPreferredSize().getHeight()) / 2.0));
                        LegTableRowPanel.this.delete.setSize((int)LegTableRowPanel.this.delete.getPreferredSize().getWidth(), (int)LegTableRowPanel.this.delete.getPreferredSize().getHeight());
                    }
                } else {
                    LegTableRowPanel.this.showOnDailyOps.setLocation(currentX + xInset, (int)(((double)h - LegTableRowPanel.this.showOnDailyOps.getPreferredSize().getHeight()) / 2.0));
                    LegTableRowPanel.this.showOnDailyOps.setSize(w - 2 * LegTableRowPanel.this.getCellPadding(), (int)LegTableRowPanel.this.showOnDailyOps.getPreferredSize().getHeight());
                    currentX += w;
                    w = LegTableRowPanel.this.model.getParentModel().getColumnWidth(1);
                    LegTableRowPanel.this.cateringLeg.setLocation(currentX + xInset, (int)(((double)h - LegTableRowPanel.this.cateringLeg.getPreferredSize().getHeight()) / 2.0));
                    LegTableRowPanel.this.cateringLeg.setSize(w - 2 * LegTableRowPanel.this.getCellPadding(), (int)LegTableRowPanel.this.cateringLeg.getPreferredSize().getHeight());
                    currentX += w;
                    w = LegTableRowPanel.this.model.getParentModel().getColumnWidth(2);
                    LegTableRowPanel.this.stdLeg.setLocation(currentX + xInset, (int)(((double)h - LegTableRowPanel.this.stdLeg.getPreferredSize().getHeight()) / 2.0));
                    LegTableRowPanel.this.stdLeg.setSize(w - 2 * LegTableRowPanel.this.getCellPadding(), (int)LegTableRowPanel.this.stdLeg.getPreferredSize().getHeight());
                    currentX += w;
                    w = LegTableRowPanel.this.model.getParentModel().getColumnWidth(3);
                    LegTableRowPanel.this.staLeg.setLocation(currentX + xInset, (int)(((double)h - LegTableRowPanel.this.staLeg.getPreferredSize().getHeight()) / 2.0));
                    LegTableRowPanel.this.staLeg.setSize(w - 2 * LegTableRowPanel.this.getCellPadding(), (int)LegTableRowPanel.this.staLeg.getPreferredSize().getHeight());
                    currentX += w;
                    w = LegTableRowPanel.this.model.getParentModel().getColumnWidth(4);
                    LegTableRowPanel.this.depPort.setLocation(currentX + xInset, (int)(((double)h - LegTableRowPanel.this.depPort.getPreferredSize().getHeight()) / 2.0));
                    LegTableRowPanel.this.depPort.setSize(w - 2 * xInset, (int)LegTableRowPanel.this.depPort.getPreferredSize().getHeight());
                    currentX += w;
                    w = LegTableRowPanel.this.model.getParentModel().getColumnWidth(5);
                    ++i;
                    LegTableRowPanel.this.arrPort.setLocation(currentX + xInset, (int)(((double)h - LegTableRowPanel.this.arrPort.getPreferredSize().getHeight()) / 2.0));
                    LegTableRowPanel.this.arrPort.setSize(w - 2 * xInset, (int)LegTableRowPanel.this.arrPort.getPreferredSize().getHeight());
                    currentX += w;
                    w = LegTableRowPanel.this.model.getParentModel().getColumnWidth(6);
                    if (LegTableRowPanel.this.type != null) {
                        LegTableRowPanel.this.type.setLocation(currentX + LegTableRowPanel.this.getCellPadding(), (int)(((double)parent.getHeight() - LegTableRowPanel.this.type.getPreferredSize().getHeight()) / 2.0));
                        LegTableRowPanel.this.type.setSize(w - 2 * LegTableRowPanel.this.getCellPadding(), (int)LegTableRowPanel.this.type.getPreferredSize().getHeight());
                        currentX += w;
                        w = LegTableRowPanel.this.model.getParentModel().getColumnWidth(7);
                    }
                    if (LegTableRowPanel.this.flightNo != null) {
                        LegTableRowPanel.this.flightNo.setLocation(currentX + LegTableRowPanel.this.getCellPadding(), (int)(((double)parent.getHeight() - LegTableRowPanel.this.flightNo.getPreferredSize().getHeight()) / 2.0));
                        LegTableRowPanel.this.flightNo.setSize(w - 2 * LegTableRowPanel.this.getCellPadding(), (int)LegTableRowPanel.this.flightNo.getPreferredSize().getHeight());
                        currentX += w;
                        w = LegTableRowPanel.this.model.getParentModel().getColumnWidth(8);
                    }
                    if (LegTableRowPanel.this.flightTime != null) {
                        LegTableRowPanel.this.flightTime.setLocation(currentX + LegTableRowPanel.this.getCellPadding(), (int)(((double)parent.getHeight() - LegTableRowPanel.this.flightTime.getPreferredSize().getHeight()) / 2.0));
                        LegTableRowPanel.this.flightTime.setSize(w - 2 * LegTableRowPanel.this.getCellPadding(), (int)LegTableRowPanel.this.flightTime.getPreferredSize().getHeight());
                        currentX += w;
                        w = LegTableRowPanel.this.model.getParentModel().getColumnWidth(9);
                    }
                    LegTableRowPanel.this.setControlsX(currentX);
                    if (LegTableRowPanel.this.delete != null) {
                        LegTableRowPanel.this.delete.setLocation(currentX + xInset, (int)(((double)h - LegTableRowPanel.this.delete.getPreferredSize().getHeight()) / 2.0));
                        LegTableRowPanel.this.delete.setSize((int)LegTableRowPanel.this.delete.getPreferredSize().getWidth(), (int)LegTableRowPanel.this.delete.getPreferredSize().getHeight());
                    }
                }
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, LegTableRowPanel.this.getDefaultRowHeight());
            }
        }
    }

    private class LegTableLayout
    extends DefaultLayout {
        private LegTableLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = parent.getWidth();
            int h = parent.getHeight();
            LegTable.this.table.setLocation(0, 0);
            int th = 5;
            if (LegTable.this.deliveryAirport != null) {
                th = (int)LegTable.this.deliveryAirport.getPreferredSize().getHeight() + LegTable.this.table.getCellPadding();
            }
            LegTable.this.table.setSize(w, h - th);
            if (LegTable.this.deliveryAirport != null) {
                LegTable.this.deliveryAirport.setLocation(LegTable.this.table.getCellPadding(), (int)((double)parent.getHeight() - (LegTable.this.deliveryAirport.getPreferredSize().getHeight() + (double)LegTable.this.table.getCellPadding())));
                LegTable.this.deliveryAirport.setSize(200, (int)LegTable.this.deliveryAirport.getPreferredSize().getHeight());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension((int)LegTable.this.table.getPreferredSize().getWidth(), (int)(LegTable.this.table.getPreferredSize().getHeight() + 5.0));
        }
    }

    public static enum LegTableType {
        FLIGHTSCHEDULE,
        MEALPLAN,
        STOWINGLIST,
        ADHOC;

    }
}

