/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.flighttools;

import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.flighttools.FlightToolsModule;
import ch.icit.pegasus.client.gui.modules.importer.utils.ImporterItemView;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table.renderer.CellViewBooleanRenderer;
import ch.icit.pegasus.client.gui.table.renderer.CellViewFlightStateERenderer;
import ch.icit.pegasus.client.gui.table.renderer.custom.CellViewReturnsCountStateERenderer;
import ch.icit.pegasus.client.gui.table2.PageableTable2;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Killable;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.ArrowButton;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.combobox.multiselection.MultiHaulTypeSelectionComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.multiselection.MultiSelectionPanel;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.skins.AlignedSizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.SearchResultIterator;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.FlightSearchAlgorithm;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.flight.FlightServiceManager;
import ch.icit.pegasus.client.services.interfaces.flight.SalesOnBoardServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.RetailInMotionServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ExceptionHandler;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.toolkits.FileToolkit;
import ch.icit.pegasus.client.util.toolkits.StowingToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightStateE;
import ch.icit.pegasus.server.core.dtos.flightschedule.ReturnsCountStateE;
import ch.icit.pegasus.server.core.dtos.flightschedule.returnscount.ReturnsCountFlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.returnscount.ReturnsCountParameterConfig;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateReference;
import ch.icit.pegasus.server.core.dtos.masterdata.HaulTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PaxFigureTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.FlightToolsAccess;
import ch.icit.pegasus.server.core.dtos.search.FlightSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import ch.icit.utils.ExcelRow;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FileUtils;

public class UpdateStowingListInsert
extends DefaultDataInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private PageableTable2 searchTable;
    private Table2 queueTable;
    private Table2 finishedTable;
    private boolean calculateRim;
    private boolean updateFlightOnly;
    private boolean reloadStwFromFS;
    private boolean updateRCOnly;
    private boolean reloadSobData;
    private boolean reloadFlightData;
    private boolean setFlightsBackToOpen;
    private boolean revertTransactions;
    private TitledItem<CheckBox> toAutoCheckout;
    private TitledItem<CheckBox> onlyPerformTransactions;
    private TitledItem<CheckBox> setInOutFixed;
    private TitledItem<CheckBox> recalculateStowing;
    private TitledItem<CheckBox> useDefaultStowingListAnyway;
    private TitledItem<CheckBox> completeRC;
    private TitledItem<CheckBox> revalidateRC;
    private TitledItem<CheckBox> ignoreTransactions;
    private TitledItem<CheckBox> anonymous;
    private TitledItem<CheckBox> updateInvoiced;
    private TextButton start;
    private TextButton stop;
    private TextButton addAllButton;
    private TextButton addAllOnSiteButton;
    private TextButton readInFlights;
    private TextButton getTemplate;
    private ComboBox stateCombo;
    protected String FILTER_CHECKOUT = "checkout";
    protected String FILTER_NOT_INVOICED = "invoiced";
    protected String FILTER_INVOICED = "notInvoiced";
    protected String FILTER_SEARCH_FLIGHT_NUMBER = "FlightNo";
    protected String FILTER_STATE = "State";
    protected String FILTER_PERIOD = "Period";
    protected TitledPeriodEditor periodeditor;
    protected String FILTER_CUSTOMER = "Customer";
    protected String FILTER_STOWING_LIST = "StowingList";
    protected String FILTER_HAUL_TYPE = "HaulType";
    private String currentFlightNo;
    private FlightStateE currentFlightState;
    private PeriodComplete currentPeriod;
    private CustomerLight currentCustomer;
    private Boolean currentCheckoutState;
    private boolean onlyOpenFlights;
    private boolean ignoreCancelledFlights;
    private StowingListTemplateComplete currentStowingList;
    private List<Thread> works = new ArrayList<Thread>();
    private AtomicInteger targetThreadCount = new AtomicInteger();
    private AtomicInteger currentThreadCount = new AtomicInteger();
    private boolean isRunning;
    private RDProvider provider;
    private boolean inserted;
    private Boolean currentInvoiced;
    private boolean canUpdateInvoiced;
    private MultiSelectionPanel<MultiHaulTypeSelectionComboBox> haulPanel;
    private List<HaulTypeComplete> haulType;
    private Boolean haultypeActivated;

    public UpdateStowingListInsert(FlightToolsModule module, RDProvider provider) {
        super(module);
        this.provider = provider;
        this.canUpdateInvoiced = provider.isWritable(FlightToolsAccess.FLIGHT_UPDATE_INVOICED_FLIGHT);
        this.insertElements();
        this.hideAll();
    }

    public void hideAll() {
        this.updateFlightOnly = false;
        this.reloadStwFromFS = false;
        this.updateRCOnly = false;
        this.reloadSobData = false;
        this.reloadFlightData = false;
        this.setFlightsBackToOpen = false;
        this.revertTransactions = false;
        if (this.toAutoCheckout.getFader().isFaded()) {
            this.toAutoCheckout.fadeOut(false);
        }
        if (this.onlyPerformTransactions.getFader().isFaded()) {
            this.onlyPerformTransactions.fadeOut(false);
        }
        if (this.setInOutFixed.getFader().isFaded()) {
            this.setInOutFixed.fadeOut(false);
        }
        if (this.recalculateStowing.getFader().isFaded()) {
            this.recalculateStowing.fadeOut(false);
        }
        if (this.completeRC.getFader().isFaded()) {
            this.completeRC.fadeOut(false);
        }
        if (this.revalidateRC.getFader().isFaded()) {
            this.revalidateRC.fadeOut(false);
        }
        if (this.ignoreTransactions.getFader().isFaded()) {
            this.ignoreTransactions.fadeOut(false);
        }
        if (this.anonymous.getFader().isFaded()) {
            this.anonymous.fadeOut(false);
        }
        if (this.useDefaultStowingListAnyway.getFader().isFaded()) {
            this.useDefaultStowingListAnyway.fadeOut(false);
        }
        if (this.updateInvoiced != null && this.updateInvoiced.getFader().isFaded()) {
            this.updateInvoiced.fadeOut(false);
        }
        this.setEnabled(this.isEnabled());
    }

    public void showCalculateRetailinMotion() {
        this.hideAll();
        this.calculateRim = true;
    }

    public void showRevertTransaction() {
        this.updateFlightOnly = false;
        this.reloadStwFromFS = false;
        this.updateRCOnly = false;
        this.reloadSobData = false;
        this.reloadFlightData = false;
        this.setFlightsBackToOpen = false;
        this.revertTransactions = true;
        this.setEnabled(this.isEnabled());
    }

    public void showUpdateRCOnly() {
        this.updateFlightOnly = false;
        this.reloadStwFromFS = false;
        this.updateRCOnly = true;
        this.reloadSobData = false;
        this.reloadFlightData = false;
        this.setFlightsBackToOpen = false;
        this.revertTransactions = false;
        if (this.toAutoCheckout.getFader().isFaded()) {
            this.toAutoCheckout.fadeOut(false);
        }
        if (this.onlyPerformTransactions.getFader().isFaded()) {
            this.onlyPerformTransactions.fadeOut(false);
        }
        if (this.setInOutFixed.getFader().isFaded()) {
            this.setInOutFixed.fadeOut(false);
        }
        if (this.recalculateStowing.getFader().isFaded()) {
            this.recalculateStowing.fadeOut(false);
        }
        if (!this.completeRC.getFader().isFaded()) {
            this.completeRC.fadeIn();
        }
        if (!this.revalidateRC.getFader().isFaded()) {
            this.revalidateRC.fadeIn();
        }
        if (this.ignoreTransactions.getFader().isFaded()) {
            this.ignoreTransactions.fadeOut(false);
        }
        if (this.anonymous.getFader().isFaded()) {
            this.anonymous.fadeOut(false);
        }
        if (this.useDefaultStowingListAnyway.getFader().isFaded()) {
            this.useDefaultStowingListAnyway.fadeOut(false);
        }
        if (this.updateInvoiced != null && !this.updateInvoiced.getFader().isFaded()) {
            this.updateInvoiced.fadeIn();
        }
        this.setEnabled(this.isEnabled());
    }

    public void showUpdateFlightState() {
        this.updateFlightOnly = false;
        this.reloadStwFromFS = false;
        this.updateRCOnly = false;
        this.reloadSobData = false;
        this.reloadFlightData = false;
        this.setFlightsBackToOpen = true;
        this.revertTransactions = false;
        if (this.toAutoCheckout.getFader().isFaded()) {
            this.toAutoCheckout.fadeOut(false);
        }
        if (this.onlyPerformTransactions.getFader().isFaded()) {
            this.onlyPerformTransactions.fadeOut(false);
        }
        if (this.setInOutFixed.getFader().isFaded()) {
            this.setInOutFixed.fadeOut(false);
        }
        if (this.recalculateStowing.getFader().isFaded()) {
            this.recalculateStowing.fadeOut(false);
        }
        if (this.ignoreTransactions.getFader().isFaded()) {
            this.ignoreTransactions.fadeOut(false);
        }
        if (this.anonymous.getFader().isFaded()) {
            this.anonymous.fadeOut(false);
        }
        if (this.completeRC.getFader().isFaded()) {
            this.completeRC.fadeOut(false);
        }
        if (this.revalidateRC.getFader().isFaded()) {
            this.revalidateRC.fadeOut(false);
        }
        if (this.useDefaultStowingListAnyway.getFader().isFaded()) {
            this.useDefaultStowingListAnyway.fadeOut(false);
        }
        if (this.updateInvoiced != null && this.updateInvoiced.getFader().isFaded()) {
            this.updateInvoiced.fadeOut(false);
        }
        this.setEnabled(this.isEnabled());
    }

    public void showUpdateFlightOnly() {
        this.updateFlightOnly = true;
        this.reloadStwFromFS = false;
        this.updateRCOnly = false;
        this.reloadSobData = false;
        this.reloadFlightData = false;
        this.setFlightsBackToOpen = false;
        this.revertTransactions = false;
        if (!this.toAutoCheckout.getFader().isFaded()) {
            this.toAutoCheckout.fadeIn();
        }
        if (!this.onlyPerformTransactions.getFader().isFaded()) {
            this.onlyPerformTransactions.fadeIn();
        }
        if (!this.setInOutFixed.getFader().isFaded()) {
            this.setInOutFixed.fadeIn();
        }
        if (!this.recalculateStowing.getFader().isFaded()) {
            this.recalculateStowing.fadeIn();
        }
        if (!this.ignoreTransactions.getFader().isFaded()) {
            this.ignoreTransactions.fadeIn();
        }
        if (!this.anonymous.getFader().isFaded()) {
            this.anonymous.fadeIn();
        }
        if (this.completeRC.getFader().isFaded()) {
            this.completeRC.fadeOut(false);
        }
        if (this.revalidateRC.getFader().isFaded()) {
            this.revalidateRC.fadeOut(false);
        }
        if (this.useDefaultStowingListAnyway.getFader().isFaded()) {
            this.useDefaultStowingListAnyway.fadeOut(false);
        }
        if (this.updateInvoiced != null && !this.updateInvoiced.getFader().isFaded()) {
            this.updateInvoiced.fadeIn();
        }
        this.setEnabled(this.isEnabled());
    }

    public void showSendSobData() {
        this.updateFlightOnly = false;
        this.reloadStwFromFS = false;
        this.updateRCOnly = false;
        this.reloadSobData = true;
        this.reloadFlightData = false;
        this.setFlightsBackToOpen = false;
        this.revertTransactions = false;
        if (this.toAutoCheckout.getFader().isFaded()) {
            this.toAutoCheckout.fadeOut(false);
        }
        if (this.onlyPerformTransactions.getFader().isFaded()) {
            this.onlyPerformTransactions.fadeOut(false);
        }
        if (this.setInOutFixed.getFader().isFaded()) {
            this.setInOutFixed.fadeOut(false);
        }
        if (this.recalculateStowing.getFader().isFaded()) {
            this.recalculateStowing.fadeOut(false);
        }
        if (this.ignoreTransactions.getFader().isFaded()) {
            this.ignoreTransactions.fadeOut(false);
        }
        if (this.anonymous.getFader().isFaded()) {
            this.anonymous.fadeOut(false);
        }
        if (this.completeRC.getFader().isFaded()) {
            this.completeRC.fadeOut(false);
        }
        if (this.revalidateRC.getFader().isFaded()) {
            this.revalidateRC.fadeOut(false);
        }
        if (this.useDefaultStowingListAnyway.getFader().isFaded()) {
            this.useDefaultStowingListAnyway.fadeOut(false);
        }
        if (this.updateInvoiced != null && this.updateInvoiced.getFader().isFaded()) {
            this.updateInvoiced.fadeOut(false);
        }
        this.setEnabled(this.isEnabled());
    }

    public void showUpdateFlightData() {
        this.updateFlightOnly = false;
        this.reloadStwFromFS = false;
        this.updateRCOnly = false;
        this.reloadSobData = false;
        this.reloadFlightData = true;
        this.setFlightsBackToOpen = false;
        this.revertTransactions = false;
        if (this.toAutoCheckout.getFader().isFaded()) {
            this.toAutoCheckout.fadeOut(false);
        }
        if (this.onlyPerformTransactions.getFader().isFaded()) {
            this.onlyPerformTransactions.fadeOut(false);
        }
        if (this.setInOutFixed.getFader().isFaded()) {
            this.setInOutFixed.fadeOut(false);
        }
        if (this.recalculateStowing.getFader().isFaded()) {
            this.recalculateStowing.fadeOut(false);
        }
        if (this.ignoreTransactions.getFader().isFaded()) {
            this.ignoreTransactions.fadeOut(false);
        }
        if (this.anonymous.getFader().isFaded()) {
            this.anonymous.fadeOut(false);
        }
        if (this.completeRC.getFader().isFaded()) {
            this.completeRC.fadeOut(false);
        }
        if (this.revalidateRC.getFader().isFaded()) {
            this.revalidateRC.fadeOut(false);
        }
        if (this.useDefaultStowingListAnyway.getFader().isFaded()) {
            this.useDefaultStowingListAnyway.fadeOut(false);
        }
        if (this.updateInvoiced != null && this.updateInvoiced.getFader().isFaded()) {
            this.updateInvoiced.fadeOut(false);
        }
        this.setEnabled(this.isEnabled());
    }

    public void showReload() {
        this.updateFlightOnly = false;
        this.reloadStwFromFS = true;
        this.updateRCOnly = false;
        this.reloadSobData = false;
        this.reloadFlightData = false;
        this.setFlightsBackToOpen = false;
        this.revertTransactions = false;
        if (this.toAutoCheckout.getFader().isFaded()) {
            this.toAutoCheckout.fadeOut(false);
        }
        if (this.onlyPerformTransactions.getFader().isFaded()) {
            this.onlyPerformTransactions.fadeOut(false);
        }
        if (this.setInOutFixed.getFader().isFaded()) {
            this.setInOutFixed.fadeOut(false);
        }
        if (this.recalculateStowing.getFader().isFaded()) {
            this.recalculateStowing.fadeOut(false);
        }
        if (this.ignoreTransactions.getFader().isFaded()) {
            this.ignoreTransactions.fadeOut(false);
        }
        if (this.anonymous.getFader().isFaded()) {
            this.anonymous.fadeOut(false);
        }
        if (this.completeRC.getFader().isFaded()) {
            this.completeRC.fadeOut(false);
        }
        if (this.revalidateRC.getFader().isFaded()) {
            this.revalidateRC.fadeOut(false);
        }
        if (!this.useDefaultStowingListAnyway.getFader().isFaded()) {
            this.useDefaultStowingListAnyway.fadeIn();
        }
        if (this.updateInvoiced != null && !this.updateInvoiced.getFader().isFaded()) {
            this.updateInvoiced.fadeIn();
        }
        this.setEnabled(this.isEnabled());
    }

    private Runnable getNextRunnable() {
        if (!this.isRunning) {
            return null;
        }
        try {
            if (this.queueTable.getRowCount() > 0) {
                for (int c = 0; c < this.queueTable.getRowCount(); ++c) {
                    QueuedTableRow qr = (QueuedTableRow)this.queueTable.getRowAt(c);
                    if (qr.getModel().getNode().getChildNamed(DtoFieldConstants.ON_RUNNING) != null) continue;
                    qr.setEnabled(false);
                    Node n = qr.getModel().getNode().getChildNamed(DtoFieldConstants.ON_RUNNING);
                    if (n == null) {
                        n = new ViewNode(DtoFieldConstants.ON_RUNNING.getFieldName());
                        n.setName(DtoFieldConstants.ON_RUNNING);
                        n.setPermanent(true);
                        qr.getModel().getNode().addChild(n, 0L);
                    }
                    return qr.getRunnable();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void addThread() {
        this.targetThreadCount.incrementAndGet();
        Thread t = new Thread(() -> {
            try {
                while (this.isRunning) {
                    Runnable r = this.getNextRunnable();
                    while (r != null) {
                        r.run();
                        if (this.targetThreadCount.get() < this.currentThreadCount.get()) {
                            r = null;
                            this.currentThreadCount.decrementAndGet();
                            continue;
                        }
                        r = this.getNextRunnable();
                    }
                }
                this.currentThreadCount.decrementAndGet();
                throw new IllegalStateException("Stowing Update stopped (State change to not running)");
            }
            catch (Throwable e) {
                e.printStackTrace();
                if (e instanceof Exception) {
                    SwingUtilities.invokeLater(() -> InnerPopupFactory.showErrorDialog((Exception)e, "Error occurred while updating Stowing List", (Component)this));
                }
                return;
            }
        });
        t.start();
        this.currentThreadCount.incrementAndGet();
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.start) {
            if (!this.ensureReportSelected()) {
                return;
            }
            this.isRunning = true;
            this.addThread();
        } else if (source == this.stop) {
            this.isRunning = false;
        } else if (source == this.addAllOnSiteButton) {
            for (Table2RowPanel p : this.searchTable.getRows()) {
                SearchTableRow sr = (SearchTableRow)p;
                sr.buttonPressed(sr.move, 0, 0);
            }
        } else if (source == this.addAllButton) {
            this.searchTable.showLoadingAnimation("Read Flights");
            this.setEnabled(false);
            ThreadSafeExecutable run = new ThreadSafeExecutable(){

                @Override
                public Node<?> loadData() throws Exception {
                    FlightSearchConfiguration config = (FlightSearchConfiguration)UpdateStowingListInsert.this.searchTable.filterValueChanged(null, null);
                    config.setPageNumber(0);
                    SearchResultIterator fsi = new SearchResultIterator((ASearchConfiguration)config);
                    for (FlightLight f : fsi) {
                        Node fn = INodeCreator.getDefaultImpl().getNode4DTO((Object)f, false, true);
                        UpdateStowingListInsert.this.queueTable.getModel().getNode().addChild(fn, 0L);
                    }
                    return null;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            if (UpdateStowingListInsert.this.searchTable != null) {
                                UpdateStowingListInsert.this.searchTable.hideLoadingAnimation();
                            }
                            UpdateStowingListInsert.this.setEnabled(true);
                        }

                        public void errorOccurred(ClientException exception) {
                            ArrayList<ClientException> el = new ArrayList<ClientException>();
                            el.add(exception);
                            InnerPopupFactory.showScreenValidationPopup(ScreenValidationObject.convertList(el), "Unable to read in Flights", UpdateStowingListInsert.this);
                            if (UpdateStowingListInsert.this.searchTable != null) {
                                UpdateStowingListInsert.this.searchTable.hideLoadingAnimation();
                            }
                            UpdateStowingListInsert.this.setEnabled(true);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        } else if (source == this.getTemplate) {
            this.setEnabled(false);
            try {
                File f = this.downloadFile();
                if (f == null) {
                    InnerPopupFactory.showErrorDialog("No template ready. Please contact support.", (Component)this);
                }
                this.setEnabled(true);
                Desktop.getDesktop().open(f);
            }
            catch (IOException e) {
                InnerPopupFactory.showErrorDialog(e, (Component)this);
            }
            this.setEnabled(true);
        } else if (source == this.readInFlights) {
            this.searchTable.showLoadingAnimation("Read Flights");
            this.setEnabled(false);
            ThreadSafeExecutable run = new ThreadSafeExecutable(){

                @Override
                public Node<?> loadData() throws Exception {
                    List<ExcelRow> rows = FileToolkit.getRows(UpdateStowingListInsert.this);
                    if (rows != null) {
                        for (ExcelRow r : rows) {
                            Date selectedDate = (Date)r.getCells().get(0);
                            String selectedCode = (String)r.getCells().get(1);
                            FlightSearchConfiguration config = new FlightSearchConfiguration();
                            config.setDayPeriod(new PeriodComplete(new java.sql.Date(selectedDate.getTime()), new java.sql.Date(selectedDate.getTime())));
                            config.setFlightStdSta(FlightSearchConfiguration.FLIGHT_STD_STA.stdOnly);
                            config.setFlightNumber(selectedCode);
                            config.setOnlyOpenFlights(Boolean.valueOf(true));
                            SearchResultIterator fsi = new SearchResultIterator((ASearchConfiguration)config);
                            for (FlightLight f : fsi) {
                                Node fn = INodeCreator.getDefaultImpl().getNode4DTO((Object)f, false, true);
                                UpdateStowingListInsert.this.queueTable.getModel().getNode().addChild(fn, 0L);
                            }
                        }
                    }
                    return null;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            UpdateStowingListInsert.this.searchTable.hideLoadingAnimation();
                            UpdateStowingListInsert.this.setEnabled(true);
                        }

                        public void errorOccurred(ClientException exception) {
                            ArrayList<ClientException> el = new ArrayList<ClientException>();
                            el.add(exception);
                            InnerPopupFactory.showScreenValidationPopup(ScreenValidationObject.convertList(el), "Unable to read in Flights", UpdateStowingListInsert.this);
                            UpdateStowingListInsert.this.searchTable.hideLoadingAnimation();
                            UpdateStowingListInsert.this.setEnabled(true);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        } else {
            this.setEnabled(this.isEnabled());
        }
    }

    private File downloadFile() throws IOException {
        File tempFile = File.createTempFile("ImporterFile_", ".xlsx");
        URL url = this.createURL();
        if (url == null) {
            return null;
        }
        FileUtils.copyURLToFile((URL)url, (File)tempFile);
        return tempFile;
    }

    private URL createURL() throws MalformedURLException {
        return ImporterItemView.class.getResource("/importtemplates/FlightTools.xlsx");
    }

    private boolean ensureReportSelected() {
        if (this.calculateRim || this.updateFlightOnly || this.reloadStwFromFS || this.updateRCOnly || this.reloadSobData || this.reloadFlightData || this.setFlightsBackToOpen || this.revertTransactions) {
            return true;
        }
        InnerPopupFactory.showErrorDialog("Please select Update Type first (Combo Box on the upper left corner)", (Component)this);
        return false;
    }

    @Override
    public void insertElements() {
        if (this.inserted) {
            return;
        }
        this.setLayout(new Layout());
        this.createThreadControl();
        this.createSearchTable();
        this.createQueueTable();
        this.createFinishTable();
        this.inserted = true;
    }

    private void createThreadControl() {
        this.setLayout(new Layout());
        this.start = new TextButton("Start");
        this.stop = new TextButton("Stop");
        this.start.addButtonListener(this);
        this.stop.addButtonListener(this);
        this.toAutoCheckout = new TitledItem<CheckBox>(new CheckBox(), "Ensure Auto Checkout is active", TitledItem.TitledItemOrientation.EAST);
        this.onlyPerformTransactions = new TitledItem<CheckBox>(new CheckBox(), "Only Transaction Update", TitledItem.TitledItemOrientation.EAST);
        this.setInOutFixed = new TitledItem<CheckBox>(new CheckBox(), "Disable regular Transaction (only IR allowed)", TitledItem.TitledItemOrientation.EAST);
        this.recalculateStowing = new TitledItem<CheckBox>(new CheckBox(), Words.RECALCULATE_STOWING_LIST, TitledItem.TitledItemOrientation.EAST);
        this.useDefaultStowingListAnyway = new TitledItem<CheckBox>(new CheckBox(), Words.USE_DEFAULT_STOWING_LIST_ANYWAY, TitledItem.TitledItemOrientation.EAST);
        this.completeRC = new TitledItem<CheckBox>(new CheckBox(), "Complete RC", TitledItem.TitledItemOrientation.EAST);
        this.revalidateRC = new TitledItem<CheckBox>(new CheckBox(), "Revalidate RC", TitledItem.TitledItemOrientation.EAST);
        this.ignoreTransactions = new TitledItem<CheckBox>(new CheckBox(), Words.IGNORE_TRANSACTIONS, TitledItem.TitledItemOrientation.EAST);
        this.anonymous = new TitledItem<CheckBox>(new CheckBox(), Words.ANONYMOUS, TitledItem.TitledItemOrientation.EAST);
        if (this.canUpdateInvoiced) {
            this.updateInvoiced = new TitledItem<CheckBox>(new CheckBox(), Words.UPDATE_INVOICED, TitledItem.TitledItemOrientation.EAST);
            this.updateInvoiced.getFader().setPermanent(true);
            this.add(this.updateInvoiced);
        }
        this.toAutoCheckout.getFader().setPermanent(true);
        this.onlyPerformTransactions.getFader().setPermanent(true);
        this.setInOutFixed.getFader().setPermanent(true);
        this.recalculateStowing.getFader().setPermanent(true);
        this.useDefaultStowingListAnyway.getFader().setPermanent(true);
        this.completeRC.getFader().setPermanent(true);
        this.revalidateRC.getFader().setPermanent(true);
        this.ignoreTransactions.getFader().setPermanent(true);
        this.anonymous.getFader().setPermanent(true);
        this.add(this.start);
        this.add(this.stop);
        this.add(this.toAutoCheckout);
        this.add(this.onlyPerformTransactions);
        this.add(this.setInOutFixed);
        this.add(this.ignoreTransactions);
        this.add(this.anonymous);
        this.add(this.recalculateStowing);
        this.add(this.useDefaultStowingListAnyway);
        this.add(this.completeRC);
        this.add(this.revalidateRC);
        this.setEnabled(this.isEnabled());
    }

    private void createQueueTable() {
        this.queueTable = new Table2(false, "", true, true, "Queue");
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        int tw = TableColumnInfo.dateTimeColumnWidth + 2 * this.queueTable.getCellPadding();
        columns.add(new TableColumnInfo(Words.STATE, null, null, null, "", 108, 108, 108));
        columns.add(new TableColumnInfo(Words.OUTBOUND, null, null, null, "", 180, 180, 180));
        columns.add(new TableColumnInfo(Words.STD, null, null, null, "", tw, tw, tw));
        columns.add(new TableColumnInfo(Words.STOWING, null, null, null, "", 120, 120, 120));
        columns.add(new TableColumnInfo(Words.RC, null, null, null, "", 60, 60, 60));
        tw = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + 2 * this.searchTable.getCellPadding();
        columns.add(new TableColumnInfo(Words.AUTO_CHECKOUT_SHORT, null, null, null, "", tw, tw, tw));
        tw = ArrowButton.getPreferredWidth() + 2 * this.queueTable.getCellPadding();
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(5)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(6)).setxExpand(0.0);
        this.queueTable.setModel(new Table2Model(columns, model -> new QueuedTableRow(model, Table2RowPanel.TableControlsType.ONE)));
        this.queueTable.getModel().setNode((Node)new ViewNode("Queue"));
        this.queueTable.setSortedColumn(0);
        this.add(this.queueTable);
    }

    private void createFinishTable() {
        this.finishedTable = new Table2(false, "", true, true, "Updated Flights");
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        int tw = TableColumnInfo.dateTimeColumnWidth + 2 * this.finishedTable.getCellPadding();
        columns.add(new TableColumnInfo(Words.STATE, null, null, null, "", 108, 108, 108));
        columns.add(new TableColumnInfo(Words.OUTBOUND, null, null, null, "", 180, 180, 180));
        columns.add(new TableColumnInfo(Words.STD, null, null, null, "", tw, tw, tw));
        columns.add(new TableColumnInfo(Words.STOWING, null, null, null, "", 120, 120, 120));
        columns.add(new TableColumnInfo(Words.RC, null, null, null, "", 60, 60, 60));
        tw = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + 2 * this.searchTable.getCellPadding();
        columns.add(new TableColumnInfo(Words.AUTO_CHECKOUT_SHORT, null, null, null, "", tw, tw, tw));
        tw = ArrowButton.getPreferredWidth() + 2 * this.finishedTable.getCellPadding();
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(5)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(6)).setxExpand(0.0);
        this.finishedTable.setModel(new Table2Model(columns, model -> new FinishRow(model, Table2RowPanel.TableControlsType.ONE)));
        this.finishedTable.getModel().setNode((Node)new ViewNode("Finished"));
        this.finishedTable.setSortedColumn(0);
        this.add(this.finishedTable);
    }

    private void createSearchTable() {
        this.searchTable = new PageableTable2("Search Flights", true, true, true){

            @Override
            public SearchAlgorithm getSearchAlgorithm() {
                return SearchAlgorithmRegistry.getSearchAlgorithm(FlightSearchAlgorithm.class);
            }

            @Override
            public ASearchConfiguration<? extends ADTO, ? extends Enum<?>> filterValueChanged(String id, Object value) {
                if (UpdateStowingListInsert.this.FILTER_SEARCH_FLIGHT_NUMBER.equals(id)) {
                    UpdateStowingListInsert.this.currentFlightNo = (String)value;
                } else if (UpdateStowingListInsert.this.FILTER_STATE.equals(id)) {
                    if (value instanceof FlightStateE) {
                        UpdateStowingListInsert.this.currentFlightState = (FlightStateE)value;
                        UpdateStowingListInsert.this.onlyOpenFlights = false;
                        UpdateStowingListInsert.this.ignoreCancelledFlights = false;
                    } else if (value instanceof String) {
                        if (Words.ALL.equals(value)) {
                            UpdateStowingListInsert.this.currentFlightState = null;
                            UpdateStowingListInsert.this.onlyOpenFlights = false;
                            UpdateStowingListInsert.this.ignoreCancelledFlights = false;
                        } else if (Words.ALL_EXCEPT_PLANNED.equals(value)) {
                            UpdateStowingListInsert.this.currentFlightState = null;
                            UpdateStowingListInsert.this.onlyOpenFlights = true;
                            UpdateStowingListInsert.this.ignoreCancelledFlights = false;
                        } else if (Words.ALL_EXCEPT_PLANNED_AND_CANCELLED.equals(value)) {
                            UpdateStowingListInsert.this.currentFlightState = null;
                            UpdateStowingListInsert.this.onlyOpenFlights = true;
                            UpdateStowingListInsert.this.ignoreCancelledFlights = true;
                        }
                    }
                } else if (UpdateStowingListInsert.this.FILTER_PERIOD.equals(id)) {
                    if (value instanceof TitledPeriodEditor) {
                        UpdateStowingListInsert.this.currentPeriod = new PeriodComplete(((TitledPeriodEditor)value).getStartDate(), ((TitledPeriodEditor)value).getEndDate());
                    } else if (value instanceof PeriodComplete) {
                        UpdateStowingListInsert.this.currentPeriod = (PeriodComplete)value;
                    }
                } else if (UpdateStowingListInsert.this.FILTER_CUSTOMER.equals(id)) {
                    if (value instanceof CustomerLight) {
                        UpdateStowingListInsert.this.currentCustomer = (CustomerLight)value;
                    } else if (value instanceof Node) {
                        UpdateStowingListInsert.this.currentCustomer = (CustomerLight)((Node)value).getValue();
                    }
                } else if (UpdateStowingListInsert.this.FILTER_CHECKOUT.equals(id)) {
                    if (value instanceof String) {
                        Object[] t = (Object[])value;
                        if (t.equals(Words.ALL)) {
                            UpdateStowingListInsert.this.currentCheckoutState = null;
                        } else if (t.equals(Words.YES)) {
                            UpdateStowingListInsert.this.currentCheckoutState = true;
                        } else if (t.equals(Words.NO_ANSWER)) {
                            UpdateStowingListInsert.this.currentCheckoutState = false;
                        }
                    }
                } else if (UpdateStowingListInsert.this.FILTER_STOWING_LIST.equals(id)) {
                    if (value instanceof StowingListTemplateComplete) {
                        UpdateStowingListInsert.this.currentStowingList = (StowingListTemplateComplete)value;
                    } else {
                        UpdateStowingListInsert.this.currentStowingList = null;
                    }
                } else if (UpdateStowingListInsert.this.FILTER_INVOICED.equals(id)) {
                    if (value instanceof Boolean) {
                        UpdateStowingListInsert.this.currentInvoiced = (Boolean)value;
                    }
                } else if (UpdateStowingListInsert.this.FILTER_NOT_INVOICED.equals(id)) {
                    if (value instanceof Boolean) {
                        UpdateStowingListInsert.this.currentInvoiced = (Boolean)value == false;
                    }
                } else if (UpdateStowingListInsert.this.FILTER_HAUL_TYPE.equals(id)) {
                    if (value instanceof Object[]) {
                        UpdateStowingListInsert.this.haulType = new ArrayList();
                        for (Object a : (Object[])value) {
                            UpdateStowingListInsert.this.haulType.add((HaulTypeComplete)a);
                        }
                    } else if (value instanceof Boolean) {
                        UpdateStowingListInsert.this.haultypeActivated = (Boolean)value;
                    } else {
                        UpdateStowingListInsert.this.haulType = null;
                    }
                }
                FlightSearchConfiguration c = new FlightSearchConfiguration();
                c.setFlightNumber(UpdateStowingListInsert.this.currentFlightNo);
                c.setFlightState(UpdateStowingListInsert.this.currentFlightState);
                c.setOnlyOpenFlights(Boolean.valueOf(UpdateStowingListInsert.this.onlyOpenFlights));
                c.setIgnoreCancelledFlights(Boolean.valueOf(UpdateStowingListInsert.this.ignoreCancelledFlights));
                c.setStowingListTemplate((StowingListTemplateReference)UpdateStowingListInsert.this.currentStowingList);
                c.setIsInvoiced(UpdateStowingListInsert.this.currentInvoiced);
                c.setHaulTypeList(UpdateStowingListInsert.this.haulType);
                c.setShowNullHaulTypes(UpdateStowingListInsert.this.haultypeActivated);
                if (UpdateStowingListInsert.this.currentPeriod != null) {
                    c.setDayPeriod(new PeriodComplete(UpdateStowingListInsert.this.currentPeriod.getStartDate(), UpdateStowingListInsert.this.currentPeriod.getEndDate()));
                } else {
                    c.setDayPeriod(new PeriodComplete(new java.sql.Date(System.currentTimeMillis()), new java.sql.Date(System.currentTimeMillis())));
                }
                c.setCustomer(UpdateStowingListInsert.this.currentCustomer);
                c.setAutoCheckout(UpdateStowingListInsert.this.currentCheckoutState);
                c.setPageNumber(this.pagination.getCurrentPage() - 1);
                if (c.getPageNumber() < 0) {
                    c.setPageNumber(0);
                }
                return c;
            }

            @Override
            public void fillFilterChain() {
                UpdateStowingListInsert.this.stateCombo = ComboBoxFactory.getFlightStateComboBox(true);
                ComboBox checkoutCombo = new ComboBox();
                checkoutCombo.addItem(Words.ALL);
                checkoutCombo.addItem(Words.YES);
                checkoutCombo.addItem(Words.NO_ANSWER);
                this.filterChain.addSeachField(UpdateStowingListInsert.this.FILTER_SEARCH_FLIGHT_NUMBER, Words.FLIGHT_NUMBER);
                this.filterChain.addSelectionCombo(UpdateStowingListInsert.this.FILTER_STATE, Words.STATE, UpdateStowingListInsert.this.stateCombo);
                this.filterChain.addSelectionCombo(UpdateStowingListInsert.this.FILTER_CHECKOUT, Words.AUTO_CHECKOUT_FLIGHT, checkoutCombo);
                this.filterChain.addCheckBox(UpdateStowingListInsert.this.FILTER_INVOICED, Words.INVOICED_ONLY, false);
                this.filterChain.addCheckBox(UpdateStowingListInsert.this.FILTER_NOT_INVOICED, Words.NOT_INVOICED_ONLY, false);
                PeriodComplete p = FilterChainConfiguration.getDefaultSearchPeriod();
                UpdateStowingListInsert.this.periodeditor = this.filterChain.addPeriodSelection(UpdateStowingListInsert.this.FILTER_PERIOD, p.getStartDate(), p.getEndDate(), "", true);
                UpdateStowingListInsert.this.periodeditor.setCommitOnFocusLost(true);
                this.filterChain.addCustomerSearchField(UpdateStowingListInsert.this.FILTER_CUSTOMER);
                this.filterChain.addStowingListTemplateField(UpdateStowingListInsert.this.FILTER_STOWING_LIST);
                MultiHaulTypeSelectionComboBox haulCombo = new MultiHaulTypeSelectionComboBox(INodeCreator.getDefaultImpl().createNodes(new ArrayList(), false));
                UpdateStowingListInsert.this.haulPanel = new MultiSelectionPanel<MultiHaulTypeSelectionComboBox>(haulCombo);
                UpdateStowingListInsert.this.haulPanel.setShouldPersist(true);
                this.filterChain.addMultiSelection(UpdateStowingListInsert.this.haulPanel, UpdateStowingListInsert.this.FILTER_HAUL_TYPE, Words.HAUL_TYPE);
                this.filterChain.addSearchButton();
            }
        };
        this.searchTable.setTitleText("Search Flights");
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        int tw = TableColumnInfo.dateTimeColumnWidth + 2 * this.searchTable.getCellPadding();
        columns.add(new TableColumnInfo(Words.STATE, null, null, null, "", 108, 108, 108));
        columns.add(new TableColumnInfo(Words.OUTBOUND, null, null, null, "", 180, 180, 180));
        columns.add(new TableColumnInfo(Words.STD, null, null, null, "", tw, tw, tw));
        columns.add(new TableColumnInfo(Words.STOWING, null, null, null, "", 120, 120, 120));
        columns.add(new TableColumnInfo(Words.RC, null, null, null, "", 60, 60, 60));
        tw = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + 2 * this.searchTable.getCellPadding();
        columns.add(new TableColumnInfo(Words.AUTO_CHECKOUT_SHORT, null, null, null, "", tw, tw, tw));
        tw = ArrowButton.getPreferredWidth() + 2 * this.searchTable.getCellPadding();
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(5)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(6)).setxExpand(0.0);
        this.searchTable.setModel(new Table2Model(columns, model -> new SearchTableRow(model, Table2RowPanel.TableControlsType.ONE)));
        this.addAllOnSiteButton = new TextButton("Add shown Flights");
        this.addAllOnSiteButton.addButtonListener(this);
        this.searchTable.addFooterButton(this.addAllOnSiteButton);
        this.addAllButton = new TextButton("Add ALL Flights");
        this.addAllButton.addButtonListener(this);
        this.searchTable.addFooterButtonSecond(this.addAllButton);
        this.readInFlights = new TextButton("Read Flight from Excel");
        this.readInFlights.addButtonListener(this);
        this.searchTable.addFooterButtonThird(this.readInFlights);
        this.getTemplate = new TextButton("Download Template");
        this.getTemplate.addButtonListener(this);
        this.searchTable.addFooterButtonFourth(this.getTemplate);
        this.searchTable.getModel().setNode((Node)new ViewNode("Flights"));
        this.searchTable.setSortedColumn(0);
        this.add(this.searchTable);
        this.searchTable.invokeDefaultSearch();
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                StaticEnumServiceManager.getAllFlightStateE();
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(PaxFigureTypeComplete.class);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(HaulTypeComplete.class);
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return UpdateStowingListInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.searchTable != null) {
            this.toAutoCheckout.setEnabled(isEnabled && this.provider.isWritable("flightupdate_flightonly_autocheckout") && this.updateFlightOnly);
            this.onlyPerformTransactions.setEnabled(isEnabled && this.provider.isWritable("flightupdate_flightonly_transactions") && this.updateFlightOnly);
            this.setInOutFixed.setEnabled(isEnabled && this.provider.isWritable("flightupdate_flightonly_transactions") && this.updateFlightOnly);
            this.recalculateStowing.setEnabled(isEnabled && this.provider.isWritable("flightupdate_flightonly_forcerecalculate") && this.updateFlightOnly);
            this.ignoreTransactions.setEnabled(isEnabled && this.provider.isWritable(FlightToolsAccess.FLIGHT_UPDATE_FLIGHT_ONLY_IGNORE_TRANSACTIONS) && this.updateFlightOnly);
            this.anonymous.setEnabled(isEnabled && this.provider.isWritable(FlightToolsAccess.FLIGHT_UPDATE_FLIGHT_ONLY_ANONYMOUS) && this.updateFlightOnly);
            this.completeRC.setEnabled(isEnabled && this.provider.isWritable("flightupdate_rconly_complete") && this.updateRCOnly);
            this.revalidateRC.setEnabled(isEnabled && this.provider.isWritable("flightupdate_rconly_revalidate") && this.updateRCOnly);
            this.useDefaultStowingListAnyway.setEnabled(isEnabled && this.provider.isWritable("flightupdate_stw_use_default") && this.reloadStwFromFS);
            boolean ss = this.calculateRim || this.updateFlightOnly || this.updateRCOnly || this.reloadStwFromFS || this.reloadFlightData || this.reloadSobData || this.setFlightsBackToOpen || this.revertTransactions;
            this.start.setEnabled(isEnabled && ss);
            this.stop.setEnabled(isEnabled && ss);
            if (this.updateInvoiced != null) {
                this.updateInvoiced.setEnabled(isEnabled);
            }
            this.searchTable.setEnabled(isEnabled);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.useDefaultStowingListAnyway.kill();
        this.recalculateStowing.kill();
        this.completeRC.kill();
        this.revalidateRC.kill();
        this.start.kill();
        this.stop.kill();
        this.addAllOnSiteButton.kill();
        this.readInFlights.kill();
        this.getTemplate.kill();
        this.searchTable.kill();
        this.queueTable.kill();
        this.finishedTable.kill();
        this.toAutoCheckout.kill();
        this.onlyPerformTransactions.kill();
        this.setInOutFixed.kill();
        this.addAllButton.kill();
        this.ignoreTransactions.kill();
        this.anonymous.kill();
        if (this.updateInvoiced != null) {
            this.updateInvoiced.kill();
        }
        this.recalculateStowing = null;
        this.completeRC = null;
        this.revalidateRC = null;
        this.useDefaultStowingListAnyway = null;
        this.start = null;
        this.stop = null;
        this.addAllOnSiteButton = null;
        this.readInFlights = null;
        this.getTemplate = null;
        this.searchTable = null;
        this.queueTable = null;
        this.finishedTable = null;
        this.toAutoCheckout = null;
        this.onlyPerformTransactions = null;
        this.setInOutFixed = null;
        this.addAllButton = null;
        this.ignoreTransactions = null;
        this.anonymous = null;
        this.updateInvoiced = null;
    }

    @Override
    public Node getNode() {
        return null;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        return null;
    }

    @Override
    public String getInsertName() {
        return "Stowing List Update";
    }

    private abstract class TableRowImplDef
    extends Table2RowPanel {
        private static final long serialVersionUID = 1L;
        private CellViewFlightStateERenderer state;
        private TextLabel outBound;
        private TextLabel std;
        private TextLabel stowing;
        private CellViewReturnsCountStateERenderer stateRenderer;
        private CellViewBooleanRenderer booleanRenderer;

        public TableRowImplDef(Table2RowModel m) {
            super(m);
            this.state = new CellViewFlightStateERenderer((FlightLight)m.getNode().getValue());
            this.outBound = new TextLabel(m.getNode().getChildNamed(FlightLight_.outboundCode));
            this.std = new TextLabel(m.getNode().getChildNamed(FlightLight_.std), ConverterRegistry.getConverter(DateTimeConverter.class));
            this.stowing = new TextLabel(m.getNode().getChildNamed(new DtoField[]{FlightLight_.activeStowingList, StowingListLight_.name}));
            this.booleanRenderer = new CellViewBooleanRenderer(Boolean.TRUE.equals(m.getNode().getChildNamed(FlightLight_.autoCheckout).getValue()), true);
            this.stateRenderer = new CellViewReturnsCountStateERenderer((ReturnsCountStateE)m.getNode().getChildNamed(FlightLight_.returnsCountState).getValue(), (FlightLight)m.getNode().getValue());
            this.createLatestItem();
            this.setLayout(new Layout());
            this.add(this.state);
            this.add(this.outBound);
            this.add(this.booleanRenderer);
            this.add(this.std);
            this.add(this.stowing);
            this.add(this.stateRenderer);
            this.add(this.getLatestItem());
        }

        public void setTextColor(Color color) {
            this.outBound.setForeground(color);
            this.std.setForeground(color);
            this.stowing.setForeground(color);
        }

        public abstract void createLatestItem();

        public abstract JComponent getLatestItem();

        @Override
        public List<Component> getFocusComponents() {
            return null;
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.model.getNode().getChildNamed(FlightLight_.flightState).getValue();
                }
                case 1: {
                    return this.model.getNode().getChildNamed(FlightLight_.outboundCode).getValue();
                }
                case 2: {
                    return this.model.getNode().getChildNamed(FlightLight_.std).getValue();
                }
                case 3: {
                    return this.model.getNode().getChildNamed(new DtoField[]{FlightLight_.activeStowingList, StowingListLight_.name}).getValue();
                }
                case 4: {
                    return this.model.getNode().getChildNamed(FlightLight_.returnsCountState).getValue();
                }
                case 5: {
                    return this.model.getNode().getChildNamed(FlightLight_.autoCheckout).getValue();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            if (this.isKilled()) {
                return;
            }
            boolean b = isEnabled && this.getModel().getNode().getChildNamed(DtoFieldConstants.ON_RUNNING) == null;
            super.setEnabled(b);
            this.state.setEnabled(b);
            this.outBound.setEnabled(b);
            this.std.setEnabled(b);
            this.stowing.setEnabled(b);
            this.booleanRenderer.setEnabled(b);
            this.stateRenderer.setEnabled(b);
            this.getLatestItem().setEnabled(b);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            if (this.state == null) {
                return;
            }
            this.state.kill();
            this.state = null;
            this.outBound.kill();
            this.outBound = null;
            this.std.kill();
            this.std = null;
            this.stowing.kill();
            this.stowing = null;
            this.booleanRenderer.kill();
            this.booleanRenderer = null;
            this.stateRenderer.kill();
            this.stateRenderer = null;
            if (this.getLatestItem() instanceof Killable) {
                ((Killable)((Object)this.getLatestItem())).kill();
            }
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImplDef.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImplDef.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                TableRowImplDef.this.state.setLocation(currentX + TableRowImplDef.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImplDef.this.state.getPreferredSize().getHeight()) / 2.0));
                TableRowImplDef.this.state.setSize(w - 2 * TableRowImplDef.this.getCellPadding(), (int)TableRowImplDef.this.state.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImplDef.this.model.getParentModel().getColumnWidth(1);
                TableRowImplDef.this.outBound.setLocation(currentX + TableRowImplDef.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImplDef.this.outBound.getPreferredSize().getHeight()) / 2.0));
                TableRowImplDef.this.outBound.setSize(w - 2 * TableRowImplDef.this.getCellPadding(), (int)TableRowImplDef.this.outBound.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImplDef.this.model.getParentModel().getColumnWidth(2);
                TableRowImplDef.this.std.setLocation(currentX + TableRowImplDef.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImplDef.this.std.getPreferredSize().getHeight()) / 2.0));
                TableRowImplDef.this.std.setSize(w - 2 * TableRowImplDef.this.getCellPadding(), (int)TableRowImplDef.this.std.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImplDef.this.model.getParentModel().getColumnWidth(3);
                TableRowImplDef.this.stowing.setLocation(currentX + TableRowImplDef.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImplDef.this.stowing.getPreferredSize().getHeight()) / 2.0));
                TableRowImplDef.this.stowing.setSize(w - 2 * TableRowImplDef.this.getCellPadding(), (int)TableRowImplDef.this.stowing.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImplDef.this.model.getParentModel().getColumnWidth(4);
                TableRowImplDef.this.stateRenderer.setLocation(currentX + TableRowImplDef.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImplDef.this.stateRenderer.getPreferredSize().getHeight()) / 2.0));
                TableRowImplDef.this.stateRenderer.setSize(w - 2 * TableRowImplDef.this.getCellPadding(), (int)TableRowImplDef.this.stateRenderer.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImplDef.this.model.getParentModel().getColumnWidth(5);
                TableRowImplDef.this.booleanRenderer.setLocation(currentX + TableRowImplDef.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImplDef.this.booleanRenderer.getPreferredSize().getHeight()) / 2.0));
                TableRowImplDef.this.booleanRenderer.setSize(parent.getWidth() - 2 * TableRowImplDef.this.getCellPadding(), (int)TableRowImplDef.this.booleanRenderer.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImplDef.this.model.getParentModel().getColumnWidth(6);
                TableRowImplDef.this.setControlsX(currentX);
                TableRowImplDef.this.getLatestItem().setLocation(currentX + TableRowImplDef.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImplDef.this.getLatestItem().getPreferredSize().getHeight()) / 2.0));
                TableRowImplDef.this.getLatestItem().setSize(TableRowImplDef.this.getLatestItem().getPreferredSize());
            }
        }
    }

    private class FinishRow
    extends TableRowImplDef {
        private static final long serialVersionUID = 1L;
        private CheckBox move;

        public FinishRow(Table2RowModel m, Table2RowPanel.TableControlsType controlSkin) {
            super(m);
            this.setUseControlSkin(controlSkin);
            boolean updated = false;
            if (m.getNode() != null && m.getNode().getChildNamed(DtoFieldConstants.RESULT) != null) {
                updated = Boolean.TRUE.equals(m.getNode().getChildNamed(DtoFieldConstants.RESULT).getValue());
            }
            Color color = updated ? Color.green : Color.red;
            this.setTextColor(color);
        }

        @Override
        public void createLatestItem() {
            this.move = new CheckBox();
        }

        @Override
        public JComponent getLatestItem() {
            return this.move;
        }
    }

    private class QueuedTableRow
    extends TableRowImplDef
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private DeleteButton move;

        public QueuedTableRow(Table2RowModel m, Table2RowPanel.TableControlsType controlSkin) {
            super(m);
            this.setUseControlSkin(controlSkin);
        }

        public Runnable getRunnable() {
            return () -> {
                FlightLight f = (FlightLight)this.getModel().getNode().getValue();
                ViewNode res = new ViewNode("Result");
                res.setPermanent(true);
                this.getModel().getNode().addChild((Node)res, 0L);
                if (f.getId() == null) {
                    res.setValue((Object)true, 0L);
                } else {
                    try {
                        ArrayList<String> warnings = new ArrayList<String>();
                        if (UpdateStowingListInsert.this.reloadStwFromFS) {
                            boolean useDefaultStw = UpdateStowingListInsert.this.useDefaultStowingListAnyway != null && UpdateStowingListInsert.this.useDefaultStowingListAnyway.getElement() != null ? ((CheckBox)UpdateStowingListInsert.this.useDefaultStowingListAnyway.getElement()).isChecked() : false;
                            FlightComplete fc = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getFlight(new FlightReference(f.getId())).getValue();
                            if (Boolean.TRUE.equals(fc.getAllowStowingListReload())) {
                                boolean update = UpdateStowingListInsert.this.updateInvoiced != null && ((CheckBox)UpdateStowingListInsert.this.updateInvoiced.getElement()).isChecked();
                                Node n = StowingToolkit.reloadStowingListFromFlightSchedule((FlightComplete)fc, (StowingListLight)fc.getActiveStowingList(), warnings, (boolean)update, (boolean)useDefaultStw);
                                switch (f.getFlightState()) {
                                    case CANCELLED: 
                                    case CLOSED: 
                                    case DISPATCHED: 
                                    case EN_ROUTE: {
                                        fc = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getFlight(new FlightReference(f.getId())).getValue();
                                        break;
                                    }
                                    case OPEN: 
                                    case PLANNED: {
                                        break;
                                    }
                                    default: {
                                        break;
                                    }
                                }
                            }
                        } else if (UpdateStowingListInsert.this.updateFlightOnly) {
                            boolean update;
                            FlightComplete fc = null;
                            if (((CheckBox)UpdateStowingListInsert.this.recalculateStowing.getElement()).isChecked() && f.getFlightState() != FlightStateE.PLANNED) {
                                fc = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).recalculateFlight(new FlightReference(f.getId())).getValue();
                            }
                            if (((CheckBox)UpdateStowingListInsert.this.toAutoCheckout.getElement()).isChecked()) {
                                if (fc == null) {
                                    fc = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getFlight(new FlightReference(f.getId())).getValue();
                                }
                                fc.setAutoCheckout(Boolean.valueOf(true));
                            }
                            if (((CheckBox)UpdateStowingListInsert.this.setInOutFixed.getElement()).isChecked()) {
                                if (fc == null) {
                                    fc = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getFlight(new FlightReference(f.getId())).getValue();
                                }
                                fc.setInBoundFixed(Boolean.valueOf(true));
                                fc.setOutBoundFixed(Boolean.valueOf(true));
                                update = UpdateStowingListInsert.this.updateInvoiced != null && ((CheckBox)UpdateStowingListInsert.this.updateInvoiced.getElement()).isChecked();
                                fc = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).update(fc, new ListWrapper(warnings), update, false, ((CheckBox)UpdateStowingListInsert.this.ignoreTransactions.getElement()).isChecked(), ((CheckBox)UpdateStowingListInsert.this.anonymous.getElement()).isChecked()).getObject();
                                f = fc;
                            }
                            if (((CheckBox)UpdateStowingListInsert.this.onlyPerformTransactions.getElement()).isChecked()) {
                                ((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).performStockCheckouts(new FlightReference(f.getId()), true);
                            } else {
                                if (fc == null) {
                                    fc = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getFlight(new FlightReference(f.getId())).getValue();
                                }
                                update = UpdateStowingListInsert.this.updateInvoiced != null && ((CheckBox)UpdateStowingListInsert.this.updateInvoiced.getElement()).isChecked();
                                fc = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).update(fc, new ListWrapper(warnings), update, false, ((CheckBox)UpdateStowingListInsert.this.ignoreTransactions.getElement()).isChecked(), ((CheckBox)UpdateStowingListInsert.this.anonymous.getElement()).isChecked()).getObject();
                            }
                        } else if (UpdateStowingListInsert.this.updateRCOnly) {
                            if (f.getReturnsCountState() != ReturnsCountStateE.NOT_COUNTED || ((CheckBox)UpdateStowingListInsert.this.completeRC.getElement()).isChecked()) {
                                switch (f.getFlightState()) {
                                    case CANCELLED: 
                                    case CLOSED: 
                                    case DISPATCHED: {
                                        ReturnsCountFlightComplete rc = (ReturnsCountFlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getCountItems(new FlightReference(f.getId()), new ReturnsCountParameterConfig(null, f.getUpliftCount())).getValue();
                                        if (!rc.getReturnsCountDepartments().isEmpty()) {
                                            if (((CheckBox)UpdateStowingListInsert.this.completeRC.getElement()).isChecked()) {
                                                for (CostCenterComplete d : rc.getReturnsCountDepartments()) {
                                                    rc.getDepartments().remove(d);
                                                    rc.getDepartments().put(d, true);
                                                }
                                            }
                                            boolean update = UpdateStowingListInsert.this.updateInvoiced != null && ((CheckBox)UpdateStowingListInsert.this.updateInvoiced.getElement()).isChecked();
                                            StowingToolkit.revalidateReturnsCount((ReturnsCountFlightComplete)rc);
                                            ReturnsCountFlightComplete nrc = (ReturnsCountFlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).updateCountItems(rc, false, update).getValue();
                                            this.getModel().getNode().removeExistingValues();
                                            this.getModel().getNode().setValue((Object)nrc.getFlight(), 0L);
                                            this.getModel().getNode().updateNode();
                                            if (!((CheckBox)UpdateStowingListInsert.this.revalidateRC.getElement()).isChecked()) break;
                                            ((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).performStockCheckouts(new FlightReference(nrc.getFlight().getId()), true);
                                            break;
                                        }
                                        warnings.add("Unable to update Returns Count. No Department set. Flight not updated");
                                        break;
                                    }
                                    case EN_ROUTE: 
                                    case OPEN: 
                                    case PLANNED: {
                                        break;
                                    }
                                    default: {
                                        break;
                                    }
                                }
                            }
                        } else if (UpdateStowingListInsert.this.reloadSobData) {
                            ((SalesOnBoardServiceManager)ServiceManagerRegistry.getService(SalesOnBoardServiceManager.class)).exportFlightData(new FlightReference(f.getId()));
                        } else if (UpdateStowingListInsert.this.reloadFlightData) {
                            f = (FlightLight)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).reloadFlightData(new FlightReference(f.getId())).getValue();
                            if (this.getModel() != null && this.getModel().getNode() != null) {
                                this.getModel().getNode().removeExistingValues();
                                this.getModel().getNode().setValue((Object)f, 0L);
                                this.getModel().getNode().updateNode();
                            }
                        } else if (UpdateStowingListInsert.this.setFlightsBackToOpen) {
                            try {
                                f = (FlightLight)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).setFlightBackOpen(new FlightReference(f.getId())).getValue();
                                this.getModel().getNode().removeExistingValues();
                                this.getModel().getNode().setValue((Object)f, 0L);
                                this.getModel().getNode().updateNode();
                            }
                            catch (Exception e) {
                                warnings.add(e.getMessage());
                            }
                        } else if (UpdateStowingListInsert.this.revertTransactions) {
                            try {
                                f = (FlightLight)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).revertAndRecalculateTransaction(new FlightReference(f.getId())).getValue();
                                this.getModel().getNode().removeExistingValues();
                                this.getModel().getNode().setValue((Object)f, 0L);
                                this.getModel().getNode().updateNode();
                            }
                            catch (Exception e) {
                                warnings.add(e.getMessage());
                            }
                        } else if (UpdateStowingListInsert.this.calculateRim) {
                            try {
                                f = (FlightLight)((RetailInMotionServiceManager)ServiceManagerRegistry.getService(RetailInMotionServiceManager.class)).updateRetailinMotionTransaction(new FlightReference(f.getId())).getValue();
                                this.getModel().getNode().removeExistingValues();
                                this.getModel().getNode().setValue((Object)f, 0L);
                                this.getModel().getNode().updateNode();
                            }
                            catch (Exception e) {
                                warnings.add(e.getMessage());
                            }
                        }
                        if (!warnings.isEmpty()) {
                            FlightLight fl = f;
                            SwingUtilities.invokeLater(() -> {
                                DateTimeConverter con = (DateTimeConverter)ConverterRegistry.getConverter(DateTimeConverter.class);
                                InnerPopupFactory.showWarningDialog(ScreenValidationObject.createList((List)warnings), "Please review current Flight " + fl.getOutboundCode() + " @ " + con.convert((Object)fl.getStd(), null, new Object[0]), (Component)UpdateStowingListInsert.this);
                            });
                        }
                        res.setValue((Object)true, 0L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        boolean fixingFailed = true;
                        if (fixingFailed) {
                            ExceptionHandler.getHandler().sendMail((Throwable)e, ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser(), "Unable to update Stowing List of Flight " + f);
                            InnerPopupFactory.showErrorDialog(e, (Component)this);
                        } else {
                            InnerPopupFactory.showErrorDialog(e, (Component)UpdateStowingListInsert.this);
                        }
                        res.setValue((Object)false, 0L);
                    }
                }
                Node node = this.getModel().getNode();
                UpdateStowingListInsert.this.queueTable.getModel().getNode().removeChild(node, 0L);
                UpdateStowingListInsert.this.finishedTable.getModel().getNode().addChild(node, 0L);
            };
        }

        @Override
        public void createLatestItem() {
            this.move = new DeleteButton();
            this.move.addButtonListener(this);
        }

        @Override
        public JComponent getLatestItem() {
            return this.move;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            UpdateStowingListInsert.this.queueTable.getModel().getNode().removeChild(this.getModel().getNode(), 0L);
        }
    }

    private class SearchTableRow
    extends TableRowImplDef
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private ArrowButton move;

        public SearchTableRow(Table2RowModel m, Table2RowPanel.TableControlsType controlSkin) {
            super(m);
            this.setUseControlSkin(controlSkin);
        }

        @Override
        public void createLatestItem() {
            this.move = new ArrowButton(AlignedSizedSkin1Field.AlignedDirection.Right);
            this.move.addButtonListener(this);
        }

        @Override
        public JComponent getLatestItem() {
            return this.move;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.move) {
                UpdateStowingListInsert.this.queueTable.getModel().getNode().addChild(this.getModel().getNode(), 0L);
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            if (UpdateStowingListInsert.this.animation != null) {
                UpdateStowingListInsert.this.animation.setLocation((int)((double)parent.getWidth() - UpdateStowingListInsert.this.animation.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - UpdateStowingListInsert.this.animation.getPreferredSize().getHeight()) / 2);
                UpdateStowingListInsert.this.animation.setSize(UpdateStowingListInsert.this.animation.getPreferredSize());
            }
            if (UpdateStowingListInsert.this.isInserted) {
                UpdateStowingListInsert.this.searchTable.setLocation(border, border);
                UpdateStowingListInsert.this.searchTable.setSize((parent.getWidth() - 3 * border) / 2, parent.getHeight() - 2 * border);
                int x = parent.getWidth() / 2 + border;
                UpdateStowingListInsert.this.start.setLocation(x + border, border);
                UpdateStowingListInsert.this.start.setSize(UpdateStowingListInsert.this.start.getPreferredSize());
                UpdateStowingListInsert.this.stop.setLocation(UpdateStowingListInsert.this.start.getX() + UpdateStowingListInsert.this.start.getWidth() + border, border);
                UpdateStowingListInsert.this.stop.setSize(UpdateStowingListInsert.this.stop.getPreferredSize());
                if (UpdateStowingListInsert.this.updateInvoiced != null) {
                    UpdateStowingListInsert.this.updateInvoiced.setLocation(UpdateStowingListInsert.this.start.getX(), UpdateStowingListInsert.this.start.getY() + UpdateStowingListInsert.this.start.getHeight() + border);
                    UpdateStowingListInsert.this.updateInvoiced.setSize(UpdateStowingListInsert.this.updateInvoiced.getPreferredSize());
                }
                UpdateStowingListInsert.this.toAutoCheckout.setLocation(UpdateStowingListInsert.this.stop.getX() + UpdateStowingListInsert.this.stop.getWidth() + border, UpdateStowingListInsert.this.stop.getY());
                UpdateStowingListInsert.this.toAutoCheckout.setSize(UpdateStowingListInsert.this.toAutoCheckout.getPreferredSize());
                UpdateStowingListInsert.this.onlyPerformTransactions.setLocation(UpdateStowingListInsert.this.toAutoCheckout.getX(), UpdateStowingListInsert.this.toAutoCheckout.getY() + UpdateStowingListInsert.this.toAutoCheckout.getHeight() + border);
                UpdateStowingListInsert.this.onlyPerformTransactions.setSize(UpdateStowingListInsert.this.onlyPerformTransactions.getPreferredSize());
                UpdateStowingListInsert.this.setInOutFixed.setLocation(UpdateStowingListInsert.this.toAutoCheckout.getX(), UpdateStowingListInsert.this.onlyPerformTransactions.getY() + UpdateStowingListInsert.this.onlyPerformTransactions.getHeight() + border);
                UpdateStowingListInsert.this.setInOutFixed.setSize(UpdateStowingListInsert.this.setInOutFixed.getPreferredSize());
                UpdateStowingListInsert.this.recalculateStowing.setLocation(UpdateStowingListInsert.this.toAutoCheckout.getX(), UpdateStowingListInsert.this.setInOutFixed.getY() + UpdateStowingListInsert.this.setInOutFixed.getHeight() + border);
                UpdateStowingListInsert.this.recalculateStowing.setSize(UpdateStowingListInsert.this.recalculateStowing.getPreferredSize());
                UpdateStowingListInsert.this.ignoreTransactions.setLocation(UpdateStowingListInsert.this.toAutoCheckout.getX(), UpdateStowingListInsert.this.recalculateStowing.getY() + UpdateStowingListInsert.this.recalculateStowing.getHeight() + border);
                UpdateStowingListInsert.this.ignoreTransactions.setSize(UpdateStowingListInsert.this.ignoreTransactions.getPreferredSize());
                UpdateStowingListInsert.this.anonymous.setLocation(UpdateStowingListInsert.this.toAutoCheckout.getX(), UpdateStowingListInsert.this.ignoreTransactions.getY() + UpdateStowingListInsert.this.ignoreTransactions.getHeight() + border);
                UpdateStowingListInsert.this.anonymous.setSize(UpdateStowingListInsert.this.anonymous.getPreferredSize());
                UpdateStowingListInsert.this.completeRC.setLocation(UpdateStowingListInsert.this.stop.getX() + UpdateStowingListInsert.this.stop.getWidth() + border, UpdateStowingListInsert.this.stop.getY());
                UpdateStowingListInsert.this.completeRC.setSize(UpdateStowingListInsert.this.completeRC.getPreferredSize());
                UpdateStowingListInsert.this.revalidateRC.setLocation(UpdateStowingListInsert.this.completeRC.getX(), UpdateStowingListInsert.this.completeRC.getY() + UpdateStowingListInsert.this.completeRC.getHeight() + border);
                UpdateStowingListInsert.this.revalidateRC.setSize(UpdateStowingListInsert.this.revalidateRC.getPreferredSize());
                UpdateStowingListInsert.this.useDefaultStowingListAnyway.setLocation(UpdateStowingListInsert.this.stop.getX() + UpdateStowingListInsert.this.stop.getWidth() + border, UpdateStowingListInsert.this.stop.getY());
                UpdateStowingListInsert.this.useDefaultStowingListAnyway.setSize(UpdateStowingListInsert.this.useDefaultStowingListAnyway.getPreferredSize());
                UpdateStowingListInsert.this.queueTable.setLocation(x, UpdateStowingListInsert.this.anonymous.getY() + UpdateStowingListInsert.this.anonymous.getHeight() + border * 2);
                UpdateStowingListInsert.this.queueTable.setSize(parent.getWidth() - (UpdateStowingListInsert.this.queueTable.getX() + border), parent.getHeight() / 2 - (UpdateStowingListInsert.this.queueTable.getY() + border));
                UpdateStowingListInsert.this.finishedTable.setLocation(x, UpdateStowingListInsert.this.queueTable.getY() + UpdateStowingListInsert.this.queueTable.getHeight() + border);
                UpdateStowingListInsert.this.finishedTable.setSize(parent.getWidth() - (UpdateStowingListInsert.this.finishedTable.getX() + border), parent.getHeight() - (UpdateStowingListInsert.this.finishedTable.getY() + border));
            }
        }
    }
}

