/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.internalconsumption.details;

import ch.icit.pegasus.client.converter.BasicArticleConverter;
import ch.icit.pegasus.client.converter.QuantityConverter2Decimal;
import ch.icit.pegasus.client.converter.StorePositionConverter;
import ch.icit.pegasus.client.converter.StorePositionShortNameConverter;
import ch.icit.pegasus.client.converter.StoreViewConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Killable;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.StorePositionSearchBox;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.StoreServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.toolkits.ArticleToolkit;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.cantine.InternalConsumptionComplete_;
import ch.icit.pegasus.server.core.dtos.cantine.InternalConsumptionLight;
import ch.icit.pegasus.server.core.dtos.cantine.InternalConsumptionMovementComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.InternalConsumptionAccess;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeComplete_;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeLight;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeReference;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight;
import ch.icit.pegasus.server.core.dtos.store.StoreTypeE;
import ch.icit.pegasus.server.core.dtos.store.transaction.ManualStockMovementComplete_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.dtos.utils.StoreToolkit;
import ch.icit.pegasus.server.core.dtos.utils.TransactionType;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class TransactionDetailsPanel
extends TableDetailsPanel<InternalConsumptionLight> {
    private static final long serialVersionUID = 1L;
    private boolean moveFromClosedStore = false;
    private boolean rebookAllowed = false;
    private boolean showQuantity;
    private Map<BasicArticleComplete, Map<StorePositionLight, StoreQuantityComplete>> stockHash = new HashMap<BasicArticleComplete, Map<StorePositionLight, StoreQuantityComplete>>();

    public TransactionDetailsPanel(RowEditor<InternalConsumptionLight> editor, RDProvider provider) {
        super(editor, provider);
        boolean isNoPro = CompanyUtil.isNoPro((SystemSettingsComplete)((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()));
        if (isNoPro) {
            this.moveFromClosedStore = true;
        }
        this.rebookAllowed = provider.isWritable(InternalConsumptionAccess.RE_PERFORM_TRANSACTIONS);
        this.setTitleText(Words.TRANSACTIONS);
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        int tw = CheckBox.getPreferredWidth() + 2 * this.table.getCellPadding();
        columns.add(new TableColumnInfo(0.4, 0.0, Words.ARTICLE, null, null, null, "", 200, 200, 200));
        columns.add(new TableColumnInfo(0.0, 0.0, Words.AMOUNT, null, null, null, "", 180, 180, 180));
        columns.add(new TableColumnInfo(0.3, 0.0, Words.ORIGIN, null, null, null, "", 70, 70, 70));
        columns.add(new TableColumnInfo(0.3, 0.0, Words.DESTINATION, null, null, null, "", 70, 70, 70));
        columns.add(new TableColumnInfo(0.0, 0.0, Words.TRY_TO_CHECKOUT, null, null, null, "", tw, tw, tw));
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setProvider(this.provider);
        table.setRequestFocusOnAdd(true);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
    }

    @Override
    public void childRemoved() {
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        TableRowImpl rowPanel = new TableRowImpl(model);
        rowPanel.setUseControlSkin(Table2RowPanel.TableControlsType.NONE);
        return rowPanel;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.showQuantity = !Boolean.TRUE.equals(this.editor.getModel().getNode().getChildNamed(InternalConsumptionComplete_.process).getValue());
        this.table.getModel().setNode(node.getChildNamed(InternalConsumptionComplete_.movementInformations));
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ItemListener,
    ButtonListener {
        private static final long serialVersionUID = 1L;
        private CheckBox commitTransaction;
        private ComboBox orgStore;
        private ComboBox orgPosition;
        private TextLabel stock;
        private StorePositionSearchBox destination;
        private TextLabel articleName;
        private Component articleAmount;
        private TextLabel originStore;
        private TextLabel destinationStore;
        private InfoButton packagingTable;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setLayout(new Layout());
            this.articleName = new TextLabel(m.getNode().getChildNamed(InternalConsumptionMovementComplete_.article), ConverterRegistry.getConverter(BasicArticleConverter.class));
            if (TransactionDetailsPanel.this.showQuantity) {
                this.articleAmount = new InputComboBox2(m.getNode().getChildNamed(new DtoField[]{InternalConsumptionMovementComplete_.quantity, StoreQuantityComplete_.amount}), m.getNode().getChildNamed(new DtoField[]{InternalConsumptionMovementComplete_.quantity, StoreQuantityComplete_.unit}), InputComboBox.InputComboBoxType.PRICE_AND_UNIT_LONG);
                ((InputComboBox2)this.articleAmount).setPossibleUnits(INodeCreator.getDefaultImpl().createNodes(ArticleToolkit.getSelectableUnitsForArticle((Node<BasicArticleComplete>)m.getNode().getChildNamed(InternalConsumptionMovementComplete_.article)), true));
            } else {
                this.articleAmount = new TextLabel(m.getNode().getChildNamed(InternalConsumptionMovementComplete_.quantity), ConverterRegistry.getConverter(QuantityConverter2Decimal.class));
            }
            this.packagingTable = new InfoButton();
            if (!Boolean.TRUE.equals(m.getNode().getChildNamed(InternalConsumptionMovementComplete_.transactionPerformed).getValue())) {
                Node n = m.getNode().getChildNamed(DtoFieldConstants.PERFORM_IT);
                if (n == null) {
                    n = new Node();
                    n.setName(DtoFieldConstants.PERFORM_IT);
                    n.setValue((Object)false, 0L);
                    m.getNode().addChild(n, 0L);
                }
                this.commitTransaction = new CheckBox((Node<Boolean>)n);
                this.commitTransaction.addButtonListener(this);
                Node dp = this.model.getNode().getChildNamed(InternalConsumptionMovementComplete_.targetPosition);
                Node os = this.model.getNode().getChildNamed(InternalConsumptionMovementComplete_.originPosition);
                os.setPermanent(true);
                os.setName(InternalConsumptionMovementComplete_.originPosition);
                m.getNode().addChild(os, 0L);
                this.orgStore = new ComboBox((Node)new DTOProxyNode(), null, ConverterRegistry.getConverter(StoreViewConverter.class));
                this.orgPosition = new ComboBox(os, null, ConverterRegistry.getConverter(StorePositionConverter.class));
                this.destination = new StorePositionSearchBox();
                this.destination.setNode((Node<StorePositionLight>)dp);
                this.stock = new TextLabel(null, ConverterRegistry.getConverter(QuantityConverter2Decimal.class));
                this.loadArticleStore();
                this.add(this.stock);
                this.add(this.orgStore);
                this.add(this.orgPosition);
                this.add(this.destination);
                this.add(this.commitTransaction);
            } else {
                this.originStore = new TextLabel(m.getNode().getChildNamed(new DtoField[]{InternalConsumptionMovementComplete_.transaction, ManualStockMovementComplete_.originPosition}), ConverterRegistry.getConverter(StorePositionShortNameConverter.class));
                this.destinationStore = new TextLabel(m.getNode().getChildNamed(new DtoField[]{InternalConsumptionMovementComplete_.transaction, ManualStockMovementComplete_.destinationPosition}), ConverterRegistry.getConverter(StorePositionShortNameConverter.class));
                this.loadArticleStore();
                this.add(this.originStore);
                this.add(this.destinationStore);
            }
            this.add(this.articleAmount);
            this.add(this.articleName);
            this.add(this.packagingTable);
        }

        @Override
        public List<Component> getFocusComponents() {
            return null;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            boolean enable = isEnabled;
            if (this.commitTransaction != null && this.commitTransaction.isChecked()) {
                enable = false;
            }
            this.articleName.setEnabled(enable);
            this.articleAmount.setEnabled(enable);
            this.packagingTable.setEnabled(enable);
            if (this.stock != null) {
                this.stock.setEnabled(enable);
            }
            if (this.originStore != null) {
                this.originStore.setEnabled(enable);
            }
            if (this.orgStore != null) {
                this.orgStore.setEnabled(enable);
            }
            if (this.orgPosition != null) {
                this.orgPosition.setEnabled(enable);
            }
            if (this.destination != null) {
                this.destination.setEnabled(enable);
            }
            if (this.destinationStore != null) {
                this.destinationStore.setEnabled(enable);
            }
            if (this.commitTransaction != null) {
                this.commitTransaction.setEnabled(isEnabled);
            }
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            if (this.commitTransaction != null) {
                this.commitTransaction.kill();
                this.commitTransaction = null;
            }
            this.articleName.kill();
            this.articleName = null;
            if (this.articleAmount instanceof Killable) {
                ((Killable)((Object)this.articleAmount)).kill();
            }
            this.articleAmount = null;
            if (this.stock != null) {
                this.stock.kill();
                this.stock = null;
            }
            if (this.originStore != null) {
                this.originStore.kill();
                this.originStore = null;
            }
            if (this.orgStore != null) {
                this.orgStore.kill();
                this.orgStore = null;
            }
            if (this.orgPosition != null) {
                this.orgPosition.kill();
                this.orgPosition = null;
            }
            if (this.destination != null) {
                this.destination.kill();
                this.destination = null;
            }
            if (this.destinationStore != null) {
                this.destinationStore.kill();
                this.destinationStore = null;
            }
            this.packagingTable.kill();
            this.packagingTable = null;
        }

        @Override
        public void itemStateChanged(ItemEvent arg0) {
            if (arg0.getStateChange() == 1) {
                if (arg0.getSource() == this.orgStore) {
                    this.updatePosition();
                }
                if (arg0.getSource() == this.orgPosition) {
                    this.updateStock();
                }
            }
        }

        private void updateStore(Map<StorePositionLight, StoreQuantityComplete> map) {
            HashSet<StoreLight> stores = new HashSet<StoreLight>();
            for (StorePositionLight s : map.keySet()) {
                if (s.getStore().getStoreType() == StoreTypeE.IRREGULARITY) continue;
                stores.add(s.getStore());
            }
            ArrayList<StoreLight> ss = new ArrayList<StoreLight>();
            ss.addAll(stores);
            if (this.orgPosition != null) {
                this.orgPosition.addItemListener(this);
            }
            if (this.orgStore != null) {
                this.orgStore.addItemListener(this);
                this.orgStore.refreshPossibleValues(INodeCreator.getDefaultImpl().createNodes(ss, true));
            }
        }

        private void updatePosition() {
            if (this.orgStore.getSelectedItem() != null && this.orgStore.getSelectedItem() instanceof Node) {
                Node sn = (Node)this.orgStore.getSelectedItem();
                Node article = this.model.getNode().getChildNamed(InternalConsumptionMovementComplete_.article);
                if (sn.getValue() != null) {
                    Map map = (Map)TransactionDetailsPanel.this.stockHash.get(article.getValue());
                    ArrayList positions = new ArrayList();
                    for (Map.Entry e : map.entrySet()) {
                        if (((StorePositionLight)e.getKey()).getStore().getStoreType() == StoreTypeE.IRREGULARITY || !((StorePositionLight)e.getKey()).getStore().equals(sn.getValue())) continue;
                        positions.add(e.getKey());
                    }
                    this.orgPosition.refreshPossibleValues(INodeCreator.getDefaultImpl().createNodes(positions, true));
                }
            }
        }

        private void updateStock() {
            if (this.orgPosition.getSelectedItem() != null && this.orgPosition.getSelectedItem() instanceof Node) {
                Node sn = (Node)this.orgPosition.getSelectedItem();
                Node article = this.model.getNode().getChildNamed(InternalConsumptionMovementComplete_.article);
                if (sn.getValue() != null) {
                    Map map = (Map)TransactionDetailsPanel.this.stockHash.get(article.getValue());
                    for (Map.Entry e : map.entrySet()) {
                        if (((StorePositionLight)e.getKey()).getStore().getStoreType() == StoreTypeE.IRREGULARITY || !((StorePositionLight)e.getKey()).equals(sn.getValue())) continue;
                        this.stock.setNode(INodeCreator.getDefaultImpl().getNode4DTO(e.getValue(), false, false));
                        return;
                    }
                }
            }
        }

        private void updatePackingTable(BasicArticleComplete article) {
            Date date = (Date)TransactionDetailsPanel.this.editor.getModel().getNode().getChildNamed(InternalConsumptionComplete_.consumptionDate).getValue();
            Timestamp validity = new Timestamp(date.getTime());
            if (!Boolean.TRUE.equals(this.model.getNode().getChildNamed(InternalConsumptionMovementComplete_.transactionPerformed).getValue()) || this.model.getNode().getChildNamed(InternalConsumptionMovementComplete_.transaction).getValue() == null) {
                this.packagingTable.installStringViewer(ArticleToolkit.getArticleInfoPopupString(article, validity, 4147, true));
            } else {
                this.packagingTable.installStringViewer(ArticleToolkit.getArticleInfoPopupString(article, validity, 4147, true, (List)this.model.getNode().getChildNamed(new DtoField[]{InternalConsumptionMovementComplete_.transaction, ManualStockMovementComplete_.charge, ArticleChargeComplete_.packingQuantities}).getValue()));
            }
        }

        private void loadArticleStore() {
            final BasicArticleComplete article2 = (BasicArticleComplete)this.model.getNode().getChildNamed(InternalConsumptionMovementComplete_.article).getValue(BasicArticleComplete.class);
            Map map = (Map)TransactionDetailsPanel.this.stockHash.get(article2);
            if (article2 == null || map == null) {
                ThreadSafeExecutable run = new ThreadSafeExecutable(){

                    @Override
                    public Node<?> loadData() throws Exception {
                        Node articleNodeFromModel;
                        BasicArticleComplete article = article2;
                        if (article == null && TableRowImpl.this.model.getNode() != null && (articleNodeFromModel = TableRowImpl.this.model.getNode().getChildNamed(InternalConsumptionMovementComplete_.article)) != null) {
                            BasicArticleReference artL = (BasicArticleReference)articleNodeFromModel.getValue();
                            article = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle(new BasicArticleReference(artL.getId())).getValue();
                            try {
                                Node chargeNode;
                                if (Boolean.TRUE.equals(TableRowImpl.this.model.getNode().getChildNamed(InternalConsumptionMovementComplete_.transactionPerformed).getValue()) && (chargeNode = TableRowImpl.this.model.getNode().getChildNamed(new DtoField[]{InternalConsumptionMovementComplete_.transaction, ManualStockMovementComplete_.charge})) != null && chargeNode.getValue(ArticleChargeComplete.class) == null) {
                                    ArticleChargeComplete chargeComplete = (ArticleChargeComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).getCharge(new ArticleChargeReference(((ArticleChargeLight)chargeNode.getValue()).getId())).getValue();
                                    chargeNode.removeExistingValues();
                                    chargeNode.setValue((Object)chargeComplete, 0L);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            TableRowImpl.this.updatePackingTable(article);
                        }
                        HashMap map2 = ((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).getStockPerStorePosition((BasicArticleReference)article).getMap();
                        HashMap map3 = null;
                        if (TransactionDetailsPanel.this.moveFromClosedStore) {
                            map3 = map2;
                        } else {
                            map3 = new HashMap();
                            for (Map.Entry e : map2.entrySet()) {
                                if (!((StorePositionLight)e.getKey()).getStore().getAutoCheckoutStore().booleanValue()) continue;
                                map3.put(e.getKey(), e.getValue());
                            }
                        }
                        Map filtered = StoreToolkit.filter(map3, (TransactionType)TransactionType.INTERNAL_CONSUMPTION, (UserComplete)TransactionDetailsPanel.this.currentUser, (SystemSettingsComplete)TransactionDetailsPanel.this.settings);
                        TransactionDetailsPanel.this.stockHash.put(article, filtered);
                        ViewNode n = new ViewNode("");
                        n.setValue((Object)filtered, 0L);
                        return n;
                    }

                    @Override
                    public RemoteLoader getInvoker() {
                        return new RemoteLoader(){

                            public void remoteObjectLoaded(Node<?> node) {
                                TableRowImpl.this.updateStore((Map)node.getValue());
                            }

                            public void errorOccurred(ClientException exception) {
                                InnerPopupFactory.showErrorDialog((Exception)exception, (Component)TransactionDetailsPanel.this);
                            }
                        };
                    }

                    @Override
                    public long getID() {
                        return 0L;
                    }
                };
                ThreadSafeLoader.run(run);
            } else {
                this.updateStore(map);
            }
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            this.setEnabled(this.isEnabled());
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                TableRowImpl.this.articleName.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.articleAmount.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.articleName.setSize((int)((double)w - ((double)(2 * TableRowImpl.this.getCellPadding() + TableRowImpl.this.getInnerCellPadding()) + TableRowImpl.this.packagingTable.getPreferredSize().getWidth())), (int)TableRowImpl.this.articleName.getPreferredSize().getHeight());
                TableRowImpl.this.packagingTable.setLocation(TableRowImpl.this.articleName.getX() + TableRowImpl.this.articleName.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.packagingTable.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.packagingTable.setSize(TableRowImpl.this.packagingTable.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.articleAmount.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.articleAmount.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.articleAmount.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.articleAmount.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                if (TableRowImpl.this.originStore != null) {
                    TableRowImpl.this.originStore.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.originStore.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.originStore.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.originStore.getPreferredSize().getHeight());
                } else {
                    int w2tl = (w - (2 * TableRowImpl.this.getCellPadding() + TableRowImpl.this.getInnerCellPadding() + 100)) / 2;
                    TableRowImpl.this.orgStore.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.orgStore.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.orgStore.setSize(w2tl, (int)TableRowImpl.this.orgStore.getPreferredSize().getHeight());
                    TableRowImpl.this.orgPosition.setLocation(TableRowImpl.this.orgStore.getX() + TableRowImpl.this.orgStore.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.orgPosition.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.orgPosition.setSize(w2tl, (int)TableRowImpl.this.orgPosition.getPreferredSize().getHeight());
                    TableRowImpl.this.stock.setLocation(TableRowImpl.this.orgPosition.getX() + TableRowImpl.this.orgPosition.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.stock.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.stock.setSize(TableRowImpl.this.stock.getPreferredSize());
                }
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                if (TableRowImpl.this.destinationStore != null) {
                    TableRowImpl.this.destinationStore.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.destinationStore.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.destinationStore.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.destinationStore.getPreferredSize().getHeight());
                } else {
                    TableRowImpl.this.destination.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.destination.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.destination.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.destination.getPreferredSize().getHeight());
                }
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                if (TableRowImpl.this.commitTransaction != null) {
                    TableRowImpl.this.commitTransaction.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.commitTransaction.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.commitTransaction.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.commitTransaction.getPreferredSize().getHeight());
                }
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }
        }
    }
}

