/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.inventory.details.utils;

import ch.icit.pegasus.client.converter.BasicArticleConverter;
import ch.icit.pegasus.client.converter.StorePositionConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.QuantityRenderer;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.DefaultScrollablePrintPopupInsert;
import ch.icit.pegasus.client.gui.utils.print.APrintConfigurationComplete;
import ch.icit.pegasus.client.gui.utils.print.InventoryPrintConfigurationComplete;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.InventoryServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryLight;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryReference;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StoreReference;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class PrintRemainsPopupInsert
extends DefaultScrollablePrintPopupInsert {
    private static final long serialVersionUID = 1L;
    private Node currentStock;
    private InventoryReference inventory;
    private TitledItem<Table2> table;
    private boolean isLoadingRemains = false;

    public PrintRemainsPopupInsert(Node currentNode, InventoryReference i) {
        super(true, false);
        this.currentStock = currentNode;
        this.inventory = i;
        this.getViewContainer().setLayout(new Layout());
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
        this.createComponents();
        this.isLoadingRemains = true;
        this.popup.enableOKButton(false);
        this.popup.enableCancelButton(false);
        this.removeInheritedComponents();
        this.ensureAnimation();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                List charge = ((InventoryServiceManager)ServiceManagerRegistry.getService(InventoryServiceManager.class)).getRemainingArticleBatches((StoreLight)PrintRemainsPopupInsert.this.currentStock.getChildNamed(new String[]{"store"}).getValue(), (InventoryLight)PrintRemainsPopupInsert.this.currentStock.getParent().getParent().getValue()).getList();
                if (charge == null) {
                    throw new ClientServerCallException(Words.ERROR_WHILE_LOAD_ARTICLE_CHARGES);
                }
                return INodeCreator.getDefaultImpl().createNodes(charge, true);
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintRemainsPopupInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public APrintConfigurationComplete<?> getPrintConfiguration() {
        return new InventoryPrintConfigurationComplete();
    }

    public void remoteObjectLoaded(Node node) {
        if (this.isLoadingRemains) {
            if (this.errorMSG == null) {
                this.removeAnimation(false);
                this.createInners();
                this.table.getElement().getModel().setNode(node);
                this.createComponents();
                this.popup.enableCancelButton(true);
            } else {
                this.removeAnimation(true);
            }
            this.isLoadingRemains = false;
        } else {
            super.remoteObjectLoaded(node);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.table != null) {
            this.table.setVisible(false);
        }
    }

    private void createInners() {
        this.table = new TitledItem<Table2>(new Table2(false, null, true, false), Words.UNCOUNTED_BATCHES, TitledItem.TitledItemOrientation.NORTH);
        this.table.setIgnorePrefHeight(true);
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.ARTICLE, null, null, null, "", 40, 40, 40));
        columns.add(new TableColumnInfo(Words.POSITION, null, null, null, "", 180, 180, 180));
        columns.add(new TableColumnInfo(Words.AMOUNT, null, null, null, "", 80, 80, 80));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        this.table.getElement().setModel(new Table2Model(columns, model -> new TableRowImpl(model)));
        this.table.setProgress(1.0f);
        this.add(this.table);
    }

    @Override
    public String getTitleString() {
        return Words.STORE_NAME;
    }

    @Override
    protected String getFinishedText() {
        return Words.NOT_SUPPORTED_YET;
    }

    @Override
    protected String getProgressText() {
        if (this.isLoadingRemains) {
            return Words.LOAD_STORE_DATA;
        }
        return Words.PRINT_REMAINING_ARTICLES_IN_STORE;
    }

    @Override
    public String getTitleValue() {
        return (String)this.currentStock.getChildNamed(new String[]{"store-code"}).getValue();
    }

    @Override
    public boolean withSecondSeparator() {
        return true;
    }

    @Override
    protected void startPrinting() {
        super.startPrinting();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                InventoryPrintConfigurationComplete config = (InventoryPrintConfigurationComplete)PrintRemainsPopupInsert.this.configNode.getValue();
                config.setStore(new StoreReference(((StoreLight)PrintRemainsPopupInsert.this.currentStock.getChildNamed(new String[]{"store"}).getValue()).getId()));
                config.setItem(PrintRemainsPopupInsert.this.inventory);
                ((InventoryServiceManager)ServiceManagerRegistry.getService(InventoryServiceManager.class)).printRemainingInventoryBatches(new StoreReference(((StoreLight)PrintRemainsPopupInsert.this.currentStock.getChildNamed(new String[]{"store"}).getValue()).getId()), PrintRemainsPopupInsert.this.inventory);
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintRemainsPopupInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return new Object[0];
    }

    @Override
    public boolean isClosableWithEnter() {
        return true;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    private class TableRowImpl
    extends Table2RowPanel {
        private static final long serialVersionUID = 1L;
        private TextLabel article;
        private TextLabel storePosition;
        private QuantityRenderer quantity;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.article = new TextLabel(m.getNode().getChildNamed(new String[]{"charge-basicArticle"}), ConverterRegistry.getConverter(BasicArticleConverter.class));
            this.storePosition = new TextLabel(m.getNode().getChildNamed(new String[]{"position"}), ConverterRegistry.getConverter(StorePositionConverter.class));
            this.quantity = new QuantityRenderer((Node<?>)m.getNode().getChildNamed(new String[]{"quantity"}));
            this.article.setProgress(1.0f);
            this.storePosition.setProgress(1.0f);
            this.quantity.setProgress(1.0f);
            this.setLayout(new Layout());
            this.add(this.article);
            this.add(this.storePosition);
            this.add(this.quantity);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.article.kill();
            this.storePosition.kill();
            this.quantity.kill();
        }

        @Override
        public List<Component> getFocusComponents() {
            return null;
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.article.getNode().getChildNamed(new String[]{"number"}).getValue();
                }
                case 1: {
                    return this.storePosition.getText();
                }
                case 2: {
                    return this.quantity.getText();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.article.setEnabled(isEnabled);
            this.storePosition.setEnabled(isEnabled);
            this.quantity.setEnabled(isEnabled);
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.article.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.article.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.article.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.article.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.storePosition.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.storePosition.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.storePosition.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.storePosition.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.quantity.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.quantity.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.quantity.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.quantity.getPreferredSize().getHeight());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int cy = PrintRemainsPopupInsert.this.layoutInheritedComponents(parent);
            cy += PrintRemainsPopupInsert.this.border;
            if (PrintRemainsPopupInsert.this.table != null) {
                PrintRemainsPopupInsert.this.table.setLocation(PrintRemainsPopupInsert.this.border, cy);
                PrintRemainsPopupInsert.this.table.setSize(parent.getWidth() - 2 * PrintRemainsPopupInsert.this.border, parent.getHeight() - (cy + PrintRemainsPopupInsert.this.border));
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int border = 10;
            int h = PrintRemainsPopupInsert.this.getInheritedComponentsHeight() + border;
            h += 200;
            return new Dimension(0, h += border);
        }
    }
}

