/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.knifetracking.knife;

import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.services.interfaces.tracking.KnifeTrackingServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.tracking.knife.KnifeComplete;
import ch.icit.pegasus.server.core.dtos.tracking.knife.KnifeReference;
import ch.icit.pegasus.server.core.dtos.tracking.knife.KnifeStateE;
import ch.icit.pegasus.server.core.i18n.Words;

public class KnifeModuleDataHandler
extends DefaultDataHandler<KnifeComplete, KnifeComplete> {
    public KnifeModuleDataHandler(long id, ScreenTableView tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return null;
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener progressListener) {
        this.showMessage(progressListener, Words.REFRESH_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                KnifeComplete knife = (KnifeComplete)node.getValue(KnifeComplete.class);
                KnifeComplete nknife = (KnifeComplete)((KnifeTrackingServiceManager)ServiceManagerRegistry.getService(KnifeTrackingServiceManager.class)).getKnife(new KnifeReference(knife.getId())).getValue();
                node.removeExistingValues();
                node.setValue((Object)nknife, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    @Override
    public void updateData(final Node<KnifeComplete> node, final RemoteLoader model, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                node.commit(KnifeComplete.class);
                KnifeComplete knife = (KnifeComplete)node.getValue(KnifeComplete.class);
                if (knife.getEligibleLocations().isEmpty()) {
                    knife.getEligibleLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
                }
                KnifeComplete gn = (KnifeComplete)((KnifeTrackingServiceManager)ServiceManagerRegistry.getService(KnifeTrackingServiceManager.class)).updateKnife((KnifeReference)knife).getValue();
                node.removeExistingValues();
                node.setValue((Object)gn, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return System.currentTimeMillis();
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<KnifeComplete> createEmptyNode() {
        KnifeComplete r = new KnifeComplete();
        r.setClientOId(Long.valueOf(ADTO.getNextId()));
        r.setBarcode("");
        r.setKnifeState(KnifeStateE.BOXED);
        return INodeCreator.getDefaultImpl().getNode4DTO((Object)r, false, false);
    }

    @Override
    public void createNewData(final Node<KnifeComplete> node, final RemoteLoader model, boolean sameNode, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                node.commit(KnifeComplete.class);
                KnifeComplete g = (KnifeComplete)node.getValue(KnifeComplete.class);
                if (g.getEligibleLocations().isEmpty()) {
                    g.getEligibleLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
                }
                KnifeComplete gn = (KnifeComplete)((KnifeTrackingServiceManager)ServiceManagerRegistry.getService(KnifeTrackingServiceManager.class)).createKnife(g).getValue();
                node.removeExistingValues();
                node.setValue((Object)gn, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return System.currentTimeMillis();
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                KnifeModuleDataHandler.this.setCurrentLoadMaximum(2);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(InternalCostCenterComplete.class);
                StaticEnumServiceManager.getAllIncidentTypes();
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return KnifeModuleDataHandler.this.model;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<KnifeComplete> resetData(Node<KnifeComplete> node) {
        KnifeComplete n = new KnifeComplete();
        n.setClientOId(Long.valueOf(ADTO.getNextId()));
        return INodeCreator.getDefaultImpl().getNode4DTO((Object)n, true, false);
    }

    @Override
    public Class<KnifeComplete> getCommittingClass() {
        return KnifeComplete.class;
    }

    @Override
    public void doRemoteValidation(Node<KnifeComplete> node, RemoteLoader listener, ProgressListener l, boolean validateAll) {
    }
}

