/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DetailsPanel;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.MasterDataInsert;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.color.ColorChooser;
import ch.icit.pegasus.client.gui.utils.color.ColorPreview;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.Color3DComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.Color3DComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.ColorComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ColorComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ColorConfig
extends MasterDataInsert<ColorComplete> {
    private static final long serialVersionUID = 1L;

    public ColorConfig(MasterDataModule p) {
        super(p);
    }

    @Override
    public DetailsPanel getDetails() {
        return new ColorConfigPanel();
    }

    @Override
    public ColorComplete getNewObject() {
        ColorComplete a = new ColorComplete();
        a.setClientOId(Long.valueOf(ADTO.getNextId()));
        a.setColor3d(new Color3DComplete(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0)));
        return a;
    }

    @Override
    public Class<? extends ColorComplete> getMasterDataClass() {
        return ColorComplete.class;
    }

    @Override
    public String getInsertName() {
        return "Colors";
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Iterator it = this.masterDataTable.getModel().getNode().getChilds();
        HashSet<String> codes = new HashSet<String>();
        boolean codeSet = true;
        boolean colorSet = true;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.getChildNamed(new DtoField[]{ColorComplete_.color3d, Color3DComplete_.red}).getValue() == null) {
                colorSet = false;
            }
            if (n.getChildNamed(new DtoField[]{ColorComplete_.color3d, Color3DComplete_.green}).getValue() == null) {
                colorSet = false;
            }
            if (n.getChildNamed(new DtoField[]{ColorComplete_.color3d, Color3DComplete_.blue}).getValue() == null) {
                colorSet = false;
            }
            if (n.getChildNamed(ColorComplete_.name).getValue() == null) {
                codeSet = false;
                continue;
            }
            if (codes.contains(n.getChildNamed(ColorComplete_.name).getValue())) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Name " + n.getChildNamed(ColorComplete_.name).getValue() + " is not unique."));
                continue;
            }
            codes.add((String)n.getChildNamed(ColorComplete_.name).getValue());
        }
        if (!codeSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Names are set"));
        }
        if (!colorSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Colors are set"));
        }
        return a;
    }

    private class ColorConfigPanel
    extends DetailsPanel
    implements ButtonListener,
    NodeListener {
        private static final long serialVersionUID = 1L;
        private TitledItem<TextField> name;
        private TitledItem<TextField> shortName;
        private ColorChooser colorChooser;
        private TitledItem<CheckBox> useEquipmentColor;
        private Node node;
        private ColorPreview preview;

        public ColorConfigPanel() {
            this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
            this.name = new TitledItem<TextField>(new TextField(null), "Name", TitledItem.TitledItemOrientation.NORTH);
            this.shortName = new TitledItem<TextField>(new TextField(null), "Short Name", TitledItem.TitledItemOrientation.NORTH);
            this.useEquipmentColor = new TitledItem<CheckBox>(new CheckBox(null), Words.USE_EQUIPMENT_LABEL_COLOR, TitledItem.TitledItemOrientation.NORTH);
            this.colorChooser = new ColorChooser();
            this.preview = new ColorPreview();
            this.setLayout(new AALayout());
            this.add(this.name);
            this.add(this.shortName);
            this.add(this.colorChooser);
            this.add(this.preview);
            this.add(this.useEquipmentColor);
        }

        private void updatePreview() {
            double r = (Double)this.node.getChildNamed(new DtoField[]{ColorComplete_.color3d, Color3DComplete_.red}).getValue();
            double g = (Double)this.node.getChildNamed(new DtoField[]{ColorComplete_.color3d, Color3DComplete_.green}).getValue();
            double b = (Double)this.node.getChildNamed(new DtoField[]{ColorComplete_.color3d, Color3DComplete_.blue}).getValue();
            int ri = (int)(255.0 * r);
            int gi = (int)(255.0 * g);
            int bi = (int)(255.0 * b);
            Color c = new Color(ri, gi, bi);
            if (this.preview != null) {
                this.preview.setColor(c);
                this.preview.repaint(32L);
            }
        }

        @Override
        public List<Component> getFocusComponents() {
            List<Component> a = this.name.getFocusComponents();
            a.addAll(this.shortName.getFocusComponents());
            a.addAll(this.colorChooser.getFocusComponents());
            CheckedListAdder.addToList(a, this.useEquipmentColor);
            return a;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.name.requestFocusInWindowNow();
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
            this.name.setVisibleContainer(pane);
            this.shortName.setVisibleContainer(pane);
            this.colorChooser.setVisibleContainer(pane);
            this.useEquipmentColor.setVisibleContainer(pane);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.removeListeners();
            this.name.kill();
            this.shortName.kill();
            this.colorChooser.kill();
            this.useEquipmentColor.kill();
            this.remove(this.preview);
            this.name = null;
            this.shortName = null;
            this.preview = null;
            this.colorChooser = null;
            this.useEquipmentColor = null;
        }

        private void removeListeners() {
            if (this.node != null && this.node.getChildNamed(ColorComplete_.color3d) != null) {
                this.node.getChildNamed(new DtoField[]{ColorComplete_.color3d, Color3DComplete_.red}).removeNodeListener((NodeListener)this);
                this.node.getChildNamed(new DtoField[]{ColorComplete_.color3d, Color3DComplete_.blue}).removeNodeListener((NodeListener)this);
                this.node.getChildNamed(new DtoField[]{ColorComplete_.color3d, Color3DComplete_.green}).removeNodeListener((NodeListener)this);
            }
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean b = isEnabled;
            b = this.isNodeSet() ? isEnabled : false;
            super.setEnabled(b);
            this.name.setEnabled(b);
            this.shortName.setEnabled(b);
            this.preview.setEnabled(b);
            this.colorChooser.setEnabled(b);
            this.useEquipmentColor.setEnabled(b);
        }

        public Converter getConverter() {
            return ConverterRegistry.getConverter(StringConverter.class);
        }

        @Override
        public void setNode(Node<?> node) {
            this.removeListeners();
            this.node = node;
            super.setNode(node);
            this.name.getElement().setNode(node.getChildNamed(ColorComplete_.name));
            this.shortName.getElement().setNode(node.getChildNamed(ColorComplete_.shortName));
            this.colorChooser.setNode(node.getChildNamed(ColorComplete_.color3d));
            node.getChildNamed(new DtoField[]{ColorComplete_.color3d, Color3DComplete_.red}).addNodeListener((NodeListener)this);
            node.getChildNamed(new DtoField[]{ColorComplete_.color3d, Color3DComplete_.green}).addNodeListener((NodeListener)this);
            node.getChildNamed(new DtoField[]{ColorComplete_.color3d, Color3DComplete_.blue}).addNodeListener((NodeListener)this);
            this.updatePreview();
            this.setEnabled(true);
            ColorConfig.this.setEnabled(true);
        }

        @Override
        public DtoField getAttributeName() {
            return ColorComplete_.name;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
        }

        public void valueChanged(Node<?> node) {
            this.updatePreview();
        }

        public void childAdded(Node<?> source, Node<?> child) {
        }

        public void childRemoved(Node<?> source, Node<?> child) {
        }

        public void childrenAdded(Node<?> source, Node<?> ... nodes) {
        }

        public boolean isSwingOnly() {
            return true;
        }

        private class AALayout
        extends DefaultLayout {
            private AALayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                ColorConfigPanel.this.name.setLocation(ColorConfig.this.masterDataTable.getCellPadding(), ColorConfig.this.masterDataTable.getCellPadding());
                ColorConfigPanel.this.name.setSize(200, (int)ColorConfigPanel.this.name.getPreferredSize().getHeight());
                ColorConfigPanel.this.shortName.setLocation(ColorConfig.this.masterDataTable.getCellPadding(), ColorConfigPanel.this.name.getY() + ColorConfigPanel.this.name.getHeight() + ColorConfig.this.masterDataTable.getCellPadding());
                ColorConfigPanel.this.shortName.setSize(200, (int)ColorConfigPanel.this.shortName.getPreferredSize().getHeight());
                ColorConfigPanel.this.colorChooser.setLocation(ColorConfig.this.masterDataTable.getCellPadding(), ColorConfigPanel.this.shortName.getY() + ColorConfigPanel.this.shortName.getHeight() + ColorConfig.this.masterDataTable.getCellPadding());
                ColorConfigPanel.this.colorChooser.setSize(ColorConfigPanel.this.colorChooser.getPreferredSize());
                ColorConfigPanel.this.preview.setLocation(ColorConfigPanel.this.name.getX() + ColorConfigPanel.this.name.getWidth() + 10, ColorConfigPanel.this.name.getY());
                ColorConfigPanel.this.preview.setSize(55, ColorConfigPanel.this.shortName.getY() + ColorConfigPanel.this.shortName.getHeight() - ColorConfigPanel.this.name.getY());
                ColorConfigPanel.this.useEquipmentColor.setLocation(ColorConfig.this.masterDataTable.getCellPadding(), ColorConfigPanel.this.colorChooser.getY() + ColorConfigPanel.this.colorChooser.getHeight() + ColorConfig.this.masterDataTable.getCellPadding());
                ColorConfigPanel.this.useEquipmentColor.setSize(ColorConfigPanel.this.useEquipmentColor.getPreferredSize());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension();
            }
        }
    }
}

