/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.HolidayTypeCompleteConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DetailsPanel;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.MasterDataInsert;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.HolidayPlanComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.HolidayPlanComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.HolidayPlanRuleComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.HolidayPlanRuleComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.HolidayPlanTypeComplete;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class HolidayPlanConfig
extends MasterDataInsert<HolidayPlanComplete> {
    private static final long serialVersionUID = 1L;

    public HolidayPlanConfig(MasterDataModule p) {
        super(p);
    }

    @Override
    public DetailsPanel getDetails() {
        return new HolidayPlanConfigPanel();
    }

    @Override
    public HolidayPlanComplete getNewObject() {
        HolidayPlanComplete a = new HolidayPlanComplete();
        a.setClientOId(Long.valueOf(ADTO.getNextId()));
        return a;
    }

    @Override
    public Class<HolidayPlanComplete> getMasterDataClass() {
        return HolidayPlanComplete.class;
    }

    @Override
    public String getInsertName() {
        return Words.HOLIDAY_PLAN;
    }

    @Override
    public void loadAdditionalData() throws ClientServerCallException {
        ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllUnCached(HolidayPlanTypeComplete.class, true);
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Iterator it = this.masterDataTable.getModel().getNode().getChilds();
        HashSet<String> codes = new HashSet<String>();
        boolean codeSet = true;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.getChildNamed(HolidayPlanComplete_.name).getValue() == null) {
                codeSet = false;
                continue;
            }
            if (codes.contains(n.getChildNamed(HolidayPlanComplete_.name).getValue())) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.NAME_IS_NOT_UNIQUE, (Object[])new Object[]{n.getChildNamed(HolidayPlanComplete_.name).getValue()})));
                continue;
            }
            codes.add((String)n.getChildNamed(HolidayPlanComplete_.name).getValue());
        }
        if (!codeSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_NAME_IS_SET));
        }
        return a;
    }

    private class HolidayPlanConfigPanel
    extends DetailsPanel {
        private static final long serialVersionUID = 1L;
        private TitledItem<TextField> name;
        private TitledItem<TextField> description;
        private TitledItem<CheckBox> deliverOnMonday;
        private TitledItem<CheckBox> deliverOnTuesday;
        private TitledItem<CheckBox> deliverOnWednesday;
        private TitledItem<CheckBox> deliverOnThursday;
        private TitledItem<CheckBox> deliverOnFriday;
        private TitledItem<CheckBox> deliverOnSaturday;
        private TitledItem<CheckBox> deliverOnSunday;
        private TitledItem<ComboBox> type;
        private Table2 rulesTable;

        public HolidayPlanConfigPanel() {
            this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
            this.name = new TitledItem<TextField>(new TextField(null), Words.NAME, TitledItem.TitledItemOrientation.NORTH);
            this.description = new TitledItem<TextField>(new TextField(null), Words.DESCRIPTION, TitledItem.TitledItemOrientation.NORTH);
            this.deliverOnMonday = new TitledItem<CheckBox>(new CheckBox(), "Deliver on Monday", TitledItem.TitledItemOrientation.EAST);
            this.deliverOnTuesday = new TitledItem<CheckBox>(new CheckBox(), "Deliver on Tuesday", TitledItem.TitledItemOrientation.EAST);
            this.deliverOnWednesday = new TitledItem<CheckBox>(new CheckBox(), "Deliver on Wednesday", TitledItem.TitledItemOrientation.EAST);
            this.deliverOnThursday = new TitledItem<CheckBox>(new CheckBox(), "Deliver on Thursday", TitledItem.TitledItemOrientation.EAST);
            this.deliverOnFriday = new TitledItem<CheckBox>(new CheckBox(), "Deliver on Friday", TitledItem.TitledItemOrientation.EAST);
            this.deliverOnSaturday = new TitledItem<CheckBox>(new CheckBox(), "Deliver on Saturday", TitledItem.TitledItemOrientation.EAST);
            this.deliverOnSunday = new TitledItem<CheckBox>(new CheckBox(), "Deliver on Sunday", TitledItem.TitledItemOrientation.EAST);
            this.type = new TitledItem<ComboBox>(new ComboBox(null, null, ConverterRegistry.getConverter(HolidayTypeCompleteConverter.class)), "Holiday Plan Type", TitledItem.TitledItemOrientation.NORTH);
            this.rulesTable = new Table2(true, Words.ADD, true, true, "Exceptions");
            this.rulesTable.setTitleText("Rules");
            this.rulesTable.setDontUseScrollBar(5);
            this.rulesTable.setRequestFocusOnAdd(true);
            this.rulesTable.setSortedColumn(0);
            ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
            columns.add(new TableColumnInfo(Words.NAME, "", String.class, null, "", 120, Integer.MAX_VALUE, 120));
            int dw = DateChooser.getPreferredWidth(this, false) + 2 * this.rulesTable.getCellPadding();
            columns.add(new TableColumnInfo(Words.DATE, "", String.class, null, "", dw, dw, dw));
            dw = CheckBox.getPreferredWidth() + 2 * this.rulesTable.getCellPadding();
            columns.add(new TableColumnInfo(Words.DELIVER, "", String.class, null, "", dw, dw, dw));
            int tw = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM) + 2 * this.rulesTable.getCellPadding();
            columns.add(new TableColumnInfo("", "", String.class, null, "", tw, tw, tw));
            ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
            ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
            Table2Model tableModel = new Table2Model(columns);
            this.rulesTable.setButtonHandler(new Table2ButtonHandler(){

                @Override
                public void addButtonPressed(int x, int y, Button source) {
                    HolidayPlanRuleComplete rule = new HolidayPlanRuleComplete();
                    rule.setDeliver(Boolean.valueOf(false));
                    rule.setDate(new Date(System.currentTimeMillis()));
                    rule.setClientOId(Long.valueOf(ADTO.getNextId()));
                    Node node = INodeCreator.getDefaultImpl().getNode4DTO((Object)rule, true, false);
                    HolidayPlanConfigPanel.this.rulesTable.getModel().getNode().addChild(node, 0L);
                    HolidayPlanConfigPanel.this.rulesTable.revalidate();
                }

                @Override
                public void childRemoved() {
                    HolidayPlanConfigPanel.this.rulesTable.revalidate();
                }
            });
            tableModel.setViewFactory(model -> new TableRowImpl(model));
            this.rulesTable.setModel(tableModel);
            this.setLayout(new AALayout());
            this.add(this.name);
            this.add(this.description);
            this.add(this.deliverOnMonday);
            this.add(this.deliverOnTuesday);
            this.add(this.deliverOnWednesday);
            this.add(this.deliverOnThursday);
            this.add(this.deliverOnFriday);
            this.add(this.deliverOnSaturday);
            this.add(this.deliverOnSunday);
            this.add(this.rulesTable);
            this.add(this.type);
        }

        @Override
        public List<Component> getFocusComponents() {
            List<Component> a = this.name.getFocusComponents();
            a.addAll(this.description.getFocusComponents());
            a.addAll(this.type.getFocusComponents());
            return a;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.name.requestFocusInWindowNow();
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
            this.name.setVisibleContainer(pane);
            this.description.setVisibleContainer(pane);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.name.kill();
            this.description.kill();
            this.type.kill();
            this.type = null;
            this.rulesTable.kill();
            this.rulesTable = null;
            this.deliverOnMonday.kill();
            this.deliverOnThursday.kill();
            this.deliverOnWednesday.kill();
            this.deliverOnSaturday.kill();
            this.deliverOnFriday.kill();
            this.deliverOnSaturday.kill();
            this.deliverOnSunday.kill();
            this.deliverOnMonday = null;
            this.deliverOnThursday = null;
            this.deliverOnWednesday = null;
            this.deliverOnSaturday = null;
            this.deliverOnFriday = null;
            this.deliverOnSaturday = null;
            this.deliverOnSunday = null;
            this.name = null;
            this.description = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean b = this.isNodeSet() ? isEnabled : false;
            super.setEnabled(b);
            this.name.setEnabled(b);
            this.description.setEnabled(b);
            this.deliverOnMonday.setEnabled(b);
            this.deliverOnThursday.setEnabled(b);
            this.deliverOnWednesday.setEnabled(b);
            this.deliverOnSaturday.setEnabled(b);
            this.deliverOnFriday.setEnabled(b);
            this.deliverOnSaturday.setEnabled(b);
            this.deliverOnSunday.setEnabled(b);
            this.rulesTable.setEnabled(b);
            this.type.setEnabled(b);
        }

        public Converter getConverter() {
            return ConverterRegistry.getConverter(StringConverter.class);
        }

        @Override
        public void setNode(Node<?> node) {
            super.setNode(node);
            this.name.getElement().setNode(node.getChildNamed(HolidayPlanComplete_.name));
            this.description.getElement().setNode(node.getChildNamed(HolidayPlanComplete_.description));
            this.rulesTable.getModel().setNode(node.getChildNamed(HolidayPlanComplete_.rules));
            this.deliverOnMonday.getElement().setNode(node.getChildNamed(HolidayPlanComplete_.deliverOnMonday));
            this.deliverOnThursday.getElement().setNode(node.getChildNamed(HolidayPlanComplete_.deliverOnThursday));
            this.deliverOnWednesday.getElement().setNode(node.getChildNamed(HolidayPlanComplete_.deliverOnWednesday));
            this.deliverOnTuesday.getElement().setNode(node.getChildNamed(HolidayPlanComplete_.deliverOnTuesday));
            this.deliverOnFriday.getElement().setNode(node.getChildNamed(HolidayPlanComplete_.deliverOnFriday));
            this.deliverOnSaturday.getElement().setNode(node.getChildNamed(HolidayPlanComplete_.deliverOnSaturday));
            this.deliverOnSunday.getElement().setNode(node.getChildNamed(HolidayPlanComplete_.deliverOnSunday));
            this.type.getElement().setNode(node.getChildNamed(HolidayPlanComplete_.type));
            this.type.getElement().refreshPossibleValues(NodeToolkit.getAffixList(HolidayPlanTypeComplete.class));
            this.setEnabled(true);
            HolidayPlanConfig.this.setEnabled(true);
        }

        @Override
        public DtoField getAttributeName() {
            return HolidayPlanComplete_.name;
        }

        private class TableRowImpl
        extends Table2RowPanel {
            private TextField name;
            private DateChooser date;
            private CheckBox deliver;
            private DeleteButton delete;

            public TableRowImpl(Table2RowModel m) {
                super(m);
                this.name = new TextField(this.model.getNode().getChildNamed(HolidayPlanRuleComplete_.name));
                this.date = new DateChooser(this.model.getNode().getChildNamed(HolidayPlanRuleComplete_.date));
                this.deliver = new CheckBox((Node<Boolean>)this.model.getNode().getChildNamed(HolidayPlanRuleComplete_.deliver));
                this.delete = new DeleteButton();
                this.delete.addButtonListener((source, x, y) -> HolidayPlanConfigPanel.this.rulesTable.getModel().getNode().removeChild(this.model.getNode(), 0L));
                this.setLayout(new Layout());
                this.add(this.name);
                this.add(this.date);
                this.add(this.deliver);
                this.add(this.delete);
            }

            @Override
            public Object getObject4Column(int column) {
                return null;
            }

            private class Layout
            extends DefaultLayout {
                private Layout() {
                }

                @Override
                public Dimension preferredLayoutSize(Container parent) {
                    return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
                }

                @Override
                public void layoutContainer(Container parent) {
                    int currentX = 0;
                    int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                    TableRowImpl.this.name.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.name.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.name.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.name.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                    TableRowImpl.this.date.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.date.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.date.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.date.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                    TableRowImpl.this.deliver.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.date.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.deliver.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.date.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                    TableRowImpl.this.setControlsX(currentX);
                    TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.delete.setSize(TableRowImpl.this.date.getPreferredSize());
                }
            }
        }

        private class AALayout
        extends DefaultLayout {
            private AALayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                HolidayPlanConfigPanel.this.name.setLocation(HolidayPlanConfig.this.masterDataTable.getCellPadding(), HolidayPlanConfig.this.masterDataTable.getCellPadding());
                HolidayPlanConfigPanel.this.name.setSize(200, (int)HolidayPlanConfigPanel.this.name.getPreferredSize().getHeight());
                HolidayPlanConfigPanel.this.description.setLocation(HolidayPlanConfig.this.masterDataTable.getCellPadding(), HolidayPlanConfigPanel.this.name.getY() + HolidayPlanConfigPanel.this.name.getHeight() + HolidayPlanConfig.this.masterDataTable.getCellPadding());
                HolidayPlanConfigPanel.this.description.setSize(200, (int)HolidayPlanConfigPanel.this.description.getPreferredSize().getHeight());
                HolidayPlanConfigPanel.this.type.setLocation(HolidayPlanConfig.this.masterDataTable.getCellPadding(), HolidayPlanConfigPanel.this.description.getY() + HolidayPlanConfigPanel.this.description.getHeight() + HolidayPlanConfig.this.masterDataTable.getCellPadding());
                HolidayPlanConfigPanel.this.type.setSize(200, (int)HolidayPlanConfigPanel.this.type.getPreferredSize().getHeight());
                HolidayPlanConfigPanel.this.deliverOnMonday.setLocation(HolidayPlanConfigPanel.this.name.getX() + HolidayPlanConfigPanel.this.name.getWidth() + 20, HolidayPlanConfigPanel.this.name.getY());
                HolidayPlanConfigPanel.this.deliverOnMonday.setSize(HolidayPlanConfigPanel.this.deliverOnMonday.getPreferredSize());
                HolidayPlanConfigPanel.this.deliverOnTuesday.setLocation(HolidayPlanConfigPanel.this.deliverOnMonday.getX(), HolidayPlanConfigPanel.this.deliverOnMonday.getY() + HolidayPlanConfigPanel.this.deliverOnMonday.getHeight() + 5);
                HolidayPlanConfigPanel.this.deliverOnTuesday.setSize(HolidayPlanConfigPanel.this.deliverOnTuesday.getPreferredSize());
                HolidayPlanConfigPanel.this.deliverOnWednesday.setLocation(HolidayPlanConfigPanel.this.deliverOnMonday.getX(), HolidayPlanConfigPanel.this.deliverOnTuesday.getY() + HolidayPlanConfigPanel.this.deliverOnTuesday.getHeight() + 5);
                HolidayPlanConfigPanel.this.deliverOnWednesday.setSize(HolidayPlanConfigPanel.this.deliverOnWednesday.getPreferredSize());
                HolidayPlanConfigPanel.this.deliverOnThursday.setLocation(HolidayPlanConfigPanel.this.deliverOnMonday.getX(), HolidayPlanConfigPanel.this.deliverOnWednesday.getY() + HolidayPlanConfigPanel.this.deliverOnWednesday.getHeight() + 5);
                HolidayPlanConfigPanel.this.deliverOnThursday.setSize(HolidayPlanConfigPanel.this.deliverOnThursday.getPreferredSize());
                HolidayPlanConfigPanel.this.deliverOnFriday.setLocation(HolidayPlanConfigPanel.this.deliverOnMonday.getX(), HolidayPlanConfigPanel.this.deliverOnThursday.getY() + HolidayPlanConfigPanel.this.deliverOnThursday.getHeight() + 5);
                HolidayPlanConfigPanel.this.deliverOnFriday.setSize(HolidayPlanConfigPanel.this.deliverOnFriday.getPreferredSize());
                HolidayPlanConfigPanel.this.deliverOnSaturday.setLocation(HolidayPlanConfigPanel.this.deliverOnMonday.getX(), HolidayPlanConfigPanel.this.deliverOnFriday.getY() + HolidayPlanConfigPanel.this.deliverOnFriday.getHeight() + 5);
                HolidayPlanConfigPanel.this.deliverOnSaturday.setSize(HolidayPlanConfigPanel.this.deliverOnSaturday.getPreferredSize());
                HolidayPlanConfigPanel.this.deliverOnSunday.setLocation(HolidayPlanConfigPanel.this.deliverOnMonday.getX(), HolidayPlanConfigPanel.this.deliverOnSaturday.getY() + HolidayPlanConfigPanel.this.deliverOnSaturday.getHeight() + 5);
                HolidayPlanConfigPanel.this.deliverOnSunday.setSize(HolidayPlanConfigPanel.this.deliverOnSunday.getPreferredSize());
                HolidayPlanConfigPanel.this.rulesTable.setLocation(HolidayPlanConfigPanel.this.name.getX(), HolidayPlanConfigPanel.this.deliverOnSunday.getY() + HolidayPlanConfigPanel.this.deliverOnSunday.getHeight() + 10);
                HolidayPlanConfigPanel.this.rulesTable.setSize(400, 400);
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension();
            }
        }
    }
}

