/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DetailsPanel;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.MasterDataInsert;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.mobile.ThermometerConfigComplete;
import ch.icit.pegasus.server.core.dtos.mobile.ThermometerConfigComplete_;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ThermometerConfig
extends MasterDataInsert<ThermometerConfigComplete> {
    private static final long serialVersionUID = 1L;

    public ThermometerConfig(MasterDataModule p) {
        super(p);
    }

    @Override
    public DetailsPanel getDetails() {
        return new ThermometerConfigPanel();
    }

    @Override
    public String getInsertName() {
        return "Thermometer Configs";
    }

    @Override
    public ThermometerConfigComplete getNewObject() {
        ThermometerConfigComplete a = new ThermometerConfigComplete();
        a.setClientOId(Long.valueOf(ADTO.getNextId()));
        return a;
    }

    @Override
    public Class<? extends ThermometerConfigComplete> getMasterDataClass() {
        return ThermometerConfigComplete.class;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Iterator it = this.masterDataTable.getModel().getNode().getChilds();
        HashSet<String> codes = new HashSet<String>();
        boolean codeSet = true;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.getChildNamed(ThermometerConfigComplete_.deviceName).getValue() == null) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.ENSURE_NAME_IS_UNIQUE, (Object[])new Object[]{n.getChildNamed(ThermometerConfigComplete_.deviceName).getValue()})));
            }
            if (n.getChildNamed(ThermometerConfigComplete_.deviceAddress).getValue() == null) {
                codeSet = false;
                continue;
            }
            if (codes.contains(n.getChildNamed(ThermometerConfigComplete_.deviceAddress).getValue())) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.ENSURE_CODE_IS_UNIQUE, (Object[])new Object[]{n.getChildNamed(ThermometerConfigComplete_.deviceAddress).getValue()})));
                continue;
            }
            codes.add((String)n.getChildNamed(ThermometerConfigComplete_.deviceAddress).getValue());
        }
        if (!codeSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_ALL_CODES_ARE_SET));
        }
        return a;
    }

    private class ThermometerConfigPanel
    extends DetailsPanel {
        private static final long serialVersionUID = 1L;
        private TitledItem<TextField> vendorDeviceName;
        private TitledItem<TextField> address;
        private TitledItem<TextField> serviceId;
        private TitledItem<TextField> characteristicsId;
        private TitledItem<TextField> barcode;

        public ThermometerConfigPanel() {
            this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
            this.vendorDeviceName = new TitledItem<TextField>(new TextField(null), "Vendor Name", TitledItem.TitledItemOrientation.NORTH);
            this.address = new TitledItem<TextField>(new TextField(null), "BLE Address", TitledItem.TitledItemOrientation.NORTH);
            this.barcode = new TitledItem<TextField>(new TextField(null), "Device Name", TitledItem.TitledItemOrientation.NORTH);
            this.serviceId = new TitledItem<TextField>(new TextField(null), "Service Id", TitledItem.TitledItemOrientation.NORTH);
            this.characteristicsId = new TitledItem<TextField>(new TextField(), "Characteristics Id", TitledItem.TitledItemOrientation.NORTH);
            this.setLayout(new AALayout());
            this.add(this.vendorDeviceName);
            this.add(this.address);
            this.add(this.barcode);
            this.add(this.serviceId);
            this.add(this.characteristicsId);
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.vendorDeviceName);
            CheckedListAdder.addToList(focusList, this.address);
            CheckedListAdder.addToList(focusList, this.barcode);
            CheckedListAdder.addToList(focusList, this.serviceId);
            CheckedListAdder.addToList(focusList, this.characteristicsId);
            return focusList;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.vendorDeviceName.requestFocusInWindowNow();
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
            this.vendorDeviceName.setVisibleContainer(pane);
            this.address.setVisibleContainer(pane);
            this.barcode.setVisibleContainer(pane);
            this.serviceId.setVisibleContainer(pane);
            this.characteristicsId.setVisibleContainer(pane);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.vendorDeviceName.kill();
            this.address.kill();
            this.barcode.kill();
            this.serviceId.kill();
            this.characteristicsId.kill();
            this.vendorDeviceName = null;
            this.address = null;
            this.barcode = null;
            this.serviceId = null;
            this.characteristicsId = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean b = this.isNodeSet() ? isEnabled : false;
            super.setEnabled(b);
            this.vendorDeviceName.setEnabled(b);
            this.address.setEnabled(b);
            this.barcode.setEnabled(b);
            this.serviceId.setEnabled(b);
            this.characteristicsId.setEnabled(b);
        }

        public Converter getConverter() {
            return ConverterRegistry.getConverter(StringConverter.class);
        }

        @Override
        public void setNode(Node<?> node) {
            super.setNode(node);
            this.vendorDeviceName.getElement().setNode(node.getChildNamed(ThermometerConfigComplete_.deviceName));
            this.address.getElement().setNode(node.getChildNamed(ThermometerConfigComplete_.deviceAddress));
            this.barcode.getElement().setNode(node.getChildNamed(ThermometerConfigComplete_.deviceBarcode));
            this.serviceId.getElement().setNode(node.getChildNamed(ThermometerConfigComplete_.bleServiceId));
            this.characteristicsId.getElement().setNode(node.getChildNamed(ThermometerConfigComplete_.bleCharacteristicsId));
            this.setEnabled(true);
            ThermometerConfig.this.setEnabled(true);
        }

        @Override
        public DtoField getAttributeName() {
            return ThermometerConfigComplete_.deviceBarcode;
        }

        private class AALayout
        extends DefaultLayout {
            private AALayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                ThermometerConfigPanel.this.vendorDeviceName.setLocation(ThermometerConfig.this.masterDataTable.getCellPadding(), ThermometerConfig.this.masterDataTable.getCellPadding());
                ThermometerConfigPanel.this.vendorDeviceName.setSize(200, (int)ThermometerConfigPanel.this.vendorDeviceName.getPreferredSize().getHeight());
                ThermometerConfigPanel.this.address.setLocation(ThermometerConfig.this.masterDataTable.getCellPadding(), ThermometerConfigPanel.this.vendorDeviceName.getY() + ThermometerConfigPanel.this.vendorDeviceName.getHeight() + ThermometerConfig.this.masterDataTable.getCellPadding());
                ThermometerConfigPanel.this.address.setSize(200, (int)ThermometerConfigPanel.this.address.getPreferredSize().getHeight());
                ThermometerConfigPanel.this.barcode.setLocation(ThermometerConfig.this.masterDataTable.getCellPadding(), ThermometerConfigPanel.this.address.getY() + ThermometerConfigPanel.this.address.getHeight() + ThermometerConfig.this.masterDataTable.getCellPadding());
                ThermometerConfigPanel.this.barcode.setSize(200, (int)ThermometerConfigPanel.this.barcode.getPreferredSize().getHeight());
                ThermometerConfigPanel.this.serviceId.setLocation(ThermometerConfig.this.masterDataTable.getCellPadding(), ThermometerConfigPanel.this.barcode.getY() + ThermometerConfigPanel.this.barcode.getHeight() + ThermometerConfig.this.masterDataTable.getCellPadding());
                ThermometerConfigPanel.this.serviceId.setSize(400, (int)ThermometerConfigPanel.this.serviceId.getPreferredSize().getHeight());
                ThermometerConfigPanel.this.characteristicsId.setLocation(ThermometerConfig.this.masterDataTable.getCellPadding(), ThermometerConfigPanel.this.serviceId.getY() + ThermometerConfigPanel.this.serviceId.getHeight() + ThermometerConfig.this.masterDataTable.getCellPadding());
                ThermometerConfigPanel.this.characteristicsId.setSize(400, (int)ThermometerConfigPanel.this.characteristicsId.getPreferredSize().getHeight());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension();
            }
        }
    }
}

