/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.matdispo;

import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.hud.submoduleprovider.SubModuleProvider;
import ch.icit.pegasus.client.gui.modules.Module;
import ch.icit.pegasus.client.gui.modules.matdispo.MatDispoOldModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.matdispo.details.ArticleDetailsPanel;
import ch.icit.pegasus.client.gui.modules.matdispo.details.FlightDetailsPanel;
import ch.icit.pegasus.client.gui.modules.matdispo.details.ProductDetailsPanel;
import ch.icit.pegasus.client.gui.modules.matdispo.utils.MatDispoExportPopup;
import ch.icit.pegasus.client.gui.screentemplates.splitscreen.SplitScreenView3;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.DispositionServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.HUDToolkit;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantReference;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.MatDispoAccess;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.MapWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.TimestampWrapper;
import ch.icit.pegasus.server.core.dtos.utils.UnitConversionToolkit;
import ch.icit.pegasus.server.core.services.exception.ClientRemoteException;
import ch.icit.pegasus.server.core.util.Triple;
import ch.icit.pegasus.server.core.util.Tuple;
import ch.icit.pegasus.server.dtos.IDTO;
import ch.icit.utils.ExcelRow;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MatDispoOldModule<T extends IDTO>
extends SplitScreenView3<T>
implements Module,
SubModuleProvider {
    private static final long serialVersionUID = 1L;
    private List<String> warningsProducts = new ArrayList<String>();
    private List<String> warningsArticles = new ArrayList<String>();
    private Map<ProductComplete, Map<BasicArticleComplete, QuantityComplete>> articleByProduct;

    public MatDispoOldModule() {
        this.dataHandler = new MatDispoOldModuleDataHandler();
        this.split1Title = new TextLabel("Flights");
        this.split2Title = new TextLabel("Products");
        this.split3Title = new TextLabel("Articles");
        this.check1To3 = new CheckBox();
        this.check1To3.setChecked(false);
        this.description1To3 = new TextLabel("Stowed overview only (without products)");
        this.description2To3 = new TextLabel("(Stowed products and meals only)");
        this.split1 = new FlightDetailsPanel(this);
        this.split2 = new ProductDetailsPanel(this);
        this.split3 = new ArticleDetailsPanel(this);
        this.add((Component)this.check1To3, -1);
        this.add((Component)this.description1To3, -1);
        this.add((Component)this.description2To3, -1);
        this.add((Component)this.split1, -1);
        this.add((Component)this.split2, -1);
        this.add((Component)this.split3, -1);
        this.add((Component)this.split1Title, -1);
        this.add((Component)this.split2Title, -1);
        this.add((Component)this.split3Title, -1);
    }

    @Override
    public String getSplitText1() {
        return "Calculate Products";
    }

    @Override
    public String getSplitText2() {
        return "Calculate Articles";
    }

    @Override
    public String getSplitText3() {
        return "Calculate Articles";
    }

    @Override
    public void processSplit1ToSlip2() {
        this.showAnimation(true);
        FlightDetailsPanel sp1 = (FlightDetailsPanel)this.split1;
        final List<FlightLight> flights = sp1.getFlightList();
        final Double load = sp1.getDefaultLoad();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ArrayList<FlightReference> flightrefs = new ArrayList<FlightReference>();
                for (FlightLight flightLight : flights) {
                    flightrefs.add(new FlightReference(flightLight.getId()));
                }
                Tuple p = ((DispositionServiceManager)ServiceManagerRegistry.getService(DispositionServiceManager.class)).getProductsFromFlight(new ListWrapper(flightrefs), load);
                Map warnings = ((MapWrapper)p.getS()).getMap();
                if (!warnings.isEmpty()) {
                    ArrayList<ScreenValidationObject> values = new ArrayList<ScreenValidationObject>();
                    for (Map.Entry entry : warnings.entrySet()) {
                        for (String t : ((ListWrapper)entry.getValue()).getList()) {
                            values.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, t));
                        }
                    }
                    if (!values.isEmpty()) {
                        InnerPopupFactory.showMessageDialog(values, "Found invalid Products", (Component)MatDispoOldModule.this);
                    }
                }
                ProductDetailsPanel ps = (ProductDetailsPanel)MatDispoOldModule.this.split2;
                HashMap<FlightLight, List<String>> newWarnings = new HashMap<FlightLight, List<String>>();
                for (Map.Entry entry : warnings.entrySet()) {
                    newWarnings.put((FlightLight)entry.getKey(), ((ListWrapper)entry.getValue()).getList());
                }
                ps.addWarnings(newWarnings);
                ViewNode viewNode = new ViewNode("");
                viewNode.setValue((Object)((MapWrapper)p.getT()).getMap(), 0L);
                return viewNode;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        Map p = (Map)node.getValue();
                        ProductDetailsPanel ps = (ProductDetailsPanel)MatDispoOldModule.this.split2;
                        ps.addProducts(p);
                        MatDispoOldModule.this.showAnimation(false);
                    }

                    public void errorOccurred(ClientException exception) {
                        MatDispoOldModule.this.errorOccurred(exception);
                        MatDispoOldModule.this.showAnimation(false);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void processSplit2ToSplit3() {
        this.showAnimation(true);
        ArticleDetailsPanel ps = (ArticleDetailsPanel)this.split3;
        if (!ps.isTableEmpty()) {
            String t = "<b>The Article's List is not empty</b><br/>The overview list has already overview inserted. Do you want to clear current list?";
            InnerPopupFactory.showDesicionPopup("Merge overview", t, this.check1To3, new InnerPopUpListener2(){

                @Override
                public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
                    MatDispoOldModule.this.doCloseing2(xargs);
                }
            }, 220, 120);
        } else {
            this.doCloseing2(new Object[0]);
        }
    }

    private void doCloseing2(Object ... xargs) {
        boolean merge = false;
        merge = xargs == null;
        final boolean b = merge;
        String t = "<b>Group Articles by Customer?</b><br/>Press Yes if you want to group Article Quantities by Customer.";
        InnerPopupFactory.showDesicionPopup("Merge overview", t, this.check1To3, new InnerPopUpListener2(){

            @Override
            public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
                MatDispoOldModule.this.doClosing3(b, xargs);
            }
        }, 220, 120);
    }

    private void doClosing3(final boolean mergeArticles, Object[] xargs) {
        final boolean groupByCustomer = xargs != null;
        this.articleByProduct = new HashMap<ProductComplete, Map<BasicArticleComplete, QuantityComplete>>();
        final ProductDetailsPanel ps = (ProductDetailsPanel)this.split2;
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                HashMap<CustomerLight, List<String>> allWarnings = new HashMap<CustomerLight, List<String>>();
                Map<CustomerLight, Map<ProductVariantReference, Integer>> m = ps.getProductMap(groupByCustomer);
                HashMap<CustomerLight, Map> returnMap = new HashMap<CustomerLight, Map>();
                for (Map.Entry<CustomerLight, Map<ProductVariantReference, Integer>> e : m.entrySet()) {
                    Triple a = ((DispositionServiceManager)ServiceManagerRegistry.getService(DispositionServiceManager.class)).getArticlesFromProduct(new MapWrapper(e.getValue()), new TimestampWrapper((Timestamp)ps.getDueDate().getValue()));
                    returnMap.put(e.getKey(), ((MapWrapper)a.getT()).getMap());
                    ArrayList ws = (ArrayList)allWarnings.get(e.getKey());
                    if (ws == null) {
                        ws = new ArrayList();
                        allWarnings.put(e.getKey(), ws);
                    }
                    for (Map.Entry ex : ((MapWrapper)a.getS()).getMap().entrySet()) {
                        ws.addAll(((ListWrapper)ex.getValue()).getList());
                    }
                    for (Map.Entry et : ((MapWrapper)a.getU()).getMap().entrySet()) {
                        HashMap byProduct = (HashMap)MatDispoOldModule.this.articleByProduct.get(et.getKey());
                        if (byProduct == null) {
                            byProduct = new HashMap();
                            MatDispoOldModule.this.articleByProduct.put(et.getKey(), byProduct);
                        }
                        for (Map.Entry arts : ((MapWrapper)et.getValue()).getMap().entrySet()) {
                            QuantityComplete oq = (QuantityComplete)byProduct.get(arts.getKey());
                            if (oq == null) {
                                oq = new QuantityComplete(Double.valueOf(0.0), ((BasicArticleComplete)arts.getKey()).getBaseUnit());
                            }
                            double ca = UnitConversionToolkit.convertUnit((UnitComplete)((QuantityComplete)arts.getValue()).getUnit(), (UnitComplete)oq.getUnit(), (double)((QuantityComplete)arts.getValue()).getQuantity(), (BasicArticleLight)((BasicArticleLight)arts.getKey()), (Timestamp)new Timestamp(System.currentTimeMillis()));
                            oq.setQuantity(Double.valueOf(oq.getQuantity() + ca));
                            byProduct.put(arts.getKey(), oq);
                        }
                    }
                }
                ArticleDetailsPanel as = (ArticleDetailsPanel)MatDispoOldModule.this.split3;
                as.addWarnings2(allWarnings);
                ViewNode n = new ViewNode("");
                n.setValue(returnMap, 0L);
                if (!allWarnings.isEmpty()) {
                    ArrayList<ScreenValidationObject> o = new ArrayList<ScreenValidationObject>();
                    for (Map.Entry e : allWarnings.entrySet()) {
                        for (String w : (List)e.getValue()) {
                            String ws = (e.getKey() != null ? ((CustomerLight)e.getKey()).getCode() : "") + " " + w;
                            o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, ws));
                        }
                    }
                    if (!o.isEmpty()) {
                        InnerPopupFactory.showErrorDialog(o, "Following Warnings occured. Calculation is done anyway.", (Component)MatDispoOldModule.this);
                    }
                }
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        Map a = (Map)node.getValue();
                        if (a == null) {
                            return;
                        }
                        ArticleDetailsPanel as = (ArticleDetailsPanel)MatDispoOldModule.this.split3;
                        as.addArticlesNew(a, mergeArticles);
                        MatDispoOldModule.this.showAnimation(false);
                    }

                    public void errorOccurred(ClientException exception) {
                        MatDispoOldModule.this.errorOccurred(exception);
                        MatDispoOldModule.this.showAnimation(false);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void doClosing(Object ... xargs) {
        boolean merge = false;
        merge = xargs == null;
        this.showAnimation(true);
        FlightDetailsPanel sp1 = (FlightDetailsPanel)this.split1;
        final List<FlightLight> flights = sp1.getFlightList();
        final Double defaultLoad = sp1.getDefaultLoad();
        final boolean b = merge;
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Map p = null;
                int i = 1;
                HashMap<FlightLight, List<String>> warnings = new HashMap<FlightLight, List<String>>();
                for (FlightLight f : flights) {
                    if (MatDispoOldModule.this.animation != null) {
                        MatDispoOldModule.this.animation.stateChanged("Process Flight " + i + " of " + flights.size());
                    }
                    ++i;
                    ArrayList<FlightLight> nfs = new ArrayList<FlightLight>();
                    nfs.add(f);
                    Tuple o1 = ((DispositionServiceManager)ServiceManagerRegistry.getService(DispositionServiceManager.class)).getArticlesFromFlight(new ListWrapper(nfs), MatDispoOldModule.this.check1To3.isChecked(), defaultLoad, new TimestampWrapper(f.getStd()));
                    ArrayList ws = (ArrayList)warnings.get(f);
                    if (ws == null) {
                        ws = new ArrayList();
                        warnings.put(f, ws);
                    }
                    for (Map.Entry entry : ((MapWrapper)o1.getS()).getMap().entrySet()) {
                        ws.addAll(((ListWrapper)entry.getValue()).getList());
                    }
                    if (p == null) {
                        p = ((MapWrapper)o1.getT()).getMap();
                        continue;
                    }
                    for (Map.Entry entry : ((MapWrapper)o1.getT()).getMap().entrySet()) {
                        QuantityComplete q = (QuantityComplete)p.get(entry.getKey());
                        if (q == null) {
                            p.put(entry.getKey(), entry.getValue());
                            continue;
                        }
                        QuantityComplete nq = (QuantityComplete)entry.getValue();
                        double nv = UnitConversionToolkit.convertUnit((UnitComplete)nq.getUnit(), (UnitComplete)q.getUnit(), (double)nq.getQuantity(), (BasicArticleLight)((BasicArticleLight)entry.getKey()), (Timestamp)new Timestamp(System.currentTimeMillis()));
                        q.setQuantity(Double.valueOf(q.getQuantity() + nv));
                    }
                }
                ArticleDetailsPanel ps = (ArticleDetailsPanel)MatDispoOldModule.this.split3;
                ps.addWarnings(warnings);
                DateTimeConverter dtc = (DateTimeConverter)ConverterRegistry.getConverter(DateTimeConverter.class);
                if (!warnings.isEmpty()) {
                    ArrayList<ScreenValidationObject> o = new ArrayList<ScreenValidationObject>();
                    for (Map.Entry e : warnings.entrySet()) {
                        for (String string : (List)e.getValue()) {
                            String ws = ((FlightLight)e.getKey()).getOutboundCode() + " @ " + dtc.convert((Object)((FlightLight)e.getKey()).getStd(), null, new Object[0]) + " " + string;
                            o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, ws));
                        }
                    }
                    if (!o.isEmpty()) {
                        InnerPopupFactory.showMessageDialog(o, "Found invalid Products", (Component)MatDispoOldModule.this);
                    }
                }
                ViewNode n = new ViewNode("");
                if (p == null) {
                    String t = "Current MaterialDispositionCalculationComplete is inconsistent!";
                    n.setValue((Object)t, 0L);
                    return n;
                }
                n.setValue(p, 0L);
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        if (node.getValue() instanceof String) {
                            InnerPopupFactory.showErrorDialog((String)node.getValue(), (Component)MatDispoOldModule.this);
                        } else {
                            Map p = (Map)node.getValue();
                            HashMap<CustomerLight, Map<BasicArticleComplete, Object>> np = new HashMap<CustomerLight, Map<BasicArticleComplete, Object>>();
                            np.put(null, p);
                            ArticleDetailsPanel ps = (ArticleDetailsPanel)MatDispoOldModule.this.split3;
                            ps.addArticlesNew(np, b);
                        }
                        MatDispoOldModule.this.showAnimation(false);
                    }

                    public void errorOccurred(ClientException exception) {
                        MatDispoOldModule.this.errorOccurred(exception);
                        MatDispoOldModule.this.showAnimation(false);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void processSplit1ToSplit3() {
        ArticleDetailsPanel ps = (ArticleDetailsPanel)this.split3;
        if (!ps.isTableEmpty()) {
            String t = "<b>The Article's List is not empty</b><br/>The overview list has already overview inserted. Do you want to clear current list?";
            InnerPopupFactory.showDesicionPopup("Merge overview", t, this.check1To3, new InnerPopUpListener2(){

                @Override
                public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
                    MatDispoOldModule.this.doClosing(xargs);
                }
            }, 220, 120);
        } else {
            this.doClosing(new Object[1]);
        }
    }

    @Override
    public void exportData(int x, int y) {
        InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
        popUp.setAttributes(this.export, true, true, "Export Mat Dispo");
        RDProvider p = new RDProvider(HUDToolkit.getCurrentAccessRight(MatDispoAccess.MODULE_MATERIAL_DISPOSITION, ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser()), false);
        boolean showMaterialCosts = p.isWritable("printMaterialCosts");
        popUp.setView(new MatDispoExportPopup(this, (ArticleDetailsPanel)this.split3, (ProductDetailsPanel)this.split2, (FlightDetailsPanel)this.split1, showMaterialCosts));
        popUp.showPopUp(x, y, -1, -1, null, this.export);
    }

    @Override
    public String getInvokingName() {
        return MatDispoAccess.MODULE_MATERIAL_DISPOSITION.getIdentifier();
    }

    @Override
    public List<ExcelRow> getRows() throws ClientRemoteException {
        return null;
    }

    @Override
    public String getOverriddenModuleRights() {
        return null;
    }

    public boolean isSmartScreenAllowed(SubModuleDefinitionComplete screen, RowModel model) {
        return true;
    }

    public boolean isDeletable(RowModel model) {
        return false;
    }

    public boolean isRestorable(RowModel model) {
        return false;
    }

    public Map<ProductComplete, Map<BasicArticleComplete, QuantityComplete>> getArticleByProduct() {
        return this.articleByProduct;
    }

    public void setArticleByProduct(Map<ProductComplete, Map<BasicArticleComplete, QuantityComplete>> articleByProduct) {
        this.articleByProduct = articleByProduct;
    }

    public List<ExcelRow> getArticleByProductRows() {
        ArrayList<ExcelRow> rows = new ArrayList<ExcelRow>();
        ExcelRow header = new ExcelRow();
        header.setHeader(true);
        header.addCell((Object)"Customer", new String[0]);
        header.addCell((Object)"Product No", new String[0]);
        header.addCell((Object)"Product Name", new String[0]);
        header.addCell((Object)"Product Qty", new String[0]);
        header.addCell((Object)"Article No", new String[0]);
        header.addCell((Object)"Artile Name", new String[0]);
        header.addCell((Object)"UoM", new String[0]);
        header.addCell((Object)"Qty", new String[0]);
        rows.add(header);
        if (this.articleByProduct != null) {
            for (Map.Entry<ProductComplete, Map<BasicArticleComplete, QuantityComplete>> prod : this.articleByProduct.entrySet()) {
                for (Map.Entry<BasicArticleComplete, QuantityComplete> art : prod.getValue().entrySet()) {
                    ExcelRow r = new ExcelRow();
                    r.addCell((Object)prod.getKey().getCustomer().getCode(), new String[0]);
                    r.addCell((Object)prod.getKey().getNumber(), new String[0]);
                    r.addCell((Object)prod.getKey().getCurrentVariant().getName(), new String[0]);
                    Integer amount = ((ProductDetailsPanel)this.split2).getProductAmount(prod.getKey());
                    r.addCell((Object)amount, new String[0]);
                    r.addCell((Object)art.getKey().getNumber(), new String[0]);
                    r.addCell((Object)art.getKey().getName(), new String[0]);
                    r.addCell((Object)art.getValue().getUnit().getShortName(), new String[0]);
                    r.addCell((Object)art.getValue().getQuantity(), new String[0]);
                    rows.add(r);
                }
            }
        }
        return rows;
    }

    @Override
    public String getScreenTitle() {
        return MatDispoAccess.MODULE_MATERIAL_DISPOSITION.getDisplayName();
    }
}

