/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.migros;

import ch.icit.pegasus.client.converter.BooleanConverter;
import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.MigrosDataTypeEConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.gui.modules.migros.MigrosTransferModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.migros.details.AddImportDetailsPanel;
import ch.icit.pegasus.client.gui.modules.migros.details.SpecificationDetailsPanel;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.MessageProvidedRowEditor;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.RowEditorFactory;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.Table;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.utils.TableLayoutConstraint;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.MigrosTransferSearchAlgorithm;
import ch.icit.pegasus.server.core.dtos.dataexchange.migros.MigrosDataComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.migros.MigrosDataComplete_;
import ch.icit.pegasus.server.core.dtos.dataexchange.migros.MigrosDataTypeE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.SubModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.MigrosAccess;
import ch.icit.pegasus.server.core.dtos.search.MigrosTransferSearchConfiguration;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.search.SortDirection;
import java.awt.Component;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class MigrosTransferModule
extends ScreenTableView<MigrosDataComplete, MigrosTransferSearchConfiguration.MIGROS_TRANSFER_COLUMN> {
    private static final long serialVersionUID = 1L;
    private static final String FILTER_NAME = "name_filter";
    private static final String FILTER_DATE = "date_filter";
    private static final String FILTER_VALIDITY = "validity_filter";
    private static final String FILTER_TRANSFER_TYPE = "type_filter";
    private static final String FILTER_PROCESSED = "processed_filter";
    private static final String FILTER_INVOICE_SENT = "invoice_sent_filter";
    private static final String FILTER_ORDER_AVIS = "order_avis_filter";
    private String searchCriteriaName = null;
    private PeriodComplete filterCriteriaPeriod;
    private Boolean filterCriteriaValidity;
    private MigrosDataTypeE filterCriteriaType;
    private Boolean filterCriteriaProcessed;
    private Boolean invoiceSent;
    private Boolean orderAvisSent;
    private TitledPeriodEditor p;

    public MigrosTransferModule() {
        super(MigrosDataComplete.class);
        this.isSynchronSearch = false;
    }

    @Override
    public AccessDefinitionComplete getInvoker() {
        return MigrosAccess.MODULE_MIGROS_TRANSFER;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.p.kill();
        this.p = null;
    }

    @Override
    public FilterChainConfiguration getDefaultConfiguration() {
        FilterChainConfiguration c = new FilterChainConfiguration();
        c.addProperty("sortedColumn", MigrosTransferSearchConfiguration.MIGROS_TRANSFER_COLUMN.PERIOD.toString() + "<>" + true);
        return c;
    }

    @Override
    protected void createFilterChain(long id) {
        this.filterChain.setSearchTextField2Width(200);
        this.filterChain.addSearchField(FILTER_NAME, Words.NAME, "");
        this.p = this.filterChain.addPeriodSelection(FILTER_DATE, new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis()), "", true);
        this.p.setCheckBoxEnabled();
        ComboBox types = new ComboBox();
        types.addItem(Words.ALL);
        for (MigrosDataTypeE value : MigrosDataTypeE.values()) {
            types.addItem(value);
        }
        this.filterChain.addSelectionComboBox(types, FILTER_TRANSFER_TYPE, "Type", Words.ALL);
        ComboBox validityCombo = ComboBoxFactory.getYesNoComboBox(true);
        this.filterChain.addSelectionComboBox(validityCombo, 100, FILTER_VALIDITY, "Validity", Words.ALL);
        ComboBox processedCombo = ComboBoxFactory.getYesNoComboBox(true);
        this.filterChain.addSelectionComboBox(processedCombo, 100, FILTER_PROCESSED, "Processed", Words.ALL);
        ComboBox invoiceCombo = ComboBoxFactory.getYesNoComboBox(true);
        this.filterChain.addSelectionComboBox(invoiceCombo, 100, FILTER_INVOICE_SENT, "Invoice Sent", Words.ALL);
        ComboBox orderAvisCombo = ComboBoxFactory.getYesNoComboBox(true);
        this.filterChain.addSelectionComboBox(orderAvisCombo, 100, FILTER_ORDER_AVIS, "Order Avis Sent", Words.ALL);
        this.filterChain.addResetButton();
    }

    @Override
    public ASearchConfiguration<MigrosDataComplete, MigrosTransferSearchConfiguration.MIGROS_TRANSFER_COLUMN> getModuleSearchParameters(Object name, Object value, boolean isReset, boolean emptyConfig, Component source) {
        if (isReset) {
            this.searchCriteriaName = null;
            this.filterCriteriaPeriod = null;
            this.filterCriteriaType = null;
            this.filterCriteriaValidity = null;
            this.filterCriteriaProcessed = null;
            this.invoiceSent = null;
            this.orderAvisSent = null;
        } else if (name == FILTER_NAME) {
            this.searchCriteriaName = (String)value;
        } else if (name == FILTER_DATE) {
            PeriodComplete per;
            this.filterCriteriaPeriod = per = new PeriodComplete(this.p.getStartDate(), this.p.getEndDate());
        } else if (name == FILTER_VALIDITY) {
            this.filterCriteriaValidity = Words.ALL.equals(value) ? null : (Words.YES.equals(value) ? Boolean.valueOf(true) : Boolean.valueOf(false));
        } else if (name == FILTER_PROCESSED) {
            this.filterCriteriaProcessed = Words.ALL.equals(value) ? null : (Words.YES.equals(value) ? Boolean.valueOf(true) : Boolean.valueOf(false));
        } else if (name == FILTER_TRANSFER_TYPE) {
            this.filterCriteriaType = Words.ALL.equals(value) ? null : (MigrosDataTypeE)value;
        } else if (name == FILTER_INVOICE_SENT) {
            this.invoiceSent = Words.ALL.equals(value) ? null : (Words.YES.equals(value) ? Boolean.valueOf(true) : Boolean.valueOf(false));
        } else if (name == FILTER_ORDER_AVIS) {
            this.orderAvisSent = Words.ALL.equals(value) ? null : (Words.YES.equals(value) ? Boolean.valueOf(true) : Boolean.valueOf(false));
        }
        MigrosTransferSearchConfiguration c = new MigrosTransferSearchConfiguration();
        c.setNumResults(this.numberOfShownResults);
        c.setOrderNumber(this.searchCriteriaName);
        c.setPeriod(this.filterCriteriaPeriod);
        c.setValidity(this.filterCriteriaValidity);
        c.setProcessed(this.filterCriteriaProcessed);
        c.setDataType(this.filterCriteriaType);
        c.setOrderAvisGenerated(this.orderAvisSent);
        c.setInvoiceSent(this.invoiceSent);
        if (this.currentColumnAttribute != null) {
            c.setSortColumn(this.currentColumnAttribute);
        }
        if (this.isAsc) {
            c.setSortDirection(SortDirection.ASCENDING);
        } else {
            c.setSortDirection(SortDirection.DESCENDING);
        }
        if (source == this.pagination) {
            c.setPageNumber(this.pagination.getCurrentPage() - 1);
        } else {
            c.setPageNumber(0);
        }
        if (c.getPageNumber() < 0) {
            c.setPageNumber(0);
        }
        return c;
    }

    @Override
    protected RowEditorFactory<MigrosDataComplete> getRowEditorFactory() {
        return model -> {
            MessageProvidedRowEditor<MigrosDataComplete> rowEditor = new MessageProvidedRowEditor<MigrosDataComplete>(model, "");
            RDProvider p = this.createProvider(model.isAddRow());
            DefaultDetailsPanel panel = null;
            panel = rowEditor.getModel().isAddRow() ? new AddImportDetailsPanel((RowEditor<MigrosDataComplete>)rowEditor, p) : new SpecificationDetailsPanel((RowEditor<MigrosDataComplete>)rowEditor, p);
            rowEditor.add(panel, (Object)new TableLayoutConstraint(0, 0, 1.0, 0.0));
            rowEditor.addToFocusQueue(panel);
            rowEditor.allInstalled();
            rowEditor.setVisibleContainer(this.getTable());
            return rowEditor;
        };
    }

    @Override
    protected Table.SmartIconConfiguration getPossibleSmartIcons() {
        return Table.SmartIconConfiguration.TWO;
    }

    @Override
    protected IDataHandler getModuleDataHandler() {
        return new MigrosTransferModuleDataHandler(this.loadingId, this);
    }

    @Override
    protected List<TableColumnInfo> getTableColumnInfo() {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.VALID, "", (Class)BooleanConverter.class, null, MigrosDataComplete_.validity, TableColumnInfo.state2WithExpandWidth));
        columns.add(new TableColumnInfo(Words.PROCESSED, "", (Class)BooleanConverter.class, null, MigrosDataComplete_.processed, TableColumnInfo.checkColumnWith));
        columns.add(new TableColumnInfo(Words.TYPE, "", (Class)MigrosDataTypeEConverter.class, null, MigrosDataComplete_.dataType, 105));
        columns.add(new TableColumnInfo(Words.NAME, "", StringConverter.class, null, MigrosDataComplete_.name, 120, Integer.MAX_VALUE, 120));
        columns.add(new TableColumnInfo(Words.CREATION_DATE, "", (Class)DateTimeConverter.class, (Enum<?>)MigrosTransferSearchConfiguration.MIGROS_TRANSFER_COLUMN.PERIOD, MigrosDataComplete_.creationTime, TableColumnInfo.dateTimeColumnWidth));
        return columns;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        super.remoteObjectLoaded(node);
    }

    @Override
    public SearchAlgorithm<MigrosDataComplete> getSearchAlgorithm() {
        return SearchAlgorithmRegistry.getSearchAlgorithm(MigrosTransferSearchAlgorithm.class);
    }

    @Override
    public void redo() {
    }

    @Override
    public void undo() {
    }

    @Override
    public boolean isAnalysisModuleAllowed(SubModuleAccessRightComplete subModule) {
        return super.isAnalysisModuleAllowed(subModule);
    }

    @Override
    public boolean isSmartScreenAllowed(SubModuleDefinitionComplete screen, RowModel<MigrosDataComplete> model) {
        if (model != null && model.getDTO(MigrosDataComplete.class) != null) {
            MigrosDataComplete dto = model.getDTO(MigrosDataComplete.class);
            if (screen.getInvokingName().equals(MigrosAccess.ACTION_RESOLVE.getIdentifier())) {
                return dto.getDataType() == MigrosDataTypeE.CreditNote ? !Boolean.TRUE.equals(dto.getProcessed()) : !Boolean.TRUE.equals(dto.getValidity());
            }
            if (screen.getInvokingName().equals(MigrosAccess.ACTION_SEND_ORDER_AVIS.getIdentifier())) {
                return dto.getDataType() == MigrosDataTypeE.Order && !Boolean.TRUE.equals(dto.getProcessed());
            }
            if (screen.getInvokingName().equals(MigrosAccess.ACTION_CLOSE_INVOICE.getIdentifier())) {
                return dto.getDataType() == MigrosDataTypeE.Invoice && !Boolean.TRUE.equals(dto.getProcessed());
            }
            if (screen.getInvokingName().equals(MigrosAccess.ACTION_CANCEL_INVOICE.getIdentifier())) {
                return dto.getDataType() == MigrosDataTypeE.Invoice && Boolean.TRUE.equals(dto.getProcessed()) && !Boolean.TRUE.equals(dto.getCreditNoteGenerated());
            }
        }
        return true;
    }
}

