/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.movement.article.chargebased.details;

import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.gui.modules.movement.article.chargebased.GroupCBStockMovementModule;
import ch.icit.pegasus.client.gui.modules.movement.article.chargebased.details.utils.Store_QuantityAdaptor;
import ch.icit.pegasus.client.gui.modules.movement.article.chargebased.details.utils.TableRowDefinition;
import ch.icit.pegasus.client.gui.modules.movement.article.chargebased.details.utils.TableRowImpl;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchComboBox;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeLight;
import ch.icit.pegasus.server.core.dtos.store.StockMovementGroupComplete_;
import ch.icit.pegasus.server.core.dtos.store.StockMovementGroupLight;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight;
import ch.icit.pegasus.server.core.dtos.store.transaction.ManualStockMovementComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.CustomerReference;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.utils.Tuple;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public abstract class MovePositionsDetailsPanel
extends TableDetailsPanel<StockMovementGroupLight>
implements SearchTextField2Listener {
    private static final long serialVersionUID = 1L;
    private GroupCBStockMovementModule parentW;
    private TextLabel filterTitle;
    private TitledItem<SearchComboBox> customerSearch;
    private TitledItem<CheckBox> customerNoSearch;

    public MovePositionsDetailsPanel(RowEditor<StockMovementGroupLight> editor, RDProvider provider, GroupCBStockMovementModule parentWw) {
        super(editor, provider, true);
        this.parentW = parentWw;
        this.setTitleText(Words.ARTICLE);
        TableRowImpl.storeCache.clear();
        ch.icit.pegasus.client.gui.modules.movement.article.positionbased.details.utils.TableRowImpl.storeCache.clear();
        this.filterTitle = new TextLabel(Words.FILTER_CONFIGURATION);
        this.customerSearch = new TitledItem<SearchComboBox>(SearchComboBoxFactory.getCustomerSearchField(true), Words.CUSTOMER, TitledItem.TitledItemOrientation.NORTH);
        this.customerNoSearch = new TitledItem<CheckBox>(new CheckBox(), Words.SEARCH_CUSTOMER_NO, TitledItem.TitledItemOrientation.WEST);
        this.customerSearch.getElement().addSearchTextFieldListener(this);
        this.customerNoSearch.getElement().addButtonListener(this);
        this.addToView(this.filterTitle);
        this.addToView(this.customerSearch);
        this.addToView(this.customerNoSearch);
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        super.buttonPressed(source, x, y);
        if (this.customerNoSearch.getElement() == source) {
            boolean b = this.customerNoSearch.getElement().isChecked();
            for (Table2RowPanel p : this.table.getRows()) {
                TableRowDefinition d = (TableRowDefinition)p;
                d.searchCustomerNoChanged(b);
            }
        }
    }

    public abstract boolean isChargeBased();

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        int tw = 0;
        columns.add(new TableColumnInfo(0.6, 1.0, Words.ARTICLE, "", StringConverter.class, null, "", 30, Integer.MAX_VALUE, 30));
        if (this.editor.getModel().isAddRow()) {
            columns.add(new TableColumnInfo(this.isChargeBased() ? 0.15 : 0.2, 1.0, Words.STORE, "", StringConverter.class, null, "", 70, Integer.MAX_VALUE, 70));
            columns.add(new TableColumnInfo(this.isChargeBased() ? 0.15 : 0.2, 1.0, Words.POSITION, "", StringConverter.class, null, "", 70, Integer.MAX_VALUE, 70));
            if (this.isChargeBased()) {
                columns.add(new TableColumnInfo(0.2, 1.0, Words.BATCH, "", StringConverter.class, null, "", 70, Integer.MAX_VALUE, 70));
                if (this.settings.getAllowExpiryDateChangeWhileMoveCharge().booleanValue()) {
                    columns.add(new TableColumnInfo(0.2, 1.0, Words.EXPIRY_DATE, "", DateConverter.class, null, "", 70, Integer.MAX_VALUE, 70));
                }
            }
            tw = InputComboBox.getPreferredWidth(this, InputComboBox.InputComboBoxType.PRICE_LONG);
            columns.add(new TableColumnInfo(0.0, 1.0, Words.AVAILABLE, "", StringConverter.class, null, "", tw, tw, tw));
        } else {
            columns.add(new TableColumnInfo(0.4, 1.0, Words.STORE_POSITION, "", StringConverter.class, null, "", 30, Integer.MAX_VALUE, 30));
        }
        tw = InputComboBox.getPreferredWidth(this, InputComboBox.InputComboBoxType.PRICE_AND_UNIT_LONG);
        columns.add(new TableColumnInfo(0.0, 1.0, Words.AMOUNT, "", StringConverter.class, null, "", tw += 2 * this.table.getCellPadding(), tw, tw));
        if (this.editor.getModel().isAddRow()) {
            tw = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + 2 * this.table.getCellPadding();
            columns.add(new TableColumnInfo(0.0, 1.0, Words.ALL, "", StringConverter.class, null, "", tw += 6, tw, tw));
        }
        columns.add(new TableColumnInfo(this.isChargeBased() ? 0.1 : 0.2, 1.0, Words.MOVE_TO, "", StringConverter.class, null, "", 180, Integer.MAX_VALUE, 180));
        columns.add(new TableColumnInfo(0.0, 1.0, Words.LABEL_COUNT, "", StringConverter.class, null, "", 75, 75, 75));
        tw = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + 2 * this.table.getCellPadding();
        columns.add(new TableColumnInfo(0.0, 1.0, "", "", StringConverter.class, null, "", tw, tw, tw));
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setRequestFocusOnAdd(true);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
        ManualStockMovementComplete m = new ManualStockMovementComplete();
        m.setClientOId(Long.valueOf(ADTO.getNextId()));
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)m, true, false);
        this.table.getModel().getNode().addChild(n, System.currentTimeMillis());
        this.editor.revalidate();
    }

    @Override
    public void childRemoved() {
        this.editor.revalidate();
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        TableRowDefinition p = this.parentW.getRowPanel(model, this.editor, this.provider, this.editor.getModel().isAddRow());
        p.setUseControlSkin(Table2RowPanel.TableControlsType.TWO);
        TableRowDefinition d = p;
        d.searchCustomerNoChanged(this.customerNoSearch.getElement().isChecked());
        if (this.customerSearch.getElement().getNode().getValue() != null) {
            d.customerChanged((CustomerReference)this.customerSearch.getElement().getNode().getValue());
        }
        return p;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.table.setEnabled(isEnabled);
        this.filterTitle.setEnabled(isEnabled);
        this.customerNoSearch.setEnabled(isEnabled);
        this.customerSearch.setEnabled(isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.filterTitle.kill();
        this.filterTitle = null;
        this.customerNoSearch.kill();
        this.customerNoSearch = null;
        this.customerSearch.kill();
        this.customerSearch = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> focusList = this.customerSearch.getFocusComponents();
        CheckedListAdder.addToList(focusList, this.customerNoSearch);
        CheckedListAdder.addToList(focusList, this.table);
        return focusList;
    }

    @Override
    public void setNode(Node node) {
        super.setNode(node);
        this.table.getModel().setNode(node.getChildNamed(StockMovementGroupComplete_.stockMovements));
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        boolean checkoutPositionIsValid = true;
        boolean checkInPositionIsValid = true;
        HashMap<ArticleChargeLight, Set<StorePositionLight>> completeChargeMovements = new HashMap<ArticleChargeLight, Set<StorePositionLight>>();
        HashMap<BasicArticleLight, Set<StorePositionLight>> completeArticleMovements = new HashMap<BasicArticleLight, Set<StorePositionLight>>();
        HashMap<Tuple<Object, StorePositionLight>, Store_QuantityAdaptor> map = new HashMap<Tuple<Object, StorePositionLight>, Store_QuantityAdaptor>();
        for (Table2RowPanel p : this.table.getRows()) {
            TableRowDefinition pp;
            if (p instanceof TableRowImpl) {
                pp = (TableRowImpl)p;
                if (!((TableRowImpl)pp).validateLine(map, completeChargeMovements)) {
                    checkoutPositionIsValid = false;
                }
                if (((TableRowImpl)pp).validateCheckinPositions(map)) continue;
                checkInPositionIsValid = false;
                continue;
            }
            if (!(p instanceof ch.icit.pegasus.client.gui.modules.movement.article.positionbased.details.utils.TableRowImpl)) continue;
            pp = (ch.icit.pegasus.client.gui.modules.movement.article.positionbased.details.utils.TableRowImpl)p;
            if (!((ch.icit.pegasus.client.gui.modules.movement.article.positionbased.details.utils.TableRowImpl)pp).validateLine(map, completeArticleMovements)) {
                checkoutPositionIsValid = false;
            }
            if (((ch.icit.pegasus.client.gui.modules.movement.article.positionbased.details.utils.TableRowImpl)pp).validateCheckinPositions(map)) continue;
            checkInPositionIsValid = false;
        }
        if (!checkoutPositionIsValid) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.REVIEW_CHECKOUT_POSITIONS));
        }
        if (!checkInPositionIsValid) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.REVIEW_CHECKIN_POSITIONS));
        }
        if (this.editor.getModel().isAddRow()) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, Words.ALL_POSITION_WITH_0_AMOUNT_WILL_BE_DELETED));
        }
        return validationObjects;
    }

    @Override
    public void layoutContainer(Container parent) {
        this.filterTitle.setLocation(this.horizontalBorder, this.verticalBorder);
        this.filterTitle.setSize(this.filterTitle.getPreferredSize());
        this.customerSearch.setLocation(this.horizontalBorder, this.filterTitle.getY() + this.filterTitle.getHeight() + this.inner_verticalBorder);
        this.customerSearch.setSize(180, (int)this.customerSearch.getPreferredSize().getHeight());
        this.customerNoSearch.setLocation(this.customerSearch.getX() + this.customerSearch.getWidth() + this.horizontalBorder, (int)((double)(this.customerSearch.getY() + this.customerSearch.getHeight()) - this.customerNoSearch.getPreferredSize().getHeight()));
        this.customerNoSearch.setSize(this.customerNoSearch.getPreferredSize());
        this.table.setLocation(0, this.customerSearch.getY() + this.customerSearch.getHeight() + this.verticalBorder);
        this.table.setSize(parent.getWidth(), 300);
    }

    @Override
    public Dimension calculateContainerPreferredSize() {
        int h = this.verticalBorder;
        h = (int)((double)h + this.filterTitle.getPreferredSize().getHeight());
        h += this.inner_verticalBorder;
        h = (int)((double)h + this.customerSearch.getPreferredSize().getHeight());
        h += this.verticalBorder;
        return new Dimension(0, h += 300);
    }

    @Override
    public void newValueSelected(SearchTextField2 source, Node<?> n) {
        if (this.customerSearch.getElement() == source) {
            CustomerReference b = (CustomerReference)this.customerSearch.getElement().getNode().getValue();
            for (Table2RowPanel p : this.table.getRows()) {
                TableRowDefinition d = (TableRowDefinition)p;
                d.customerChanged(b);
            }
        }
    }
}

