/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.product.details;

import ch.icit.pegasus.client.converter.ReturnsCountTypeEConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.StateDependantDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.LocationUtil;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDCheckBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDMultiLocationComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDSearchTextField2;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.validator.ValidationUtil;
import ch.icit.pegasus.server.core.dtos.ALocalizedDeletableDTO_;
import ch.icit.pegasus.server.core.dtos.ILocalizedDTO;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantComplete_;
import ch.icit.pegasus.server.core.dtos.product.ReturnsCountTypeE;
import ch.icit.pegasus.server.core.dtos.product.SoBProductConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class ProductSpecificationDetailsPanel
extends StateDependantDetailsPanel<ProductComplete>
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private static boolean isNoPro;
    private TitledItem<TextLabel> productNumber;
    private TitledItem<RDSearchTextField2<ProductComplete>> customer;
    private TitledPeriodEditor periodEditor;
    private TitledItem<RDMultiLocationComboBox> locations;
    private TitledItem<RDCheckBox> autoCheckout;
    private TitledItem<RDCheckBox> salesOnBoardItem;
    private TitledItem<RDCheckBox> showOnKitchenSheet;
    private Node<?> currentVariant;
    private TitledItem<RDComboBox> counted;
    private TitledItem<RDCheckBox> dutyFree;

    public ProductSpecificationDetailsPanel(RowEditor<ProductComplete> editor, RDProvider provider) {
        super(editor, provider);
        isNoPro = CompanyUtil.isNoPro((SystemSettingsComplete)this.settings);
        this.setTitleText(Words.SPECIFICATION);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations = new TitledItem<RDMultiLocationComboBox>(new RDMultiLocationComboBox(provider), Words.LOCATIONS, TitledItem.TitledItemOrientation.NORTH);
        }
        this.productNumber = new TitledItem<TextLabel>(new TextLabel(), Words.NUMBER, TitledItem.TitledItemOrientation.NORTH);
        this.productNumber.getElement().setReadOnlyTextField(true);
        this.periodEditor = new TitledPeriodEditor(null, null, true, provider, ProductComplete_.period);
        this.periodEditor.enableInfinity(false, true);
        this.customer = new TitledItem(new RDSearchTextField2(provider, RDSearchTextField2.SearchTypes.CUSTOMER), Words.CUSTOMER, TitledItem.TitledItemOrientation.NORTH);
        if (!isNoPro) {
            this.salesOnBoardItem = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.SALES_ON_BOARD_ITEM, TitledItem.TitledItemOrientation.EAST);
            this.salesOnBoardItem.setInnerGap(5);
            this.salesOnBoardItem.getElement().addButtonListener(this);
            this.autoCheckout = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.INCLUDE_FOR_AUTO_CHECKOUT, TitledItem.TitledItemOrientation.EAST);
            this.autoCheckout.setInnerGap(5);
            this.dutyFree = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.BONDED, TitledItem.TitledItemOrientation.EAST);
            this.dutyFree.setInnerGap(5);
            this.counted = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(ReturnsCountTypeEConverter.class)), Words.COUNT_RETURN_UPLIFT, TitledItem.TitledItemOrientation.NORTH);
            this.showOnKitchenSheet = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.SHOW_ON_KITCHEN_SHEET, TitledItem.TitledItemOrientation.EAST);
        }
        this.setCustomLayouter(new Layout());
        this.addToView(this.periodEditor);
        this.addToView(this.customer);
        this.addToView(this.productNumber);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.addToView(this.locations);
        }
        if (!isNoPro) {
            this.addToView(this.salesOnBoardItem);
            this.addToView(this.counted);
            this.addToView(this.autoCheckout);
            this.addToView(this.dutyFree);
            this.addToView(this.showOnKitchenSheet);
        }
    }

    @Override
    public DtoField<ModificationStateE> getStateChildName() {
        return ProductVariantComplete_.state;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        super.buttonPressed(source, x, y);
        if (source instanceof CheckBox) {
            this.editor.setEnabled(this.editor.isEnabled());
        }
    }

    @Override
    public void requestFocusInWindowNow() {
        this.customer.requestFocusInWindowNow();
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (this.customer.getElement().isWritable() && !this.customer.getElement().isItemSelected()) {
            this.customer.getElement().setInvalid();
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation()) && this.locations.getElement().isWritable() && this.locations.getElement().getNode().getChildCount() < 1) {
            this.locations.getElement().setInvalid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_LOCATION_IS_SET));
        }
        validationObjects.addAll(ValidationUtil.validatePeriod((Node<Date>)this.editor.getModel().getNode().getChildNamed(new DtoField[]{ProductComplete_.period, PeriodComplete_.startDate}), (Node<Date>)this.editor.getModel().getNode().getChildNamed(new DtoField[]{ProductComplete_.period, PeriodComplete_.endDate}), this.periodEditor));
        return validationObjects;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        boolean enabled = this.isStateDraft();
        boolean enabled2 = isEnabled && enabled;
        this.productNumber.setEnabled(enabled2);
        this.customer.setEnabled(enabled2);
        this.periodEditor.setEnabled(isEnabled);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.setEnabled(enabled2);
        }
        if (!isNoPro) {
            this.counted.setEnabled(enabled2);
            this.dutyFree.setEnabled(enabled2);
            this.autoCheckout.setEnabled(enabled2);
            this.showOnKitchenSheet.setEnabled(enabled2);
            boolean enabled3 = true;
            if (this.currentVariant != null) {
                enabled3 = this.currentVariant.getValue(SoBProductConfigurationComplete.class) == null;
            }
            this.salesOnBoardItem.setEnabled(isEnabled && enabled && enabled3);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.productNumber.kill();
        this.customer.kill();
        this.periodEditor.kill();
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.kill();
        }
        if (!isNoPro) {
            this.salesOnBoardItem.kill();
            this.counted.kill();
            this.dutyFree.kill();
            this.autoCheckout.kill();
            this.showOnKitchenSheet.kill();
        }
        this.dutyFree = null;
        this.counted = null;
        this.productNumber = null;
        this.customer = null;
        this.periodEditor = null;
        this.locations = null;
        this.salesOnBoardItem = null;
        this.autoCheckout = null;
        this.showOnKitchenSheet = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.customer);
        CheckedListAdder.addToList(focusList, this.periodEditor);
        CheckedListAdder.addToList(focusList, this.locations);
        CheckedListAdder.addToList(focusList, this.counted);
        CheckedListAdder.addToList(focusList, this.salesOnBoardItem);
        CheckedListAdder.addToList(focusList, this.dutyFree);
        CheckedListAdder.addToList(focusList, this.autoCheckout);
        CheckedListAdder.addToList(focusList, this.showOnKitchenSheet);
        return focusList;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        if (this.editor.getModel().isAddRow()) {
            ProductComplete dto = (ProductComplete)this.editor.getModel().getNode().getValue();
            LocationUtil.ensureCurrentLocation((ILocalizedDTO)dto);
        }
        this.currentVariant = node;
        this.productNumber.getElement().setNode(this.editor.getModel().getNode().getChildNamed(ProductComplete_.number));
        this.customer.getElement().setNode(this.editor.getModel().getNode().getChildNamed(ProductComplete_.customer));
        this.periodEditor.setStartDateNode(this.editor.getModel().getNode().getChildNamed(new DtoField[]{ProductComplete_.period, PeriodComplete_.startDate}));
        this.periodEditor.setEndDateNode(this.editor.getModel().getNode().getChildNamed(new DtoField[]{ProductComplete_.period, PeriodComplete_.endDate}));
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.getElement().setNode(this.editor.getModel().getNode().getChildNamed(ALocalizedDeletableDTO_.eligibleLocations));
        }
        if (!isNoPro) {
            this.salesOnBoardItem.getElement().setNode(this.editor.getModel().getNode().getChildNamed(ProductComplete_.salesOnBoard));
            this.counted.getElement().refreshPossibleValues(NodeToolkit.getAffixList(ReturnsCountTypeE.class));
            this.counted.getElement().setNode(this.editor.getModel().getNode().getChildNamed(ProductComplete_.returnsCountType));
            this.dutyFree.getElement().setNode(this.editor.getModel().getNode().getChildNamed(ProductComplete_.bonded));
            this.autoCheckout.getElement().setNode(this.editor.getModel().getNode().getChildNamed(ProductComplete_.autoCheckout));
            this.showOnKitchenSheet.getElement().setNode(this.editor.getModel().getNode().getChildNamed(ProductComplete_.showOnKitchenSheet));
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = ProductSpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + ProductSpecificationDetailsPanel.this.customer.getPreferredSize().getHeight());
            h += ProductSpecificationDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + ProductSpecificationDetailsPanel.this.periodEditor.getPreferredSize().getHeight());
            h += ProductSpecificationDetailsPanel.this.inner_verticalBorder;
            if (Boolean.TRUE.equals(ProductSpecificationDetailsPanel.this.viewSettings.getShowLocation())) {
                h = (int)((double)h + ProductSpecificationDetailsPanel.this.locations.getPreferredSize().getHeight());
                h += ProductSpecificationDetailsPanel.this.inner_verticalBorder;
            }
            if (!isNoPro) {
                h = (int)((double)h + ProductSpecificationDetailsPanel.this.counted.getPreferredSize().getHeight());
                h += ProductSpecificationDetailsPanel.this.inner_verticalBorder;
                h = (int)((double)h + ProductSpecificationDetailsPanel.this.dutyFree.getPreferredSize().getHeight());
                h += ProductSpecificationDetailsPanel.this.inner_verticalBorder;
                h = (int)((double)h + ProductSpecificationDetailsPanel.this.autoCheckout.getPreferredSize().getHeight());
                h += ProductSpecificationDetailsPanel.this.verticalBorder;
            }
            int w = TitledPeriodEditor.getPreferredWidth(ProductSpecificationDetailsPanel.this, false, true);
            return new Dimension(w += 2 * ProductSpecificationDetailsPanel.this.horizontalBorder, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            int currentY = ProductSpecificationDetailsPanel.this.verticalBorder;
            int w = parent.getWidth();
            int w2tl = (w - 3 * ProductSpecificationDetailsPanel.this.horizontalBorder) / 2;
            int w4tl = (w - (2 * ProductSpecificationDetailsPanel.this.horizontalBorder + 3 * (ProductSpecificationDetailsPanel.this.horizontalBorder * 2))) / 4;
            ProductSpecificationDetailsPanel.this.customer.setLocation(ProductSpecificationDetailsPanel.this.horizontalBorder, currentY);
            ProductSpecificationDetailsPanel.this.customer.setSize(w - (2 * ProductSpecificationDetailsPanel.this.horizontalBorder + ProductSpecificationDetailsPanel.this.inner_horizontalBorder + w4tl), (int)ProductSpecificationDetailsPanel.this.customer.getPreferredSize().getHeight());
            ProductSpecificationDetailsPanel.this.productNumber.setLocation(ProductSpecificationDetailsPanel.this.customer.getX() + ProductSpecificationDetailsPanel.this.customer.getWidth() + ProductSpecificationDetailsPanel.this.inner_horizontalBorder, currentY);
            ProductSpecificationDetailsPanel.this.productNumber.setSize(w4tl, (int)ProductSpecificationDetailsPanel.this.productNumber.getPreferredSize().getHeight());
            currentY = (int)((double)currentY + (ProductSpecificationDetailsPanel.this.customer.getPreferredSize().getHeight() + (double)ProductSpecificationDetailsPanel.this.inner_verticalBorder));
            ProductSpecificationDetailsPanel.this.periodEditor.setLocation(ProductSpecificationDetailsPanel.this.horizontalBorder, currentY - 2);
            ProductSpecificationDetailsPanel.this.periodEditor.setSize(w - 2 * ProductSpecificationDetailsPanel.this.horizontalBorder, (int)ProductSpecificationDetailsPanel.this.periodEditor.getPreferredSize().getHeight());
            int cx = 0;
            if (Boolean.TRUE.equals(ProductSpecificationDetailsPanel.this.viewSettings.getShowLocation())) {
                ProductSpecificationDetailsPanel.this.locations.setLocation(ProductSpecificationDetailsPanel.this.horizontalBorder, ProductSpecificationDetailsPanel.this.periodEditor.getY() + ProductSpecificationDetailsPanel.this.periodEditor.getHeight() + ProductSpecificationDetailsPanel.this.inner_verticalBorder - 2);
                ProductSpecificationDetailsPanel.this.locations.setSize(w2tl, (int)ProductSpecificationDetailsPanel.this.periodEditor.getPreferredSize().getHeight());
                cx = ProductSpecificationDetailsPanel.this.locations.getX() + ProductSpecificationDetailsPanel.this.locations.getWidth();
            }
            if (!isNoPro) {
                ProductSpecificationDetailsPanel.this.counted.setLocation(cx + ProductSpecificationDetailsPanel.this.horizontalBorder, ProductSpecificationDetailsPanel.this.periodEditor.getY() + ProductSpecificationDetailsPanel.this.periodEditor.getHeight() + ProductSpecificationDetailsPanel.this.inner_verticalBorder - 2);
                ProductSpecificationDetailsPanel.this.counted.setSize(w2tl, (int)ProductSpecificationDetailsPanel.this.counted.getPreferredSize().getHeight());
                ProductSpecificationDetailsPanel.this.salesOnBoardItem.setLocation(ProductSpecificationDetailsPanel.this.counted.getX(), ProductSpecificationDetailsPanel.this.counted.getY() + ProductSpecificationDetailsPanel.this.counted.getHeight() + ProductSpecificationDetailsPanel.this.verticalBorder);
                ProductSpecificationDetailsPanel.this.salesOnBoardItem.setSize(w2tl, (int)ProductSpecificationDetailsPanel.this.salesOnBoardItem.getPreferredSize().getHeight());
                ProductSpecificationDetailsPanel.this.dutyFree.setLocation(ProductSpecificationDetailsPanel.this.counted.getX(), ProductSpecificationDetailsPanel.this.salesOnBoardItem.getY() + ProductSpecificationDetailsPanel.this.salesOnBoardItem.getHeight() + ProductSpecificationDetailsPanel.this.inner_verticalBorder);
                ProductSpecificationDetailsPanel.this.dutyFree.setSize(w2tl, (int)ProductSpecificationDetailsPanel.this.dutyFree.getPreferredSize().getHeight());
                ProductSpecificationDetailsPanel.this.autoCheckout.setLocation(ProductSpecificationDetailsPanel.this.salesOnBoardItem.getX() + ProductSpecificationDetailsPanel.this.salesOnBoardItem.getWidth() + ProductSpecificationDetailsPanel.this.horizontalBorder, ProductSpecificationDetailsPanel.this.salesOnBoardItem.getY());
                ProductSpecificationDetailsPanel.this.autoCheckout.setSize(w2tl, (int)ProductSpecificationDetailsPanel.this.autoCheckout.getPreferredSize().getHeight());
                ProductSpecificationDetailsPanel.this.showOnKitchenSheet.setLocation(ProductSpecificationDetailsPanel.this.dutyFree.getX() + ProductSpecificationDetailsPanel.this.dutyFree.getWidth() + ProductSpecificationDetailsPanel.this.horizontalBorder, ProductSpecificationDetailsPanel.this.dutyFree.getY());
                ProductSpecificationDetailsPanel.this.showOnKitchenSheet.setSize(w2tl, (int)ProductSpecificationDetailsPanel.this.showOnKitchenSheet.getPreferredSize().getHeight());
            }
        }
    }
}

