/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.product.details;

import ch.icit.pegasus.client.converter.AircraftTypeConverter;
import ch.icit.pegasus.client.converter.BoundDirectionConverter;
import ch.icit.pegasus.client.converter.ColorConverter;
import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.GalleyEquipmentInsertTypeConverter;
import ch.icit.pegasus.client.converter.HaulTypeConverter;
import ch.icit.pegasus.client.converter.MealTypeConverter;
import ch.icit.pegasus.client.converter.PaxMealTypeConverter;
import ch.icit.pegasus.client.converter.ProductTypeCompleteConverter;
import ch.icit.pegasus.client.converter.UnitConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.StateDependantDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDCheckBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDInputComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDMultiClassSelectionComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDMultiHaulTypeComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDMultiLabelTagSelectionComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDMultiMenuTypeSelectionComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDMultiServiceTypeSelectionComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.toolkits.ProductToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.AMenuTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.AircraftTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.AlaCarteMenuTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ColorComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.GalleyEquipmentInsertTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PaxMealTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ProductTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.SpecialMenuTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.MealTypeComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductSalesComponentComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductSalesComponentComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.ProductAccess;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class VariantSpecificationsDetailsPanelPart2
extends StateDependantDetailsPanel<ProductComplete> {
    private static final long serialVersionUID = 1L;
    private TitledItem<RDCheckBox> standard;
    private TitledItem<RDCheckBox> specialMeal;
    private TitledItem<RDCheckBox> alaCarte;
    private HorizontalSeparator sep1;
    private boolean isMenuSelectable;
    private TitledItem<RDMultiClassSelectionComboBox> cabinClass;
    private TitledItem<RDMultiServiceTypeSelectionComboBox> serviceType;
    private TitledItem<RDMultiMenuTypeSelectionComboBox> specialMealType;
    private TitledItem<RDMultiHaulTypeComboBox> haulType;
    private TitledItem<RDComboBox> aircraftType;
    private TitledItem<RDComboBox> inout;
    private TitledItem<RDCheckBox> isAdditional;
    private TitledItem<RDCheckBox> hideOnLabel;
    private TitledItem<RDComboBox> defaultTray;
    private TitledItem<RDComboBox> defaultLabelColor;
    private TitledItem<RDTextField> cycle;
    private InfoButton cycleInfo;
    private TitledItem<RDCheckBox> labeled;
    private TitledItem<RDCheckBox> alwaysOnDeliverySlip;
    private TitledItem<RDComboBox> productType;
    private TitledItem<RDTextField> productToMealMultiplier;
    private TitledItem<RDComboBox> mealType;
    private TitledItem<RDCheckBox> excludeFromReporting;
    private TitledItem<RDCheckBox> nominated;
    private TitledItem<RDCheckBox> showOnDailyOps;
    private TitledItem<RDCheckBox> excludeFromCanBeUsedByOtherCustomers;
    private TitledItem<RDCheckBox> useMasterDataForProductGroupTypes;
    private TitledItem<RDCheckBox> takeKonterProbe;
    private TitledItem<RDComboBox> department;
    private TitledItem<RDTextField> netWeight;
    private TitledItem<RDTextField> grossWeight;
    private TitledItem<RDComboBox> paxMealType;
    private TitledItem<RDComboBox> deliveryUnit;
    private TitledItem<RDComboBox> labelUnit;
    private TitledItem<RDTextField> packSize;
    private TitledItem<RDTextField> productsPerLabel;
    private RDCheckBox useExpiryDate;
    private TitledItem<RDTextField> defaultExpiryDate;
    private TitledItem<RDMultiLabelTagSelectionComboBox> labelTags;
    private TitledItem<RDInputComboBox> salesComponentQuantity;
    private TitledItem<RDTextField> salesComponentName;
    private TitledItem<RDInputComboBox> salesComponentPrice;

    public VariantSpecificationsDetailsPanelPart2(RowEditor<ProductComplete> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.ADDITIONAL_DATA);
        this.isMenuSelectable = provider.isWritable(ProductVariantComplete_.menuTypes);
        this.standard = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.STANDARD, TitledItem.TitledItemOrientation.EAST);
        this.specialMeal = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.SPECIAL_MEAL, TitledItem.TitledItemOrientation.EAST);
        this.alaCarte = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.ALA_CARTE, TitledItem.TitledItemOrientation.EAST);
        if (Boolean.TRUE.equals(this.viewSettings.getShowProductNominated())) {
            this.nominated = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.NOMINATED, TitledItem.TitledItemOrientation.EAST);
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowProductCheckerSheet())) {
            this.showOnDailyOps = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.SHOW_ON_OPS_AND_CHECKER_SHEET, TitledItem.TitledItemOrientation.EAST);
        }
        this.standard.getElement().addButtonListener(this);
        this.specialMeal.getElement().addButtonListener(this);
        this.alaCarte.getElement().addButtonListener(this);
        this.netWeight = new TitledItem<RDTextField>(new RDTextField(provider, TextFieldType.DOUBLE), Words.NET_WEIGHT, TitledItem.TitledItemOrientation.NORTH);
        this.grossWeight = new TitledItem<RDTextField>(new RDTextField(provider, TextFieldType.DOUBLE), Words.GROSS_WEIGHT, TitledItem.TitledItemOrientation.NORTH);
        this.netWeight.getElement().setMaxKommaStellen(3);
        this.grossWeight.getElement().setMaxKommaStellen(3);
        this.sep1 = new HorizontalSeparator();
        this.cabinClass = new TitledItem<RDMultiClassSelectionComboBox>(new RDMultiClassSelectionComboBox(provider), Words.CABIN_CLASS, TitledItem.TitledItemOrientation.NORTH);
        if (Boolean.TRUE.equals(this.viewSettings.getShowProductLabeledInCatalog())) {
            this.labeled = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.LABELED_IN_CATALOG, TitledItem.TitledItemOrientation.EAST);
            this.labeled.setInnerGap(5);
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowProductAlwaysOnDeliverySlip())) {
            this.alwaysOnDeliverySlip = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.ALWAYS_ON_DELVIERY_SLIP, TitledItem.TitledItemOrientation.EAST);
            this.alwaysOnDeliverySlip.setInnerGap(5);
        }
        this.productType = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(ProductTypeCompleteConverter.class), true, true), "Product Type", TitledItem.TitledItemOrientation.NORTH);
        this.productType.setInnerGap(5);
        this.productToMealMultiplier = new TitledItem<RDTextField>(new RDTextField(provider, TextFieldType.INT), Words.ITEMS_PER_PRODUCT, TitledItem.TitledItemOrientation.NORTH);
        this.productToMealMultiplier.setInnerGap(5);
        this.department = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(CostCenterConverter.class), true), Words.DEPARTMENT, TitledItem.TitledItemOrientation.NORTH);
        this.serviceType = new TitledItem<RDMultiServiceTypeSelectionComboBox>(new RDMultiServiceTypeSelectionComboBox(provider), Words.SERVICE_TYPE, TitledItem.TitledItemOrientation.NORTH);
        this.paxMealType = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(PaxMealTypeConverter.class), true), Words.PAX_MEAL_TYPE, TitledItem.TitledItemOrientation.NORTH);
        this.specialMealType = new TitledItem<RDMultiMenuTypeSelectionComboBox>(new RDMultiMenuTypeSelectionComboBox(provider, DtoFieldConstants.PRODUCT_MENU_TYPES.getFieldName()), WordsToolkit.toCapitalLetter((String)Words.MENU_TYPE), TitledItem.TitledItemOrientation.NORTH);
        if (Boolean.TRUE.equals(this.viewSettings.getShowProductDefaultTray())) {
            GalleyEquipmentInsertTypeConverter tViewConverter = (GalleyEquipmentInsertTypeConverter)ConverterRegistry.getConverter(GalleyEquipmentInsertTypeConverter.class);
            this.defaultTray = new TitledItem<RDComboBox>(new RDComboBox(provider, (Converter)tViewConverter, true, true), Words.DEFAULT_TRAY, TitledItem.TitledItemOrientation.NORTH);
        }
        if (Boolean.TRUE.equals(this.settings.getEnableProductDefaultLabelColor())) {
            this.defaultLabelColor = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(ColorConverter.class), true, true), Words.DEFAULT_LABEL_COLOR, TitledItem.TitledItemOrientation.NORTH);
        }
        HaulTypeConverter haulTypeViewConverter = (HaulTypeConverter)ConverterRegistry.getConverter(HaulTypeConverter.class);
        this.haulType = new TitledItem<RDMultiHaulTypeComboBox>(new RDMultiHaulTypeComboBox(provider), Words.HAUL_TYPE, TitledItem.TitledItemOrientation.NORTH);
        if (Boolean.TRUE.equals(this.viewSettings.getShowProductAircraft())) {
            AircraftTypeConverter aircraftTypeViewConverter = (AircraftTypeConverter)ConverterRegistry.getConverter(AircraftTypeConverter.class);
            this.aircraftType = new TitledItem<RDComboBox>(new RDComboBox(provider, (Converter)aircraftTypeViewConverter, true), Words.AIRCRAFT_TYPE, TitledItem.TitledItemOrientation.NORTH);
            this.aircraftType.getElement().refreshPossibleValues(NodeToolkit.getAffixList(AircraftTypeComplete.class));
        }
        Node possibleValues = StaticEnumServiceManager.getAllBoundDirections();
        BoundDirectionConverter viewConverter = (BoundDirectionConverter)ConverterRegistry.getConverter(BoundDirectionConverter.class);
        this.inout = new TitledItem<RDComboBox>(new RDComboBox(provider, (Converter)viewConverter, true), Words.IN_OUT, TitledItem.TitledItemOrientation.NORTH);
        this.inout.getElement().refreshPossibleValues(possibleValues);
        if (Boolean.TRUE.equals(this.viewSettings.getShowProductDeliverableForFlightOrder())) {
            this.isAdditional = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.DELIVERABLE_FOR_FLIGHT_ORDER, TitledItem.TitledItemOrientation.EAST);
            this.isAdditional.setInnerGap(5);
        }
        this.hideOnLabel = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.HIDE_ON_LABEL, TitledItem.TitledItemOrientation.EAST);
        this.hideOnLabel.setInnerGap(5);
        this.cycle = new TitledItem<RDTextField>(new RDTextField(provider, TextFieldType.NORMAL), Words.CYCLE, TitledItem.TitledItemOrientation.NORTH);
        this.cycle.getElement().setOverrideName(ProductAccess.CYCLE);
        this.cycleInfo = new InfoButton(SizedSkin1Field.SkinSize.MEDIUM);
        this.cycleInfo.installStringViewer(ProductToolkit.getCycleDescriptionString());
        this.mealType = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(MealTypeConverter.class), true, true), Words.MEAL_TYPE, TitledItem.TitledItemOrientation.NORTH);
        if (Boolean.TRUE.equals(this.viewSettings.getShowProductExcludeFromReporting())) {
            this.excludeFromReporting = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.EXCLUDE_FROM_REPORTING, TitledItem.TitledItemOrientation.EAST);
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowProductUseByOtherCustomers())) {
            this.excludeFromCanBeUsedByOtherCustomers = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.EXCLUDE_FROM_CAN_BE_USED_BY_OTHER_CUSTOMER, TitledItem.TitledItemOrientation.EAST);
        }
        if (Boolean.TRUE.equals(this.settings.getUseMasterDataForProductGroupNames())) {
            this.useMasterDataForProductGroupTypes = new TitledItem<RDCheckBox>(new RDCheckBox(provider), "Use Drop Down for Group Names", TitledItem.TitledItemOrientation.EAST);
        }
        this.takeKonterProbe = new TitledItem<RDCheckBox>(new RDCheckBox(provider), "Take Konter Probe", TitledItem.TitledItemOrientation.EAST);
        if (Boolean.TRUE.equals(this.viewSettings.getShowProductDeliveryUnit())) {
            this.deliveryUnit = CompanyUtil.isFPB((SystemSettingsComplete)this.settings) ? new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(UnitConverter.class), true), Words.UNIT_ON_DELIVERY_SLIP_FOR_ONE_PRODUCT, TitledItem.TitledItemOrientation.NORTH) : new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(UnitConverter.class), true), Words.DELIVERY_UNIT, TitledItem.TitledItemOrientation.NORTH);
        }
        if (Boolean.TRUE.equals(this.viewSettings.getProductShowLabelUnit())) {
            this.labelUnit = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(UnitConverter.class), true), "Label Unit", TitledItem.TitledItemOrientation.NORTH);
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowProductPackSize())) {
            this.packSize = new TitledItem<RDTextField>(new RDTextField(provider, TextFieldType.INT_NULLABLE), Words.PACK_SIZE, TitledItem.TitledItemOrientation.NORTH);
            this.productsPerLabel = new TitledItem<RDTextField>(new RDTextField(provider, TextFieldType.INT_NULLABLE), Words.ITEMS_PER_LABELS, TitledItem.TitledItemOrientation.NORTH);
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowProductLabelTags())) {
            this.labelTags = new TitledItem<RDMultiLabelTagSelectionComboBox>(new RDMultiLabelTagSelectionComboBox(provider), "Label Tags", TitledItem.TitledItemOrientation.NORTH);
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowProductExpiryDate())) {
            this.useExpiryDate = new RDCheckBox(provider);
            this.useExpiryDate.addButtonListener(this);
            this.defaultExpiryDate = new TitledItem<RDTextField>(new RDTextField(provider, TextFieldType.INT_NULLABLE), "Expiry Days", TitledItem.TitledItemOrientation.NORTH);
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowProductSalesComponent())) {
            this.salesComponentQuantity = new TitledItem<RDInputComboBox>(new RDInputComboBox(provider, InputComboBox.InputComboBoxType.PRICE_DOUBLE), "Sales Component Qty", TitledItem.TitledItemOrientation.NORTH);
            this.salesComponentName = new TitledItem<RDTextField>(new RDTextField(provider), "Sales Product Name", TitledItem.TitledItemOrientation.NORTH);
            this.salesComponentPrice = new TitledItem<RDInputComboBox>(new RDInputComboBox(provider, InputComboBox.InputComboBoxType.PRICE_DOUBLE), "Sales Product Price", TitledItem.TitledItemOrientation.NORTH);
            this.salesComponentQuantity.getElement().setOverrideName(ProductVariantComplete_.productSalesComponent);
            this.salesComponentName.getElement().setOverrideName(ProductVariantComplete_.productSalesComponent);
            this.salesComponentPrice.getElement().setOverrideName(ProductVariantComplete_.productSalesComponent);
        }
        this.setCustomLayouter(new Layout());
        this.addToView(this.department);
        this.addToView(this.paxMealType);
        this.addToView(this.cabinClass);
        this.addToView(this.serviceType);
        this.addToView(this.specialMealType);
        this.addToView(this.haulType);
        this.addToView(this.takeKonterProbe);
        if (this.labelTags != null) {
            this.addToView(this.labelTags);
        }
        if (this.excludeFromCanBeUsedByOtherCustomers != null) {
            this.addToView(this.excludeFromCanBeUsedByOtherCustomers);
        }
        if (this.useMasterDataForProductGroupTypes != null) {
            this.addToView(this.useMasterDataForProductGroupTypes);
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowProductAircraft())) {
            this.addToView(this.aircraftType);
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowProductDefaultTray())) {
            this.addToView(this.defaultTray);
        }
        if (this.defaultLabelColor != null) {
            this.addToView(this.defaultLabelColor);
        }
        this.addToView(this.inout);
        if (this.isAdditional != null) {
            this.addToView(this.isAdditional);
        }
        this.addToView(this.hideOnLabel);
        this.addToView(this.cycle);
        this.addToView(this.cycleInfo);
        if (Boolean.TRUE.equals(this.viewSettings.getShowProductLabeledInCatalog())) {
            this.addToView(this.labeled);
        }
        if (this.alwaysOnDeliverySlip != null) {
            this.addToView(this.alwaysOnDeliverySlip);
        }
        this.addToView(this.mealType);
        if (this.nominated != null) {
            this.addToView(this.nominated);
        }
        if (this.showOnDailyOps != null) {
            this.addToView(this.showOnDailyOps);
        }
        this.addToView(this.productType);
        this.addToView(this.productToMealMultiplier);
        this.addToView(this.specialMeal);
        this.addToView(this.alaCarte);
        this.addToView(this.standard);
        this.addToView(this.sep1);
        if (this.excludeFromReporting != null) {
            this.addToView(this.excludeFromReporting);
        }
        this.addToView(this.netWeight);
        this.addToView(this.grossWeight);
        if (Boolean.TRUE.equals(this.viewSettings.getShowProductDeliveryUnit())) {
            this.addToView(this.deliveryUnit);
        }
        if (Boolean.TRUE.equals(this.viewSettings.getProductShowLabelUnit())) {
            this.addToView(this.labelUnit);
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowProductPackSize())) {
            this.addToView(this.packSize);
            this.addToView(this.productsPerLabel);
        }
        if (this.useExpiryDate != null) {
            this.addToView(this.useExpiryDate);
            this.addToView(this.defaultExpiryDate);
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowProductSalesComponent())) {
            this.addToView(this.salesComponentName);
            this.addToView(this.salesComponentPrice);
            this.addToView(this.salesComponentQuantity);
        }
    }

    @Override
    public DtoField<ModificationStateE> getStateChildName() {
        return ProductVariantLight_.state;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.cabinClass.getElement().setNode(node.getChildNamed(ProductVariantComplete_.cabinClasses));
        this.serviceType.getElement().setNode(node.getChildNamed(ProductVariantComplete_.serviceTypes));
        if (Boolean.TRUE.equals(this.viewSettings.getShowProductDefaultTray())) {
            this.defaultTray.getElement().setNode(node.getChildNamed(ProductVariantComplete_.defaultInsertType));
            this.defaultTray.getElement().refreshPossibleValues(NodeToolkit.getAffixList(GalleyEquipmentInsertTypeComplete.class));
        }
        if (this.defaultLabelColor != null) {
            this.defaultLabelColor.getElement().setNode(node.getChildNamed(ProductVariantComplete_.defaultLabelColor));
            this.defaultLabelColor.getElement().refreshPossibleValues(NodeToolkit.getAffixList(ColorComplete.class));
        }
        this.haulType.getElement().setNode(node.getChildNamed(ProductVariantComplete_.haulTypes));
        if (this.labelTags != null) {
            this.labelTags.getElement().setNode(node.getChildNamed(ProductVariantComplete_.labelTags));
        }
        this.takeKonterProbe.getElement().setNode(node.getChildNamed(ProductVariantComplete_.takeKonterProbe));
        if (this.excludeFromCanBeUsedByOtherCustomers != null) {
            this.excludeFromCanBeUsedByOtherCustomers.getElement().setNode(node.getChildNamed(ProductVariantLight_.excludeFromCanBeUseFromOtherCustomers));
        }
        if (this.useMasterDataForProductGroupTypes != null) {
            this.useMasterDataForProductGroupTypes.getElement().setNode(node.getChildNamed(ProductVariantLight_.useMasterDataForProductGroupTypes));
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowProductAircraft())) {
            this.aircraftType.getElement().setNode(node.getChildNamed(ProductVariantComplete_.aircraftType));
        }
        this.inout.getElement().setNode(node.getChildNamed(ProductVariantComplete_.boundDirection));
        if (this.isAdditional != null) {
            this.isAdditional.getElement().setNode(node.getChildNamed(ProductVariantComplete_.additional));
        }
        this.hideOnLabel.getElement().setNode(node.getChildNamed(ProductVariantLight_.hideOnLabel));
        this.cycle.getElement().setNode(node.getChildNamed(ProductVariantComplete_.productCycle));
        if (Boolean.TRUE.equals(this.viewSettings.getShowProductLabeledInCatalog())) {
            this.labeled.getElement().setNode(node.getChildNamed(ProductVariantComplete_.labeled));
        }
        if (this.alwaysOnDeliverySlip != null) {
            this.alwaysOnDeliverySlip.getElement().setNode(node.getChildNamed(ProductVariantComplete_.alwaysOnDeliverySlip));
        }
        this.productType.getElement().setNode(node.getChildNamed(ProductVariantLight_.productType));
        this.productType.getElement().refreshPossibleValues(NodeToolkit.getAffixList(ProductTypeComplete.class));
        this.productToMealMultiplier.getElement().setNode(node.getChildNamed(ProductVariantLight_.productToMealMultiplier));
        this.mealType.getElement().setNode(node.getChildNamed(ProductVariantComplete_.mealType));
        this.mealType.getElement().refreshPossibleValues(NodeToolkit.getAffixList(MealTypeComplete.class));
        this.department.getElement().setNode(node.getChildNamed(ProductVariantComplete_.department));
        this.department.getElement().refreshPossibleValues(ComboBoxFactory.filterDepartmentsAll(NodeToolkit.getAffixList(InternalCostCenterComplete.class), node.getChildNamed(ProductVariantComplete_.department), ComboBoxFactory.DepartmentType.PRODUCT_UNIT));
        this.paxMealType.getElement().setNode(node.getChildNamed(ProductVariantComplete_.paxMealType));
        this.paxMealType.getElement().refreshPossibleValues(NodeToolkit.getAffixList(PaxMealTypeComplete.class));
        if (this.excludeFromReporting != null) {
            this.excludeFromReporting.getElement().setNode(node.getChildNamed(ProductVariantLight_.excludeFromReporting));
        }
        if (this.nominated != null) {
            this.nominated.getElement().setNode(node.getChildNamed(ProductVariantLight_.nominated));
        }
        this.specialMeal.getElement().setNode(node.getChildNamed(ProductVariantLight_.spmlProduct));
        this.alaCarte.getElement().setNode(node.getChildNamed(ProductVariantLight_.alaCarteProduct));
        this.standard.getElement().setNode(node.getChildNamed(ProductVariantLight_.standardProduct));
        this.configToMergedMenuTypeList();
        this.netWeight.getElement().setNode(node.getChildNamed(ProductVariantComplete_.nettoWeight));
        this.grossWeight.getElement().setNode(node.getChildNamed(ProductVariantComplete_.bruttoWeight));
        this.specialMealType.getElement().setNode(node.getChildNamed(ProductVariantComplete_.menuTypes));
        if (this.showOnDailyOps != null) {
            this.showOnDailyOps.getElement().setNode(node.getChildNamed(ProductVariantComplete_.showOnDailyOpsSheet));
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowProductDeliveryUnit())) {
            this.deliveryUnit.getElement().setNode(node.getChildNamed(ProductVariantComplete_.deliveryUnit));
            this.deliveryUnit.getElement().refreshPossibleValues(NodeToolkit.getAffixList(UnitComplete.class));
        }
        if (Boolean.TRUE.equals(this.viewSettings.getProductShowLabelUnit())) {
            this.labelUnit.getElement().setNode(node.getChildNamed(ProductVariantComplete_.labelUnit));
            this.labelUnit.getElement().refreshPossibleValues(NodeToolkit.getAffixList(UnitComplete.class));
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowProductPackSize())) {
            this.packSize.getElement().setNode(node.getChildNamed(ProductVariantComplete_.packSize));
            this.productsPerLabel.getElement().setNode(node.getChildNamed(ProductVariantComplete_.productsPerLabel));
        }
        if (this.useExpiryDate != null) {
            this.useExpiryDate.setNode(node.getChildNamed(ProductVariantLight_.useExpiryDate));
            this.defaultExpiryDate.getElement().setNode(node.getChildNamed(ProductVariantLight_.defaultExpiryDate));
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowProductSalesComponent())) {
            ProductVariantComplete variant = (ProductVariantComplete)node.getValue(ProductVariantComplete.class);
            if (variant.getProductSalesComponent() == null) {
                ProductSalesComponentComplete comp = new ProductSalesComponentComplete();
                comp.setClientOId(Long.valueOf(ADTO.getNextId()));
                comp.setComponentQuantity(new QuantityComplete(Double.valueOf(0.0), this.settings.getPieceUnit()));
                comp.setSalesProductPrice(new PriceComplete(this.settings.getCurrency(), Double.valueOf(0.0)));
                comp.setSalesProductName("");
                variant.setProductSalesComponent(comp);
            }
            this.salesComponentPrice.getElement().setNode(node.getChildNamed(new DtoField[]{ProductVariantComplete_.productSalesComponent, ProductSalesComponentComplete_.salesProductPrice, PriceComplete_.price}), node.getChildNamed(new DtoField[]{ProductVariantComplete_.productSalesComponent, ProductSalesComponentComplete_.salesProductPrice, PriceComplete_.currency}));
            this.salesComponentQuantity.getElement().setNode(node.getChildNamed(new DtoField[]{ProductVariantComplete_.productSalesComponent, ProductSalesComponentComplete_.componentQuantity, QuantityComplete_.quantity}), node.getChildNamed(new DtoField[]{ProductVariantComplete_.productSalesComponent, ProductSalesComponentComplete_.componentQuantity, QuantityComplete_.unit}));
            this.salesComponentName.getElement().setNode(node.getChildNamed(new DtoField[]{ProductVariantComplete_.productSalesComponent, ProductSalesComponentComplete_.salesProductName}));
        }
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        super.buttonPressed(source, x, y);
        if (source == this.standard.getElement().getEditor()) {
            this.configToMergedMenuTypeList();
        } else if (source == this.specialMeal.getElement().getEditor()) {
            this.configToMergedMenuTypeList();
        } else if (source == this.alaCarte.getElement().getEditor()) {
            this.configToMergedMenuTypeList();
        } else {
            this.setEnabled(this.isEnabled());
        }
    }

    private void configToMergedMenuTypeList() {
        this.createMergedList();
    }

    private Node createMergedList() {
        ViewNode list = new ViewNode(DtoFieldConstants.PRODUCT_MENU_TYPES.getFieldName());
        list.setName(DtoFieldConstants.PRODUCT_MENU_TYPES);
        if (Boolean.TRUE.equals(this.node.getChildNamed(ProductVariantLight_.spmlProduct).getValue())) {
            for (SpecialMenuTypeComplete specialMenuTypeComplete : (List)NodeToolkit.getAffixList(SpecialMenuTypeComplete.class).getValue()) {
                list.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)specialMenuTypeComplete, true, true), 0L);
            }
        }
        if (Boolean.TRUE.equals(this.node.getChildNamed(ProductVariantLight_.alaCarteProduct).getValue())) {
            for (SpecialMenuTypeComplete specialMenuTypeComplete : (List)NodeToolkit.getAffixList(AlaCarteMenuTypeComplete.class).getValue()) {
                list.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)specialMenuTypeComplete, true, true), 0L);
            }
        }
        NodeToolkit.removeAffixNamed((String)DtoFieldConstants.PRODUCT_MENU_TYPES.getFieldName());
        NodeToolkit.addAffix((Node)list);
        return list;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.standard);
        CheckedListAdder.addToList(focusList, this.specialMeal);
        CheckedListAdder.addToList(focusList, this.alaCarte);
        CheckedListAdder.addToList(focusList, this.cabinClass);
        CheckedListAdder.addToList(focusList, this.inout);
        CheckedListAdder.addToList(focusList, this.aircraftType);
        CheckedListAdder.addToList(focusList, this.haulType);
        CheckedListAdder.addToList(focusList, this.serviceType);
        CheckedListAdder.addToList(focusList, this.specialMealType);
        CheckedListAdder.addToList(focusList, this.isAdditional);
        CheckedListAdder.addToList(focusList, this.hideOnLabel);
        CheckedListAdder.addToList(focusList, this.defaultTray);
        CheckedListAdder.addToList(focusList, this.defaultLabelColor);
        CheckedListAdder.addToList(focusList, this.mealType);
        CheckedListAdder.addToList(focusList, this.labeled);
        CheckedListAdder.addToList(focusList, this.alwaysOnDeliverySlip);
        CheckedListAdder.addToList(focusList, this.excludeFromReporting);
        CheckedListAdder.addToList(focusList, this.nominated);
        CheckedListAdder.addToList(focusList, this.showOnDailyOps);
        CheckedListAdder.addToList(focusList, this.excludeFromCanBeUsedByOtherCustomers);
        CheckedListAdder.addToList(focusList, this.takeKonterProbe);
        CheckedListAdder.addToList(focusList, this.useMasterDataForProductGroupTypes);
        CheckedListAdder.addToList(focusList, this.cycle);
        CheckedListAdder.addToList(focusList, this.labelUnit);
        CheckedListAdder.addToList(focusList, this.netWeight);
        CheckedListAdder.addToList(focusList, this.grossWeight);
        CheckedListAdder.addToList(focusList, this.productType);
        CheckedListAdder.addToList(focusList, this.productToMealMultiplier);
        CheckedListAdder.addToList(focusList, this.department);
        CheckedListAdder.addToList(focusList, this.paxMealType);
        CheckedListAdder.addToList(focusList, this.deliveryUnit);
        CheckedListAdder.addToList(focusList, this.packSize);
        CheckedListAdder.addToList(focusList, this.useExpiryDate);
        CheckedListAdder.addToList(focusList, this.defaultExpiryDate);
        CheckedListAdder.addToList(focusList, this.productsPerLabel);
        CheckedListAdder.addToList(focusList, this.labelTags);
        CheckedListAdder.addToList(focusList, this.salesComponentQuantity);
        CheckedListAdder.addToList(focusList, this.salesComponentName);
        CheckedListAdder.addToList(focusList, this.salesComponentPrice);
        return focusList;
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean isDraft = this.isStateDraft();
        boolean enabled = isEnabled && isDraft;
        super.setEnabled(enabled);
        this.standard.setEnabled(enabled && this.isMenuSelectable);
        this.specialMeal.setEnabled(enabled && this.isMenuSelectable);
        this.alaCarte.setEnabled(enabled && this.isMenuSelectable);
        this.cabinClass.setEnabled(enabled);
        this.serviceType.setEnabled(enabled);
        this.specialMealType.setEnabled(enabled);
        this.haulType.setEnabled(enabled);
        if (this.useMasterDataForProductGroupTypes != null) {
            this.useMasterDataForProductGroupTypes.setEnabled(enabled);
        }
        if (this.labelTags != null) {
            this.labelTags.setEnabled(enabled);
        }
        this.inout.setEnabled(enabled);
        if (this.aircraftType != null) {
            this.aircraftType.setEnabled(enabled);
        }
        if (this.isAdditional != null) {
            this.isAdditional.setEnabled(enabled);
        }
        this.hideOnLabel.setEnabled(enabled);
        if (this.defaultTray != null) {
            this.defaultTray.setEnabled(enabled);
        }
        if (this.defaultLabelColor != null) {
            this.defaultLabelColor.setEnabled(enabled);
            this.cycle.setEnabled(enabled);
        }
        this.cycleInfo.setEnabled(enabled);
        if (this.labeled != null) {
            this.labeled.setEnabled(enabled);
        }
        if (this.alwaysOnDeliverySlip != null) {
            this.alwaysOnDeliverySlip.setEnabled(enabled);
        }
        this.mealType.setEnabled(enabled);
        if (this.excludeFromReporting != null) {
            this.excludeFromReporting.setEnabled(enabled);
        }
        if (this.nominated != null) {
            this.nominated.setEnabled(enabled);
        }
        if (this.showOnDailyOps != null) {
            this.showOnDailyOps.setEnabled(enabled);
        }
        if (this.excludeFromCanBeUsedByOtherCustomers != null) {
            this.excludeFromCanBeUsedByOtherCustomers.setEnabled(enabled);
        }
        this.takeKonterProbe.setEnabled(enabled);
        this.netWeight.setEnabled(enabled);
        this.grossWeight.setEnabled(enabled);
        if (this.deliveryUnit != null) {
            this.deliveryUnit.setEnabled(enabled);
        }
        if (this.labelUnit != null) {
            this.labelUnit.setEnabled(enabled);
        }
        this.productType.setEnabled(enabled);
        this.productToMealMultiplier.setEnabled(enabled);
        this.department.setEnabled(enabled);
        this.paxMealType.setEnabled(enabled);
        if (this.packSize != null) {
            this.packSize.setEnabled(enabled);
            this.productsPerLabel.setEnabled(enabled);
        }
        if (this.useExpiryDate != null) {
            this.useExpiryDate.setEnabled(enabled);
            this.defaultExpiryDate.setEnabled(enabled && this.useExpiryDate.isChecked());
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowProductSalesComponent())) {
            this.salesComponentQuantity.setEnabled(isEnabled);
            this.salesComponentName.setEnabled(isEnabled);
            this.salesComponentPrice.setEnabled(isEnabled);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.cabinClass.kill();
        this.serviceType.kill();
        this.specialMealType.kill();
        this.haulType.kill();
        if (this.aircraftType != null) {
            this.aircraftType.kill();
        }
        if (this.isAdditional != null) {
            this.isAdditional.kill();
        }
        this.hideOnLabel.kill();
        this.inout.kill();
        this.cycle.kill();
        this.cycleInfo.kill();
        if (this.labeled != null) {
            this.labeled.kill();
        }
        if (this.labelTags != null) {
            this.labelTags.kill();
        }
        this.labelTags = null;
        if (this.alwaysOnDeliverySlip != null) {
            this.alwaysOnDeliverySlip.kill();
        }
        this.standard.kill();
        this.alaCarte.kill();
        this.specialMeal.kill();
        if (this.excludeFromReporting != null) {
            this.excludeFromReporting.kill();
        }
        this.productType.kill();
        this.productToMealMultiplier.kill();
        if (this.nominated != null) {
            this.nominated.kill();
        }
        if (this.showOnDailyOps != null) {
            this.showOnDailyOps.kill();
        }
        if (this.excludeFromCanBeUsedByOtherCustomers != null) {
            this.excludeFromCanBeUsedByOtherCustomers.kill();
        }
        this.takeKonterProbe.kill();
        this.takeKonterProbe = null;
        this.department.kill();
        this.paxMealType.kill();
        this.netWeight.kill();
        this.grossWeight.kill();
        if (this.useMasterDataForProductGroupTypes != null) {
            this.useMasterDataForProductGroupTypes.kill();
        }
        if (this.deliveryUnit != null) {
            this.deliveryUnit.kill();
        }
        if (this.labelUnit != null) {
            this.labelUnit.kill();
        }
        if (this.defaultTray != null) {
            this.defaultTray.kill();
        }
        if (this.defaultLabelColor != null) {
            this.defaultLabelColor.kill();
        }
        if (this.packSize != null) {
            this.packSize.kill();
        }
        if (this.productsPerLabel != null) {
            this.productsPerLabel.kill();
        }
        if (this.useExpiryDate != null) {
            this.useExpiryDate.kill();
            this.defaultExpiryDate.kill();
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowProductSalesComponent())) {
            this.salesComponentQuantity.kill();
            this.salesComponentName.kill();
            this.salesComponentPrice.kill();
            this.salesComponentQuantity = null;
            this.salesComponentName = null;
            this.salesComponentPrice = null;
        }
        this.excludeFromCanBeUsedByOtherCustomers = null;
        this.inout = null;
        this.cabinClass = null;
        this.paxMealType = null;
        this.serviceType = null;
        this.specialMealType = null;
        this.haulType = null;
        this.aircraftType = null;
        this.isAdditional = null;
        this.hideOnLabel = null;
        this.cycle = null;
        this.cycleInfo = null;
        this.labeled = null;
        this.alwaysOnDeliverySlip = null;
        this.mealType = null;
        this.standard = null;
        this.alaCarte = null;
        this.specialMeal = null;
        this.standard = null;
        this.specialMeal = null;
        this.alaCarte = null;
        this.excludeFromReporting = null;
        this.productType = null;
        this.productToMealMultiplier = null;
        this.nominated = null;
        this.showOnDailyOps = null;
        this.department = null;
        this.netWeight = null;
        this.grossWeight = null;
        this.deliveryUnit = null;
        this.labelUnit = null;
        this.defaultTray = null;
        this.defaultLabelColor = null;
        this.packSize = null;
        this.productsPerLabel = null;
        this.useMasterDataForProductGroupTypes = null;
        this.useExpiryDate = null;
        this.defaultExpiryDate = null;
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        Integer count;
        ArrayList<ScreenValidationObject> o = new ArrayList<ScreenValidationObject>();
        if (this.productType.getElement().getNode().getValue() != null) {
            if (this.productToMealMultiplier.getElement().isWritable() && ((count = (Integer)this.productToMealMultiplier.getElement().getNode().getValue()) == null || count == 0)) {
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_ITEM_PER_PRODUCT_IS_GREATER_OR_EQUALS_TO_ONE));
            }
        } else if (this.productToMealMultiplier.getElement().isWritable() && (count = (Integer)this.productToMealMultiplier.getElement().getNode().getValue()) != null && count != 0) {
            o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_ITEM_PER_PRODUCT_IS_EQUALS_ZERO));
        }
        if (this.specialMeal.getElement().isChecked()) {
            boolean add = true;
            if (this.node.getChildNamed(ProductVariantLight_.menuTypes).getValue() == null) {
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.NO_MENU_TYPE_FOR_SPML_SELECTED));
            } else {
                add = this.isAdditional((List)this.node.getChildNamed(ProductVariantLight_.menuTypes).getValue());
            }
            if (this.node.getChildNamed(ProductVariantLight_.cabinClasses).getChildCount() == 0) {
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.NO_CABIN_CLASS_FOR_SPML_SELECTED));
            }
            if (!add && this.node.getChildNamed(ProductVariantLight_.mealType).getValue() == null) {
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.NO_MEAL_TYPE_FOR_SPML_SELECTED));
            }
            if (!add && this.node.getChildNamed(ProductVariantLight_.serviceTypes).getChildCount() == 0) {
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.NO_SERVICE_TYPE_FOR_SPML_SELECTED));
            }
        } else if (this.alaCarte.getElement().isChecked()) {
            if (this.node.getChildNamed(ProductVariantLight_.menuTypes).getValue() == null) {
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.NO_MENU_TYPE_FOR_ALACARTE_SELECTED));
            }
            if (this.node.getChildNamed(ProductVariantLight_.cabinClasses).getChildCount() == 0) {
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.NO_CABIN_CLASS_FOR_ALACARTE_SELECTED));
            }
            if (this.node.getChildNamed(ProductVariantLight_.mealType).getValue() == null) {
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.NO_MEAL_TYPE_FOR_ALACARTE_SELECTED));
            }
            if (this.node.getChildNamed(ProductVariantLight_.serviceTypes).getChildCount() == 0) {
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.NO_SERVICE_TYPE_FOR_ALACARTE_SELECTED));
            }
        }
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        if (Boolean.TRUE.equals(settings.getProductDefaultDepartmentMandatory()) && this.department.getElement().isWritable() && this.department.getElement().getNode().getValue() == null) {
            o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.DEFAULT_DEPARTMENT_MUST_BE_SET));
            this.department.getElement().setInvalid();
        }
        return o;
    }

    private boolean isAdditional(List<AMenuTypeComplete> specialMenuTypeComplete) {
        for (AMenuTypeComplete aMenuTypeComplete : specialMenuTypeComplete) {
            SpecialMenuTypeComplete specialMealType;
            if (!(aMenuTypeComplete instanceof SpecialMenuTypeComplete) || !Boolean.TRUE.equals((specialMealType = (SpecialMenuTypeComplete)aMenuTypeComplete).getAdditional())) continue;
            return true;
        }
        return false;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int yColumn1 = VariantSpecificationsDetailsPanelPart2.this.verticalBorder;
            int yColumn2 = VariantSpecificationsDetailsPanelPart2.this.verticalBorder;
            int w = parent.getWidth();
            int w2tl = (w - (2 * VariantSpecificationsDetailsPanelPart2.this.horizontalBorder + VariantSpecificationsDetailsPanelPart2.this.inner_horizontalBorder)) / 2;
            VariantSpecificationsDetailsPanelPart2.this.standard.setLocation(VariantSpecificationsDetailsPanelPart2.this.horizontalBorder, yColumn1);
            VariantSpecificationsDetailsPanelPart2.this.standard.setSize(VariantSpecificationsDetailsPanelPart2.this.standard.getPreferredSize());
            yColumn1 = VariantSpecificationsDetailsPanelPart2.this.standard.getY() + VariantSpecificationsDetailsPanelPart2.this.standard.getHeight() + VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            VariantSpecificationsDetailsPanelPart2.this.specialMeal.setLocation(VariantSpecificationsDetailsPanelPart2.this.horizontalBorder, yColumn1);
            VariantSpecificationsDetailsPanelPart2.this.specialMeal.setSize(VariantSpecificationsDetailsPanelPart2.this.specialMeal.getPreferredSize());
            yColumn1 = VariantSpecificationsDetailsPanelPart2.this.specialMeal.getY() + VariantSpecificationsDetailsPanelPart2.this.specialMeal.getHeight() + VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            VariantSpecificationsDetailsPanelPart2.this.alaCarte.setLocation(VariantSpecificationsDetailsPanelPart2.this.horizontalBorder, yColumn1);
            VariantSpecificationsDetailsPanelPart2.this.alaCarte.setSize(VariantSpecificationsDetailsPanelPart2.this.alaCarte.getPreferredSize());
            yColumn1 = VariantSpecificationsDetailsPanelPart2.this.alaCarte.getY() + VariantSpecificationsDetailsPanelPart2.this.alaCarte.getHeight() + VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            VariantSpecificationsDetailsPanelPart2.this.sep1.setLocation(0, yColumn1);
            VariantSpecificationsDetailsPanelPart2.this.sep1.setSize(parent.getWidth(), (int)VariantSpecificationsDetailsPanelPart2.this.sep1.getPreferredSize().getHeight());
            yColumn2 = yColumn1 = VariantSpecificationsDetailsPanelPart2.this.sep1.getY() + VariantSpecificationsDetailsPanelPart2.this.sep1.getHeight() + VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            VariantSpecificationsDetailsPanelPart2.this.cabinClass.setLocation(VariantSpecificationsDetailsPanelPart2.this.horizontalBorder, yColumn1);
            VariantSpecificationsDetailsPanelPart2.this.cabinClass.setSize(w2tl, (int)VariantSpecificationsDetailsPanelPart2.this.cabinClass.getPreferredSize().getHeight());
            VariantSpecificationsDetailsPanelPart2.this.inout.setLocation(VariantSpecificationsDetailsPanelPart2.this.cabinClass.getX() + VariantSpecificationsDetailsPanelPart2.this.cabinClass.getWidth() + VariantSpecificationsDetailsPanelPart2.this.inner_horizontalBorder, yColumn2);
            VariantSpecificationsDetailsPanelPart2.this.inout.setSize(w2tl, (int)VariantSpecificationsDetailsPanelPart2.this.inout.getPreferredSize().getHeight());
            yColumn2 = yColumn1 = VariantSpecificationsDetailsPanelPart2.this.cabinClass.getY() + VariantSpecificationsDetailsPanelPart2.this.cabinClass.getHeight() + VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            if (VariantSpecificationsDetailsPanelPart2.this.aircraftType != null) {
                VariantSpecificationsDetailsPanelPart2.this.aircraftType.setLocation(VariantSpecificationsDetailsPanelPart2.this.horizontalBorder, yColumn1);
                VariantSpecificationsDetailsPanelPart2.this.aircraftType.setSize(w2tl, (int)VariantSpecificationsDetailsPanelPart2.this.aircraftType.getPreferredSize().getHeight());
                yColumn1 = VariantSpecificationsDetailsPanelPart2.this.aircraftType.getY() + VariantSpecificationsDetailsPanelPart2.this.aircraftType.getHeight() + VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            }
            VariantSpecificationsDetailsPanelPart2.this.haulType.setLocation(VariantSpecificationsDetailsPanelPart2.this.cabinClass.getX() + VariantSpecificationsDetailsPanelPart2.this.cabinClass.getWidth() + VariantSpecificationsDetailsPanelPart2.this.inner_horizontalBorder, yColumn2);
            VariantSpecificationsDetailsPanelPart2.this.haulType.setSize(w2tl, (int)VariantSpecificationsDetailsPanelPart2.this.haulType.getPreferredSize().getHeight());
            yColumn2 = VariantSpecificationsDetailsPanelPart2.this.haulType.getY() + VariantSpecificationsDetailsPanelPart2.this.haulType.getHeight() + VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            VariantSpecificationsDetailsPanelPart2.this.serviceType.setLocation(VariantSpecificationsDetailsPanelPart2.this.horizontalBorder, yColumn1);
            VariantSpecificationsDetailsPanelPart2.this.serviceType.setSize(w2tl, (int)VariantSpecificationsDetailsPanelPart2.this.serviceType.getPreferredSize().getHeight());
            yColumn1 = VariantSpecificationsDetailsPanelPart2.this.serviceType.getY() + VariantSpecificationsDetailsPanelPart2.this.serviceType.getHeight() + VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            VariantSpecificationsDetailsPanelPart2.this.specialMealType.setLocation(VariantSpecificationsDetailsPanelPart2.this.serviceType.getX() + VariantSpecificationsDetailsPanelPart2.this.serviceType.getWidth() + VariantSpecificationsDetailsPanelPart2.this.inner_horizontalBorder, yColumn2);
            VariantSpecificationsDetailsPanelPart2.this.specialMealType.setSize(w2tl, (int)VariantSpecificationsDetailsPanelPart2.this.specialMealType.getPreferredSize().getHeight());
            yColumn2 = VariantSpecificationsDetailsPanelPart2.this.specialMealType.getY() + VariantSpecificationsDetailsPanelPart2.this.specialMealType.getHeight() + VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            if (VariantSpecificationsDetailsPanelPart2.this.isAdditional != null) {
                VariantSpecificationsDetailsPanelPart2.this.isAdditional.setLocation(VariantSpecificationsDetailsPanelPart2.this.horizontalBorder, yColumn1 + 3);
                VariantSpecificationsDetailsPanelPart2.this.isAdditional.setSize(VariantSpecificationsDetailsPanelPart2.this.isAdditional.getPreferredSize());
                yColumn1 = VariantSpecificationsDetailsPanelPart2.this.isAdditional.getY() + VariantSpecificationsDetailsPanelPart2.this.isAdditional.getHeight() + VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            }
            VariantSpecificationsDetailsPanelPart2.this.hideOnLabel.setLocation(VariantSpecificationsDetailsPanelPart2.this.horizontalBorder, yColumn1 + 3);
            VariantSpecificationsDetailsPanelPart2.this.hideOnLabel.setSize(VariantSpecificationsDetailsPanelPart2.this.hideOnLabel.getPreferredSize());
            yColumn1 = VariantSpecificationsDetailsPanelPart2.this.hideOnLabel.getY() + VariantSpecificationsDetailsPanelPart2.this.hideOnLabel.getHeight() + VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            VariantSpecificationsDetailsPanelPart2.this.mealType.setLocation(VariantSpecificationsDetailsPanelPart2.this.specialMealType.getX(), yColumn2);
            VariantSpecificationsDetailsPanelPart2.this.mealType.setSize(w2tl, (int)VariantSpecificationsDetailsPanelPart2.this.mealType.getPreferredSize().getHeight());
            yColumn2 = VariantSpecificationsDetailsPanelPart2.this.mealType.getY() + VariantSpecificationsDetailsPanelPart2.this.mealType.getHeight() + VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            if (VariantSpecificationsDetailsPanelPart2.this.defaultTray != null) {
                VariantSpecificationsDetailsPanelPart2.this.defaultTray.setLocation(VariantSpecificationsDetailsPanelPart2.this.specialMealType.getX(), VariantSpecificationsDetailsPanelPart2.this.mealType.getY() + VariantSpecificationsDetailsPanelPart2.this.mealType.getHeight() + VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder);
                VariantSpecificationsDetailsPanelPart2.this.defaultTray.setSize(w2tl, (int)VariantSpecificationsDetailsPanelPart2.this.defaultTray.getPreferredSize().getHeight());
                yColumn2 = VariantSpecificationsDetailsPanelPart2.this.defaultTray.getY() + VariantSpecificationsDetailsPanelPart2.this.defaultTray.getHeight() + VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            }
            if (VariantSpecificationsDetailsPanelPart2.this.defaultLabelColor != null) {
                VariantSpecificationsDetailsPanelPart2.this.defaultLabelColor.setLocation(VariantSpecificationsDetailsPanelPart2.this.inout.getX(), yColumn2);
                VariantSpecificationsDetailsPanelPart2.this.defaultLabelColor.setSize(w2tl, (int)VariantSpecificationsDetailsPanelPart2.this.defaultLabelColor.getPreferredSize().getHeight());
                yColumn2 = VariantSpecificationsDetailsPanelPart2.this.defaultLabelColor.getY() + VariantSpecificationsDetailsPanelPart2.this.defaultLabelColor.getHeight() + VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            }
            if (VariantSpecificationsDetailsPanelPart2.this.labeled != null) {
                VariantSpecificationsDetailsPanelPart2.this.labeled.setLocation(VariantSpecificationsDetailsPanelPart2.this.serviceType.getX(), yColumn1);
                VariantSpecificationsDetailsPanelPart2.this.labeled.setSize(VariantSpecificationsDetailsPanelPart2.this.labeled.getPreferredSize());
                yColumn1 = VariantSpecificationsDetailsPanelPart2.this.labeled.getY() + VariantSpecificationsDetailsPanelPart2.this.labeled.getHeight() + VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            }
            if (VariantSpecificationsDetailsPanelPart2.this.alwaysOnDeliverySlip != null) {
                VariantSpecificationsDetailsPanelPart2.this.alwaysOnDeliverySlip.setLocation(VariantSpecificationsDetailsPanelPart2.this.serviceType.getX(), yColumn1);
                VariantSpecificationsDetailsPanelPart2.this.alwaysOnDeliverySlip.setSize(VariantSpecificationsDetailsPanelPart2.this.alwaysOnDeliverySlip.getPreferredSize());
                yColumn1 = VariantSpecificationsDetailsPanelPart2.this.alwaysOnDeliverySlip.getY() + VariantSpecificationsDetailsPanelPart2.this.alwaysOnDeliverySlip.getHeight() + VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            }
            if (VariantSpecificationsDetailsPanelPart2.this.excludeFromReporting != null) {
                VariantSpecificationsDetailsPanelPart2.this.excludeFromReporting.setLocation(VariantSpecificationsDetailsPanelPart2.this.serviceType.getX(), yColumn1);
                VariantSpecificationsDetailsPanelPart2.this.excludeFromReporting.setSize(VariantSpecificationsDetailsPanelPart2.this.excludeFromReporting.getPreferredSize());
                yColumn1 = VariantSpecificationsDetailsPanelPart2.this.excludeFromReporting.getY() + VariantSpecificationsDetailsPanelPart2.this.excludeFromReporting.getHeight() + VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            }
            if (VariantSpecificationsDetailsPanelPart2.this.nominated != null) {
                VariantSpecificationsDetailsPanelPart2.this.nominated.setLocation(VariantSpecificationsDetailsPanelPart2.this.serviceType.getX(), yColumn1);
                VariantSpecificationsDetailsPanelPart2.this.nominated.setSize(VariantSpecificationsDetailsPanelPart2.this.nominated.getPreferredSize());
                yColumn1 = VariantSpecificationsDetailsPanelPart2.this.nominated.getY() + VariantSpecificationsDetailsPanelPart2.this.nominated.getHeight() + VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            }
            if (VariantSpecificationsDetailsPanelPart2.this.showOnDailyOps != null) {
                VariantSpecificationsDetailsPanelPart2.this.showOnDailyOps.setLocation(VariantSpecificationsDetailsPanelPart2.this.serviceType.getX(), yColumn1);
                VariantSpecificationsDetailsPanelPart2.this.showOnDailyOps.setSize(VariantSpecificationsDetailsPanelPart2.this.showOnDailyOps.getPreferredSize());
                yColumn1 = VariantSpecificationsDetailsPanelPart2.this.showOnDailyOps.getY() + VariantSpecificationsDetailsPanelPart2.this.showOnDailyOps.getHeight() + VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            }
            if (VariantSpecificationsDetailsPanelPart2.this.excludeFromCanBeUsedByOtherCustomers != null) {
                VariantSpecificationsDetailsPanelPart2.this.excludeFromCanBeUsedByOtherCustomers.setLocation(VariantSpecificationsDetailsPanelPart2.this.serviceType.getX(), yColumn1);
                VariantSpecificationsDetailsPanelPart2.this.excludeFromCanBeUsedByOtherCustomers.setSize(VariantSpecificationsDetailsPanelPart2.this.excludeFromCanBeUsedByOtherCustomers.getPreferredSize());
                yColumn1 = VariantSpecificationsDetailsPanelPart2.this.excludeFromCanBeUsedByOtherCustomers.getY() + VariantSpecificationsDetailsPanelPart2.this.excludeFromCanBeUsedByOtherCustomers.getHeight() + VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            }
            VariantSpecificationsDetailsPanelPart2.this.takeKonterProbe.setLocation(VariantSpecificationsDetailsPanelPart2.this.serviceType.getX(), yColumn1);
            VariantSpecificationsDetailsPanelPart2.this.takeKonterProbe.setSize(VariantSpecificationsDetailsPanelPart2.this.takeKonterProbe.getPreferredSize());
            yColumn1 = VariantSpecificationsDetailsPanelPart2.this.takeKonterProbe.getY() + VariantSpecificationsDetailsPanelPart2.this.takeKonterProbe.getHeight() + VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            if (VariantSpecificationsDetailsPanelPart2.this.useMasterDataForProductGroupTypes != null) {
                VariantSpecificationsDetailsPanelPart2.this.useMasterDataForProductGroupTypes.setLocation(VariantSpecificationsDetailsPanelPart2.this.serviceType.getX(), yColumn1);
                VariantSpecificationsDetailsPanelPart2.this.useMasterDataForProductGroupTypes.setSize(VariantSpecificationsDetailsPanelPart2.this.useMasterDataForProductGroupTypes.getPreferredSize());
                yColumn1 = VariantSpecificationsDetailsPanelPart2.this.useMasterDataForProductGroupTypes.getY() + VariantSpecificationsDetailsPanelPart2.this.useMasterDataForProductGroupTypes.getHeight() + VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            }
            if (VariantSpecificationsDetailsPanelPart2.this.labelUnit != null) {
                VariantSpecificationsDetailsPanelPart2.this.labelUnit.setLocation(VariantSpecificationsDetailsPanelPart2.this.serviceType.getX(), yColumn1);
                VariantSpecificationsDetailsPanelPart2.this.labelUnit.setSize(VariantSpecificationsDetailsPanelPart2.this.netWeight.getWidth(), (int)VariantSpecificationsDetailsPanelPart2.this.labelUnit.getPreferredSize().getHeight());
                yColumn1 = VariantSpecificationsDetailsPanelPart2.this.labelUnit.getY() + VariantSpecificationsDetailsPanelPart2.this.labelUnit.getHeight() + VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            }
            VariantSpecificationsDetailsPanelPart2.this.netWeight.setLocation(VariantSpecificationsDetailsPanelPart2.this.serviceType.getX(), yColumn1);
            VariantSpecificationsDetailsPanelPart2.this.netWeight.setSize((VariantSpecificationsDetailsPanelPart2.this.cabinClass.getWidth() - VariantSpecificationsDetailsPanelPart2.this.inner_horizontalBorder) / 2, (int)VariantSpecificationsDetailsPanelPart2.this.netWeight.getPreferredSize().getHeight());
            VariantSpecificationsDetailsPanelPart2.this.grossWeight.setLocation(VariantSpecificationsDetailsPanelPart2.this.netWeight.getX() + VariantSpecificationsDetailsPanelPart2.this.netWeight.getWidth() + VariantSpecificationsDetailsPanelPart2.this.inner_horizontalBorder, yColumn1);
            VariantSpecificationsDetailsPanelPart2.this.grossWeight.setSize((VariantSpecificationsDetailsPanelPart2.this.cabinClass.getWidth() - VariantSpecificationsDetailsPanelPart2.this.inner_horizontalBorder) / 2, (int)VariantSpecificationsDetailsPanelPart2.this.grossWeight.getPreferredSize().getHeight());
            int innerY = VariantSpecificationsDetailsPanelPart2.this.netWeight.getY() + VariantSpecificationsDetailsPanelPart2.this.netWeight.getHeight() + VariantSpecificationsDetailsPanelPart2.this.verticalBorder;
            if (VariantSpecificationsDetailsPanelPart2.this.deliveryUnit != null) {
                VariantSpecificationsDetailsPanelPart2.this.deliveryUnit.setLocation(VariantSpecificationsDetailsPanelPart2.this.serviceType.getX(), innerY);
                VariantSpecificationsDetailsPanelPart2.this.deliveryUnit.setSize(VariantSpecificationsDetailsPanelPart2.this.netWeight.getWidth(), (int)VariantSpecificationsDetailsPanelPart2.this.deliveryUnit.getPreferredSize().getHeight());
                innerY = VariantSpecificationsDetailsPanelPart2.this.deliveryUnit.getY() + VariantSpecificationsDetailsPanelPart2.this.deliveryUnit.getHeight() + VariantSpecificationsDetailsPanelPart2.this.verticalBorder;
            }
            if (VariantSpecificationsDetailsPanelPart2.this.useExpiryDate != null) {
                VariantSpecificationsDetailsPanelPart2.this.useExpiryDate.setLocation(VariantSpecificationsDetailsPanelPart2.this.netWeight.getX(), (int)((double)innerY + (VariantSpecificationsDetailsPanelPart2.this.defaultExpiryDate.getPreferredSize().getHeight() - VariantSpecificationsDetailsPanelPart2.this.useExpiryDate.getPreferredSize().getHeight())) - 2);
                VariantSpecificationsDetailsPanelPart2.this.useExpiryDate.setSize(VariantSpecificationsDetailsPanelPart2.this.useExpiryDate.getPreferredSize());
                VariantSpecificationsDetailsPanelPart2.this.defaultExpiryDate.setLocation(VariantSpecificationsDetailsPanelPart2.this.useExpiryDate.getX() + VariantSpecificationsDetailsPanelPart2.this.useExpiryDate.getWidth() + 5, innerY);
                VariantSpecificationsDetailsPanelPart2.this.defaultExpiryDate.setSize(VariantSpecificationsDetailsPanelPart2.this.netWeight.getWidth() - (VariantSpecificationsDetailsPanelPart2.this.useExpiryDate.getWidth() + 5), (int)VariantSpecificationsDetailsPanelPart2.this.defaultExpiryDate.getPreferredSize().getHeight());
                innerY = VariantSpecificationsDetailsPanelPart2.this.defaultExpiryDate.getY() + VariantSpecificationsDetailsPanelPart2.this.defaultExpiryDate.getHeight();
            }
            if (VariantSpecificationsDetailsPanelPart2.this.packSize != null) {
                VariantSpecificationsDetailsPanelPart2.this.packSize.setLocation(VariantSpecificationsDetailsPanelPart2.this.netWeight.getX() + VariantSpecificationsDetailsPanelPart2.this.netWeight.getWidth() + VariantSpecificationsDetailsPanelPart2.this.inner_horizontalBorder, VariantSpecificationsDetailsPanelPart2.this.netWeight.getY() + VariantSpecificationsDetailsPanelPart2.this.netWeight.getHeight() + VariantSpecificationsDetailsPanelPart2.this.verticalBorder);
                VariantSpecificationsDetailsPanelPart2.this.packSize.setSize(VariantSpecificationsDetailsPanelPart2.this.netWeight.getWidth(), (int)VariantSpecificationsDetailsPanelPart2.this.packSize.getPreferredSize().getHeight());
                VariantSpecificationsDetailsPanelPart2.this.productsPerLabel.setLocation(VariantSpecificationsDetailsPanelPart2.this.netWeight.getX() + VariantSpecificationsDetailsPanelPart2.this.netWeight.getWidth() + VariantSpecificationsDetailsPanelPart2.this.inner_horizontalBorder, VariantSpecificationsDetailsPanelPart2.this.packSize.getY() + VariantSpecificationsDetailsPanelPart2.this.packSize.getHeight() + VariantSpecificationsDetailsPanelPart2.this.verticalBorder);
                VariantSpecificationsDetailsPanelPart2.this.productsPerLabel.setSize(VariantSpecificationsDetailsPanelPart2.this.netWeight.getWidth(), (int)VariantSpecificationsDetailsPanelPart2.this.packSize.getPreferredSize().getHeight());
            }
            if (Boolean.TRUE.equals(VariantSpecificationsDetailsPanelPart2.this.viewSettings.getShowProductSalesComponent())) {
                VariantSpecificationsDetailsPanelPart2.this.salesComponentName.setLocation(VariantSpecificationsDetailsPanelPart2.this.horizontalBorder, innerY + VariantSpecificationsDetailsPanelPart2.this.verticalBorder);
                VariantSpecificationsDetailsPanelPart2.this.salesComponentName.setSize(200, (int)VariantSpecificationsDetailsPanelPart2.this.salesComponentName.getPreferredSize().getHeight());
                VariantSpecificationsDetailsPanelPart2.this.salesComponentQuantity.setLocation(VariantSpecificationsDetailsPanelPart2.this.salesComponentName.getX() + VariantSpecificationsDetailsPanelPart2.this.salesComponentName.getWidth() + VariantSpecificationsDetailsPanelPart2.this.inner_horizontalBorder, VariantSpecificationsDetailsPanelPart2.this.salesComponentName.getY());
                VariantSpecificationsDetailsPanelPart2.this.salesComponentQuantity.setSize(150, (int)VariantSpecificationsDetailsPanelPart2.this.salesComponentQuantity.getPreferredSize().getHeight());
                VariantSpecificationsDetailsPanelPart2.this.salesComponentPrice.setLocation(VariantSpecificationsDetailsPanelPart2.this.salesComponentQuantity.getX() + VariantSpecificationsDetailsPanelPart2.this.salesComponentQuantity.getWidth() + VariantSpecificationsDetailsPanelPart2.this.inner_horizontalBorder, VariantSpecificationsDetailsPanelPart2.this.salesComponentName.getY());
                VariantSpecificationsDetailsPanelPart2.this.salesComponentPrice.setSize(150, (int)VariantSpecificationsDetailsPanelPart2.this.salesComponentPrice.getPreferredSize().getHeight());
            }
            VariantSpecificationsDetailsPanelPart2.this.cycle.setLocation(VariantSpecificationsDetailsPanelPart2.this.inout.getX(), yColumn2);
            VariantSpecificationsDetailsPanelPart2.this.cycle.setSize((int)((double)VariantSpecificationsDetailsPanelPart2.this.mealType.getWidth() - (VariantSpecificationsDetailsPanelPart2.this.cycleInfo.getPreferredSize().getWidth() + 5.0)), (int)VariantSpecificationsDetailsPanelPart2.this.cycle.getPreferredSize().getHeight());
            VariantSpecificationsDetailsPanelPart2.this.cycleInfo.setLocation(VariantSpecificationsDetailsPanelPart2.this.cycle.getX() + VariantSpecificationsDetailsPanelPart2.this.cycle.getWidth() + 5, (int)((double)(VariantSpecificationsDetailsPanelPart2.this.cycle.getY() + VariantSpecificationsDetailsPanelPart2.this.cycle.getHeight()) - VariantSpecificationsDetailsPanelPart2.this.cycleInfo.getPreferredSize().getHeight()) - 2);
            VariantSpecificationsDetailsPanelPart2.this.cycleInfo.setSize(VariantSpecificationsDetailsPanelPart2.this.cycleInfo.getPreferredSize());
            yColumn2 = VariantSpecificationsDetailsPanelPart2.this.cycle.getY() + VariantSpecificationsDetailsPanelPart2.this.cycle.getHeight() + VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            VariantSpecificationsDetailsPanelPart2.this.productType.setLocation(VariantSpecificationsDetailsPanelPart2.this.cycle.getX(), yColumn2);
            VariantSpecificationsDetailsPanelPart2.this.productType.setSize(VariantSpecificationsDetailsPanelPart2.this.mealType.getWidth() - 50, (int)VariantSpecificationsDetailsPanelPart2.this.productType.getPreferredSize().getHeight());
            VariantSpecificationsDetailsPanelPart2.this.productToMealMultiplier.setLocation(VariantSpecificationsDetailsPanelPart2.this.productType.getX() + VariantSpecificationsDetailsPanelPart2.this.productType.getWidth() + 5, VariantSpecificationsDetailsPanelPart2.this.productType.getY());
            VariantSpecificationsDetailsPanelPart2.this.productToMealMultiplier.setSize(parent.getWidth() - (VariantSpecificationsDetailsPanelPart2.this.productToMealMultiplier.getX() + VariantSpecificationsDetailsPanelPart2.this.horizontalBorder), (int)VariantSpecificationsDetailsPanelPart2.this.productToMealMultiplier.getPreferredSize().getHeight());
            yColumn2 = VariantSpecificationsDetailsPanelPart2.this.productType.getY() + VariantSpecificationsDetailsPanelPart2.this.productType.getHeight() + VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            VariantSpecificationsDetailsPanelPart2.this.department.setLocation(VariantSpecificationsDetailsPanelPart2.this.cycle.getX(), yColumn2);
            VariantSpecificationsDetailsPanelPart2.this.department.setSize(VariantSpecificationsDetailsPanelPart2.this.mealType.getWidth() - 50, (int)VariantSpecificationsDetailsPanelPart2.this.department.getPreferredSize().getHeight());
            yColumn2 = VariantSpecificationsDetailsPanelPart2.this.department.getY() + VariantSpecificationsDetailsPanelPart2.this.department.getHeight() + VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            VariantSpecificationsDetailsPanelPart2.this.paxMealType.setLocation(VariantSpecificationsDetailsPanelPart2.this.cycle.getX(), yColumn2);
            VariantSpecificationsDetailsPanelPart2.this.paxMealType.setSize(VariantSpecificationsDetailsPanelPart2.this.mealType.getWidth() - 50, (int)VariantSpecificationsDetailsPanelPart2.this.paxMealType.getPreferredSize().getHeight());
            yColumn2 = VariantSpecificationsDetailsPanelPart2.this.paxMealType.getY() + VariantSpecificationsDetailsPanelPart2.this.paxMealType.getHeight() + VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            if (VariantSpecificationsDetailsPanelPart2.this.labelTags != null) {
                VariantSpecificationsDetailsPanelPart2.this.labelTags.setLocation(VariantSpecificationsDetailsPanelPart2.this.paxMealType.getX(), yColumn2);
                VariantSpecificationsDetailsPanelPart2.this.labelTags.setSize(VariantSpecificationsDetailsPanelPart2.this.paxMealType.getWidth() - 50, (int)VariantSpecificationsDetailsPanelPart2.this.labelTags.getPreferredSize().getHeight());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h1 = VariantSpecificationsDetailsPanelPart2.this.verticalBorder;
            h1 = (int)((double)h1 + VariantSpecificationsDetailsPanelPart2.this.standard.getPreferredSize().getHeight());
            h1 += VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            h1 = (int)((double)h1 + VariantSpecificationsDetailsPanelPart2.this.specialMeal.getPreferredSize().getHeight());
            h1 += VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            h1 = (int)((double)h1 + VariantSpecificationsDetailsPanelPart2.this.alaCarte.getPreferredSize().getHeight());
            h1 += VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            h1 = (int)((double)h1 + VariantSpecificationsDetailsPanelPart2.this.sep1.getPreferredSize().getHeight());
            int h2 = h1 += VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            h1 = (int)((double)h1 + VariantSpecificationsDetailsPanelPart2.this.cabinClass.getPreferredSize().getHeight());
            h1 += VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            if (VariantSpecificationsDetailsPanelPart2.this.aircraftType != null) {
                h1 = (int)((double)h1 + VariantSpecificationsDetailsPanelPart2.this.aircraftType.getPreferredSize().getHeight());
                h1 += VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            }
            h1 = (int)((double)h1 + VariantSpecificationsDetailsPanelPart2.this.serviceType.getPreferredSize().getHeight());
            h1 += VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            if (VariantSpecificationsDetailsPanelPart2.this.isAdditional != null) {
                h1 = (int)((double)h1 + VariantSpecificationsDetailsPanelPart2.this.isAdditional.getPreferredSize().getHeight());
                h1 += VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            }
            h1 = (int)((double)h1 + VariantSpecificationsDetailsPanelPart2.this.hideOnLabel.getPreferredSize().getHeight());
            h1 += VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            if (VariantSpecificationsDetailsPanelPart2.this.labeled != null) {
                h1 = (int)((double)h1 + VariantSpecificationsDetailsPanelPart2.this.labeled.getPreferredSize().getHeight());
                h1 += VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            }
            if (VariantSpecificationsDetailsPanelPart2.this.alwaysOnDeliverySlip != null) {
                h1 = (int)((double)h1 + VariantSpecificationsDetailsPanelPart2.this.alwaysOnDeliverySlip.getPreferredSize().getHeight());
                h1 += VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            }
            if (VariantSpecificationsDetailsPanelPart2.this.excludeFromReporting != null) {
                h1 = (int)((double)h1 + VariantSpecificationsDetailsPanelPart2.this.excludeFromReporting.getPreferredSize().getHeight());
                h1 += VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            }
            if (VariantSpecificationsDetailsPanelPart2.this.nominated != null) {
                h1 = (int)((double)h1 + VariantSpecificationsDetailsPanelPart2.this.nominated.getPreferredSize().getHeight());
                h1 += VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            }
            if (VariantSpecificationsDetailsPanelPart2.this.showOnDailyOps != null) {
                h1 = (int)((double)h1 + VariantSpecificationsDetailsPanelPart2.this.showOnDailyOps.getPreferredSize().getHeight());
                h1 += VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            }
            if (VariantSpecificationsDetailsPanelPart2.this.excludeFromCanBeUsedByOtherCustomers != null) {
                h1 = (int)((double)h1 + VariantSpecificationsDetailsPanelPart2.this.excludeFromCanBeUsedByOtherCustomers.getPreferredSize().getHeight());
                h1 += VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            }
            h1 = (int)((double)h1 + VariantSpecificationsDetailsPanelPart2.this.takeKonterProbe.getPreferredSize().getHeight());
            h1 += VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            if (VariantSpecificationsDetailsPanelPart2.this.useMasterDataForProductGroupTypes != null) {
                h1 = (int)((double)h1 + VariantSpecificationsDetailsPanelPart2.this.useMasterDataForProductGroupTypes.getPreferredSize().getHeight());
                h1 += VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            }
            h1 = (int)((double)h1 + VariantSpecificationsDetailsPanelPart2.this.netWeight.getPreferredSize().getHeight());
            if (VariantSpecificationsDetailsPanelPart2.this.deliveryUnit != null) {
                h1 += VariantSpecificationsDetailsPanelPart2.this.verticalBorder;
                h1 += VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
                h1 = (int)((double)h1 + VariantSpecificationsDetailsPanelPart2.this.deliveryUnit.getPreferredSize().getHeight());
            }
            if (VariantSpecificationsDetailsPanelPart2.this.labelUnit != null) {
                h1 = (int)((double)h1 + VariantSpecificationsDetailsPanelPart2.this.labelUnit.getPreferredSize().getHeight());
                h1 += VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            }
            if (VariantSpecificationsDetailsPanelPart2.this.packSize != null) {
                h1 += VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
                h1 = (int)((double)h1 + VariantSpecificationsDetailsPanelPart2.this.packSize.getPreferredSize().getHeight());
            }
            if (VariantSpecificationsDetailsPanelPart2.this.productsPerLabel != null) {
                h1 += VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
                h1 = (int)((double)h1 + VariantSpecificationsDetailsPanelPart2.this.productsPerLabel.getPreferredSize().getHeight());
            }
            h1 += VariantSpecificationsDetailsPanelPart2.this.verticalBorder;
            h2 = (int)((double)h2 + VariantSpecificationsDetailsPanelPart2.this.inout.getPreferredSize().getHeight());
            h2 += VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            h2 = (int)((double)h2 + VariantSpecificationsDetailsPanelPart2.this.haulType.getPreferredSize().getHeight());
            h2 += VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            h2 = (int)((double)h2 + VariantSpecificationsDetailsPanelPart2.this.specialMeal.getPreferredSize().getHeight());
            h2 += VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            h2 = (int)((double)h2 + VariantSpecificationsDetailsPanelPart2.this.mealType.getPreferredSize().getHeight());
            h2 += VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            if (VariantSpecificationsDetailsPanelPart2.this.defaultTray != null) {
                h2 = (int)((double)h2 + VariantSpecificationsDetailsPanelPart2.this.defaultTray.getPreferredSize().getHeight());
                h2 += VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            }
            if (VariantSpecificationsDetailsPanelPart2.this.defaultLabelColor != null) {
                h2 = (int)((double)h2 + VariantSpecificationsDetailsPanelPart2.this.defaultLabelColor.getPreferredSize().getHeight());
                h2 += VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            }
            h2 = (int)((double)h2 + VariantSpecificationsDetailsPanelPart2.this.cycle.getPreferredSize().getHeight());
            h2 += VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            h2 = (int)((double)h2 + VariantSpecificationsDetailsPanelPart2.this.productType.getPreferredSize().getHeight());
            h2 += VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            h2 = (int)((double)h2 + VariantSpecificationsDetailsPanelPart2.this.department.getPreferredSize().getHeight());
            h2 += VariantSpecificationsDetailsPanelPart2.this.inner_verticalBorder;
            h2 = (int)((double)h2 + VariantSpecificationsDetailsPanelPart2.this.paxMealType.getPreferredSize().getHeight());
            h2 += VariantSpecificationsDetailsPanelPart2.this.verticalBorder;
            if (Boolean.TRUE.equals(VariantSpecificationsDetailsPanelPart2.this.viewSettings.getShowProductSalesComponent())) {
                h1 = (int)((double)h1 + VariantSpecificationsDetailsPanelPart2.this.salesComponentName.getPreferredSize().getHeight());
                h1 += VariantSpecificationsDetailsPanelPart2.this.verticalBorder;
            }
            h2 += VariantSpecificationsDetailsPanelPart2.this.verticalBorder;
            return new Dimension(0, h1 > (h2 += VariantSpecificationsDetailsPanelPart2.this.verticalBorder) ? h1 : h2);
        }
    }
}

