/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.radar;

import ch.icit.pegasus.client.MainFrame;
import ch.icit.pegasus.client.gui.hud.ConnectionToOutside;
import ch.icit.pegasus.client.gui.hud.submoduleprovider.AnalysisSubModuleProvider;
import ch.icit.pegasus.client.gui.hud.submoduleprovider.DtoSubModuleProvider;
import ch.icit.pegasus.client.gui.modules.Module;
import ch.icit.pegasus.client.gui.modules.radar.view.RadarPanel;
import ch.icit.pegasus.client.gui.screentemplates.overview.FilterChainScreenView;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.utils.TransferObject;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.ListNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.FlightSearchAlgorithm;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.RetailInMotionSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.edelweiss.EdelweissSettingsComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.AirportComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.AlaCarteMenuTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.SpecialMenuTypeComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleTypeE;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.FlightAccess;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.RadarAccess;
import ch.icit.pegasus.server.core.dtos.search.FlightSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.search.SortDirection;
import java.awt.Component;
import java.sql.Date;
import java.util.List;
import javax.swing.JComponent;

public class RadarModule
extends FilterChainScreenView<FlightLight, FlightSearchConfiguration.FLIGHT_COLUMN>
implements DtoSubModuleProvider<FlightLight>,
AnalysisSubModuleProvider<FlightLight>,
ConnectionToOutside<FlightLight, FlightSearchConfiguration.FLIGHT_COLUMN>,
Module {
    private static final long serialVersionUID = 1L;
    private static String SEARCH_NO = "Number";
    private static String SEARCH_CUSTOMER = "Customer";
    private static String SEARCH_STATE = "State";
    private static String SEARCH_OPSDATE = "OpsDate";
    private static String SEARCH_TYPES = "Types";
    private static String DAYS_SHOWN = "Days";
    private String filterCriteria1;
    private CustomerLight filterCriteria2;
    private FlightStateE filterCriteria3;
    private Date filterCriteria4;
    private Boolean filterCriteria5;
    private int filterCriteria6;
    private RadarPanel radar;
    private Boolean onlyOpenFlights = false;
    private ComboBox box;

    public RadarModule() {
        this.isSynchronSearch = false;
        this.node = new ListNode();
        this.searchAlgorithm = SearchAlgorithmRegistry.getSearchAlgorithm(FlightSearchAlgorithm.class);
    }

    @Override
    public RDProvider getCurrentProvider() {
        return null;
    }

    @Override
    public String getOverriddenModuleRights() {
        return null;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.radar.kill();
        this.radar = null;
        this.box.kill();
        this.box = null;
    }

    @Override
    protected ASearchConfiguration<? extends ADTO, ? extends Enum<?>> getEmptySortedSearchConfiguration() {
        return this.getSearchParameters(this.node, null, null, true, this.filterChain);
    }

    @Override
    public void setLoadData(boolean isLoading) {
        super.setLoadData(isLoading);
    }

    @Override
    public FilterChainConfiguration getDefaultConfiguration() {
        FilterChainConfiguration c = new FilterChainConfiguration();
        c.addProperty("sortedColumn", FlightSearchConfiguration.FLIGHT_COLUMN.OUTBOUND_CODE.toString() + "<>" + true);
        return c;
    }

    @Override
    protected void install() {
        RDProvider p = new RDProvider(this.getCurrentAccessRight(this.getInvoker()), false);
        this.radar = new RadarPanel((Node<List<FlightLight>>)this.node, this, p);
        this.add(this.radar);
    }

    @Override
    public void setMainFrame(MainFrame mainFrame) {
        super.setMainFrame(mainFrame);
        this.radar.init(mainFrame);
    }

    @Override
    protected void createFilterChain(long id) {
        this.filterChain.addSearchField(SEARCH_NO, "FLIGHT NO", "");
        this.filterChain.addCustomerSearchField(SEARCH_CUSTOMER);
        this.box = ComboBoxFactory.getFlightStateComboBox(true);
        this.box.setSelectedItem(Words.ALL);
        this.filterChain.addSelectionComboBox(this.box, SEARCH_STATE, "STATE", Words.ALL);
        this.filterChain.addDateSelection(SEARCH_OPSDATE, "OPS DATE", new Date(System.currentTimeMillis()));
        this.filterChain.addNumericStepper(DAYS_SHOWN, "DAYS", 1, Integer.MAX_VALUE, 1);
        ComboBox types = new ComboBox();
        types.addItem(Words.ALL);
        types.addItem(Words.INBOUND);
        types.addItem(Words.OUTBOUND);
        this.filterChain.addSelectionComboBox(types, SEARCH_TYPES, "IN/OUT", Words.ALL);
        this.filterChain.addResetButton();
    }

    @Override
    public ASearchConfiguration<FlightLight, FlightSearchConfiguration.FLIGHT_COLUMN> getSearchParameters(Node<?> currentMetaNode, Object name, Object value, boolean isReset, Component source) {
        if (isReset) {
            this.filterCriteria1 = null;
            this.filterCriteria2 = null;
            this.filterCriteria3 = null;
            this.filterCriteria4 = null;
            this.filterCriteria5 = null;
            this.filterCriteria6 = 1;
            this.onlyOpenFlights = false;
        } else if (name == SEARCH_NO) {
            this.filterCriteria1 = (String)value;
        } else if (name == SEARCH_CUSTOMER) {
            if (value instanceof CustomerLight) {
                this.filterCriteria2 = (CustomerLight)value;
            } else if (value instanceof Node) {
                this.filterCriteria2 = (CustomerLight)((Node)value).getValue();
            }
        } else if (name == SEARCH_STATE) {
            if (value instanceof FlightStateE) {
                this.filterCriteria3 = (FlightStateE)value;
                this.onlyOpenFlights = false;
            } else if (value instanceof String) {
                if (value.equals(Words.ALL)) {
                    this.filterCriteria3 = null;
                    this.onlyOpenFlights = false;
                } else if (value.equals(Words.ALL_EXCEPT_PLANNED)) {
                    this.filterCriteria3 = null;
                    this.onlyOpenFlights = true;
                } else {
                    this.filterCriteria3 = null;
                    this.onlyOpenFlights = false;
                }
            } else {
                this.filterCriteria3 = null;
                this.onlyOpenFlights = false;
            }
        } else if (name == SEARCH_OPSDATE) {
            if (value instanceof Date) {
                this.filterCriteria4 = (Date)value;
            } else if (value instanceof Node) {
                this.filterCriteria4 = (Date)((Node)value).getValue();
            }
        } else if (name == SEARCH_TYPES) {
            if (value instanceof String) {
                this.filterCriteria5 = value.equals(Words.INBOUND) ? Boolean.valueOf(true) : (value.equals(Words.OUTBOUND) ? Boolean.valueOf(false) : null);
            }
        } else if (name == DAYS_SHOWN && value instanceof Integer) {
            this.filterCriteria6 = (Integer)value;
        }
        PeriodComplete p = null;
        if (this.filterCriteria4 == null) {
            this.filterCriteria4 = new Date(System.currentTimeMillis());
        }
        this.radar.updateSelectedDate(this.filterCriteria4, this.filterCriteria6);
        p = new PeriodComplete(this.filterCriteria4, this.filterCriteria4);
        FlightSearchConfiguration c = new FlightSearchConfiguration();
        c.setNumResults(Integer.MAX_VALUE);
        c.setCustomer(this.filterCriteria2);
        c.setFlightNumber(this.filterCriteria1);
        c.setFlightState(this.filterCriteria3);
        c.setOnlyOpenFlights(this.onlyOpenFlights);
        c.getLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
        if (this.filterCriteria6 < 1) {
            this.filterCriteria6 = 1;
        }
        long days = 86400000L * (long)(this.filterCriteria6 - 1);
        Date endDate = new Date(p.getStartDate().getTime() + days);
        p.setEndDate(endDate);
        c.setDayPeriod(p);
        c.setFlightStdSta(FlightSearchConfiguration.FLIGHT_STD_STA.staStd);
        if (this.currentColumnAttribute != null) {
            c.setSortColumn(this.currentColumnAttribute);
        }
        if (this.isAsc) {
            c.setSortDirection(SortDirection.ASCENDING);
        } else {
            c.setSortDirection(SortDirection.DESCENDING);
        }
        return c;
    }

    @Override
    protected void startDownload() {
        super.startDownload();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(SpecialMenuTypeComplete.class);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CabinClassComplete.class);
                StaticEnumServiceManager.getAllFlightStateE();
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CostCenterComplete.class);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached();
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(AirportComplete.class);
                StaticEnumServiceManager.getAllTruckTourTypes();
                StaticEnumServiceManager.getAllSealChecks();
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(AlaCarteMenuTypeComplete.class);
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return RadarModule.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.radar.setEnabled(isEnabled);
    }

    @Override
    public AccessDefinitionComplete getInvoker() {
        return RadarAccess.MODULE_RADAR;
    }

    @Override
    public JComponent getContentComponent() {
        return this.radar;
    }

    @Override
    public boolean isSmartScreenAllowed(SubModuleDefinitionComplete screen, RowModel<FlightLight> model) {
        Object o;
        if (this.radar.getNode() == null || this.radar.getNode().getValue() == null || ((FlightLight)this.radar.getNode().getValue()).getId() == null) {
            return false;
        }
        if (screen.getInvokingName().equals(FlightAccess.ANALYSIS_FLIGHT_VECTOR_SALES_VALIDATION.getIdentifier())) {
            RetailInMotionSettingsComplete settings = (RetailInMotionSettingsComplete)NodeToolkit.getAffixClass(RetailInMotionSettingsComplete.class).getValue();
            return settings != null && Boolean.TRUE.equals(settings.getUseRetailInMotionInterface());
        }
        if (screen.getInvokingName().equals(FlightAccess.ANALYSIS_EDELWEISS_PAX_VALIDATION.getIdentifier())) {
            EdelweissSettingsComplete settings = (EdelweissSettingsComplete)NodeToolkit.getAffixClass(EdelweissSettingsComplete.class).getValue();
            return settings != null && Boolean.TRUE.equals(settings.getUseEdelweissInterface());
        }
        if (screen.getInvokingName().equals(FlightAccess.PRINT_FLIGHT_KITCHEN_FORECAST.getIdentifier()) && model.getNode().getChildNamed(FlightLight_.excludeFromKitchenForecast) != null && (o = model.getNode().getChildNamed(FlightLight_.excludeFromKitchenForecast).getValue()) != null) {
            return (Boolean)o == false;
        }
        return screen.getType() == SubModuleTypeE.PRINT;
    }

    @Override
    public boolean isDeletable(RowModel<FlightLight> model) {
        return false;
    }

    @Override
    public boolean isRestorable(RowModel<FlightLight> model) {
        return false;
    }

    @Override
    public ASearchConfiguration<FlightLight, FlightSearchConfiguration.FLIGHT_COLUMN> getFilteredSearchConfiguration() {
        return this.getSearchParameters(null, null, null, false, null);
    }

    @Override
    public ASearchConfiguration<FlightLight, FlightSearchConfiguration.FLIGHT_COLUMN> getEmptySearchConfiguration() {
        return this.getSearchAlgorithm().getSearchConfiguration();
    }

    @Override
    public SearchAlgorithm<FlightLight> getSearchAlgorithm() {
        return SearchAlgorithmRegistry.getSearchAlgorithm(FlightSearchAlgorithm.class);
    }

    @Override
    public int getPageNumber() {
        return 0;
    }

    @Override
    public TransferObject<FlightLight> getDtoTransferObject() {
        return new TransferObject<Object>(this.radar.getNode().getValue(), this);
    }
}

