/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.recipe.details.utils;

import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.priceanimation.CalculationRunnable;
import ch.icit.pegasus.client.gui.utils.priceanimation.LoadingGroup;
import ch.icit.pegasus.client.gui.utils.priceanimation.ReloadablePriceView;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.PriorityBlockingQueue;

public class GroupLoader
implements LoadingGroup,
RemoteLoader {
    private boolean isRunning = false;
    private PriorityBlockingQueue<ReloadablePriceView> loadingQueue;
    private static final int TYPE_COMPONENT = 3;
    private static final int TYPE_TOTAL = 5;
    private static final int TYPE_WEIGHT = 7;
    private static final int TYPE_WASTE = 11;
    private ReloadablePriceView totalView;
    private ReloadablePriceView secondTotalView;
    private List<ReloadablePriceView> components;
    private ReloadablePriceView bruttoWeight;
    private ReloadablePriceView nettoWeight;
    private ReloadablePriceView assembleWaste;
    private ReloadablePriceView cookWaste;
    private Component c;

    public GroupLoader(Component c) {
        this.c = c;
        this.loadingQueue = new PriorityBlockingQueue<ReloadablePriceView>(10, new ReloadablePriceComparator());
        this.components = new ArrayList<ReloadablePriceView>();
    }

    public void setTotalView(ReloadablePriceView view) {
        this.totalView = view;
    }

    public void setSecondTotalView(ReloadablePriceView view) {
        this.secondTotalView = view;
    }

    public void addComponent(ReloadablePriceView rpv) {
        this.components.add(rpv);
    }

    public void removeComponent(ReloadablePriceView rpv) {
        this.components.remove(rpv);
    }

    @Override
    public void updateMe(ReloadablePriceView rpv) {
        int t = this.getType(rpv);
        if (t == 3) {
            this.initStratOne(rpv);
        } else {
            this.initStratTwo();
        }
        this.runMe();
    }

    private void initStratOne(ReloadablePriceView rpv) {
        if (rpv != null) {
            this.loadingQueue.add(rpv);
        } else {
            for (ReloadablePriceView p : this.components) {
                this.loadingQueue.add(p);
            }
        }
        this.initStratTwo();
    }

    private void initStratTwo() {
        if (this.totalView != null) {
            this.loadingQueue.add(this.totalView);
        }
        if (this.secondTotalView != null) {
            this.loadingQueue.add(this.secondTotalView);
        }
        if (this.bruttoWeight != null) {
            this.loadingQueue.add(this.bruttoWeight);
        }
        if (this.nettoWeight != null) {
            this.loadingQueue.add(this.nettoWeight);
        }
        if (this.assembleWaste != null) {
            this.loadingQueue.add(this.assembleWaste);
        }
        if (this.cookWaste != null) {
            this.loadingQueue.add(this.cookWaste);
        }
    }

    private void runMe() {
        if (this.isRunning) {
            return;
        }
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                while (!GroupLoader.this.loadingQueue.isEmpty()) {
                    ReloadablePriceView r = (ReloadablePriceView)GroupLoader.this.loadingQueue.poll();
                    CalculationRunnable runing = r.getCurrentRunnable();
                    if (runing == null || !runing.isAlive()) continue;
                    runing.run();
                    r.loaded();
                }
                GroupLoader.this.isRunning = false;
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return GroupLoader.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        this.isRunning = true;
        ThreadSafeLoader.run(run);
    }

    private int getType(ReloadablePriceView rpv) {
        if (rpv == this.totalView || rpv == this.secondTotalView) {
            return 5;
        }
        if (rpv == this.bruttoWeight || rpv == this.nettoWeight) {
            return 7;
        }
        if (rpv == this.assembleWaste || rpv == this.cookWaste) {
            return 11;
        }
        return 3;
    }

    public void remoteObjectLoaded(Node<?> node) {
    }

    public void errorOccurred(ClientException exception) {
        InnerPopupFactory.showErrorDialog((Exception)exception, this.c);
    }

    public void setNettoWeight(ReloadablePriceView nettoWeight) {
        this.nettoWeight = nettoWeight;
    }

    public void setBruttoWeight(ReloadablePriceView bruttoWeight) {
        this.bruttoWeight = bruttoWeight;
    }

    public void setAssembleWaste(ReloadablePriceView assembleWaste) {
        this.assembleWaste = assembleWaste;
    }

    public void setCookWaste(ReloadablePriceView cookingWaste) {
        this.cookWaste = cookingWaste;
    }

    private class ReloadablePriceComparator
    implements Comparator<ReloadablePriceView> {
        private ReloadablePriceComparator() {
        }

        @Override
        public int compare(ReloadablePriceView o1, ReloadablePriceView o2) {
            Integer t1 = GroupLoader.this.getType(o1);
            Integer t2 = GroupLoader.this.getType(o2);
            return t1.compareTo(t2);
        }
    }
}

