/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.reorderlevel;

import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.PeriodConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.gui.modules.reorderlevel.ReorderLevelModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.reorderlevel.details.ArticlesDetailsPanel;
import ch.icit.pegasus.client.gui.modules.reorderlevel.details.SpecificationDetailsPanel;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.MessageProvidedRowEditor;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.RowEditorFactory;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.Table;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.utils.TableLayoutConstraint;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.ReorderLevelSearchAlgorithm;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.ordering.reorderlevel.ReorderLevelComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.reorderlevel.ReorderLevelLight;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.ReorderLevelAccess;
import ch.icit.pegasus.server.core.dtos.search.ReorderLevelSearchConfiguration;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.search.SortDirection;
import java.awt.Component;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class ReorderLevelModule
extends ScreenTableView<ReorderLevelLight, ReorderLevelSearchConfiguration.REORDER_LEVEL_COLUMN> {
    private static final long serialVersionUID = 1L;
    private static final String FILTER_NAME = "name_or_number";
    private static final String FILTER_PERIOD = "period";
    private String filterNameOrNumber = null;
    private PeriodComplete selectedPeriod = null;

    public ReorderLevelModule() {
        super(ReorderLevelLight.class);
        this.isSynchronSearch = false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.filterNameOrNumber = null;
        this.selectedPeriod = null;
    }

    @Override
    public AccessDefinitionComplete getInvoker() {
        return ReorderLevelAccess.MODULE_REORDER_LEVEL;
    }

    @Override
    public FilterChainConfiguration getDefaultConfiguration() {
        FilterChainConfiguration c = new FilterChainConfiguration();
        c.addProperty("sortedColumn", ReorderLevelSearchConfiguration.REORDER_LEVEL_COLUMN.NAME + "<>" + true);
        c.addProperty(FILTER_PERIOD, FilterChainConfiguration.getDefaultSearchPeriodString());
        return c;
    }

    @Override
    protected void createFilterChain(long id) {
        this.filterChain.setSearchTextField2Width(200);
        this.filterChain.addSearchField(FILTER_NAME, Words.NAME_OR_NUMBER, "");
        TitledPeriodEditor period = this.filterChain.addPeriodSelection(FILTER_PERIOD, new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis()), "PERIOD", false);
        period.setCheckBoxEnabled();
        this.filterChain.addResetButton();
    }

    @Override
    public ASearchConfiguration<ReorderLevelLight, ReorderLevelSearchConfiguration.REORDER_LEVEL_COLUMN> getModuleSearchParameters(Object name, Object value, boolean isReset, boolean getEmptyConfig, Component source) {
        if (isReset) {
            this.filterNameOrNumber = null;
            this.selectedPeriod = null;
        } else if (name == FILTER_NAME) {
            this.filterNameOrNumber = (String)value;
        } else if (name == FILTER_PERIOD) {
            TitledPeriodEditor ed = (TitledPeriodEditor)value;
            PeriodComplete per = new PeriodComplete();
            if (ed.getStartDate() != null) {
                per.setStartDate(new Date(ed.getStartDate().getTime()));
                per.setEndDate(new Date(ed.getEndDate().getTime()));
            }
            this.selectedPeriod = per;
        }
        ReorderLevelSearchConfiguration c = new ReorderLevelSearchConfiguration();
        try {
            Integer numbervalue = Integer.valueOf(this.filterNameOrNumber);
            c.setNumber(numbervalue);
        }
        catch (Exception exception) {
            // empty catch block
        }
        c.setName(this.filterNameOrNumber);
        c.setPeriod(this.selectedPeriod);
        c.setNumResults(this.numberOfShownResults);
        if (source == this.pagination) {
            c.setPageNumber(this.pagination.getCurrentPage() - 1);
        } else {
            c.setPageNumber(0);
        }
        if (c.getPageNumber() < 0) {
            c.setPageNumber(0);
        }
        if (this.currentColumnAttribute != null) {
            c.setSortColumn(this.currentColumnAttribute);
        }
        if (this.isAsc) {
            c.setSortDirection(SortDirection.ASCENDING);
        } else {
            c.setSortDirection(SortDirection.DESCENDING);
        }
        return c;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        super.remoteObjectLoaded(node);
    }

    @Override
    public SearchAlgorithm<ReorderLevelLight> getSearchAlgorithm() {
        return SearchAlgorithmRegistry.getSearchAlgorithm(ReorderLevelSearchAlgorithm.class);
    }

    @Override
    public boolean isSmartScreenAllowed(SubModuleDefinitionComplete screen, RowModel<ReorderLevelLight> model) {
        if (model == null || model.getNode() == null || model.getNode().getValue() == null) {
            return false;
        }
        if (screen.getInvokingName().equals(ReorderLevelAccess.ACTION_CALCULATE_REORDER_LEVEL.getIdentifier())) {
            ReorderLevelLight reorderLevelLight = (ReorderLevelLight)model.getNode().getValue();
        }
        return model != null;
    }

    @Override
    public boolean isDeletable(RowModel<ReorderLevelLight> model) {
        return true;
    }

    @Override
    protected Table.SmartIconConfiguration getPossibleSmartIcons() {
        return Table.SmartIconConfiguration.TWO;
    }

    @Override
    protected RowEditorFactory<ReorderLevelLight> getRowEditorFactory() {
        return model -> {
            MessageProvidedRowEditor<ReorderLevelLight> rowEditor = new MessageProvidedRowEditor<ReorderLevelLight>(model, "");
            RDProvider p = this.createProvider(model.isAddRow());
            SpecificationDetailsPanel d1 = new SpecificationDetailsPanel((RowEditor<ReorderLevelLight>)rowEditor, p);
            ArticlesDetailsPanel d2 = new ArticlesDetailsPanel((RowEditor<ReorderLevelLight>)rowEditor, p);
            rowEditor.add(d1, (Object)new TableLayoutConstraint(0, 0, 1.0, 0.0));
            rowEditor.add(d2, (Object)new TableLayoutConstraint(0, 1, 1.0, 1.0));
            rowEditor.addToFocusQueue(d1);
            rowEditor.addToFocusQueue(d2);
            rowEditor.allInstalled();
            rowEditor.setVisibleContainer(this.getTable());
            return rowEditor;
        };
    }

    @Override
    protected IDataHandler getModuleDataHandler() {
        return new ReorderLevelModuleDataHandler(this.loadingId, (ScreenTableView<ReorderLevelLight, ReorderLevelSearchConfiguration.REORDER_LEVEL_COLUMN>)this);
    }

    @Override
    protected List<TableColumnInfo> getTableColumnInfo() {
        ArrayList<TableColumnInfo> info = new ArrayList<TableColumnInfo>();
        info.add(new TableColumnInfo(Words.NUMBER, "", (Class)IntegerConverter.class, (Enum<?>)ReorderLevelSearchConfiguration.REORDER_LEVEL_COLUMN.NUMBER, ReorderLevelComplete_.number, TableColumnInfo.numberColumnWithExpandWidth));
        info.add(new TableColumnInfo(Words.NAME, "", (Class)StringConverter.class, (Enum<?>)ReorderLevelSearchConfiguration.REORDER_LEVEL_COLUMN.NAME, ReorderLevelComplete_.name, 120, Integer.MAX_VALUE, 120));
        info.add(new TableColumnInfo(Words.PERIOD, "", (Class)PeriodConverter.class, (Enum<?>)ReorderLevelSearchConfiguration.REORDER_LEVEL_COLUMN.PERIOD, ReorderLevelComplete_.validity, TableColumnInfo.periodColumnWidth));
        return info;
    }
}

