/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.requisitionorder.manager.details;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.DeltaQuantityConverter;
import ch.icit.pegasus.client.converter.IntegerPlusPlusConverter;
import ch.icit.pegasus.client.converter.QuantityConverter2Decimal;
import ch.icit.pegasus.client.converter.StorePositionShortNameConverter;
import ch.icit.pegasus.client.converter.UserConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.purchaseorder.manualcreator.details.utils.RequisitionPositionNameConverter;
import ch.icit.pegasus.client.gui.modules.requisitionorder.manager.details.utils.OrderAmountChangingPopup;
import ch.icit.pegasus.client.gui.modules.requisitionorder.manager.details.utils.RejectionReceivingConverter;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table.renderer.CellViewOrderStateRenderer;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.Killable;
import ch.icit.pegasus.client.gui.utils.QuantityRenderer;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.EditButton;
import ch.icit.pegasus.client.gui.utils.buttons.ExpandIcon;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.buttons.StockTransactionRemarkButton;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.popup.IPopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.TextListPopUpInsert;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDSearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.EmbeddedDTONode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.loaders.BasicArticleLoader;
import ch.icit.pegasus.client.util.toolkits.ArticleToolkit;
import ch.icit.pegasus.client.util.toolkits.TransactionToolkit;
import ch.icit.pegasus.server.core.calculator.IBasicArticle;
import ch.icit.pegasus.server.core.calculator.IQuantity;
import ch.icit.pegasus.server.core.calculator.UnitCalculator;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.ordering.OrderPositionBatchComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.OrderPositionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.OrderStateE;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderComplete;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderLight;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderPositionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderPositionComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.RequisitionOrderAcceptationComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.RequisitionOrderAcceptationComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.RequisitionOrderMoveComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.RequisitionOrderMoveComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.RequisitionOrderPositionMutationComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.RequisitionOrderPositionMutationComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.RequisitionOrderPreparationComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.RequisitionOrderPreparationComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.RequisitionOrderRecipientTransactionComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.RequisitionOrderRejectionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.RequisitionOrderRejectionComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.remark.OrderPositionMutationRemarkComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.remark.OrderPositionReceivingRemarkComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.remark.OrderPositionRejectionRemarkComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.remark.OrderPositionRejectionRemarkComplete_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.DataFieldAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.ModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.ARequisitionOrderAccess;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.GroupCheckOutCBAccess;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.RequisitionOrderAccess;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeComplete_;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.TransactionType;
import ch.icit.pegasus.server.core.dtos.utils.UnitConversionToolkit;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

public class OrderPositionsDetailsPanel
extends TableDetailsPanel<RequisitionOrderLight> {
    private static final long serialVersionUID = 1L;
    private boolean isDeletable;
    private boolean isAmountChangable;
    private boolean isAmountChangableAnyway;
    private boolean isStoreChangable;

    public OrderPositionsDetailsPanel(RowEditor<RequisitionOrderLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.ORDER_POSITIONS);
        this.isDeletable = provider.isDeletable(RequisitionOrderComplete_.orderPositions);
        this.isAmountChangable = provider.isWritable(RequisitionOrderPositionComplete_.quantity);
        this.isStoreChangable = provider.isWritable(RequisitionOrderPositionComplete_.receivingStore);
        this.isAmountChangableAnyway = provider.isWritable(RequisitionOrderAccess.CAN_CHANGE_AMOUNT_WHEN_ORDER_CLOSED);
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        boolean isPlaced = true;
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        int w1 = this.table.getCellPadding() * 2 + ExpandIcon.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM) + 30 + this.table.getInnerCellPadding();
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        columns.add(new TableColumnInfo(Words.NO_NUMBER, "", String.class, null, "", w1, w1, w1));
        w1 = TableColumnInfo.state3 + 2 * this.table.getCellPadding();
        columns.add(new TableColumnInfo(Words.STATE, "", String.class, null, "", w1, w1, w1));
        columns.add(new TableColumnInfo(Words.ARTICLE, "", String.class, null, "", new int[0]));
        if (Boolean.TRUE.equals(this.viewSettings.getShowArticleDepartments())) {
            columns.add(new TableColumnInfo(Words.DELIVER_DEPARTMENT, "", String.class, null, "", 90, 90, 90));
        }
        int tw = InputComboBox.getPreferredWidth(this, InputComboBox.InputComboBoxType.PRICE_DOUBLE);
        int dw = TableColumnInfo.dateTimeColumnWidth + 2 * this.table.getCellPadding();
        columns.add(new TableColumnInfo(Words.DATE, "", String.class, null, "", dw, dw, dw));
        columns.add(new TableColumnInfo(Words.ORDERED, "", String.class, null, "", tw, tw, tw));
        columns.add(new TableColumnInfo(Words.READY, "", String.class, null, "", tw, tw, tw));
        columns.add(new TableColumnInfo(Words.RECEIVED, "", String.class, null, "", tw += this.table.getCellPadding() * 2 + this.table.getInnerCellPadding() + StockTransactionRemarkButton.getPreferredWidth(), tw, tw));
        columns.add(new TableColumnInfo(Words.REJECTED, "", String.class, null, "", tw, tw, tw));
        columns.add(new TableColumnInfo(Words.STORE, "", String.class, null, "", new int[0]));
        if (isPlaced) {
            tw = this.table.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + this.table.getCellPadding();
            columns.add(new TableColumnInfo("", "", String.class, null, "", tw, tw, tw));
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowArticleDepartments())) {
            ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(2)).setxExpand(0.6);
            ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(5)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(6)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(7)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(8)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(9)).setxExpand(0.4);
            if (isPlaced) {
                ((TableColumnInfo)columns.get(10)).setxExpand(0.0);
            }
        } else {
            ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(2)).setxExpand(0.6);
            ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(5)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(6)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(7)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(8)).setxExpand(0.4);
            if (isPlaced) {
                ((TableColumnInfo)columns.get(9)).setxExpand(0.0);
            }
        }
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.enableAddButton(true);
        table.setProvider(this.provider);
        table.setDontUseScrollBar(15);
        table.setSortedColumn(0);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
        RequisitionOrderPositionComplete p = new RequisitionOrderPositionComplete();
        p.setClientOId(Long.valueOf(ADTO.getNextId()));
        p.setOrder((RequisitionOrderComplete)this.editor.getModel().getNode().getValue());
        StoreQuantityComplete q = new StoreQuantityComplete();
        q.setAmount(Long.valueOf(0L));
        p.setQuantity(q);
        p.setSequenceNumber(Integer.valueOf(this.table.getRowCount()));
        p.setState(OrderStateE.PLACED);
        p.setNotDelivered(null);
        p.setAllDelivered(null);
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)p, true, false);
        this.table.getModel().getNode().addChild(n, System.currentTimeMillis());
        this.editor.revalidate();
    }

    @Override
    public void childRemoved() {
        this.editor.revalidate();
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        if (model.getNode().getValue() instanceof OrderPositionComplete) {
            return new OrderPositionTableRow(model);
        }
        return new ReceivingInspectionRow(model);
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (this.table.isWritable()) {
            if (this.table.getRows().size() == 0) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.NO_ORDER_POSITION_DEFINED));
            }
            for (Table2RowPanel p : this.table.getRows()) {
                OrderPositionTableRow t = (OrderPositionTableRow)p;
                t.commitData();
                validationObjects.addAll(t.validateRow());
            }
        }
        return validationObjects;
    }

    @Override
    public void setNode(Node<?> node) {
        this.table.getModel().setNode(node.getChildNamed(RequisitionOrderComplete_.orderPositions));
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    private class ReceivingInspectionRow
    extends Table2RowPanel
    implements ButtonListener,
    InnerPopUpListener2 {
        private static final long serialVersionUID = 1L;
        private TextLabel userName;
        private TextLabel deliveryDate;
        private TextLabel quantity;
        private TextLabel store;
        private StockTransactionRemarkButton remark;
        private EditButton editAmount;
        private InfoButton chargeInfo;
        private StoreQuantityComplete startQuantity;

        public ReceivingInspectionRow(Table2RowModel m) {
            Object[] o1;
            Timestamp validity;
            super(m);
            this.setLayout(new ReceivingLayout());
            this.userName = new TextLabel(m.getNode().getChildNamed(RequisitionOrderRecipientTransactionComplete_.user), ConverterRegistry.getConverter(UserConverter.class));
            this.chargeInfo = new InfoButton();
            this.startQuantity = (StoreQuantityComplete)m.getNode().getChildNamed(RequisitionOrderRecipientTransactionComplete_.amount).getValue();
            Class<OrderPositionReceivingRemarkComplete> remarks = null;
            if (m.getNode().getValue() instanceof RequisitionOrderAcceptationComplete) {
                validity = (Timestamp)m.getNode().getChildNamed(RequisitionOrderAcceptationComplete_.date).getValue();
                BasicArticleComplete artC = (BasicArticleComplete)m.getNode().getChildNamed(new DtoField[]{RequisitionOrderAcceptationComplete_.charge, ArticleChargeComplete_.basicArticle}).getValue(BasicArticleComplete.class);
                Node quantityNode = m.getNode().getChildNamed(RequisitionOrderAcceptationComplete_.amount);
                QuantityComplete convertedQuantity = UnitConversionToolkit.normalizeQuantity((StoreQuantityComplete)((StoreQuantityComplete)quantityNode.getValue()), (BasicArticleComplete)artC, (Timestamp)validity);
                this.quantity = new QuantityRenderer((Node<?>)INodeCreator.getDefaultImpl().getNode4DTO((Object)convertedQuantity, false, false));
                RequisitionOrderAcceptationComplete acDTO = (RequisitionOrderAcceptationComplete)m.getNode().getValue();
                this.store = new TextLabel(acDTO.getDestinationPosition().getStore().getName());
                remarks = OrderPositionReceivingRemarkComplete.class;
                this.chargeInfo.installStringViewer(ArticleToolkit.createInfoString(acDTO));
                this.editAmount = new EditButton();
                this.deliveryDate = new TextLabel(m.getNode().getChildNamed(RequisitionOrderAcceptationComplete_.date), ConverterRegistry.getConverter(DateTimeConverter.class));
            } else if (m.getNode().getValue() instanceof RequisitionOrderPreparationComplete) {
                validity = (Timestamp)m.getNode().getChildNamed(RequisitionOrderPreparationComplete_.date).getValue();
                BasicArticleComplete artC = (BasicArticleComplete)m.getNode().getChildNamed(new DtoField[]{RequisitionOrderPreparationComplete_.charge, ArticleChargeComplete_.basicArticle}).getValue(BasicArticleComplete.class);
                Node quantityNode = m.getNode().getChildNamed(RequisitionOrderAcceptationComplete_.amount);
                QuantityComplete convertedQuantity = UnitConversionToolkit.normalizeQuantity((StoreQuantityComplete)((StoreQuantityComplete)quantityNode.getValue()), (BasicArticleComplete)artC, (Timestamp)validity);
                this.quantity = new QuantityRenderer((Node<?>)INodeCreator.getDefaultImpl().getNode4DTO((Object)convertedQuantity, false, false));
                RequisitionOrderPreparationComplete acDTO = (RequisitionOrderPreparationComplete)m.getNode().getValue();
                this.store = new TextLabel(acDTO.getOriginPosition().getStore().getName());
                remarks = OrderPositionReceivingRemarkComplete.class;
                this.chargeInfo.installStringViewer(ArticleToolkit.createInfoString(acDTO));
                this.editAmount = new EditButton();
                this.deliveryDate = new TextLabel(m.getNode().getChildNamed(RequisitionOrderPreparationComplete_.date), ConverterRegistry.getConverter(DateTimeConverter.class));
            } else if (m.getNode().getValue() instanceof RequisitionOrderPositionMutationComplete) {
                this.quantity = new QuantityRenderer((Node<?>)m.getNode().getChildNamed(RequisitionOrderPositionMutationComplete_.quantity), (Converter<?, ?>)ConverterRegistry.getConverter(DeltaQuantityConverter.class));
                remarks = null;
                this.deliveryDate = new TextLabel(m.getNode().getChildNamed(RequisitionOrderPositionMutationComplete_.date), ConverterRegistry.getConverter(DateTimeConverter.class));
            } else if (m.getNode().getValue() instanceof RequisitionOrderRejectionComplete) {
                validity = (Timestamp)m.getNode().getChildNamed(RequisitionOrderRejectionComplete_.date).getValue();
                BasicArticleComplete artC = (BasicArticleComplete)m.getNode().getChildNamed(new DtoField[]{RequisitionOrderRejectionComplete_.charge, ArticleChargeComplete_.basicArticle}).getValue(BasicArticleComplete.class);
                Node quantityNode = m.getNode().getChildNamed(RequisitionOrderAcceptationComplete_.amount);
                QuantityComplete convertedQuantity = UnitConversionToolkit.normalizeQuantity((StoreQuantityComplete)((StoreQuantityComplete)quantityNode.getValue()), (BasicArticleComplete)artC, (Timestamp)validity);
                this.quantity = new QuantityRenderer((Node<?>)INodeCreator.getDefaultImpl().getNode4DTO((Object)convertedQuantity, false, false));
                RequisitionOrderRejectionComplete acDTO = (RequisitionOrderRejectionComplete)m.getNode().getValue();
                this.chargeInfo.installStringViewer(ArticleToolkit.createInfoString(acDTO));
                this.editAmount = new EditButton();
                this.deliveryDate = new TextLabel(m.getNode().getChildNamed(RequisitionOrderRejectionComplete_.date), ConverterRegistry.getConverter(DateTimeConverter.class));
            } else if (m.getNode().getValue() instanceof RequisitionOrderMoveComplete) {
                this.quantity = new TextLabel(m.getNode().getChildNamed(RequisitionOrderMoveComplete_.amount), ConverterRegistry.getConverter(RejectionReceivingConverter.class));
                RequisitionOrderMoveComplete acDTO = (RequisitionOrderMoveComplete)m.getNode().getValue();
                this.store = new TextLabel(acDTO.getDestinationPosition().getStore().getName());
                this.chargeInfo.installStringViewer(ArticleToolkit.createInfoString(acDTO));
                this.editAmount = new EditButton();
                this.deliveryDate = new TextLabel(m.getNode().getChildNamed(RequisitionOrderMoveComplete_.date), ConverterRegistry.getConverter(DateTimeConverter.class));
            }
            if (m.getNode().getChildNamed(RequisitionOrderRejectionComplete_.remark) != null && m.getNode().getChildNamed(RequisitionOrderRejectionComplete_.remark).getValue() != null && (o1 = this.getRemarkPopUp(0)) != null) {
                this.remark = new StockTransactionRemarkButton(false, remarks);
                this.remark.setPopUpView((IPopUpInsert)o1[0]);
                this.remark.setChoosen(true);
                this.remark.addButtonListener(this);
                this.remark.setProgress(1.0f);
                this.add(this.remark);
            }
            this.quantity.setProgress(1.0f);
            this.userName.setProgress(1.0f);
            if (this.editAmount != null) {
                this.editAmount.addButtonListener(this);
                this.add(this.editAmount);
            }
            this.add(this.userName);
            this.add(this.deliveryDate);
            this.add(this.quantity);
            if (this.store != null) {
                this.store.setProgress(1.0f);
                this.add(this.store);
            }
            this.add(this.chargeInfo);
            this.setEnabled(this.isEnabled());
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        private Object[] getRemarkPopUp(int type) {
            ArrayList<String> list = new ArrayList<String>();
            if (this.model.getNode().getChildNamed(RequisitionOrderRejectionComplete_.remark).getValue() != null) {
                list.add((String)this.model.getNode().getChildNamed(new DtoField[]{RequisitionOrderRejectionComplete_.remark, OrderPositionRejectionRemarkComplete_.description}).getValue());
            }
            if (list.size() == 0) {
                return null;
            }
            Object[] o = new Object[2];
            o[0] = new TextListPopUpInsert(list);
            return o;
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            if (this.userName != null) {
                this.userName.kill();
            }
            if (this.quantity != null) {
                this.quantity.kill();
            }
            if (this.store != null) {
                this.store.kill();
            }
            if (this.remark != null) {
                this.remark.kill();
            }
            if (this.chargeInfo != null) {
                this.chargeInfo.kill();
            }
            if (this.editAmount != null) {
                this.editAmount.kill();
            }
            if (this.deliveryDate != null) {
                this.deliveryDate.kill();
            }
            this.userName = null;
            this.quantity = null;
            this.store = null;
            this.remark = null;
            this.chargeInfo = null;
            this.editAmount = null;
            this.deliveryDate = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.userName.setEnabled(isEnabled);
            this.quantity.setEnabled(isEnabled);
            if (this.store != null) {
                this.store.setEnabled(isEnabled);
            }
            if (this.remark != null) {
                this.remark.setEnabled(isEnabled);
            }
            this.chargeInfo.setEnabled(isEnabled);
            if (this.editAmount != null) {
                if (isEnabled) {
                    // empty if block
                }
                this.editAmount.setEnabled(false);
            }
            this.deliveryDate.setEnabled(isEnabled);
        }

        @Override
        public List<Component> getFocusComponents() {
            return new ArrayList<Component>();
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.editAmount) {
                this.changeAmount(x, y);
            } else {
                InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
                popUp.setAttributes(null, false, false, Words.REMARKS);
                popUp.setView(this.remark.getPopUpView());
                popUp.showPopUp(y, x, 150, 60, null, this.remark);
            }
        }

        private void changeAmount(int x, int y) {
            Node newAmount = this.model.getNode().getChildNamed(DtoFieldConstants.requisitionNewAmount);
            QuantityComplete q = new QuantityComplete(Double.valueOf(TransactionToolkit.getLongValue(this.model.getNode().getChildNamed(new DtoField[]{RequisitionOrderRecipientTransactionComplete_.amount, StoreQuantityComplete_.amount})).doubleValue()), (UnitComplete)this.model.getNode().getChildNamed(new DtoField[]{RequisitionOrderRecipientTransactionComplete_.amount, StoreQuantityComplete_.unit}).getValue());
            if (newAmount == null) {
                StoreQuantityComplete sq = new StoreQuantityComplete(Long.valueOf(q.getQuantity().longValue()), q.getUnit());
                newAmount = INodeCreator.getDefaultImpl().getNode4DTO((Object)sq, false, false);
                newAmount.setName(DtoFieldConstants.requisitionNewAmount);
                this.model.getNode().addChild(newAmount, 0L);
            }
            if (newAmount != null) {
                newAmount.getChildNamed(StoreQuantityComplete_.amount).setValue((Object)q.getQuantity(), 0L);
                newAmount.getChildNamed(StoreQuantityComplete_.unit).setValue((Object)q.getUnit(), 0L);
            }
            InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
            popUp.setAttributes(this.editAmount, true, true, Words.CHANGE_AMOUNT);
            Node articleNode = this.model.getNode().getChildNamed(new DtoField[]{RequisitionOrderRecipientTransactionComplete_.batch, OrderPositionBatchComplete_.charge});
            if (articleNode == null) {
                articleNode = this.model.getNode().getChildNamed(RequisitionOrderPreparationComplete_.charge);
            }
            Date date = (Date)this.model.getNode().getParent().getParent().getParent().getParent().getChildNamed(RequisitionOrderComplete_.requiredOn).getValue();
            Timestamp validity = new Timestamp(date.getTime());
            popUp.setView(new OrderAmountChangingPopup(newAmount, this.model.getNode().getChildNamed(RequisitionOrderRecipientTransactionComplete_.amount), articleNode, validity, null, null, TransactionType.REQUISITION));
            popUp.showPopUp(x, y, 200, -1, this, this.editAmount);
        }

        @Override
        public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
            if (xargs == null) {
                return;
            }
            if (source.getCaller() == this.editAmount) {
                Node newAmount = this.model.getNode().getChildNamed(DtoFieldConstants.requisitionNewAmount);
                Long a = TransactionToolkit.getLongValue(newAmount.getChildNamed(StoreQuantityComplete_.amount));
                Long b = this.startQuantity.getAmount();
                this.model.getNode().getChildNamed(new DtoField[]{RequisitionOrderRecipientTransactionComplete_.amount, StoreQuantityComplete_.amount}).setValue(newAmount.getChildNamed(StoreQuantityComplete_.amount).getValue(), System.currentTimeMillis());
                this.model.getNode().getChildNamed(new DtoField[]{RequisitionOrderRecipientTransactionComplete_.amount, StoreQuantityComplete_.unit}).setValue(newAmount.getChildNamed(StoreQuantityComplete_.unit).getValue(), System.currentTimeMillis());
                StoreQuantityComplete qq = (StoreQuantityComplete)this.model.getNode().getChildNamed(RequisitionOrderRecipientTransactionComplete_.amount).getValue();
                qq.setAmount(a);
                qq.setUnit((UnitComplete)newAmount.getChildNamed(StoreQuantityComplete_.unit).getValue());
                this.model.getNode().getChildNamed(new DtoField[]{RequisitionOrderRecipientTransactionComplete_.amount, StoreQuantityComplete_.amount}).setValue((Object)qq.getAmount(), System.currentTimeMillis());
                this.model.getNode().getChildNamed(new DtoField[]{RequisitionOrderRecipientTransactionComplete_.amount, StoreQuantityComplete_.unit}).setValue((Object)qq.getUnit(), System.currentTimeMillis());
                if (a.longValue() != b.longValue()) {
                    this.quantity.setLeftUpperCornerPainting(true, AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("productionplanner_stocksetted_color")));
                } else {
                    this.quantity.setLeftUpperCornerPainting(false, AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("productionplanner_stocksetted_color")));
                }
                this.quantity.updateString();
            }
        }

        private class ReceivingLayout
        extends DefaultLayout {
            private ReceivingLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int w;
                int currentX = w = ReceivingInspectionRow.this.model.getParentModel().getColumnWidth(0);
                w = ReceivingInspectionRow.this.model.getParentModel().getColumnWidth(1);
                currentX += w;
                w = ReceivingInspectionRow.this.model.getParentModel().getColumnWidth(2);
                ReceivingInspectionRow.this.userName.setLocation(currentX + OrderPositionsDetailsPanel.this.table.getCellPadding(), (int)(((double)parent.getHeight() - ReceivingInspectionRow.this.userName.getPreferredSize().getHeight()) / 2.0));
                ReceivingInspectionRow.this.userName.setSize((int)((double)w - ((double)(2 * OrderPositionsDetailsPanel.this.table.getCellPadding()) + ReceivingInspectionRow.this.chargeInfo.getPreferredSize().getWidth() + (double)OrderPositionsDetailsPanel.this.table.getInnerCellPadding())), (int)ReceivingInspectionRow.this.userName.getPreferredSize().getHeight());
                ReceivingInspectionRow.this.chargeInfo.setLocation(ReceivingInspectionRow.this.userName.getX() + ReceivingInspectionRow.this.userName.getWidth() + OrderPositionsDetailsPanel.this.table.getInnerCellPadding(), (int)(((double)parent.getHeight() - ReceivingInspectionRow.this.chargeInfo.getPreferredSize().getHeight()) / 2.0));
                ReceivingInspectionRow.this.chargeInfo.setSize(ReceivingInspectionRow.this.chargeInfo.getPreferredSize());
                currentX += w;
                w = ReceivingInspectionRow.this.model.getParentModel().getColumnWidth(3);
                currentX += w;
                w = ReceivingInspectionRow.this.model.getParentModel().getColumnWidth(4);
                ReceivingInspectionRow.this.deliveryDate.setLocation(currentX + ReceivingInspectionRow.this.getCellPadding(), (int)(((double)parent.getHeight() - ReceivingInspectionRow.this.deliveryDate.getPreferredSize().getHeight()) / 2.0));
                ReceivingInspectionRow.this.deliveryDate.setSize(w - 2 * ReceivingInspectionRow.this.getCellPadding(), (int)ReceivingInspectionRow.this.deliveryDate.getPreferredSize().getHeight());
                currentX += w;
                w = ReceivingInspectionRow.this.model.getParentModel().getColumnWidth(5);
                if (ReceivingInspectionRow.this.model.getNode().getValue() instanceof RequisitionOrderPositionMutationComplete) {
                    ReceivingInspectionRow.this.quantity.setLocation(currentX + OrderPositionsDetailsPanel.this.table.getCellPadding(), (int)(((double)parent.getHeight() - ReceivingInspectionRow.this.quantity.getPreferredSize().getHeight()) / 2.0));
                    ReceivingInspectionRow.this.quantity.setSize((int)ReceivingInspectionRow.this.quantity.getPreferredSize().getWidth(), (int)ReceivingInspectionRow.this.quantity.getPreferredSize().getHeight());
                }
                currentX += w;
                w = ReceivingInspectionRow.this.model.getParentModel().getColumnWidth(6);
                if (ReceivingInspectionRow.this.model.getNode().getValue() instanceof RequisitionOrderPreparationComplete) {
                    ReceivingInspectionRow.this.quantity.setLocation(currentX + ReceivingInspectionRow.this.getCellPadding(), (int)(((double)parent.getHeight() - ReceivingInspectionRow.this.quantity.getPreferredSize().getHeight()) / 2.0));
                    ReceivingInspectionRow.this.quantity.setSize((int)ReceivingInspectionRow.this.quantity.getPreferredSize().getWidth(), (int)ReceivingInspectionRow.this.quantity.getPreferredSize().getHeight());
                    if (ReceivingInspectionRow.this.remark != null) {
                        ReceivingInspectionRow.this.remark.setLocation(ReceivingInspectionRow.this.quantity.getX() + ReceivingInspectionRow.this.quantity.getWidth() + ReceivingInspectionRow.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - ReceivingInspectionRow.this.remark.getPreferredSize().getHeight()) / 2.0));
                        ReceivingInspectionRow.this.remark.setSize(ReceivingInspectionRow.this.remark.getPreferredSize());
                    }
                    ReceivingInspectionRow.this.editAmount.setLocation((int)((double)(currentX + w) - (ReceivingInspectionRow.this.editAmount.getPreferredSize().getWidth() + (double)ReceivingInspectionRow.this.getCellPadding())), (int)((double)parent.getHeight() - ReceivingInspectionRow.this.editAmount.getPreferredSize().getHeight()) / 2);
                    ReceivingInspectionRow.this.editAmount.setSize(ReceivingInspectionRow.this.editAmount.getPreferredSize());
                }
                currentX += w;
                w = ReceivingInspectionRow.this.model.getParentModel().getColumnWidth(7);
                if (ReceivingInspectionRow.this.model.getNode().getValue() instanceof RequisitionOrderAcceptationComplete || ReceivingInspectionRow.this.model.getNode().getValue() instanceof RequisitionOrderMoveComplete) {
                    ReceivingInspectionRow.this.quantity.setLocation(currentX + OrderPositionsDetailsPanel.this.table.getCellPadding(), (int)(((double)parent.getHeight() - ReceivingInspectionRow.this.quantity.getPreferredSize().getHeight()) / 2.0));
                    ReceivingInspectionRow.this.quantity.setSize((int)ReceivingInspectionRow.this.quantity.getPreferredSize().getWidth(), (int)ReceivingInspectionRow.this.quantity.getPreferredSize().getHeight());
                    if (ReceivingInspectionRow.this.remark != null) {
                        ReceivingInspectionRow.this.remark.setLocation(ReceivingInspectionRow.this.quantity.getX() + ReceivingInspectionRow.this.quantity.getWidth() + ReceivingInspectionRow.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - ReceivingInspectionRow.this.remark.getPreferredSize().getHeight()) / 2.0));
                        ReceivingInspectionRow.this.remark.setSize(ReceivingInspectionRow.this.remark.getPreferredSize());
                    }
                    ReceivingInspectionRow.this.editAmount.setLocation((int)((double)(currentX + w) - (ReceivingInspectionRow.this.editAmount.getPreferredSize().getWidth() + (double)ReceivingInspectionRow.this.getCellPadding())), (int)((double)parent.getHeight() - ReceivingInspectionRow.this.editAmount.getPreferredSize().getHeight()) / 2);
                    ReceivingInspectionRow.this.editAmount.setSize(ReceivingInspectionRow.this.editAmount.getPreferredSize());
                }
                currentX += w;
                w = ReceivingInspectionRow.this.model.getParentModel().getColumnWidth(8);
                if (ReceivingInspectionRow.this.model.getNode().getValue() instanceof RequisitionOrderRejectionComplete) {
                    ReceivingInspectionRow.this.quantity.setLocation(currentX + OrderPositionsDetailsPanel.this.table.getCellPadding(), (int)(((double)parent.getHeight() - ReceivingInspectionRow.this.quantity.getPreferredSize().getHeight()) / 2.0));
                    ReceivingInspectionRow.this.quantity.setSize((int)ReceivingInspectionRow.this.quantity.getPreferredSize().getWidth(), (int)ReceivingInspectionRow.this.quantity.getPreferredSize().getHeight());
                    if (ReceivingInspectionRow.this.remark != null) {
                        ReceivingInspectionRow.this.remark.setLocation(ReceivingInspectionRow.this.quantity.getX() + ReceivingInspectionRow.this.quantity.getWidth() + ReceivingInspectionRow.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - ReceivingInspectionRow.this.remark.getPreferredSize().getHeight()) / 2.0));
                        ReceivingInspectionRow.this.remark.setSize(ReceivingInspectionRow.this.remark.getPreferredSize());
                    }
                    ReceivingInspectionRow.this.editAmount.setLocation((int)((double)(currentX + w) - (ReceivingInspectionRow.this.editAmount.getPreferredSize().getWidth() + (double)ReceivingInspectionRow.this.getCellPadding())), (int)((double)parent.getHeight() - ReceivingInspectionRow.this.editAmount.getPreferredSize().getHeight()) / 2);
                    ReceivingInspectionRow.this.editAmount.setSize(ReceivingInspectionRow.this.editAmount.getPreferredSize());
                }
                currentX += w;
                w = ReceivingInspectionRow.this.model.getParentModel().getColumnWidth(9);
                if (ReceivingInspectionRow.this.store != null) {
                    ReceivingInspectionRow.this.store.setLocation(currentX + OrderPositionsDetailsPanel.this.table.getCellPadding(), (int)(((double)parent.getHeight() - ReceivingInspectionRow.this.store.getPreferredSize().getHeight()) / 2.0));
                    ReceivingInspectionRow.this.store.setSize(w - 2 * OrderPositionsDetailsPanel.this.table.getCellPadding(), (int)ReceivingInspectionRow.this.store.getPreferredSize().getHeight());
                }
                currentX += w;
                currentX -= 2 * OrderPositionsDetailsPanel.this.table.getCellPadding();
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, ReceivingInspectionRow.this.getDefaultRowHeight());
            }
        }
    }

    private class OrderPositionTableRow
    extends Table2RowPanel
    implements NodeListener,
    ButtonListener,
    InnerPopUpListener2,
    SearchTextField2Listener,
    RemoteLoader {
        private static final long serialVersionUID = 1L;
        private TextLabel label;
        private ExpandIcon expandIcon;
        private CellViewOrderStateRenderer positionState;
        private Component articleName;
        private QuantityRenderer ordered;
        private EditButton changeOrder;
        private EditButton changeReceivingStore;
        private QuantityRenderer ready;
        private QuantityRenderer received;
        private StockTransactionRemarkButton rec_remark;
        private QuantityRenderer rejected;
        private StockTransactionRemarkButton rej_remark;
        private TextLabel receivingStore;
        private DeleteButton deleteButton;
        private InfoButton articleInfo;
        private TextLabel articleDepartment;
        private boolean isClosed;
        private boolean isCancelled;
        private boolean isSet;
        private boolean justAdded;
        private final List<RequisitionOrderRejectionComplete> rejections;
        private final List<RequisitionOrderAcceptationComplete> acceptations;
        private final List<RequisitionOrderPositionMutationComplete> mutations;

        public OrderPositionTableRow(Table2RowModel m) {
            super(m);
            this.isClosed = false;
            this.isCancelled = false;
            this.isSet = false;
            this.justAdded = false;
            this.rejections = new ArrayList<RequisitionOrderRejectionComplete>();
            this.acceptations = new ArrayList<RequisitionOrderAcceptationComplete>();
            this.mutations = new ArrayList<RequisitionOrderPositionMutationComplete>();
            if (m.getNode().getChildNamed(RequisitionOrderPositionComplete_.article).getValue() == null) {
                this.isSet = false;
                this.justAdded = true;
            } else {
                this.isSet = true;
            }
            this.model.getNode().getChildNamed(new DtoField[]{RequisitionOrderPositionComplete_.order, RequisitionOrderComplete_.requiredOn}).addNodeListener((NodeListener)this);
            this.isClosed = m.getNode().getChildNamed(RequisitionOrderPositionComplete_.state).getValue().equals(OrderStateE.CLOSED);
            this.isCancelled = m.getNode().getChildNamed(RequisitionOrderPositionComplete_.state).getValue().equals(OrderStateE.CANCELLED);
            this.articleInfo = new InfoButton(SizedSkin1Field.SkinSize.MEDIUM);
            Date date = (Date)OrderPositionsDetailsPanel.this.editor.getModel().getNode().getChildNamed(RequisitionOrderComplete_.requiredOn).getValue();
            Timestamp validity = new Timestamp(date.getTime());
            BasicArticleComplete artC = (BasicArticleComplete)m.getNode().getChildNamed(RequisitionOrderPositionComplete_.article).getValue(BasicArticleComplete.class);
            if (this.isSet) {
                Node newAmount;
                SimpleDateFormat format;
                Timestamp ts;
                UserLight user;
                String articleInfoPopupString = ArticleToolkit.getArticleInfoPopupString(artC, validity, 11, false);
                if (Boolean.TRUE.equals(m.getNode().getChildNamed(RequisitionOrderPositionComplete_.allDelivered).getValue())) {
                    user = (UserLight)m.getNode().getChildNamed(RequisitionOrderPositionComplete_.allDeliveredUser).getValue();
                    ts = (Timestamp)m.getNode().getChildNamed(RequisitionOrderPositionComplete_.allDeliveredDate).getValue();
                    if (user != null) {
                        format = new SimpleDateFormat("dd.MM.yyyy HH:mm");
                        articleInfoPopupString = articleInfoPopupString + "<br/><b>All delivered</b><br/>User: " + user.getUserName() + "<br/>Date: " + format.format(ts);
                    }
                } else if (Boolean.TRUE.equals(m.getNode().getChildNamed(RequisitionOrderPositionComplete_.notDelivered).getValue())) {
                    user = (UserLight)m.getNode().getChildNamed(RequisitionOrderPositionComplete_.notDeliveredUser).getValue();
                    ts = (Timestamp)m.getNode().getChildNamed(RequisitionOrderPositionComplete_.notDeliveredDate).getValue();
                    if (user != null) {
                        format = new SimpleDateFormat("dd.MM.yyyy HH:mm");
                        articleInfoPopupString = articleInfoPopupString + "<br/><b>All delivered</b><br/>User: " + user.getUserName() + "<br/>Date: " + format.format(ts);
                    }
                }
                this.articleInfo.installStringViewer(articleInfoPopupString);
                Node newPos = this.model.getNode().getChildNamed(DtoFieldConstants.requisitionNewPosition);
                if (newPos == null) {
                    newPos = new DTOProxyNode();
                    newPos.setName(DtoFieldConstants.requisitionNewPosition);
                    StorePositionLight l = (StorePositionLight)this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.receivingStore).getValue();
                    newPos.setValue((Object)l, 0L);
                    this.model.getNode().addChild(newPos, 0L);
                }
                if ((newAmount = this.model.getNode().getChildNamed(DtoFieldConstants.requisitionNewAmount)) == null) {
                    newAmount = new EmbeddedDTONode();
                    newAmount.setName(DtoFieldConstants.requisitionNewAmount);
                    StoreQuantityComplete q = new StoreQuantityComplete();
                    q.setAmount(TransactionToolkit.getLongValue(this.model.getNode().getChildNamed(new DtoField[]{RequisitionOrderPositionComplete_.quantity, StoreQuantityComplete_.amount})));
                    q.setUnit((UnitComplete)this.model.getNode().getChildNamed(new DtoField[]{RequisitionOrderPositionComplete_.quantity, StoreQuantityComplete_.unit}).getValue());
                    List conversion = UnitCalculator.getArticlePackagingQuantities((IBasicArticle)artC, (Timestamp)validity);
                    QuantityComplete nq1 = UnitConversionToolkit.normalizeQuantity((StoreQuantityComplete)q, (BasicArticleComplete)artC, (Timestamp)validity);
                    StoreQuantityComplete convert = (StoreQuantityComplete)UnitCalculator.convert((IBasicArticle)artC, (List)conversion, (IQuantity)nq1);
                    newAmount.setValue((Object)convert, 0L);
                    this.model.getNode().addChild(newAmount, 0L);
                }
            }
            this.setLayoutInnerChildsSelf(true);
            this.setExpanded(false);
            if (m.getNode().getChildNamed(RequisitionOrderPositionComplete_.sequenceNumber).getValue() == null) {
                m.getNode().getChildNamed(RequisitionOrderPositionComplete_.sequenceNumber).setValue((Object)m.getNode().getParent().getChildIndex(m.getNode()), System.currentTimeMillis());
            }
            this.label = new TextLabel(m.getNode().getChildNamed(RequisitionOrderPositionComplete_.sequenceNumber), ConverterRegistry.getConverter(IntegerPlusPlusConverter.class));
            this.expandIcon = new ExpandIcon();
            this.expandIcon.addButtonListener(this);
            OrderStateE orderState = (OrderStateE)m.getNode().getChildNamed(RequisitionOrderPositionComplete_.state).getValue();
            this.positionState = new CellViewOrderStateRenderer(orderState);
            if (this.isSet) {
                Converter artViewConverter = ConverterRegistry.getConverter(RequisitionPositionNameConverter.class);
                this.articleName = new TextLabel(m.getNode(), artViewConverter);
            } else {
                RDSearchTextField2 r1 = new RDSearchTextField2(OrderPositionsDetailsPanel.this.provider, RDSearchTextField2.SearchTypes.ARTICLE);
                r1.setNode(m.getNode().getChildNamed(RequisitionOrderPositionComplete_.article));
                r1.addSearchTextFieldListener(this);
                Object[] o = new Object[8];
                Boolean canMoveAny = false;
                for (ModuleAccessRightComplete module : OrderPositionsDetailsPanel.this.currentUser.getModules()) {
                    if (!module.getModule().getInvokingName().equals(GroupCheckOutCBAccess.MODULE_CHECKOUTGROUPCB.getIdentifier())) continue;
                    for (DataFieldAccessRightComplete fieldAccessRight : module.getFieldAccessRights()) {
                        if (!fieldAccessRight.getField().getName().equals(GroupCheckOutCBAccess.CHECKOUT_ANY_ARTICLE.getName())) continue;
                        canMoveAny = null;
                    }
                }
                o[6] = canMoveAny == null ? null : Boolean.valueOf(true);
                o[7] = this.model.getNode().getParent().getParent().getChildNamed(RequisitionOrderComplete_.halalOrder).getValue();
                r1.setAdditionalSearchField(o);
                this.articleName = r1;
            }
            this.ordered = new QuantityRenderer((Node<?>)m.getNode().getChildNamed(DtoFieldConstants.requisitionNewAmount));
            this.ordered.setViewConverter(ConverterRegistry.getConverter(QuantityConverter2Decimal.class));
            if (this.isSet) {
                StoreQuantityComplete q1 = new StoreQuantityComplete();
                q1.setAmount(((StoreQuantityComplete)m.getNode().getChildNamed(RequisitionOrderPositionComplete_.preparedAmount).getValue()).getAmount());
                q1.setUnit(((StoreQuantityComplete)m.getNode().getChildNamed(RequisitionOrderPositionComplete_.preparedAmount).getValue()).getUnit());
                QuantityComplete nq1 = UnitConversionToolkit.normalizeQuantity((StoreQuantityComplete)q1, (BasicArticleComplete)artC, (Timestamp)validity);
                this.ready = new QuantityRenderer((Node<?>)INodeCreator.getDefaultImpl().getNode4DTO((Object)nq1, true, false));
                StoreQuantityComplete q2 = new StoreQuantityComplete();
                q2.setAmount(((StoreQuantityComplete)m.getNode().getChildNamed(RequisitionOrderPositionComplete_.deliveredAmount).getValue()).getAmount());
                q2.setUnit(((StoreQuantityComplete)m.getNode().getChildNamed(RequisitionOrderPositionComplete_.deliveredAmount).getValue()).getUnit());
                QuantityComplete nq2 = UnitConversionToolkit.normalizeQuantity((StoreQuantityComplete)q2, (BasicArticleComplete)artC, (Timestamp)validity);
                this.received = new QuantityRenderer((Node<?>)INodeCreator.getDefaultImpl().getNode4DTO((Object)nq2, true, false));
                StoreQuantityComplete q4 = new StoreQuantityComplete();
                q4.setAmount(((StoreQuantityComplete)m.getNode().getChildNamed(RequisitionOrderPositionComplete_.rejectedAmount).getValue()).getAmount());
                q4.setUnit(((StoreQuantityComplete)m.getNode().getChildNamed(RequisitionOrderPositionComplete_.rejectedAmount).getValue()).getUnit());
                QuantityComplete nq4 = UnitConversionToolkit.normalizeQuantity((StoreQuantityComplete)q4, (BasicArticleComplete)artC, (Timestamp)validity);
                this.rejected = new QuantityRenderer((Node<?>)INodeCreator.getDefaultImpl().getNode4DTO((Object)nq4, true, false));
                this.rej_remark = new StockTransactionRemarkButton<OrderPositionRejectionRemarkComplete>(false, OrderPositionRejectionRemarkComplete.class);
                this.rec_remark = new StockTransactionRemarkButton<OrderPositionReceivingRemarkComplete>(false, OrderPositionReceivingRemarkComplete.class);
            }
            if (Boolean.TRUE.equals(OrderPositionsDetailsPanel.this.viewSettings.getShowArticleDepartments())) {
                this.articleDepartment = new TextLabel(m.getNode().getChildNamed(new DtoField[]{RequisitionOrderPositionComplete_.article, BasicArticleLight_.defaultRequisitionDeliverDepartment}), ConverterRegistry.getConverter(CostCenterConverter.class));
            }
            this.changeOrder = new EditButton();
            this.changeOrder.addButtonListener(this);
            this.changeReceivingStore = new EditButton();
            this.changeReceivingStore.addButtonListener(this);
            this.receivingStore = new TextLabel(m.getNode().getChildNamed(DtoFieldConstants.requisitionNewPosition), ConverterRegistry.getConverter(StorePositionShortNameConverter.class));
            this.setLayout(new Layout());
            m.getNode().getChildNamed(RequisitionOrderPositionComplete_.transactions).addNodeListener((NodeListener)this);
            m.getNode().getChildNamed(RequisitionOrderPositionComplete_.transactions).getAllChildAddEventsFor((NodeListener)this, new String[0]);
            if (this.children.size() == 0) {
                this.expandIcon.setEnabled(false);
            } else {
                this.expandIcon.setEnabled(true);
            }
            this.updateOrderUnitConversionValidity();
            if (this.isSet) {
                Object[] o1 = this.getRemarkPopUp(0);
                this.rej_remark.setPopUpView((IPopUpInsert)o1[0]);
                if (((Boolean)o1[1]).booleanValue()) {
                    this.rej_remark.setChoosen(true);
                }
                this.rej_remark.addButtonListener(this);
                o1 = this.getRemarkPopUp(2);
                this.rec_remark.setPopUpView((IPopUpInsert)o1[0]);
                if (((Boolean)o1[1]).booleanValue()) {
                    this.rec_remark.setChoosen(true);
                }
                this.rec_remark.addButtonListener(this);
            }
            if (!this.isSet) {
                this.changeOrder.setEnabled(false);
                this.changeReceivingStore.setEnabled(false);
            }
            this.add(this.label);
            this.add(this.expandIcon);
            this.add(this.positionState);
            this.add(this.articleName);
            if (this.articleInfo != null) {
                this.add(this.articleInfo);
            }
            if (this.articleDepartment != null) {
                this.add(this.articleDepartment);
            }
            this.add(this.ordered);
            this.add(this.changeOrder);
            if (this.ready != null) {
                this.add(this.ready);
                this.add(this.received);
                this.add(this.rejected);
                this.add(this.rej_remark);
                this.add(this.rec_remark);
            }
            this.add(this.receivingStore);
            this.add(this.changeReceivingStore);
            if (this.isPlaced() && OrderPositionsDetailsPanel.this.isDeletable) {
                this.deleteButton = new DeleteButton();
                this.deleteButton.addButtonListener(this);
                this.add(this.deleteButton);
            }
        }

        private boolean isPlaced() {
            OrderStateE value = (OrderStateE)this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.state).getValue();
            boolean isPlaced = value == null || value == OrderStateE.PLACED;
            return isPlaced;
        }

        private void updateOrderUnitConversionValidity() {
            if (!Boolean.TRUE.equals(this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.orderUnitConversionValidity).getValue())) {
                this.ordered.setInvalid();
            }
        }

        private void updateArticleInfoAndSelectableUnits() {
            BasicArticleComplete artC = (BasicArticleComplete)this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.article).getValue(BasicArticleComplete.class);
            Date date = (Date)this.model.getNode().getChildNamed(new DtoField[]{RequisitionOrderPositionComplete_.order, RequisitionOrderComplete_.requiredOn}).getValue();
            Timestamp validity = new Timestamp(date.getTime());
            String articleInfoPopupString = ArticleToolkit.getArticleInfoPopupString(artC, validity, 11, false);
            if (Boolean.TRUE.equals(this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.allDelivered).getValue())) {
                UserLight user = (UserLight)this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.allDeliveredUser).getValue();
                Timestamp ts = (Timestamp)this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.allDeliveredDate).getValue();
                if (user != null) {
                    SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy HH:mm");
                    articleInfoPopupString = articleInfoPopupString + "<br/><b>All delivered</b><br/>User: " + user.getUserName() + "<br/>Date: " + format.format(ts);
                }
            } else if (Boolean.TRUE.equals(this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.notDelivered).getValue())) {
                UserLight user = (UserLight)this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.notDeliveredUser).getValue();
                Timestamp ts = (Timestamp)this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.notDeliveredDate).getValue();
                if (user != null) {
                    SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy HH:mm");
                    articleInfoPopupString = articleInfoPopupString + "<br/><b>All delivered</b><br/>User: " + user.getUserName() + "<br/>Date: " + format.format(ts);
                }
            }
            this.articleInfo.installStringViewer(articleInfoPopupString);
        }

        public void commitData() {
            if (this.model.getNode().getChildNamed(DtoFieldConstants.requisitionNewAmount) != null) {
                Long a = TransactionToolkit.getLongValue(this.model.getNode().getChildNamed(new DtoField[]{DtoFieldConstants.requisitionNewAmount, StoreQuantityComplete_.amount}));
                UnitComplete u = (UnitComplete)this.model.getNode().getChildNamed(new DtoField[]{DtoFieldConstants.requisitionNewAmount, StoreQuantityComplete_.unit}).getValue();
                long currentID = System.currentTimeMillis();
                Node an = this.model.getNode().getChildNamed(new DtoField[]{RequisitionOrderPositionComplete_.quantity, StoreQuantityComplete_.amount});
                Node un = this.model.getNode().getChildNamed(new DtoField[]{RequisitionOrderPositionComplete_.quantity, StoreQuantityComplete_.unit});
                an.setValue((Object)a, currentID);
                un.setValue((Object)u, currentID);
            }
            if (this.model.getNode().getChildNamed(DtoFieldConstants.requisitionNewPosition) != null) {
                StorePositionLight storePos = (StorePositionLight)this.model.getNode().getChildNamed(DtoFieldConstants.requisitionNewPosition).getValue();
                this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.receivingStore).setValue((Object)storePos, System.currentTimeMillis());
            }
        }

        public List<ScreenValidationObject> validateRow() {
            ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
            if (this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.article).getValue(BasicArticleComplete.class) == null) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.NO_ARTICLE_SELECTED));
            } else {
                BasicArticleComplete artC = (BasicArticleComplete)this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.article).getValue(BasicArticleComplete.class);
                if (artC == null) {
                    validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.NO_ARTICLE_SELECTED));
                } else {
                    if (this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.receivingStore).getValue() == null) {
                        validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.NO_RECEIVE_STORE_SELECTED));
                    }
                    if (this.model.getNode().getChildNamed(DtoFieldConstants.requisitionNewAmount) != null) {
                        if (this.model.getNode().getChildNamed(DtoFieldConstants.requisitionNewAmount).getValue() == null || this.model.getNode().getChildNamed(new DtoField[]{DtoFieldConstants.requisitionNewAmount, StoreQuantityComplete_.amount}).getValue() == null || this.model.getNode().getChildNamed(new DtoField[]{DtoFieldConstants.requisitionNewAmount, StoreQuantityComplete_.unit}).getValue() == null) {
                            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.ENSURE_ORDER_AMOUNT_IS_SET, (Object[])new Object[]{artC.getNutritionApproveComment()})));
                        } else {
                            Date date = (Date)OrderPositionsDetailsPanel.this.editor.getModel().getNode().getChildNamed(RequisitionOrderComplete_.requiredOn).getValue();
                            Timestamp validity = new Timestamp(date.getTime());
                            UnitComplete unit = (UnitComplete)this.model.getNode().getChildNamed(new DtoField[]{DtoFieldConstants.requisitionNewAmount, StoreQuantityComplete_.unit}).getValue();
                            int i = UnitConversionToolkit.isUnitContaining((UnitComplete)unit, (BasicArticleLight)artC, (Timestamp)validity);
                            if (i == 11) {
                                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.SELECTED_UNIT_IS_NOT_CONVERTIBLE, (Object[])new Object[]{unit.getShortName(), artC.getNumber(), artC.getName()})));
                            }
                        }
                        Long l = TransactionToolkit.getLongValue(this.model.getNode().getChildNamed(new DtoField[]{DtoFieldConstants.requisitionNewAmount, StoreQuantityComplete_.amount}));
                        if (this.justAdded && (this.model.getNode().getChildNamed(DtoFieldConstants.requisitionNewAmount).getValue() == null || this.model.getNode().getChildNamed(new DtoField[]{DtoFieldConstants.requisitionNewAmount, StoreQuantityComplete_.amount}).getValue() == null || l <= 0L)) {
                            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.ENSURE_ORDER_AMOUNT_IS_GREATER_THAN_ZERO, (Object[])new Object[]{artC.getName()})));
                        }
                    }
                }
            }
            return validationObjects;
        }

        @Override
        public Object getObject4Column(int column) {
            if (Boolean.TRUE.equals(OrderPositionsDetailsPanel.this.viewSettings.getShowArticleDepartments())) {
                switch (column) {
                    case 0: {
                        return this.label.getNode().getValue();
                    }
                    case 1: {
                        return this.positionState.getStringValue();
                    }
                    case 2: {
                        if (this.articleName != null) {
                            if (this.isSet) {
                                return ((TextLabel)this.articleName).getText();
                            }
                            return ((SearchTextField2)this.articleName).getText();
                        }
                        return "";
                    }
                    case 3: {
                        return this.articleDepartment.getText();
                    }
                    case 4: {
                        return this.ordered.getText();
                    }
                    case 5: {
                        if (this.ready != null) {
                            return this.ready.getText();
                        }
                        return null;
                    }
                    case 6: {
                        if (this.received != null) {
                            return this.received.getText();
                        }
                        return null;
                    }
                    case 7: {
                        if (this.rejected != null) {
                            return this.rejected.getText();
                        }
                        return null;
                    }
                    case 8: {
                        return this.receivingStore.getText();
                    }
                }
            } else {
                switch (column) {
                    case 0: {
                        return this.label.getNode().getValue();
                    }
                    case 1: {
                        return this.positionState.getStringValue();
                    }
                    case 2: {
                        if (this.articleName != null) {
                            if (this.isSet) {
                                return ((TextLabel)this.articleName).getText();
                            }
                            return ((SearchTextField2)this.articleName).getText();
                        }
                        return "";
                    }
                    case 3: {
                        return this.ordered.getText();
                    }
                    case 4: {
                        if (this.ready != null) {
                            return this.ready.getText();
                        }
                        return null;
                    }
                    case 5: {
                        if (this.received != null) {
                            return this.received.getText();
                        }
                        return null;
                    }
                    case 6: {
                        if (this.rejected != null) {
                            return this.rejected.getText();
                        }
                        return null;
                    }
                    case 7: {
                        return this.receivingStore.getText();
                    }
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.label.setEnabled(isEnabled);
            this.expandIcon.setEnabled(isEnabled && this.children.size() != 0);
            this.articleName.setEnabled(isEnabled);
            this.ordered.setEnabled(isEnabled);
            if (this.articleDepartment != null) {
                this.articleDepartment.setEnabled(isEnabled);
            }
            boolean changeOrderAmount = false;
            if (isEnabled && this.isSet && !this.isCancelled) {
                changeOrderAmount = this.isClosed ? OrderPositionsDetailsPanel.this.isAmountChangableAnyway : OrderPositionsDetailsPanel.this.isAmountChangable;
            }
            this.changeOrder.setEnabled(changeOrderAmount);
            if (this.isSet && this.ready != null) {
                this.ready.setEnabled(isEnabled);
                this.received.setEnabled(isEnabled);
                this.rejected.setEnabled(isEnabled);
                this.rej_remark.setEnabled(isEnabled);
                this.rec_remark.setEnabled(isEnabled);
            }
            this.articleInfo.setEnabled(isEnabled && this.isSet);
            this.positionState.setEnabled(isEnabled);
            this.changeReceivingStore.setEnabled(isEnabled && !this.isClosed && OrderPositionsDetailsPanel.this.isStoreChangable && this.isSet && !this.isCancelled);
            this.receivingStore.setEnabled(isEnabled);
            if (this.deleteButton != null) {
                this.deleteButton.setEnabled(isEnabled);
            }
        }

        @Override
        public List<Component> getFocusComponents() {
            return new ArrayList<Component>();
        }

        private Object[] getRemarkPopUp(int type) {
            ArrayList<String> list = new ArrayList<String>();
            if (type == 0) {
                for (RequisitionOrderRejectionComplete requisitionOrderRejectionComplete : this.rejections) {
                    if (requisitionOrderRejectionComplete.getRemark() == null) continue;
                    list.add(requisitionOrderRejectionComplete.getRemark().getDescription());
                }
            } else if (type == 2) {
                for (RequisitionOrderAcceptationComplete requisitionOrderAcceptationComplete : this.acceptations) {
                    if (requisitionOrderAcceptationComplete.getRemark() == null) continue;
                    list.add(requisitionOrderAcceptationComplete.getRemark().getDescription());
                }
            }
            boolean isSelected = true;
            if (list.size() == 0) {
                isSelected = false;
                list.add(Words.NO_REMARK);
            }
            Object[] objectArray = new Object[]{new TextListPopUpInsert(list), isSelected};
            return objectArray;
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.transactions).removeNodeListener((NodeListener)this);
            this.model.getNode().getChildNamed(new DtoField[]{RequisitionOrderPositionComplete_.order, RequisitionOrderComplete_.requiredOn}).removeNodeListener((NodeListener)this);
            this.label.kill();
            this.expandIcon.kill();
            if (this.articleName instanceof Killable) {
                ((Killable)((Object)this.articleName)).kill();
            }
            if (this.articleInfo != null) {
                this.articleInfo.kill();
            }
            this.ordered.kill();
            if (this.isSet && this.ready != null) {
                this.ready.kill();
                this.received.kill();
                this.rej_remark.kill();
                this.rec_remark.kill();
                this.rejected.kill();
            }
            this.positionState.kill();
            this.changeOrder.kill();
            this.changeReceivingStore.kill();
            this.receivingStore.kill();
            if (this.deleteButton != null) {
                this.deleteButton.kill();
            }
            if (this.articleDepartment != null) {
                this.articleDepartment.kill();
            }
            this.label = null;
            this.expandIcon = null;
            this.articleName = null;
            this.articleInfo = null;
            this.ordered = null;
            this.ready = null;
            this.received = null;
            this.positionState = null;
            this.rej_remark = null;
            this.rec_remark = null;
            this.rejected = null;
            this.changeOrder = null;
            this.changeReceivingStore = null;
            this.receivingStore = null;
            this.deleteButton = null;
            this.articleDepartment = null;
        }

        public void childAdded(Node<?> source, Node<?> child) {
            if (source.getName().equals(RequisitionOrderPositionComplete_.transactions.getFieldName())) {
                if (child.getValue() instanceof RequisitionOrderAcceptationComplete) {
                    this.acceptations.add((RequisitionOrderAcceptationComplete)child.getValue());
                } else if (child.getValue() instanceof RequisitionOrderRejectionComplete) {
                    this.rejections.add((RequisitionOrderRejectionComplete)child.getValue());
                } else if (child.getValue() instanceof RequisitionOrderPositionMutationComplete) {
                    this.mutations.add((RequisitionOrderPositionMutationComplete)child.getValue());
                }
                if (this.model.getParentModel().shouldAddRow(child)) {
                    this.addRow(child);
                }
            }
        }

        public void childRemoved(Node<?> source, Node<?> child) {
            if (source.getName().equals(RequisitionOrderPositionComplete_.transactions.getFieldName())) {
                Node q = child.getChildNamed(new DtoField[]{RequisitionOrderRecipientTransactionComplete_.amount, StoreQuantityComplete_.amount});
                if (child.getValue() instanceof RequisitionOrderAcceptationComplete) {
                    this.received.getNode().removeChild(q, 0L);
                    ((ViewNode)this.received.getNode()).updateValue();
                } else if (child.getValue() instanceof RequisitionOrderRejectionComplete) {
                    this.rejected.getNode().removeChild(q, 0L);
                    ((ViewNode)this.rejected.getNode()).updateValue();
                } else if (child.getValue() instanceof RequisitionOrderPreparationComplete) {
                    this.ready.getNode().removeChild(q, 0L);
                    ((ViewNode)this.ready.getNode()).updateValue();
                }
                Table2RowPanel p = this.getChild4Node(child);
                if (p != null) {
                    this.removeRow(p);
                }
            }
        }

        public void valueChanged(Node<?> node) {
            this.updateArticleInfoAndSelectableUnits();
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.expandIcon) {
                this.setExpanded(!this.isExpanded(), true);
                OrderPositionsDetailsPanel.this.editor.validate();
            } else if (source == this.rej_remark) {
                InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
                popUp.setAttributes(null, false, false, Words.REMARKS);
                popUp.setView(this.rej_remark.getPopUpView());
                popUp.showPopUp(y, x, 150, 60, null, this.rej_remark);
            } else if (source == this.rec_remark) {
                InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
                popUp.setAttributes(null, false, false, Words.REMARKS);
                popUp.setView(this.rec_remark.getPopUpView());
                popUp.showPopUp(y, x, 150, 60, null, this.rec_remark);
            } else if (source == this.changeOrder) {
                this.changeAmount(x, y);
            } else if (source == this.changeReceivingStore) {
                this.changeReceivingStore(x, y);
            } else if (source == this.deleteButton) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), 0L);
            }
        }

        public void childrenAdded(Node<?> source, Node<?> ... nodes) {
        }

        private void changeReceivingStore(int x, int y) {
            Node newPos = this.model.getNode().getChildNamed(DtoFieldConstants.requisitionNewPosition);
            boolean restrictions = Boolean.TRUE.equals(OrderPositionsDetailsPanel.this.settings.getUseStoreEntryTypeRestrictionForManualTransactions()) && !OrderPositionsDetailsPanel.this.provider.isWritable(ARequisitionOrderAccess.MOVE_FROM_TO_ANY_STORE.getName(), true);
            InnerPopupFactory.showStoreChangePopup(x, y, this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.receivingStore), newPos, this.changeReceivingStore, this, TransactionType.REQUISITION_RECEIVE, restrictions);
        }

        private void changeAmount(int x, int y) {
            Node newAmount = this.model.getNode().getChildNamed(DtoFieldConstants.requisitionNewAmount);
            QuantityComplete q = this.ordered.getNode().getChildNamed(StoreQuantityComplete_.amount).getValue() instanceof Long ? new QuantityComplete(Double.valueOf(((Long)this.ordered.getNode().getChildNamed(StoreQuantityComplete_.amount).getValue()).doubleValue()), (UnitComplete)this.ordered.getNode().getChildNamed(StoreQuantityComplete_.unit).getValue()) : new QuantityComplete((Double)this.ordered.getNode().getChildNamed(StoreQuantityComplete_.amount).getValue(), (UnitComplete)this.ordered.getNode().getChildNamed(StoreQuantityComplete_.unit).getValue());
            newAmount.getChildNamed(StoreQuantityComplete_.amount).setValue((Object)q.getQuantity(), 0L);
            newAmount.getChildNamed(StoreQuantityComplete_.unit).setValue((Object)q.getUnit(), 0L);
            newAmount.getChildNamed(StoreQuantityComplete_.amount).setValue((Object)((Double)this.ordered.getNode().getChildNamed(StoreQuantityComplete_.amount).getValue()), 0L);
            newAmount.getChildNamed(StoreQuantityComplete_.unit).setValue((Object)((UnitComplete)this.ordered.getNode().getChildNamed(StoreQuantityComplete_.unit).getValue()), 0L);
            Node remarks = this.model.getNode().getChildNamed(DtoFieldConstants.requisitionRemarks);
            if (remarks == null) {
                remarks = new Node();
                remarks.setName(DtoFieldConstants.requisitionRemarks);
                this.model.getNode().addChild(remarks, 0L);
            }
            InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
            popUp.setAttributes(this.changeOrder, true, true, Words.CHANGE_ORDER_AMOUNT);
            Date date = (Date)this.model.getNode().getParent().getParent().getChildNamed(RequisitionOrderComplete_.requiredOn).getValue();
            Timestamp validity = new Timestamp(date.getTime());
            popUp.setView(new OrderAmountChangingPopup<OrderPositionMutationRemarkComplete>(newAmount, this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.quantity), this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.article), validity, this.model.getNode().getChildNamed(DtoFieldConstants.requisitionRemarks), OrderPositionMutationRemarkComplete.class, TransactionType.REQUISITION));
            popUp.showPopUp(x, y, 200, -1, this, this.changeOrder);
        }

        @Override
        public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
            if (xargs == null) {
                if (source.getCaller() == this.changeReceivingStore) {
                    Node newPos = this.model.getNode().getChildNamed(DtoFieldConstants.requisitionNewPosition);
                    Node orgPos = this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.receivingStore);
                    newPos.setValue(orgPos.getValue(), System.currentTimeMillis());
                    this.receivingStore.setLeftUpperCornerPainting(false, AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("productionplanner_stocksetted_color")));
                }
                return;
            }
            if (source.getCaller() == this.changeOrder) {
                Long a = TransactionToolkit.getLongValue(this.model.getNode().getChildNamed(new DtoField[]{DtoFieldConstants.requisitionNewAmount, StoreQuantityComplete_.amount}));
                Long b = TransactionToolkit.getLongValue(this.model.getNode().getChildNamed(new DtoField[]{RequisitionOrderPositionComplete_.quantity, StoreQuantityComplete_.amount}));
                this.ordered.getNode().getChildNamed(StoreQuantityComplete_.amount).setValue((Object)a, System.currentTimeMillis());
                this.ordered.getNode().getChildNamed(StoreQuantityComplete_.unit).setValue(this.model.getNode().getChildNamed(new DtoField[]{DtoFieldConstants.requisitionNewAmount, StoreQuantityComplete_.unit}).getValue(), System.currentTimeMillis());
                ((StoreQuantityComplete)this.ordered.getNode().getValue()).setAmount(a);
                ((StoreQuantityComplete)this.ordered.getNode().getValue()).setUnit((UnitComplete)this.model.getNode().getChildNamed(new DtoField[]{DtoFieldConstants.requisitionNewAmount, StoreQuantityComplete_.unit}).getValue());
                if (a.longValue() != b.longValue()) {
                    this.ordered.setLeftUpperCornerPainting(true, AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("productionplanner_stocksetted_color")));
                } else {
                    this.ordered.setLeftUpperCornerPainting(false, AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("productionplanner_stocksetted_color")));
                }
                this.ordered.updateString();
            } else if (source.getCaller() == this.changeReceivingStore) {
                Node newPosition = this.model.getNode().getChildNamed(DtoFieldConstants.requisitionNewPosition);
                StorePositionLight a = null;
                if (newPosition != null) {
                    a = (StorePositionLight)newPosition.getValue(StorePositionLight.class);
                }
                this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.receivingStore).commitThis();
                StorePositionLight b = (StorePositionLight)this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.receivingStore).getValue(StorePositionLight.class);
                if (a != null && !a.equals((Object)b)) {
                    this.receivingStore.setLeftUpperCornerPainting(true, AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("productionplanner_stocksetted_color")));
                } else {
                    this.receivingStore.setLeftUpperCornerPainting(false, AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("productionplanner_stocksetted_color")));
                }
                this.receivingStore.updateString();
            }
        }

        @Override
        public void newValueSelected(SearchTextField2 source, Node<?> n) {
            new BasicArticleLoader((BasicArticleReference)n.getValue(BasicArticleLight.class), this, n, this);
        }

        @Override
        public void remoteObjectLoaded(Node<?> node) {
            StoreQuantityComplete q;
            BasicArticleComplete artC = (BasicArticleComplete)node.getValue(BasicArticleComplete.class);
            this.model.getNode().getChildNamed(new DtoField[]{RequisitionOrderPositionComplete_.quantity, StoreQuantityComplete_.unit}).setValue((Object)artC.getFloatStoreUnit(), 0L);
            this.model.getNode().getChildNamed(new DtoField[]{RequisitionOrderPositionComplete_.quantity, StoreQuantityComplete_.amount}).setValue((Object)0, 0L);
            this.model.getNode().commitThis(StoreQuantityComplete.class);
            this.updateArticleInfoAndSelectableUnits();
            Node newAmount = this.model.getNode().getChildNamed(DtoFieldConstants.requisitionNewAmount);
            if (newAmount == null) {
                newAmount = new EmbeddedDTONode();
                newAmount.setName(DtoFieldConstants.requisitionNewAmount);
                q = new StoreQuantityComplete();
                Object o = this.model.getNode().getChildNamed(new DtoField[]{RequisitionOrderPositionComplete_.quantity, StoreQuantityComplete_.amount}).getValue();
                if (o instanceof Long) {
                    q.setAmount((Long)o);
                } else if (o instanceof Integer) {
                    q.setAmount(Long.valueOf(((Integer)o).longValue()));
                }
                q.setUnit((UnitComplete)this.model.getNode().getChildNamed(new DtoField[]{RequisitionOrderPositionComplete_.quantity, StoreQuantityComplete_.unit}).getValue());
                newAmount.setValue((Object)q, 0L);
                this.model.getNode().addChild(newAmount, 0L);
            } else {
                q = new StoreQuantityComplete();
                q.setUnit((UnitComplete)this.model.getNode().getChildNamed(new DtoField[]{RequisitionOrderPositionComplete_.quantity, StoreQuantityComplete_.unit}).getValue());
                q.setAmount(Long.valueOf(0L));
                newAmount.setValue((Object)q, 0L);
                newAmount.updateNode();
            }
            Node newPos = this.model.getNode().getChildNamed(DtoFieldConstants.requisitionNewPosition);
            if (newPos == null) {
                newPos = new DTOProxyNode();
                newPos.setName(DtoFieldConstants.requisitionNewPosition);
                StorePositionLight l = (StorePositionLight)this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.receivingStore).getValue();
                newPos.setValue((Object)l, 0L);
                this.model.getNode().addChild(newPos, 0L);
            }
            this.isSet = true;
            this.ordered.setNode(newAmount);
            this.receivingStore.setNode(newPos);
            this.ordered.updateString();
            this.receivingStore.updateString();
            this.setEnabled(true);
        }

        @Override
        public void errorOccurred(ClientException exception) {
        }

        public boolean isSwingOnly() {
            return true;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = OrderPositionTableRow.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                OrderPositionTableRow.this.label.setLocation(OrderPositionsDetailsPanel.this.table.getCellPadding(), (int)(((double)parent.getHeight() - OrderPositionTableRow.this.label.getPreferredSize().getHeight()) / 2.0));
                OrderPositionTableRow.this.label.setSize(30, (int)OrderPositionTableRow.this.label.getPreferredSize().getHeight());
                OrderPositionTableRow.this.expandIcon.setLocation((int)((double)(currentX + w) - ((double)OrderPositionsDetailsPanel.this.table.getCellPadding() + OrderPositionTableRow.this.expandIcon.getPreferredSize().getWidth())), (int)(((double)parent.getHeight() - OrderPositionTableRow.this.expandIcon.getPreferredSize().getHeight()) / 2.0));
                OrderPositionTableRow.this.expandIcon.setSize(OrderPositionTableRow.this.expandIcon.getPreferredSize());
                currentX += w;
                w = OrderPositionTableRow.this.model.getParentModel().getColumnWidth(1);
                OrderPositionTableRow.this.positionState.setLocation(currentX + OrderPositionsDetailsPanel.this.table.getCellPadding(), (int)(((double)parent.getHeight() - OrderPositionTableRow.this.positionState.getPreferredSize().getHeight()) / 2.0));
                OrderPositionTableRow.this.positionState.setSize(w - 2 * OrderPositionsDetailsPanel.this.table.getCellPadding(), (int)OrderPositionTableRow.this.positionState.getPreferredSize().getHeight());
                currentX += w;
                w = OrderPositionTableRow.this.model.getParentModel().getColumnWidth(2);
                OrderPositionTableRow.this.articleName.setLocation(currentX + OrderPositionsDetailsPanel.this.table.getCellPadding(), (int)(((double)parent.getHeight() - OrderPositionTableRow.this.articleName.getPreferredSize().getHeight()) / 2.0));
                OrderPositionTableRow.this.articleName.setSize((int)((double)w - ((double)(2 * OrderPositionsDetailsPanel.this.table.getCellPadding() + OrderPositionTableRow.this.getInnerCellPadding()) + OrderPositionTableRow.this.articleInfo.getPreferredSize().getWidth())), (int)OrderPositionTableRow.this.articleName.getPreferredSize().getHeight());
                OrderPositionTableRow.this.articleInfo.setLocation(OrderPositionTableRow.this.articleName.getX() + OrderPositionTableRow.this.articleName.getWidth() + OrderPositionTableRow.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - OrderPositionTableRow.this.articleInfo.getPreferredSize().getHeight()) / 2.0));
                OrderPositionTableRow.this.articleInfo.setSize(OrderPositionTableRow.this.articleInfo.getPreferredSize());
                int index = 3;
                currentX += w;
                w = OrderPositionTableRow.this.model.getParentModel().getColumnWidth(index++);
                if (OrderPositionTableRow.this.articleDepartment != null) {
                    OrderPositionTableRow.this.articleDepartment.setLocation(currentX + OrderPositionTableRow.this.getCellPadding(), (int)(((double)parent.getHeight() - OrderPositionTableRow.this.articleDepartment.getPreferredSize().getHeight()) / 2.0));
                    OrderPositionTableRow.this.articleDepartment.setSize(w - 2 * OrderPositionTableRow.this.getCellPadding(), (int)OrderPositionTableRow.this.articleDepartment.getPreferredSize().getHeight());
                    currentX += w;
                    w = OrderPositionTableRow.this.model.getParentModel().getColumnWidth(index++);
                }
                currentX += w;
                w = OrderPositionTableRow.this.model.getParentModel().getColumnWidth(index++);
                OrderPositionTableRow.this.ordered.setLocation(currentX + OrderPositionsDetailsPanel.this.table.getCellPadding(), (int)(((double)parent.getHeight() - OrderPositionTableRow.this.ordered.getPreferredSize().getHeight()) / 2.0));
                OrderPositionTableRow.this.ordered.setSize((int)((double)w - ((double)(2 * OrderPositionsDetailsPanel.this.table.getCellPadding() + OrderPositionsDetailsPanel.this.table.getInnerCellPadding()) + OrderPositionTableRow.this.changeOrder.getPreferredSize().getWidth())), (int)OrderPositionTableRow.this.ordered.getPreferredSize().getHeight());
                OrderPositionTableRow.this.changeOrder.setLocation(OrderPositionTableRow.this.ordered.getX() + OrderPositionTableRow.this.ordered.getWidth() + OrderPositionsDetailsPanel.this.table.getInnerCellPadding(), (int)(((double)parent.getHeight() - OrderPositionTableRow.this.changeOrder.getPreferredSize().getHeight()) / 2.0));
                OrderPositionTableRow.this.changeOrder.setSize(OrderPositionTableRow.this.changeOrder.getPreferredSize());
                currentX += w;
                w = OrderPositionTableRow.this.model.getParentModel().getColumnWidth(index++);
                if (OrderPositionTableRow.this.isSet && OrderPositionTableRow.this.ready != null) {
                    int att_width = (int)OrderPositionTableRow.this.rej_remark.getPreferredSize().getWidth();
                    OrderPositionTableRow.this.ready.setLocation(currentX + OrderPositionsDetailsPanel.this.table.getCellPadding(), (int)(((double)parent.getHeight() - OrderPositionTableRow.this.ready.getPreferredSize().getHeight()) / 2.0));
                    OrderPositionTableRow.this.ready.setSize(w - (3 * OrderPositionsDetailsPanel.this.table.getCellPadding() + att_width), (int)OrderPositionTableRow.this.ready.getPreferredSize().getHeight());
                }
                currentX += w;
                w = OrderPositionTableRow.this.model.getParentModel().getColumnWidth(index++);
                if (OrderPositionTableRow.this.isSet && OrderPositionTableRow.this.ready != null) {
                    OrderPositionTableRow.this.received.setLocation(currentX + OrderPositionsDetailsPanel.this.table.getCellPadding(), (int)(((double)parent.getHeight() - OrderPositionTableRow.this.received.getPreferredSize().getHeight()) / 2.0));
                    OrderPositionTableRow.this.received.setSize((int)OrderPositionTableRow.this.received.getPreferredSize().getWidth(), (int)OrderPositionTableRow.this.received.getPreferredSize().getHeight());
                    OrderPositionTableRow.this.rec_remark.setLocation(OrderPositionTableRow.this.received.getX() + OrderPositionTableRow.this.received.getWidth() + OrderPositionsDetailsPanel.this.table.getInnerCellPadding(), (int)(((double)parent.getHeight() - OrderPositionTableRow.this.rec_remark.getPreferredSize().getHeight()) / 2.0));
                    OrderPositionTableRow.this.rec_remark.setSize(OrderPositionTableRow.this.rec_remark.getPreferredSize());
                }
                currentX += w;
                w = OrderPositionTableRow.this.model.getParentModel().getColumnWidth(index++);
                if (OrderPositionTableRow.this.isSet && OrderPositionTableRow.this.ready != null) {
                    OrderPositionTableRow.this.rejected.setLocation(currentX + OrderPositionsDetailsPanel.this.table.getCellPadding(), (int)(((double)parent.getHeight() - OrderPositionTableRow.this.rejected.getPreferredSize().getHeight()) / 2.0));
                    OrderPositionTableRow.this.rejected.setSize((int)OrderPositionTableRow.this.rejected.getPreferredSize().getWidth(), (int)OrderPositionTableRow.this.rejected.getPreferredSize().getHeight());
                    OrderPositionTableRow.this.rej_remark.setLocation(OrderPositionTableRow.this.rejected.getX() + OrderPositionTableRow.this.rejected.getWidth() + OrderPositionsDetailsPanel.this.table.getInnerCellPadding(), (int)(((double)parent.getHeight() - OrderPositionTableRow.this.rej_remark.getPreferredSize().getHeight()) / 2.0));
                    OrderPositionTableRow.this.rej_remark.setSize(OrderPositionTableRow.this.rej_remark.getPreferredSize());
                }
                currentX += w;
                w = OrderPositionTableRow.this.model.getParentModel().getColumnWidth(index++);
                OrderPositionTableRow.this.receivingStore.setLocation(currentX + OrderPositionsDetailsPanel.this.table.getCellPadding(), (int)(((double)parent.getHeight() - OrderPositionTableRow.this.receivingStore.getPreferredSize().getHeight()) / 2.0));
                OrderPositionTableRow.this.receivingStore.setSize((int)((double)w - ((double)(2 * OrderPositionsDetailsPanel.this.table.getCellPadding() + OrderPositionsDetailsPanel.this.table.getInnerCellPadding()) + OrderPositionTableRow.this.changeReceivingStore.getPreferredSize().getWidth())), (int)OrderPositionTableRow.this.receivingStore.getPreferredSize().getHeight());
                OrderPositionTableRow.this.changeReceivingStore.setLocation(OrderPositionTableRow.this.receivingStore.getX() + OrderPositionTableRow.this.receivingStore.getWidth() + OrderPositionsDetailsPanel.this.table.getInnerCellPadding(), (int)(((double)parent.getHeight() - OrderPositionTableRow.this.changeReceivingStore.getPreferredSize().getHeight()) / 2.0));
                OrderPositionTableRow.this.changeReceivingStore.setSize(OrderPositionTableRow.this.changeReceivingStore.getPreferredSize());
                if (OrderPositionTableRow.this.isPlaced() && OrderPositionsDetailsPanel.this.isDeletable) {
                    currentX += w;
                    w = OrderPositionTableRow.this.model.getParentModel().getColumnWidth(index++);
                    OrderPositionTableRow.this.deleteButton.setLocation(currentX + OrderPositionTableRow.this.getCellPadding(), (int)(((double)parent.getHeight() - OrderPositionTableRow.this.deleteButton.getPreferredSize().getHeight()) / 2.0));
                    OrderPositionTableRow.this.deleteButton.setSize(OrderPositionTableRow.this.deleteButton.getPreferredSize());
                }
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, OrderPositionTableRow.this.getDefaultRowHeight());
            }
        }
    }
}

