/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.retail.details;

import ch.icit.pegasus.client.gui.modules.flight.details.utils.FlightProviderRule;
import ch.icit.pegasus.client.gui.modules.flight.utils.FlightEditableChecker;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.ordering.CustomsDocumentComplete;
import ch.icit.pegasus.server.core.dtos.ordering.CustomsDocumentComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class OrderNumbersDetailsPanel
extends TableDetailsPanel<FlightLight> {
    private static final long serialVersionUID = 1L;
    private Node<FlightComplete> node;
    private boolean isDeletable = true;
    private FlightEditableChecker checker = new FlightEditableChecker();

    public OrderNumbersDetailsPanel(RowEditor<FlightLight> editor, RDProvider provider) {
        super(editor, provider, true, true, true, true);
        this.setTitleText(Words.ORDER_NUMBERS);
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.ORDER_NO, null, null, null, "", 40, Integer.MAX_VALUE, 40));
        int tw = 2 * this.table.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setProvider(this.provider);
        table.setRequestFocusOnAdd(true);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
        CustomsDocumentComplete o = new CustomsDocumentComplete();
        o.setClientOId(Long.valueOf(ADTO.getNextId()));
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)o, true, false);
        this.table.getModel().getNode().addChild(n, System.currentTimeMillis());
    }

    @Override
    public void childRemoved() {
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        TableRowImpl rowPanel = new TableRowImpl(model);
        rowPanel.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
        return rowPanel;
    }

    @Override
    public boolean hasExpandableContent() {
        if (this.table != null) {
            return !this.table.getRows().isEmpty();
        }
        return false;
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        Node orderNumbers = this.editor.getModel().getNode().getChildNamed(FlightLight_.customsDocuments);
        Iterator it = orderNumbers.getFailSafeChildIterator();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            String value = (String)n.getChildNamed(CustomsDocumentComplete_.customsDocumentId).getValue();
            if (value != null && !value.isEmpty()) continue;
            orderNumbers.removeChild(n, 0L);
        }
        boolean isValid = true;
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        HashSet<String> ids = new HashSet<String>();
        for (Table2RowPanel p : this.table.getRows()) {
            TableRowImpl pp = (TableRowImpl)p;
            CustomsDocumentComplete doc = (CustomsDocumentComplete)pp.getModel().getNode().getValue(CustomsDocumentComplete.class);
            if (ids.contains(doc.getCustomsDocumentId())) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_DOCUMENT_NUMBERS_ARE_UNIQUE));
            }
            ids.add(doc.getCustomsDocumentId());
            if (pp.validateRow()) continue;
            isValid = false;
        }
        if (!isValid) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_CUSTOMS_DOCS_ID_IS_SET));
        }
        return validationObjects;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean enabled = this.checker.canEditFlight(this.node, this.provider, isEnabled);
        super.setEnabled(enabled);
    }

    @Override
    public void setNode(Node<?> node) {
        this.node = node;
        if (this.provider.getAdditionalRule() == null) {
            this.provider.setAdditionalRule(new FlightProviderRule((FlightComplete)node.getValue(FlightComplete.class)));
        }
        this.isDeletable = this.provider.isDeletable(FlightComplete_.customsDocuments);
        if (node.getChildNamed(FlightComplete_.customsDocuments).getValue() == null) {
            node.getChildNamed(FlightComplete_.customsDocuments).setValue(new ArrayList(), System.currentTimeMillis());
        }
        this.table.getModel().setNode(node.getChildNamed(FlightComplete_.customsDocuments));
        super.setNode(node);
    }

    @Override
    public void requestFocusInWindowNow() {
        this.table.requestFocusInWindowNow();
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener,
    ItemListener {
        private static final long serialVersionUID = 1L;
        private RDTextField field;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setLayout(new InnerLayout());
            this.field = new RDTextField(OrderNumbersDetailsPanel.this.provider);
            this.field.setNode(m.getNode().getChildNamed(CustomsDocumentComplete_.customsDocumentId));
            if (OrderNumbersDetailsPanel.this.isDeletable) {
                this.delete = new DeleteButton();
                this.delete.addButtonListener(this);
                this.add(this.delete);
            }
            this.add(this.field);
        }

        public boolean validateRow() {
            if (this.model.getNode().getChildNamed(CustomsDocumentComplete_.customsDocumentId).getValue() == null || ((String)this.model.getNode().getChildNamed(CustomsDocumentComplete_.customsDocumentId).getValue()).isEmpty()) {
                this.field.setInvalid();
                return false;
            }
            return true;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.field);
            CheckedListAdder.addToList(focusList, this.delete);
            return focusList;
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.field.getText();
                }
                case 1: {
                    return 0;
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.field.setEnabled(isEnabled);
            if (this.delete != null) {
                this.delete.setEnabled(isEnabled);
            }
        }

        @Override
        public void requestFocusInWindowNow() {
            super.requestFocusInWindowNow();
            this.field.requestFocusInWindowNow();
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.field.kill();
            this.field = null;
            if (this.delete != null) {
                this.delete.kill();
            }
            this.delete = null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), System.currentTimeMillis());
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                this.getModel().getNode().getChildNamed(CustomsDocumentComplete_.outbound).setValue(null, 0L);
            }
        }

        private class InnerLayout
        extends DefaultLayout {
            private InnerLayout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                TableRowImpl.this.field.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.field.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.field.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.field.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                if (TableRowImpl.this.delete != null) {
                    TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
                }
            }
        }
    }
}

