/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.safetystock;

import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.PeriodConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.gui.modules.safetystock.SafetyStockModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.safetystock.details.ArticlesDetailsPanel;
import ch.icit.pegasus.client.gui.modules.safetystock.details.SpecificationDetailsPanel;
import ch.icit.pegasus.client.gui.modules.safetystock.details.UserDetailsPanel;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.MessageProvidedRowEditor;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.RowEditorFactory;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.Table;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.utils.TableLayoutConstraint;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.SafetyStockSearchAlgorithm;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.ordering.safetystock.SafetyStockLight;
import ch.icit.pegasus.server.core.dtos.ordering.safetystock.SafetyStockLight_;
import ch.icit.pegasus.server.core.dtos.ordering.safetystock.SafetyStockStateE;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.SafetyStockAccess;
import ch.icit.pegasus.server.core.dtos.search.SafetyStockSearchConfiguration;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.search.SortDirection;
import java.awt.Component;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class SafetyStockModule
extends ScreenTableView<SafetyStockLight, SafetyStockSearchConfiguration.SAFETY_STOCK_COLUMN> {
    private static final long serialVersionUID = 1L;
    private static final String FILTER_NAME = "name_or_number";
    private static final String FILTER_STATE = "state";
    private static final String FILTER_PERIOD = "period";
    private String filterNameOrNumber = null;
    private SafetyStockStateE filterState = null;
    private PeriodComplete selectedPeriod = null;

    public SafetyStockModule() {
        super(SafetyStockLight.class);
        this.isSynchronSearch = false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.filterState = null;
    }

    @Override
    public AccessDefinitionComplete getInvoker() {
        return SafetyStockAccess.MODULE_SAFETY_STOCK;
    }

    @Override
    public FilterChainConfiguration getDefaultConfiguration() {
        FilterChainConfiguration c = new FilterChainConfiguration();
        c.addProperty("sortedColumn", SafetyStockSearchConfiguration.SAFETY_STOCK_COLUMN.NUMBER + "<>" + true);
        c.addProperty(FILTER_PERIOD, FilterChainConfiguration.getDefaultSearchPeriodString());
        return c;
    }

    @Override
    protected void createFilterChain(long id) {
        this.filterChain.setSearchTextField2Width(200);
        this.filterChain.addSearchField(FILTER_NAME, Words.NAME_OR_NUMBER, "");
        ComboBox stateCombo = new ComboBox();
        stateCombo.addItem(Words.ALL);
        for (SafetyStockStateE value : SafetyStockStateE.values()) {
            stateCombo.addItem(value);
        }
        this.filterChain.addSelectionComboBox(stateCombo, FILTER_STATE, "STATE", Words.ALL);
        TitledPeriodEditor period = this.filterChain.addPeriodSelection(FILTER_PERIOD, new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis()), "PERIOD", false);
        period.setCheckBoxEnabled();
        this.filterChain.addResetButton();
    }

    @Override
    public ASearchConfiguration<SafetyStockLight, SafetyStockSearchConfiguration.SAFETY_STOCK_COLUMN> getModuleSearchParameters(Object name, Object value, boolean isReset, boolean getEmptyConfig, Component source) {
        if (isReset) {
            this.filterNameOrNumber = null;
            this.filterState = null;
        } else if (name == FILTER_NAME) {
            this.filterNameOrNumber = (String)value;
        } else if (name == FILTER_STATE) {
            this.filterState = value == null || value.equals(Words.ALL) ? null : (SafetyStockStateE)value;
        } else if (name == FILTER_PERIOD) {
            TitledPeriodEditor ed = (TitledPeriodEditor)value;
            PeriodComplete per = new PeriodComplete();
            per.setStartDate(ed.getStartDate());
            per.setEndDate(ed.getEndDate());
            this.selectedPeriod = per;
        }
        SafetyStockSearchConfiguration c = new SafetyStockSearchConfiguration();
        try {
            Integer numbervalue = Integer.valueOf(this.filterNameOrNumber);
            c.setNumber(numbervalue);
        }
        catch (Exception exception) {
            // empty catch block
        }
        c.setName(this.filterNameOrNumber);
        c.setState(this.filterState);
        c.setPeriod(this.selectedPeriod);
        c.setNumResults(this.numberOfShownResults);
        if (source == this.pagination) {
            c.setPageNumber(this.pagination.getCurrentPage() - 1);
        } else {
            c.setPageNumber(0);
        }
        if (c.getPageNumber() < 0) {
            c.setPageNumber(0);
        }
        if (this.currentColumnAttribute != null) {
            c.setSortColumn(this.currentColumnAttribute);
        }
        if (this.isAsc) {
            c.setSortDirection(SortDirection.ASCENDING);
        } else {
            c.setSortDirection(SortDirection.DESCENDING);
        }
        return c;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        super.remoteObjectLoaded(node);
    }

    @Override
    public SearchAlgorithm<SafetyStockLight> getSearchAlgorithm() {
        return SearchAlgorithmRegistry.getSearchAlgorithm(SafetyStockSearchAlgorithm.class);
    }

    @Override
    public boolean isSmartScreenAllowed(SubModuleDefinitionComplete screen, RowModel<SafetyStockLight> model) {
        if (model == null || model.getNode() == null || model.getNode().getValue() == null) {
            return false;
        }
        if (screen.getInvokingName().equals(SafetyStockAccess.ACTION_CALCULATE_SAFET_STOCK.getIdentifier())) {
            SafetyStockLight safetyStockLight = (SafetyStockLight)model.getNode().getValue();
        }
        return model != null;
    }

    @Override
    public boolean isDeletable(RowModel<SafetyStockLight> model) {
        return true;
    }

    @Override
    protected Table.SmartIconConfiguration getPossibleSmartIcons() {
        return Table.SmartIconConfiguration.TWO;
    }

    @Override
    protected RowEditorFactory<SafetyStockLight> getRowEditorFactory() {
        return model -> {
            MessageProvidedRowEditor<SafetyStockLight> rowEditor = new MessageProvidedRowEditor<SafetyStockLight>(model, "");
            RDProvider p = this.createProvider(model.isAddRow());
            SpecificationDetailsPanel d1 = new SpecificationDetailsPanel((RowEditor<SafetyStockLight>)rowEditor, p);
            UserDetailsPanel d2 = new UserDetailsPanel((RowEditor<SafetyStockLight>)rowEditor, p);
            ArticlesDetailsPanel d3 = new ArticlesDetailsPanel((RowEditor<SafetyStockLight>)rowEditor, p);
            rowEditor.add(d1, (Object)new TableLayoutConstraint(0, 0, 1.0, 0.0));
            rowEditor.add(d2, (Object)new TableLayoutConstraint(0, 1, 1.0, 0.0));
            rowEditor.add(d3, (Object)new TableLayoutConstraint(0, 2, 1.0, 1.0));
            rowEditor.addToFocusQueue(d1);
            rowEditor.addToFocusQueue(d2);
            rowEditor.addToFocusQueue(d3);
            rowEditor.allInstalled();
            rowEditor.setVisibleContainer(this.getTable());
            return rowEditor;
        };
    }

    @Override
    protected IDataHandler getModuleDataHandler() {
        return new SafetyStockModuleDataHandler(this.loadingId, (ScreenTableView<SafetyStockLight, SafetyStockSearchConfiguration.SAFETY_STOCK_COLUMN>)this);
    }

    @Override
    protected List<TableColumnInfo> getTableColumnInfo() {
        ArrayList<TableColumnInfo> info = new ArrayList<TableColumnInfo>();
        info.add(new TableColumnInfo(Words.NUMBER, "", (Class)IntegerConverter.class, (Enum<?>)SafetyStockSearchConfiguration.SAFETY_STOCK_COLUMN.NUMBER, SafetyStockLight_.number, TableColumnInfo.numberColumnWithExpandWidth));
        info.add(new TableColumnInfo(Words.NAME, "", (Class)StringConverter.class, (Enum<?>)SafetyStockSearchConfiguration.SAFETY_STOCK_COLUMN.NAME, SafetyStockLight_.name, 120, Integer.MAX_VALUE, 120));
        info.add(new TableColumnInfo(Words.PERIOD, "", (Class)PeriodConverter.class, (Enum<?>)SafetyStockSearchConfiguration.SAFETY_STOCK_COLUMN.PERIOD, SafetyStockLight_.calculationPeriod, TableColumnInfo.periodColumnWidth));
        return info;
    }
}

