/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.stock.details.utils;

import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.PriceConverter1;
import ch.icit.pegasus.client.converter.UnitConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.LoadablePopupInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.EmbeddedDTONode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.StoreServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.toolkits.nodebased.UnitConversionToolkitNodeBased;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeBatchComplete_;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeComplete_;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeLight_;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeReference;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.List;

public class EditChargePriceUnitExpiryPopup
extends LoadablePopupInsert {
    private static final long serialVersionUID = 1L;
    private TitledItem<TextLabel> oldPrice;
    private TitledItem<InputComboBox> newPrice;
    private TextLabel connector;
    private TextLabel connectorOld;
    private TitledItem<TextLabel> oldPriceUnit;
    private TitledItem<ComboBox> newPriceUnit;
    private HorizontalSeparator sep1;
    private TitledItem<TextLabel> oldExpiry;
    private TitledItem<DateChooser> newExpiry;
    private HorizontalSeparator sep2;
    private TitledItem<CheckBox> updateOrder;
    private final Node transaction;
    private final boolean alwaysUpdateOrder;
    private SystemSettingsComplete settings;

    public EditChargePriceUnitExpiryPopup(Node transaction) {
        this(transaction, false);
        this.settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
    }

    public EditChargePriceUnitExpiryPopup(Node transaction, boolean alwaysUpdateOrder) {
        this.transaction = transaction;
        this.alwaysUpdateOrder = alwaysUpdateOrder;
        this.settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        this.checkChargeExistence();
    }

    private void checkChargeExistence() {
        Node n = this.transaction.getChildNamed(ArticleChargeBatchComplete_.charge);
        if (n.getValue(ArticleChargeComplete.class) == null) {
            this.showAnimation(Words.LOAD_CHARGE);
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    Node n = EditChargePriceUnitExpiryPopup.this.transaction.getChildNamed(ArticleChargeBatchComplete_.charge);
                    ArticleChargeReference l = (ArticleChargeReference)n.getValue(ArticleChargeReference.class);
                    if (l != null) {
                        try {
                            ArticleChargeComplete c = (ArticleChargeComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).getCharge(l).getValue();
                            n.removeExistingValues();
                            n.setValue((Object)c, System.currentTimeMillis());
                            n.updateNode();
                        }
                        catch (ClientGetFromServerException e) {
                            ViewNode r = new ViewNode("Error");
                            r.setValue((Object)e, 0L);
                            return r;
                        }
                    }
                    return null;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            EditChargePriceUnitExpiryPopup.this.hideAnimation();
                            if (node != null && node.getValue() instanceof ClientServerCallException) {
                                InnerPopupFactory.showErrorDialog((Exception)((Object)((ClientServerCallException)((Object)node.getValue()))), (Component)EditChargePriceUnitExpiryPopup.this);
                            } else {
                                EditChargePriceUnitExpiryPopup.this.installComponents();
                            }
                        }

                        public void errorOccurred(ClientException exception) {
                            EditChargePriceUnitExpiryPopup.this.errorOccurred(exception);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        } else {
            this.installComponents();
        }
    }

    @Override
    public void popupClosed() {
        super.popupClosed();
        this.transaction.removeAllChilds();
    }

    @Override
    public void enterPressed(PopupAction isOK) {
        this.transaction.getChildNamed(new DtoField[]{ArticleChargeBatchComplete_.charge, DtoFieldConstants.newPrice}).commitThis();
        PriceComplete np = (PriceComplete)this.transaction.getChildNamed(new DtoField[]{ArticleChargeBatchComplete_.charge, DtoFieldConstants.newPrice}).getValue();
        UnitComplete nu = (UnitComplete)this.transaction.getChildNamed(new DtoField[]{ArticleChargeBatchComplete_.charge, DtoFieldConstants.newPriceUnit}).getValue();
        Date nd = (Date)this.transaction.getChildNamed(new DtoField[]{ArticleChargeBatchComplete_.charge, DtoFieldConstants.newExpiry}).getValue();
        final ArticleChargeComplete c = (ArticleChargeComplete)this.transaction.getChildNamed(ArticleChargeBatchComplete_.charge).getValue(ArticleChargeComplete.class);
        PriceComplete op = c.getPrice();
        UnitComplete ou = c.getPriceUnit();
        Date od = c.getExpiryDate();
        boolean changed = false;
        if (!ou.equals((Object)nu)) {
            changed = true;
        }
        if (!changed && od.getTime() != nd.getTime()) {
            changed = true;
        }
        if (!changed) {
            if (!op.getPrice().equals(np.getPrice())) {
                changed = true;
            }
            if (!op.getCurrency().equals((Object)np.getCurrency())) {
                changed = true;
            }
        }
        if (changed) {
            c.setExpiryDate(nd);
            c.setPrice(np);
            c.setPriceUnit(nu);
            final boolean updateOrderPosition = this.updateOrder.getElement().isChecked();
            this.showAnimation("Save Charge");
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    ArticleChargeComplete nc = (ArticleChargeComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).updateCharge(c, updateOrderPosition).getValue();
                    EditChargePriceUnitExpiryPopup.this.transaction.getChildNamed(ArticleChargeBatchComplete_.charge).removeExistingValues();
                    EditChargePriceUnitExpiryPopup.this.transaction.getChildNamed(ArticleChargeBatchComplete_.charge).setValue((Object)nc, 0L);
                    return null;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            if (node != null && node.getValue() instanceof ClientServerCallException) {
                                InnerPopupFactory.showErrorDialog((Exception)((Object)((ClientServerCallException)((Object)node.getValue()))), (Component)EditChargePriceUnitExpiryPopup.this);
                            } else {
                                EditChargePriceUnitExpiryPopup.this.invokeClose();
                            }
                        }

                        public void errorOccurred(ClientException exception) {
                            EditChargePriceUnitExpiryPopup.this.errorOccurred(exception);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        } else {
            this.invokeClose();
        }
    }

    private void invokeClose() {
        super.enterPressed(PopupAction.OK_FOREGROUND);
    }

    private void installComponents() {
        Node newPrice = this.transaction.getChildNamed(new DtoField[]{ArticleChargeBatchComplete_.charge, DtoFieldConstants.newPrice});
        if (newPrice == null) {
            newPrice = new EmbeddedDTONode();
            newPrice.setName(DtoFieldConstants.newPrice);
            this.transaction.getChildNamed(ArticleChargeBatchComplete_.charge).addChild(newPrice, 0L);
        }
        PriceComplete p = new PriceComplete();
        PriceComplete oldP = (PriceComplete)this.transaction.getChildNamed(new DtoField[]{ArticleChargeBatchComplete_.charge, ArticleChargeComplete_.price}).getValue();
        p.setPrice(oldP.getPrice());
        p.setCurrency(oldP.getCurrency());
        newPrice.setValue((Object)p, 0L);
        Node newPriceUnit = this.transaction.getChildNamed(new DtoField[]{ArticleChargeBatchComplete_.charge, DtoFieldConstants.newPriceUnit});
        if (newPriceUnit == null) {
            newPriceUnit = new DTOProxyNode(this.transaction.getChildNamed(new DtoField[]{ArticleChargeBatchComplete_.charge, ArticleChargeComplete_.priceUnit}).getValue());
            newPriceUnit.setName(DtoFieldConstants.newPriceUnit);
            this.transaction.getChildNamed(ArticleChargeBatchComplete_.charge).addChild(newPriceUnit, 0L);
        } else {
            newPriceUnit.setValue(this.transaction.getChildNamed(new DtoField[]{ArticleChargeBatchComplete_.charge, ArticleChargeComplete_.priceUnit}).getValue(), 0L);
        }
        Node newExpiry = this.transaction.getChildNamed(new DtoField[]{ArticleChargeBatchComplete_.charge, DtoFieldConstants.newExpiry});
        if (newExpiry == null) {
            newExpiry = new Node();
            newExpiry.setName("newExpiry");
            this.transaction.getChildNamed(ArticleChargeBatchComplete_.charge).addChild(newExpiry, 0L);
        }
        newExpiry.setValue(this.transaction.getChildNamed(new DtoField[]{ArticleChargeBatchComplete_.charge, ArticleChargeComplete_.expiryDate}).getValue(), 0L);
        this.oldPrice = new TitledItem<TextLabel>(new TextLabel(this.transaction.getChildNamed(new DtoField[]{ArticleChargeBatchComplete_.charge, ArticleChargeComplete_.price}), ConverterRegistry.getConverter(PriceConverter1.class)), "Old Price", TitledItem.TitledItemOrientation.NORTH);
        this.connectorOld = new TextLabel("/");
        this.oldPriceUnit = new TitledItem<TextLabel>(new TextLabel(this.transaction.getChildNamed(new DtoField[]{ArticleChargeBatchComplete_.charge, ArticleChargeComplete_.priceUnit}), ConverterRegistry.getConverter(UnitConverter.class)), "Old Price Unit", TitledItem.TitledItemOrientation.NORTH);
        this.newPrice = new TitledItem<InputComboBox>(new InputComboBox(newPrice.getChildNamed(PriceComplete_.price), newPrice.getChildNamed(PriceComplete_.currency), InputComboBox.InputComboBoxType.PRICE_DOUBLE), "New Price", TitledItem.TitledItemOrientation.NORTH);
        this.newPrice.getElement().setOverrideUnitWith(InputComboBox.minUnitWidth);
        this.connector = new TextLabel("/");
        this.newPriceUnit = new TitledItem<ComboBox>(new ComboBox(newPriceUnit, this.getPossibleUnits((Node<ArticleChargeComplete>)this.transaction.getChildNamed(ArticleChargeBatchComplete_.charge)), ConverterRegistry.getConverter(UnitConverter.class)), "New Price Unit", TitledItem.TitledItemOrientation.NORTH);
        this.oldExpiry = new TitledItem<TextLabel>(new TextLabel(this.transaction.getChildNamed(new DtoField[]{ArticleChargeBatchComplete_.charge, ArticleChargeComplete_.expiryDate}), ConverterRegistry.getConverter(DateConverter.class)), "Old Expiry Date", TitledItem.TitledItemOrientation.NORTH);
        this.newExpiry = new TitledItem<DateChooser>(new DateChooser(newExpiry), "New Expiry Date", TitledItem.TitledItemOrientation.NORTH);
        this.updateOrder = new TitledItem<CheckBox>(new CheckBox(), "Update Order Position", TitledItem.TitledItemOrientation.EAST);
        this.updateOrder.getElement().setChecked(this.alwaysUpdateOrder);
        this.sep1 = new HorizontalSeparator();
        this.sep2 = new HorizontalSeparator();
        this.setLayout(new Layout());
        this.add(this.oldExpiry);
        this.add(this.newExpiry);
        this.add(this.oldPrice);
        this.add(this.connectorOld);
        this.add(this.oldPriceUnit);
        this.add(this.newPrice);
        this.add(this.connector);
        this.add(this.newPriceUnit);
        this.add(this.updateOrder);
        this.add(this.sep1);
        this.add(this.sep2);
        if (this.popup != null) {
            this.popup.createFocusCycle();
        }
        this.setEnabled(true);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.oldExpiry.setEnabled(isEnabled);
        this.oldPrice.setEnabled(isEnabled);
        this.newExpiry.setEnabled(isEnabled);
        this.connectorOld.setEnabled(isEnabled);
        this.oldPriceUnit.setEnabled(isEnabled);
        this.newPrice.setEnabled(isEnabled);
        this.connector.setEnabled(isEnabled);
        this.newPriceUnit.setEnabled(isEnabled);
        this.updateOrder.setEnabled(isEnabled && !this.alwaysUpdateOrder);
        this.sep1.setEnabled(isEnabled);
        this.sep2.setEnabled(isEnabled);
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        this.popup.setOkButtonText("Save");
        if (this.oldExpiry != null) {
            this.popup.createFocusCycle();
        }
    }

    private Node getPossibleUnits(Node<ArticleChargeComplete> article) {
        return UnitConversionToolkitNodeBased.getUnitList((ArticleChargeComplete)article.getValue(ArticleChargeComplete.class), (BasicArticleComplete)article.getChildNamed(ArticleChargeLight_.basicArticle).getValue(BasicArticleComplete.class), true, this.settings);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.oldPrice != null) {
            this.oldPrice.kill();
            this.oldPrice = null;
            this.oldPriceUnit.kill();
            this.oldPriceUnit = null;
            this.connectorOld.kill();
            this.connectorOld = null;
            this.newPrice.kill();
            this.newPrice = null;
            this.newPriceUnit.kill();
            this.newPriceUnit = null;
            this.connector.kill();
            this.connector = null;
            this.oldExpiry.kill();
            this.oldExpiry = null;
            this.newExpiry.kill();
            this.newExpiry = null;
            this.updateOrder.kill();
            this.updateOrder = null;
            this.sep1.kill();
            this.sep1 = null;
            this.sep2.kill();
            this.sep2 = null;
        }
    }

    @Override
    public boolean tryToGrabFocus() {
        return false;
    }

    @Override
    public List<Component> getFocusComponents() {
        if (this.newPrice != null) {
            List<Component> a = this.newPrice.getFocusComponents();
            a.addAll(this.newPriceUnit.getFocusComponents());
            a.addAll(this.newExpiry.getFocusComponents());
            a.addAll(this.updateOrder.getFocusComponents());
            return a;
        }
        return null;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.CANCEL) {
            return null;
        }
        Object[] o = new Object[]{this.newPrice.getElement().getValueNode(), this.newPrice.getElement().getUnitNode(), this.updateOrder.getElement().isChecked(), this.newPriceUnit.getElement().getNode().getValue(), this.newExpiry.getElement().getNode().getValue(), this.transaction.getChildNamed(ArticleChargeBatchComplete_.charge)};
        return o;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        if (this.newPriceUnit == null) {
            return false;
        }
        if (this.newPriceUnit.getElement().getCurrentPopUp() != null) {
            for (Component currentC = c; currentC != null; currentC = currentC.getParent()) {
                if (!currentC.equals(this.newPriceUnit.getElement().getCurrentPopUp())) continue;
                return true;
            }
        }
        return false;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(250, 300);
        }

        @Override
        public void layoutContainer(Container parent) {
            EditChargePriceUnitExpiryPopup.this.layoutAnimation(parent);
            if (EditChargePriceUnitExpiryPopup.this.oldPrice != null) {
                int border = 10;
                EditChargePriceUnitExpiryPopup.this.oldPrice.setLocation(border, border);
                EditChargePriceUnitExpiryPopup.this.oldPrice.setSize(EditChargePriceUnitExpiryPopup.this.oldPrice.getPreferredSize());
                EditChargePriceUnitExpiryPopup.this.connectorOld.setLocation(EditChargePriceUnitExpiryPopup.this.oldPrice.getX() + EditChargePriceUnitExpiryPopup.this.oldPrice.getWidth() + border / 2, (int)((double)(EditChargePriceUnitExpiryPopup.this.oldPrice.getY() + EditChargePriceUnitExpiryPopup.this.oldPrice.getHeight()) - ((TextLabel)EditChargePriceUnitExpiryPopup.this.oldPrice.getElement()).getPreferredSize().getHeight()));
                EditChargePriceUnitExpiryPopup.this.connectorOld.setSize(EditChargePriceUnitExpiryPopup.this.connectorOld.getPreferredSize());
                EditChargePriceUnitExpiryPopup.this.oldPriceUnit.setLocation(EditChargePriceUnitExpiryPopup.this.connectorOld.getX() + EditChargePriceUnitExpiryPopup.this.connectorOld.getWidth() + border / 2, EditChargePriceUnitExpiryPopup.this.oldPrice.getY());
                EditChargePriceUnitExpiryPopup.this.oldPriceUnit.setSize(EditChargePriceUnitExpiryPopup.this.oldPriceUnit.getPreferredSize());
                EditChargePriceUnitExpiryPopup.this.newPrice.setLocation(border, EditChargePriceUnitExpiryPopup.this.oldPrice.getY() + EditChargePriceUnitExpiryPopup.this.oldPrice.getHeight() + border);
                EditChargePriceUnitExpiryPopup.this.newPrice.setSize(EditChargePriceUnitExpiryPopup.this.newPrice.getPreferredSize());
                EditChargePriceUnitExpiryPopup.this.connector.setLocation(EditChargePriceUnitExpiryPopup.this.newPrice.getX() + EditChargePriceUnitExpiryPopup.this.newPrice.getWidth() + border / 2, (int)((double)(EditChargePriceUnitExpiryPopup.this.newPrice.getY() + EditChargePriceUnitExpiryPopup.this.newPrice.getHeight()) - ((InputComboBox)EditChargePriceUnitExpiryPopup.this.newPrice.getElement()).getPreferredSize().getHeight()));
                EditChargePriceUnitExpiryPopup.this.connector.setSize(EditChargePriceUnitExpiryPopup.this.connector.getPreferredSize());
                EditChargePriceUnitExpiryPopup.this.newPriceUnit.setLocation(EditChargePriceUnitExpiryPopup.this.connector.getX() + EditChargePriceUnitExpiryPopup.this.connector.getWidth() + border / 2, EditChargePriceUnitExpiryPopup.this.newPrice.getY());
                EditChargePriceUnitExpiryPopup.this.newPriceUnit.setSize(EditChargePriceUnitExpiryPopup.this.newPriceUnit.getPreferredSize());
                EditChargePriceUnitExpiryPopup.this.sep1.setLocation(0, EditChargePriceUnitExpiryPopup.this.newPriceUnit.getY() + EditChargePriceUnitExpiryPopup.this.newPriceUnit.getHeight() + border);
                EditChargePriceUnitExpiryPopup.this.sep1.setSize(parent.getWidth(), (int)EditChargePriceUnitExpiryPopup.this.sep1.getPreferredSize().getHeight());
                EditChargePriceUnitExpiryPopup.this.oldExpiry.setLocation(border, EditChargePriceUnitExpiryPopup.this.sep1.getY() + EditChargePriceUnitExpiryPopup.this.sep1.getHeight() + border);
                EditChargePriceUnitExpiryPopup.this.oldExpiry.setSize(parent.getWidth() - 2 * border, (int)EditChargePriceUnitExpiryPopup.this.oldExpiry.getPreferredSize().getHeight());
                EditChargePriceUnitExpiryPopup.this.newExpiry.setLocation(border, EditChargePriceUnitExpiryPopup.this.oldExpiry.getY() + EditChargePriceUnitExpiryPopup.this.oldExpiry.getHeight() + border);
                EditChargePriceUnitExpiryPopup.this.newExpiry.setSize(EditChargePriceUnitExpiryPopup.this.newExpiry.getPreferredSize());
                EditChargePriceUnitExpiryPopup.this.sep2.setLocation(0, EditChargePriceUnitExpiryPopup.this.newExpiry.getY() + EditChargePriceUnitExpiryPopup.this.newExpiry.getHeight() + border);
                EditChargePriceUnitExpiryPopup.this.sep2.setSize(parent.getWidth(), (int)EditChargePriceUnitExpiryPopup.this.sep2.getPreferredSize().getHeight());
                EditChargePriceUnitExpiryPopup.this.updateOrder.setLocation(border, EditChargePriceUnitExpiryPopup.this.sep2.getY() + EditChargePriceUnitExpiryPopup.this.sep2.getHeight() + border);
                EditChargePriceUnitExpiryPopup.this.updateOrder.setSize(parent.getWidth() - 2 * border, (int)EditChargePriceUnitExpiryPopup.this.updateOrder.getPreferredSize().getHeight());
            }
        }
    }
}

