/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.useradmin.details;

import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.panels.ContactPanel;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight_;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class ContactDetailsPanel
extends DefaultDetailsPanel<UserLight> {
    private static final long serialVersionUID = 1L;
    private ContactPanel panel;
    private boolean isWritable;

    public ContactDetailsPanel(RowEditor<UserLight> editor, RDProvider provider) {
        super(editor, provider);
        this.isWritable = provider.isWritable(UserComplete_.contact);
        this.setTitleText(Words.CONTACT_DATA);
        this.panel = new ContactPanel(provider, UserComplete_.contact.getFieldName());
        this.panel.setProgress(1.0f);
        this.setCustomLayouter(new Layout());
        this.addToView(this.panel);
    }

    @Override
    public void requestFocusInWindowNow() {
        this.panel.requestFocusInWindowNow();
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.panel);
        return focusList;
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        Boolean enable = (Boolean)this.editor.getModel().getNode().getChildNamed(UserLight_.isUserRole).getValue();
        this.panel.setEnabled(isEnabled & this.isWritable && enable == false);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.panel.kill();
        this.panel = null;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.panel.setNode(node.getChildNamed(UserLight_.contact));
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, (int)((double)ContactDetailsPanel.this.verticalBorder + ContactDetailsPanel.this.panel.getPreferredSize().getHeight() + (double)ContactDetailsPanel.this.verticalBorder));
        }

        @Override
        public void layoutContainer(Container parent) {
            ContactDetailsPanel.this.panel.setLocation(ContactDetailsPanel.this.horizontalBorder, ContactDetailsPanel.this.verticalBorder);
            ContactDetailsPanel.this.panel.setSize(parent.getWidth() - 2 * ContactDetailsPanel.this.horizontalBorder, parent.getHeight() - 2 * ContactDetailsPanel.this.verticalBorder);
        }
    }
}

