/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.action.purchasepreview.preview;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.OrderReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.OrderServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.toolkits.PurchaseOrderToolkit;
import ch.icit.pegasus.client.util.toolkits.copy.CopyTemplateToolkit;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.ordering.ManualPurchaseOrderPreviewComplete;
import ch.icit.pegasus.server.core.dtos.ordering.ManualPurchaseOrderPreviewLight;
import ch.icit.pegasus.server.core.dtos.ordering.ManualPurchaseOrderPreviewLight_;
import ch.icit.pegasus.server.core.dtos.ordering.ManualPurchaseOrderPreviewReference;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPositionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPreviewComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.supply.PriceAndUnitComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionBaseComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionCategoryComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.DateWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class PrintOrderPreviewComponent
extends DefaultScrollablePrintPopup2<ManualPurchaseOrderPreviewLight>
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private final Node<ManualPurchaseOrderPreviewLight> currentProduct;

    public PrintOrderPreviewComponent(Node<ManualPurchaseOrderPreviewLight> node) {
        super(false, false, null);
        this.currentProduct = node;
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        this.setEnabled(true);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        return conf;
    }

    @Override
    protected String getProgressText() {
        return Words.CREATE_ORDER_PREVIEW;
    }

    @Override
    public String getTitleString() {
        return Words.PREVIEW;
    }

    @Override
    public String getTitleValue() {
        return (String)this.currentProduct.getChildNamed(ManualPurchaseOrderPreviewLight_.name).getValue();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ManualPurchaseOrderPreviewLight orderPreviews = (ManualPurchaseOrderPreviewLight)PrintOrderPreviewComponent.this.currentProduct.getValue();
                ManualPurchaseOrderPreviewComplete orderPreviewComplete = (ManualPurchaseOrderPreviewComplete)((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).getManualPurchaseOrderPreview((ManualPurchaseOrderPreviewReference)orderPreviews).getValue();
                ArrayList<ScreenValidationObject> warnings = new ArrayList<ScreenValidationObject>();
                for (Object previewComplete : orderPreviewComplete.getOrders()) {
                    PurchaseOrderComplete order = PurchaseOrderToolkit.convertPurchaseOrderPreview((PurchaseOrderPreviewComplete)previewComplete);
                    order.getEligibleLocations().add(orderPreviews.getOrderLocation());
                    for (PurchaseOrderPositionComplete position : order.getOrderPositions()) {
                        try {
                            BasicArticleComplete basicArticle = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle(new BasicArticleReference(position.getArticle().getId())).getValue();
                            SupplierConditionBaseComplete supplier = basicArticle.getSupplier((SupplierReference)order.getSupplier());
                            List conditions = ((SupplierConditionCategoryComplete)supplier.getSupplierConditionCategory().get(0)).getConditions();
                            SupplierConditionComplete selectedCondition = null;
                            for (SupplierConditionComplete condition : conditions) {
                                if (!condition.getValidityPeriod().within(order.getOrderDate()).booleanValue()) continue;
                                selectedCondition = condition;
                                position.setSupplierCondition(CopyTemplateToolkit.copySupplierCondition(condition));
                            }
                            if (position.getSupplierCondition() == null) {
                                selectedCondition = (SupplierConditionComplete)conditions.get(conditions.size() - 1);
                            }
                            PriceAndUnitComplete articlePrice = ((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).getArticlePrice(new BasicArticleReference(position.getArticle().getId()), new SupplierReference(order.getSupplier().getId()), new DateWrapper(order.getOrderDate()), new QuantityComplete(Double.valueOf(position.getQuantity().getAmount().doubleValue()), position.getQuantity().getUnit()), order.getUseTaxZone(), order.getTaxZone(), selectedCondition);
                            position.setSupplierPrice(articlePrice.getPrice());
                            position.setPriceUnit(articlePrice.getUnit());
                        }
                        catch (Exception e) {
                            warnings.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, e.getMessage()));
                        }
                    }
                }
                if (warnings.isEmpty()) {
                    ArrayList<PurchaseOrderComplete> orders = new ArrayList<PurchaseOrderComplete>();
                    for (PurchaseOrderPreviewComplete previewComplete : orderPreviewComplete.getOrders()) {
                        PurchaseOrderComplete order = PurchaseOrderToolkit.convertPurchaseOrderPreview(previewComplete);
                        order.getEligibleLocations().add(orderPreviewComplete.getOrderLocation());
                        orders.add(order);
                    }
                    PegasusFileComplete purchaseOrderPreview = (PegasusFileComplete)((OrderReportServiceManager)ServiceManagerRegistry.getService(OrderReportServiceManager.class)).createPurchaseOrderPreview(new ListWrapper(orders)).getValue();
                    PrintOrderPreviewComponent.this.processFile(purchaseOrderPreview);
                    Node b = new Node();
                    b.setValue((Object)true, 0L);
                    return b;
                }
                InnerPopupFactory.showErrorDialog(warnings, Words.UNABLE_TO_CREATE_ORDER_PREVIEW, (Component)PrintOrderPreviewComponent.this);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintOrderPreviewComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<ManualPurchaseOrderPreviewLight> getCurrentNode() {
        return this.currentProduct;
    }

    @Override
    public BatchJob<ManualPurchaseOrderPreviewLight> createBatchJob(Node<ManualPurchaseOrderPreviewLight> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintOrderPreviewComponent.this.layoutInheritedComponents(parent);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintOrderPreviewComponent.this.getInheritedComponentsHeight();
            int w = 250;
            return new Dimension(w, h += PrintOrderPreviewComponent.this.border / 2);
        }
    }
}

