/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.action.store.productcount;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.file.FileChooserUtil;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.gui.utils.tables.InventoryProductCountTable;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.search.SearchServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.StoreServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryProductCountComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryReference;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.search.ADtoSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.ProductSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.util.SearchResult;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.utils.ExcelRow;
import ch.icit.utils.ExcelToolkit;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ProductCountActionComponent
extends DefaultScrollablePrintPopup2<StoreLight> {
    private static final long serialVersionUID = 1L;
    private Node<StoreLight> storeNode;
    private InventoryProductCountTable countTable;
    private TextButton importFromExcel;

    public ProductCountActionComponent(Node<StoreLight> dto) {
        super(false, false, false, false, null);
        this.storeNode = dto;
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String string = s[1];
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.countTable);
        CheckedListAdder.addToList(focusList, this.importFromExcel);
        return focusList;
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        return conf;
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        this.countTable = new InventoryProductCountTable(this.popup);
        this.importFromExcel = new TextButton("Import from Excel");
        this.importFromExcel.addButtonListener((source, x, y) -> this.importFile());
        this.getViewContainer().add(this.countTable);
        this.getViewContainer().add(this.importFromExcel);
    }

    private void importFile() {
        this.setEnabled(false);
        final File file = FileChooserUtil.loadFile();
        if (file != null) {
            ThreadSafeExecutable run = new ThreadSafeExecutable(){

                @Override
                public Node<?> loadData() throws Exception {
                    List rows = ExcelToolkit.readRows((File)file);
                    Node node = ProductCountActionComponent.this.countTable.getModel().getNode();
                    for (ExcelRow row : rows) {
                        InventoryProductCountComplete counting = new InventoryProductCountComplete();
                        counting.setClientOId(Long.valueOf(ADTO.getNextId()));
                        counting.setStore((StoreLight)ProductCountActionComponent.this.storeNode.getValue());
                        Integer pNumber = ExcelToolkit.readAsInteger((ExcelRow)row, (int)0);
                        Integer pCount = ExcelToolkit.readAsInteger((ExcelRow)row, (int)2);
                        counting.setCounted(pCount);
                        ProductSearchConfiguration pSearch = new ProductSearchConfiguration();
                        pSearch.setNumber(pNumber);
                        pSearch.setName(null);
                        SearchResult result = ((SearchServiceManager)ServiceManagerRegistry.getService(SearchServiceManager.class)).search((ADtoSearchConfiguration)pSearch);
                        ProductComplete product = (ProductComplete)result.getSingleResult();
                        counting.setProduct(product);
                        node.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)counting, true, false), 0L);
                    }
                    return new ViewNode("");
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            ProductCountActionComponent.this.setEnabled(true);
                        }

                        public void errorOccurred(ClientException exception) {
                            ProductCountActionComponent.this.setEnabled(true);
                            InnerPopupFactory.showErrorDialog((Exception)exception, (Component)ProductCountActionComponent.this);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        } else {
            InnerPopupFactory.showErrorDialog("No File selected", (Component)this);
        }
    }

    @Override
    protected String getProgressText() {
        return Words.SAVE_DATA;
    }

    @Override
    public String getTitleString() {
        return Words.STORE;
    }

    @Override
    public String getTitleValue() {
        return ((StoreLight)this.storeNode.getValue()).getCode();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node node = ProductCountActionComponent.this.countTable.getModel().getNode();
                UserComplete currentUser = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
                ArrayList<InventoryProductCountComplete> counts = new ArrayList<InventoryProductCountComplete>();
                Iterator it = node.getFailSafeChildIterator();
                while (it.hasNext()) {
                    Node next = (Node)it.next();
                    next.commitThis();
                    InventoryProductCountComplete value = (InventoryProductCountComplete)next.getValue();
                    if (value == null || value.getProduct() == null) continue;
                    value.setStore((StoreLight)ProductCountActionComponent.this.storeNode.getValue());
                    value.setCountUser((UserLight)currentUser);
                    value.setCountTime(new Timestamp(System.currentTimeMillis()));
                    counts.add(value);
                }
                InventoryReference inventoryInProgress = ((StoreLight)ProductCountActionComponent.this.storeNode.getValue()).getInventoryInProgress();
                ((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).countProducts(inventoryInProgress, new ListWrapper(counts));
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ProductCountActionComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<StoreLight> getCurrentNode() {
        return INodeCreator.getDefaultImpl().getNode4DTO(this.storeNode.getValue(), false, true);
    }

    @Override
    public BatchJob<StoreLight> createBatchJob(Node<StoreLight> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = ProductCountActionComponent.this.layoutInheritedComponents(parent);
            ProductCountActionComponent.this.countTable.setLocation(0, y);
            ProductCountActionComponent.this.countTable.setSize(parent.getWidth() - 4, (int)((double)parent.getHeight() - ((double)y + ProductCountActionComponent.this.importFromExcel.getPreferredSize().getHeight() + (double)(ProductCountActionComponent.this.border * 2))));
            ProductCountActionComponent.this.importFromExcel.setLocation(ProductCountActionComponent.this.border, ProductCountActionComponent.this.countTable.getY() + ProductCountActionComponent.this.countTable.getHeight() + ProductCountActionComponent.this.border);
            ProductCountActionComponent.this.importFromExcel.setSize(ProductCountActionComponent.this.importFromExcel.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = ProductCountActionComponent.this.getInheritedComponentsHeight();
            int w = 250;
            return new Dimension(w, h);
        }
    }
}

