/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.article.remote.storepositioncards;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.DateChooserAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.SearchTextField2AnalysisItem;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.StoreReportServiceManager;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.report.ArticleKanbanCardConfiguration;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StoreReference;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class AnalysisArticleStorePositionCardsComponent
extends DefaultServerSideAnalysisComponent<BasicArticleLight, BasicArticleReference> {
    private static final long serialVersionUID = 1L;
    private TitledItem<DateChooser> dueDate;
    private TitledItem<SearchTextField2<StoreLight>> storeSearch;

    public AnalysisArticleStorePositionCardsComponent(AnalysisSmartExternalOpenTool<BasicArticleLight> defaultAnalysis) {
        super(defaultAnalysis);
    }

    @Override
    public void addOptionItems() {
        this.dueDate = new TitledItem<DateChooser>(new DateChooser(INodeCreator.getDefaultImpl().getNode4DTO((Object)new Date(System.currentTimeMillis()), false, false)), Words.VALIDITY_FROM, TitledItem.TitledItemOrientation.NORTH);
        this.addOptionsItem(new DateChooserAnalysisItem(this.dueDate, "dueDate"));
        this.storeSearch = new TitledItem<SearchTextField2<StoreLight>>(SearchTextField2Factory.getStoreSearchField(true, new DTOProxyNode()), Words.PRINT_FOR_STORE, TitledItem.TitledItemOrientation.NORTH);
        this.addOptionsItem(new SearchTextField2AnalysisItem(this.storeSearch, "storeSearch"));
    }

    @Override
    public String getFileEnding() {
        return ".pdf";
    }

    @Override
    public String getTitleString() {
        return Words.ARTICLE_STORE_INFO_SHEETS;
    }

    @Override
    public String getTitleValue() {
        return Words.ARTICLE;
    }

    @Override
    public BasicArticleReference createReference(BasicArticleLight item) {
        return new BasicArticleReference(item.getId());
    }

    @Override
    public PegasusFileComplete createReport() throws ServiceException {
        ArticleKanbanCardConfiguration config = new ArticleKanbanCardConfiguration();
        config.setArticles(this.loadItemReferences());
        config.setStore((StoreReference)this.storeSearch.getElement().getNode().getValue());
        config.setDueDate((Date)this.dueDate.getElement().getNode().getValue());
        config.setFormat(ReportingOutputFormatE.PDF);
        return (PegasusFileComplete)((StoreReportServiceManager)ServiceManagerRegistry.getService(StoreReportServiceManager.class)).createKanbanCards(config).getValue();
    }

    @Override
    public List<ScreenValidationObject> validateBeforePrint() {
        List<ScreenValidationObject> a;
        ArrayList<ScreenValidationObject> l = new ArrayList<ScreenValidationObject>();
        if (this.storeSearch.getElement().getNode().getValue() == null) {
            l.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, Words.ENSURE_STORE_IS_SET));
        }
        if ((a = super.validateBeforePrint()) != null) {
            l.addAll(a);
        }
        return l;
    }
}

