/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.article.remote_new.actualstock;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateTimeChooser;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.AsynchronusAnalysisPopupInsert;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.CheckBoxAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.DateTimeChooserAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.SearchTextField2AnalysisItem;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.report.AGenericReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.analysis.article.ActualStockAnalysisReportConfiguration;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Date;
import java.sql.Timestamp;

public class ActualStockAnalysisComponent
extends AsynchronusAnalysisPopupInsert<BasicArticleLight> {
    private static final long serialVersionUID = 1L;
    private boolean isNoPro;
    private TitledItem<CheckBox> includeCosts;
    private TitledItem<CheckBox> hideZeroStock;
    private TitledItem<CheckBox> includeCustomerData;
    private TitledItem<CheckBox> splitByCharge;
    private TitledItem<DateTimeChooser> dueDateStore;
    private TitledItem<CheckBox> includeTransactionSheet;
    private TitledItem<CheckBox> includeIrregularities;
    private TitledItem<CheckBox> deactivateRequisitionPreparation;
    private TitledItem<CheckBox> deactivateRequisitionAcceptance;
    private TitledItem<CheckBox> onlyMainStores;
    private TitledItem<SearchTextField2<StoreLight>> storeSearch;
    private TitledItem<CheckBox> insertZeroStockValueForCustomerOwnedArticles;

    public ActualStockAnalysisComponent(AnalysisSmartExternalOpenTool<BasicArticleLight> subProv) {
        super(subProv);
    }

    @Override
    public void addOptionItems() {
        this.isNoPro = CompanyUtil.isNoPro((SystemSettingsComplete)((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()));
        this.dueDateStore = new TitledItem<DateTimeChooser>(new DateTimeChooser((Node<Timestamp>)INodeCreator.getDefaultImpl().getNode4DTO((Object)new Timestamp(System.currentTimeMillis()), false, false)), Words.DUE_DATE_STORE, TitledItem.TitledItemOrientation.NORTH);
        if (!this.isNoPro) {
            this.hideZeroStock = new TitledItem<CheckBox>(new CheckBox(), "Hide zero Stocks (for consumption stores only)", TitledItem.TitledItemOrientation.EAST);
            this.includeCosts = new TitledItem<CheckBox>(new CheckBox(), "Include Price", TitledItem.TitledItemOrientation.EAST);
            this.includeCustomerData = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_CUSTOMER_DATA, TitledItem.TitledItemOrientation.EAST);
            this.splitByCharge = new TitledItem<CheckBox>(new CheckBox(), Words.SPLIT_BY_CHARGE, TitledItem.TitledItemOrientation.EAST);
            this.includeTransactionSheet = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_TRANSACTION_SHEET, TitledItem.TitledItemOrientation.EAST);
            this.includeIrregularities = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_IRREGULARITIES_FLIGHT_RELEVANT, TitledItem.TitledItemOrientation.EAST);
            this.deactivateRequisitionPreparation = new TitledItem<CheckBox>(new CheckBox(), Words.DEACTIVATE_REQUISITION_PREPARATION, TitledItem.TitledItemOrientation.EAST);
            this.deactivateRequisitionAcceptance = new TitledItem<CheckBox>(new CheckBox(), Words.DEACTIVATE_REQUISITION_ACCEPTATION, TitledItem.TitledItemOrientation.EAST);
            this.onlyMainStores = new TitledItem<CheckBox>(new CheckBox(), Words.ONLY_MAIN_STORES, TitledItem.TitledItemOrientation.EAST);
            this.storeSearch = new TitledItem<SearchTextField2<StoreLight>>(SearchTextField2Factory.getStoreSearchField(true, new DTOProxyNode()), Words.STORE, TitledItem.TitledItemOrientation.NORTH);
            this.insertZeroStockValueForCustomerOwnedArticles = new TitledItem<CheckBox>(new CheckBox(), "Insert 0 stock value for customer owned articles", TitledItem.TitledItemOrientation.EAST);
            this.addOptionsItem(new CheckBoxAnalysisItem(this.includeCosts, "includeCosts"));
            this.addOptionsItem(new CheckBoxAnalysisItem(this.hideZeroStock, "zeroStock"));
            this.addOptionsItem(new CheckBoxAnalysisItem(this.includeCustomerData, "customData"));
            this.addOptionsItem(new CheckBoxAnalysisItem(this.splitByCharge, "spitByCharge"));
            this.addOptionsItem(new CheckBoxAnalysisItem(this.includeTransactionSheet, "includeTransactionSheet"));
            this.addOptionsItem(new CheckBoxAnalysisItem(this.includeIrregularities, "includeIrregularities"));
            this.addOptionsItem(new CheckBoxAnalysisItem(this.deactivateRequisitionPreparation, "deactivateRequisitionPreparation"));
            this.addOptionsItem(new CheckBoxAnalysisItem(this.deactivateRequisitionAcceptance, "deactivateRequisitionAcceptance"));
            this.addOptionsItem(new CheckBoxAnalysisItem(this.onlyMainStores, "onlyMainStores"));
            this.addOptionsItem(new CheckBoxAnalysisItem(this.insertZeroStockValueForCustomerOwnedArticles, "includeZeroStock"));
            this.addOptionsItem(new SearchTextField2AnalysisItem(this.storeSearch, "store"));
        }
        this.addOptionsItem(new DateTimeChooserAnalysisItem(this.dueDateStore, "dueDateStore"));
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!this.isNoPro) {
            this.includeTransactionSheet.setEnabled(false);
            this.includeIrregularities.setEnabled(false);
        }
    }

    @Override
    protected AGenericReportConfiguration getReportConfiguration() {
        ActualStockAnalysisReportConfiguration conf = new ActualStockAnalysisReportConfiguration();
        if (this.isNoPro) {
            conf.setIncludeCustomerData(true);
            conf.setHideZeroStock(true);
            conf.setIncludeCosts(false);
            if (this.dueDateStore.getElement().getNode().getValue() instanceof Timestamp) {
                Timestamp ts = (Timestamp)this.dueDateStore.getElement().getNode().getValue();
                conf.setDueDateStore(new Date(ts.getTime()));
            } else if (this.dueDateStore.getElement().getNode().getValue() instanceof Date) {
                conf.setDueDateStore((Date)this.dueDateStore.getElement().getNode().getValue());
            }
            conf.setSplitByCharge(false);
            conf.setIncludeTransactionSheet(false);
            conf.setIncludeIrrgularities(false);
            conf.setDeactivateRequisitionPreparation(false);
            conf.setDeactivateRequisitionAcceptation(false);
            conf.setOnlyMainStores(true);
            conf.setInsertZeroStockForCustomerOwned(Boolean.valueOf(false));
        } else {
            conf.setIncludeCustomerData(this.includeCustomerData.getElement().isChecked());
            conf.setHideZeroStock(this.hideZeroStock.getElement().isChecked());
            conf.setIncludeCosts(this.includeCosts.getElement().isChecked());
            if (this.dueDateStore.getElement().getNode().getValue() instanceof Timestamp) {
                Timestamp ts = (Timestamp)this.dueDateStore.getElement().getNode().getValue();
                conf.setDueDateStore(new Date(ts.getTime()));
            } else if (this.dueDateStore.getElement().getNode().getValue() instanceof Date) {
                conf.setDueDateStore((Date)this.dueDateStore.getElement().getNode().getValue());
            }
            conf.setSplitByCharge(this.splitByCharge.getElement().isChecked());
            conf.setIncludeTransactionSheet(this.includeTransactionSheet.getElement().isChecked());
            conf.setIncludeIrrgularities(this.includeIrregularities.getElement().isChecked());
            conf.setDeactivateRequisitionPreparation(this.deactivateRequisitionPreparation.getElement().isChecked());
            conf.setDeactivateRequisitionAcceptation(this.deactivateRequisitionAcceptance.getElement().isChecked());
            conf.setOnlyMainStores(this.onlyMainStores.getElement().isChecked());
            conf.setStore((StoreLight)this.storeSearch.getElement().getNode().getValue());
            conf.setInsertZeroStockForCustomerOwned(Boolean.valueOf(this.insertZeroStockValueForCustomerOwnedArticles.getElement().isChecked()));
        }
        return conf;
    }
}

