/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.flight.remote.manuallabel;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.panels.ManualFlightLabelPanel;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.ManualFlightLabelPanelAnalysisItem;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.FlightReportServiceManager;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.MapWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import java.util.List;
import java.util.Map;

public class AnalysisManualLabelComponent
extends DefaultServerSideAnalysisComponent<FlightLight, FlightReference> {
    private static final long serialVersionUID = 1L;
    private ManualFlightLabelPanel sealsPanel;

    public AnalysisManualLabelComponent(AnalysisSmartExternalOpenTool<FlightLight> defaultAnalysis) {
        super(defaultAnalysis);
    }

    @Override
    public void addOptionItems() {
        this.sealsPanel = new ManualFlightLabelPanel();
        this.addOptionsItem(new ManualFlightLabelPanelAnalysisItem(this.sealsPanel, "sealTable"));
    }

    @Override
    public boolean canExportAll() {
        return false;
    }

    @Override
    public String getFileEnding() {
        return ".pdf";
    }

    @Override
    public String getTitleString() {
        return Words.MANUAL_LABEL;
    }

    @Override
    public FlightReference createReference(FlightLight item) {
        if (item.getId() != null) {
            return new FlightReference(item.getId());
        }
        return item;
    }

    @Override
    public PegasusFileComplete createReport() throws ServiceException {
        List s = this.loadItemReferences();
        Map<String, Integer> seals = this.sealsPanel.getEntries();
        String eqCode = this.sealsPanel.getEquipmentTypeName();
        PegasusFileComplete file = (PegasusFileComplete)((FlightReportServiceManager)ServiceManagerRegistry.getService(FlightReportServiceManager.class)).generateManualLabels(new ListWrapper(s), new MapWrapper(seals), eqCode).getValue();
        return file;
    }
}

