/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.flight.remote.production;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.CheckBoxAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.RadioButtonAnalysisItem;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.FlightReportServiceManager;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.report.FlightProductionResourceTypeE;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import java.util.List;

public class AnalysisFlightProductionComponent
extends DefaultServerSideAnalysisComponent<FlightLight, FlightReference> {
    private static final long serialVersionUID = 1L;
    private TitledItem<RadioButton> allClasses;
    private TitledItem<RadioButton> onlyMainClasses;
    private TitledItem<RadioButton> groupNotMainClasses;
    private TitledItem<RadioButton> groupAll;
    private TitledItem<CheckBox> includeCrew;
    private TitledItem<CheckBox> calculateManMinutesForOneProduct;
    private TitledItem<CheckBox> includeProducts;
    private TitledItem<CheckBox> includeHandlingCosts;

    public AnalysisFlightProductionComponent(AnalysisSmartExternalOpenTool<FlightLight> defaultAnalysis) {
        super(defaultAnalysis);
    }

    @Override
    public void addOptionItems() {
        this.allClasses = new TitledItem<RadioButton>(new RadioButton(), Words.ALL, TitledItem.TitledItemOrientation.EAST);
        this.onlyMainClasses = new TitledItem<RadioButton>(new RadioButton(), Words.ONLY_MAIN_CLASSES, TitledItem.TitledItemOrientation.EAST);
        this.groupNotMainClasses = new TitledItem<RadioButton>(new RadioButton(), Words.GROUP_NOT_MAIN_CLASSES, TitledItem.TitledItemOrientation.EAST);
        this.groupNotMainClasses.getElement().setChecked(true);
        this.groupAll = new TitledItem<RadioButton>(new RadioButton(), Words.GROUP_ALL, TitledItem.TitledItemOrientation.EAST);
        this.includeCrew = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_CREW_PAX, TitledItem.TitledItemOrientation.EAST);
        this.includeCrew.getElement().setChecked(true);
        this.calculateManMinutesForOneProduct = new TitledItem<CheckBox>(new CheckBox(), Words.MAN_MINUTE_FOR_ONE_PRODUCT, TitledItem.TitledItemOrientation.EAST);
        this.calculateManMinutesForOneProduct.getElement().setChecked(true);
        this.includeProducts = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_PRODUCTS, TitledItem.TitledItemOrientation.EAST);
        this.includeProducts.getElement().setChecked(true);
        this.includeHandlingCosts = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_HANDLING, TitledItem.TitledItemOrientation.EAST);
        this.includeHandlingCosts.getElement().setChecked(true);
        this.addOptionsItem(new RadioButtonAnalysisItem(this.allClasses, "allClass"));
        this.addOptionsItem(new RadioButtonAnalysisItem(this.onlyMainClasses, "onlyMain"));
        this.addOptionsItem(new RadioButtonAnalysisItem(this.groupNotMainClasses, "groupNotMain"));
        this.addOptionsItem(new RadioButtonAnalysisItem(this.groupAll, "groupAll"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeCrew, "crew"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.calculateManMinutesForOneProduct, "manMinutesForOneProduct"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeHandlingCosts, "handlings"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeProducts, "products"));
    }

    @Override
    public boolean canExportAll() {
        return false;
    }

    @Override
    public String getTitleString() {
        return Words.PRODUCTION_RESOUCES;
    }

    @Override
    public FlightReference createReference(FlightLight item) {
        if (item.getId() != null) {
            return new FlightReference(item.getId());
        }
        return item;
    }

    @Override
    public PegasusFileComplete createReport() throws ServiceException {
        List s = this.loadItemReferences();
        FlightProductionResourceTypeE type = null;
        if (this.allClasses.getElement().isChecked()) {
            type = FlightProductionResourceTypeE.ALL;
        } else if (this.onlyMainClasses.getElement().isChecked()) {
            type = FlightProductionResourceTypeE.ONLY_MAIN_CLASSES;
        } else if (this.groupNotMainClasses.getElement().isChecked()) {
            type = FlightProductionResourceTypeE.GROUP_NOT_MAIN;
        } else if (this.groupAll.getElement().isChecked()) {
            type = FlightProductionResourceTypeE.GROUP_ALL;
        }
        boolean calc = this.calculateManMinutesForOneProduct.getElement().isChecked();
        boolean ih = this.includeHandlingCosts.getElement().isChecked();
        boolean ip = this.includeProducts.getElement().isChecked();
        ASearchConfiguration fc = this.getSearchConfiguration();
        PegasusFileComplete file = (PegasusFileComplete)((FlightReportServiceManager)ServiceManagerRegistry.getService(FlightReportServiceManager.class)).getFlightProductionResources(new ListWrapper(s), type, this.includeCrew.getElement().isChecked(), ih, ip, calc, fc).getValue();
        return file;
    }
}

