/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.product.remote.pricelistdetailed;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.CheckBoxAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.PeriodEditorAnalysisItem;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.ProductReportServiceManager;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Iterator;

public class AnalysisProductPriceListDetailedComponent
extends DefaultServerSideAnalysisComponent<ProductComplete, ProductReference> {
    private static final long serialVersionUID = 1L;
    private TitledPeriodEditor validityDate;
    private TitledItem<CheckBox> includeTaxes;

    public AnalysisProductPriceListDetailedComponent(AnalysisSmartExternalOpenTool<ProductComplete> defaultAnalysis) {
        super(defaultAnalysis);
    }

    @Override
    public void addOptionItems() {
        Node dateNode = new Node();
        dateNode.setValue((Object)new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis())), 0L);
        this.validityDate = new TitledPeriodEditor((Node<PeriodComplete>)dateNode, null);
        this.includeTaxes = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_TAXES, TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new PeriodEditorAnalysisItem(this.validityDate, "period"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeTaxes, "includeTaxes"));
    }

    @Override
    public String getTitleString() {
        return Words.PRICE_LIST;
    }

    @Override
    public String getTitleValue() {
        return Words.PRODUCT;
    }

    @Override
    public ProductReference createReference(ProductComplete item) {
        return new ProductReference(item.getId());
    }

    @Override
    public PegasusFileComplete createReport() throws Exception {
        PeriodComplete date = this.validityDate.getPeriod();
        ArrayList references = new ArrayList();
        Iterator s = this.getIterator();
        while (s.hasNext()) {
            references.add(s.next());
        }
        PegasusFileComplete file = (PegasusFileComplete)((ProductReportServiceManager)ServiceManagerRegistry.getService(ProductReportServiceManager.class)).getProductPriceHistoryReport(new ListWrapper(references), date, this.includeTaxes.getElement().isChecked()).getValue();
        return file;
    }
}

