/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.product.remote.sob;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledDateTimePeriodChooser;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.DateTimePeriodEditorAnalysisItem;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyReportServiceManager;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.TimestampPeriodComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;

public class AnalysisProductSobDetailsComponent
extends DefaultServerSideAnalysisComponent<ProductComplete, ProductReference> {
    private static final long serialVersionUID = 1L;
    private TitledDateTimePeriodChooser validityDate;

    public AnalysisProductSobDetailsComponent(AnalysisSmartExternalOpenTool<ProductComplete> defaultAnalysis) {
        super(defaultAnalysis);
    }

    @Override
    public void addOptionItems() {
        TimestampPeriodComplete ts = new TimestampPeriodComplete(new Timestamp(System.currentTimeMillis()), new Timestamp(System.currentTimeMillis()));
        Node dateNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)ts, false, false);
        this.validityDate = new TitledDateTimePeriodChooser((Node<TimestampPeriodComplete>)dateNode);
        this.addOptionsItem(new DateTimePeriodEditorAnalysisItem(this.validityDate, "period"));
    }

    @Override
    public String getTitleString() {
        return Words.PRODUCT_SOB;
    }

    @Override
    public String getTitleValue() {
        return Words.PRODUCT;
    }

    @Override
    public ProductReference createReference(ProductComplete item) {
        return new ProductReference(item.getId());
    }

    @Override
    public PegasusFileComplete createReport() throws Exception {
        this.validityDate.getNode().commitThis(TimestampPeriodComplete.class);
        TimestampPeriodComplete date = (TimestampPeriodComplete)this.validityDate.getNode().getValue();
        ArrayList references = new ArrayList();
        Iterator s = this.getIterator();
        while (s.hasNext()) {
            references.add(s.next());
        }
        while (s.hasNext()) {
            references.add(s.next());
        }
        PegasusFileComplete file = (PegasusFileComplete)((SupplyReportServiceManager)ServiceManagerRegistry.getService(SupplyReportServiceManager.class)).getProductSobReport(new ListWrapper(references), date).getValue();
        return file;
    }
}

